/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.block.function;

import java.util.Collection;
import java.util.Map;
import org.eclipse.collections.api.block.function.Function2;

public final class MinSizeFunction {
    public static final Function2<Integer, String, Integer> STRING = new MinSizeStringFunction();
    public static final Function2<Integer, Collection<?>, Integer> COLLECTION = new MinSizeCollectionFunction();
    public static final Function2<Integer, Map<?, ?>, Integer> MAP = new MinSizeMapFunction();

    private MinSizeFunction() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MinSizeMapFunction
    implements Function2<Integer, Map<?, ?>, Integer> {
        private static final long serialVersionUID = 1L;

        private MinSizeMapFunction() {
        }

        @Override
        public Integer value(Integer previousMin, Map<?, ?> map2) {
            return Math.min(previousMin, map2.size());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MinSizeCollectionFunction
    implements Function2<Integer, Collection<?>, Integer> {
        private static final long serialVersionUID = 1L;

        private MinSizeCollectionFunction() {
        }

        @Override
        public Integer value(Integer previousMin, Collection<?> collection) {
            return Math.min(previousMin, collection.size());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MinSizeStringFunction
    implements Function2<Integer, String, Integer> {
        private static final long serialVersionUID = 1L;

        private MinSizeStringFunction() {
        }

        @Override
        public Integer value(Integer previousMin, String s) {
            return Math.min(previousMin, s.length());
        }
    }
}

