/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.NoSuchElementException;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.primitive.ByteList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyByteIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;

public class ReverseByteIterable
extends AbstractLazyByteIterable {
    private final ByteList adapted;

    public ReverseByteIterable(ByteList newAdapted) {
        this.adapted = newAdapted;
    }

    public static ReverseByteIterable adapt(ByteList byteList) {
        return new ReverseByteIterable(byteList);
    }

    public ByteIterator byteIterator() {
        return new ReverseByteIterator();
    }

    public void each(ByteProcedure procedure) {
        ByteIterator iterator2 = this.byteIterator();
        while (iterator2.hasNext()) {
            procedure.value(iterator2.next());
        }
    }

    public long sum() {
        return this.adapted.sum();
    }

    public byte max() {
        return this.adapted.max();
    }

    public byte min() {
        return this.adapted.min();
    }

    public byte minIfEmpty(byte defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.min();
    }

    public byte maxIfEmpty(byte defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.max();
    }

    public double average() {
        return this.adapted.average();
    }

    public double median() {
        return this.adapted.median();
    }

    public byte[] toSortedArray() {
        return this.adapted.toSortedArray();
    }

    public byte[] toArray() {
        byte[] results = new byte[this.adapted.size()];
        int index = 0;
        ByteIterator iterator2 = this.byteIterator();
        while (iterator2.hasNext()) {
            results[index] = iterator2.next();
            ++index;
        }
        return results;
    }

    public boolean contains(byte value) {
        return this.adapted.contains(value);
    }

    public boolean containsAll(byte ... source) {
        return this.adapted.containsAll(source);
    }

    public boolean containsAll(ByteIterable source) {
        return this.adapted.containsAll(source);
    }

    public int size() {
        return this.adapted.size();
    }

    public boolean isEmpty() {
        return this.adapted.isEmpty();
    }

    public boolean notEmpty() {
        return this.adapted.notEmpty();
    }

    public MutableByteList toList() {
        return ByteArrayList.newList(this);
    }

    public MutableByteSet toSet() {
        return ByteHashSet.newSet(this);
    }

    public MutableByteBag toBag() {
        return ByteHashBag.newBag(this);
    }

    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter(this);
    }

    private class ReverseByteIterator
    implements ByteIterator {
        private int currentIndex;

        private ReverseByteIterator() {
            this.currentIndex = ReverseByteIterable.this.adapted.size() - 1;
        }

        public boolean hasNext() {
            return this.currentIndex != -1;
        }

        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            byte next = ReverseByteIterable.this.adapted.get(this.currentIndex);
            --this.currentIndex;
            return next;
        }
    }
}

