/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.DoubleSet;
import org.eclipse.collections.api.set.primitive.ImmutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractSynchronizedDoubleCollection;
import org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SynchronizedDoubleSet
extends AbstractSynchronizedDoubleCollection
implements MutableDoubleSet {
    private static final long serialVersionUID = 1L;

    SynchronizedDoubleSet(MutableDoubleSet set) {
        super(set);
    }

    SynchronizedDoubleSet(MutableDoubleSet set, Object newLock) {
        super(set, newLock);
    }

    public static SynchronizedDoubleSet of(MutableDoubleSet set) {
        return new SynchronizedDoubleSet(set);
    }

    public static SynchronizedDoubleSet of(MutableDoubleSet set, Object lock) {
        return new SynchronizedDoubleSet(set, lock);
    }

    @GuardedBy(value="getLock()")
    private MutableDoubleSet getMutableDoubleSet() {
        return (MutableDoubleSet)this.getDoubleCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedDoubleSet without(double element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleSet().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedDoubleSet with(double element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleSet().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedDoubleSet withAll(DoubleIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleSet().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedDoubleSet withoutAll(DoubleIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableDoubleSet().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableDoubleSet select(DoublePredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleSet().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableDoubleSet reject(DoublePredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleSet().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableSet<V> collect(DoubleToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleSet().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object otherSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleSet().equals(otherSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleSet().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyDoubleIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyDoubleIterableAdapter(this);
        }
    }

    @Override
    public MutableDoubleSet asUnmodifiable() {
        return new UnmodifiableDoubleSet(this);
    }

    @Override
    public MutableDoubleSet asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DoubleSet freeze() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleSet().freeze();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableDoubleSet toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableDoubleSet().toImmutable();
        }
    }
}

