/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.iterator.BooleanIterator;
import org.eclipse.collections.api.list.primitive.BooleanList;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.primitive.BooleanStack;
import org.eclipse.collections.api.stack.primitive.ImmutableBooleanStack;
import org.eclipse.collections.impl.bag.mutable.primitive.BooleanHashBag;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedBooleanProcedure;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.factory.primitive.BooleanStacks;
import org.eclipse.collections.impl.iterator.UnmodifiableBooleanIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.BooleanArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.BooleanHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableBooleanArrayStack
implements ImmutableBooleanStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final BooleanArrayList delegate;

    private ImmutableBooleanArrayStack(boolean[] newElements) {
        this.checkOptimizedSize(newElements.length);
        this.delegate = new BooleanArrayList(newElements);
    }

    private ImmutableBooleanArrayStack(BooleanArrayList newElements) {
        this.checkOptimizedSize(newElements.size());
        this.delegate = newElements;
    }

    private void checkOptimizedSize(int length) {
        if (length <= 1) {
            throw new IllegalArgumentException("Use BooleanStacks.immutable.with() to instantiate an optimized collection");
        }
    }

    public static ImmutableBooleanArrayStack newStack(BooleanIterable iterable) {
        return new ImmutableBooleanArrayStack(iterable.toArray());
    }

    public static ImmutableBooleanArrayStack newStackWith(boolean ... elements) {
        boolean[] newArray = new boolean[elements.length];
        System.arraycopy(elements, 0, newArray, 0, elements.length);
        return new ImmutableBooleanArrayStack(newArray);
    }

    public static ImmutableBooleanArrayStack newStackFromTopToBottom(boolean ... items) {
        return new ImmutableBooleanArrayStack(BooleanArrayList.newListWith(items).reverseThis());
    }

    public static ImmutableBooleanArrayStack newStackFromTopToBottom(BooleanIterable items) {
        return new ImmutableBooleanArrayStack(BooleanArrayList.newList(items).reverseThis());
    }

    @Override
    public ImmutableBooleanStack push(boolean item) {
        BooleanArrayList newDelegate = BooleanArrayList.newList(this.delegate);
        newDelegate.add(item);
        return new ImmutableBooleanArrayStack(newDelegate);
    }

    @Override
    public ImmutableBooleanStack pop() {
        BooleanArrayList newDelegate = BooleanArrayList.newList(this.delegate);
        newDelegate.removeAtIndex(this.delegate.size() - 1);
        return BooleanStacks.immutable.with(newDelegate.toArray());
    }

    @Override
    public ImmutableBooleanStack pop(int count2) {
        this.checkNegativeCount(count2);
        if (count2 == 0) {
            return this;
        }
        this.checkSizeLessThanCount(count2);
        BooleanArrayList newDelegate = BooleanArrayList.newList(this.delegate);
        while (count2 > 0) {
            newDelegate.removeAtIndex(newDelegate.size() - 1);
            --count2;
        }
        return BooleanStacks.immutable.with(newDelegate.toArray());
    }

    private void checkNegativeCount(int count2) {
        if (count2 < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count2);
        }
    }

    @Override
    public boolean peek() {
        return this.delegate.getLast();
    }

    @Override
    public BooleanList peek(int count2) {
        this.checkNegativeCount(count2);
        this.checkSizeLessThanCount(count2);
        if (count2 == 0) {
            return new BooleanArrayList();
        }
        BooleanArrayList subList = new BooleanArrayList(count2);
        int index = this.delegate.size() - 1;
        for (int i = 0; i < count2; ++i) {
            subList.add(this.delegate.get(index - i));
        }
        return subList;
    }

    @Override
    public boolean peekAt(int index) {
        this.rangeCheck(index);
        return this.delegate.get(this.delegate.size() - 1 - index);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index > this.delegate.size() - 1) {
            throw new IllegalArgumentException("Index " + index + " out of range.Should be between 0 and " + (this.delegate.size() - 1));
        }
    }

    @Override
    public BooleanIterator booleanIterator() {
        return new UnmodifiableBooleanIterator(this.delegate.asReversed().booleanIterator());
    }

    @Override
    public void forEach(BooleanProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(BooleanProcedure procedure) {
        this.delegate.asReversed().forEach(procedure);
    }

    @Override
    public int count(BooleanPredicate predicate) {
        return this.delegate.asReversed().count(predicate);
    }

    @Override
    public boolean anySatisfy(BooleanPredicate predicate) {
        return this.delegate.asReversed().anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(BooleanPredicate predicate) {
        return this.delegate.asReversed().allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(BooleanPredicate predicate) {
        return this.delegate.asReversed().noneSatisfy(predicate);
    }

    @Override
    public ImmutableBooleanStack select(BooleanPredicate predicate) {
        return BooleanStacks.immutable.withAllReversed(this.delegate.asReversed().select(predicate));
    }

    @Override
    public ImmutableBooleanStack reject(BooleanPredicate predicate) {
        return BooleanStacks.immutable.withAllReversed(this.delegate.asReversed().reject(predicate));
    }

    @Override
    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return this.delegate.asReversed().detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> ImmutableStack<V> collect(BooleanToObjectFunction<? extends V> function) {
        return Stacks.immutable.withAllReversed(this.delegate.asReversed().collect(function));
    }

    @Override
    public boolean[] toArray() {
        return this.delegate.asReversed().toArray();
    }

    @Override
    public boolean contains(boolean value) {
        return this.delegate.asReversed().contains(value);
    }

    @Override
    public boolean containsAll(boolean ... source) {
        return this.delegate.asReversed().containsAll(source);
    }

    @Override
    public boolean containsAll(BooleanIterable source) {
        return this.delegate.asReversed().containsAll(source);
    }

    @Override
    public MutableBooleanList toList() {
        return BooleanArrayList.newList(this);
    }

    @Override
    public MutableBooleanSet toSet() {
        return BooleanHashSet.newSet(this);
    }

    @Override
    public MutableBooleanBag toBag() {
        return BooleanHashBag.newBag(this);
    }

    public <V> V injectInto(V injectedValue, ObjectBooleanToObjectFunction<? super V, ? extends V> function) {
        return this.delegate.toReversed().injectInto(injectedValue, function);
    }

    @Override
    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter(this);
    }

    @Override
    public ImmutableBooleanStack toImmutable() {
        return this;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof BooleanStack)) {
            return false;
        }
        BooleanStack stack = (BooleanStack)otherStack;
        if (this.size() != stack.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.peekAt(i) == stack.peekAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode2 = 1;
        LazyBooleanIterable iterable = this.delegate.asReversed();
        BooleanIterator iterator2 = iterable.booleanIterator();
        while (iterator2.hasNext()) {
            boolean item = iterator2.next();
            hashCode2 = 31 * hashCode2 + (item ? 1231 : 1237);
        }
        return hashCode2;
    }

    @Override
    public String toString() {
        return this.delegate.asReversed().toString();
    }

    @Override
    public String makeString() {
        return this.delegate.asReversed().makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.asReversed().makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.asReversed().makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.asReversed().appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.asReversed().appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.asReversed().appendString(appendable, start, separator, end);
    }

    private void checkSizeLessThanCount(int count2) {
        if (this.delegate.size() < count2) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + count2 + " Size = " + this.delegate.size());
        }
    }

    private Object writeReplace() {
        return new ImmutableBooleanStackSerializationProxy(this);
    }

    private static class ImmutableBooleanStackSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private BooleanStack stack;

        public ImmutableBooleanStackSerializationProxy() {
        }

        protected ImmutableBooleanStackSerializationProxy(BooleanStack stack) {
            this.stack = stack;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.stack.size());
            try {
                this.stack.forEach(new CheckedBooleanProcedure(){

                    public void safeValue(boolean item) throws IOException {
                        out.writeBoolean(item);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size2 = in.readInt();
            BooleanArrayList deserializedDelegate = new BooleanArrayList(size2);
            for (int i = 0; i < size2; ++i) {
                deserializedDelegate.add(in.readBoolean());
            }
            this.stack = ImmutableBooleanArrayStack.newStackFromTopToBottom(deserializedDelegate);
        }

        protected Object readResolve() {
            return this.stack;
        }
    }
}

