/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.primitive.DoubleList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.primitive.DoubleStack;
import org.eclipse.collections.api.stack.primitive.ImmutableDoubleStack;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedDoubleProcedure;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.factory.primitive.DoubleStacks;
import org.eclipse.collections.impl.iterator.UnmodifiableDoubleIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableDoubleArrayStack
implements ImmutableDoubleStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final DoubleArrayList delegate;

    private ImmutableDoubleArrayStack(double[] newElements) {
        this.checkOptimizedSize(newElements.length);
        this.delegate = new DoubleArrayList(newElements);
    }

    private ImmutableDoubleArrayStack(DoubleArrayList newElements) {
        this.checkOptimizedSize(newElements.size());
        this.delegate = newElements;
    }

    private void checkOptimizedSize(int length) {
        if (length <= 1) {
            throw new IllegalArgumentException("Use DoubleStacks.immutable.with() to instantiate an optimized collection");
        }
    }

    public static ImmutableDoubleArrayStack newStack(DoubleIterable iterable) {
        return new ImmutableDoubleArrayStack(iterable.toArray());
    }

    public static ImmutableDoubleArrayStack newStackWith(double ... elements) {
        double[] newArray = new double[elements.length];
        System.arraycopy(elements, 0, newArray, 0, elements.length);
        return new ImmutableDoubleArrayStack(newArray);
    }

    public static ImmutableDoubleArrayStack newStackFromTopToBottom(double ... items) {
        return new ImmutableDoubleArrayStack(DoubleArrayList.newListWith(items).reverseThis());
    }

    public static ImmutableDoubleArrayStack newStackFromTopToBottom(DoubleIterable items) {
        return new ImmutableDoubleArrayStack(DoubleArrayList.newList(items).reverseThis());
    }

    @Override
    public ImmutableDoubleStack push(double item) {
        DoubleArrayList newDelegate = DoubleArrayList.newList(this.delegate);
        newDelegate.add(item);
        return new ImmutableDoubleArrayStack(newDelegate);
    }

    @Override
    public ImmutableDoubleStack pop() {
        DoubleArrayList newDelegate = DoubleArrayList.newList(this.delegate);
        newDelegate.removeAtIndex(this.delegate.size() - 1);
        return DoubleStacks.immutable.with(newDelegate.toArray());
    }

    @Override
    public ImmutableDoubleStack pop(int count2) {
        this.checkNegativeCount(count2);
        if (count2 == 0) {
            return this;
        }
        this.checkSizeLessThanCount(count2);
        DoubleArrayList newDelegate = DoubleArrayList.newList(this.delegate);
        while (count2 > 0) {
            newDelegate.removeAtIndex(newDelegate.size() - 1);
            --count2;
        }
        return DoubleStacks.immutable.with(newDelegate.toArray());
    }

    private void checkNegativeCount(int count2) {
        if (count2 < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count2);
        }
    }

    @Override
    public double peek() {
        return this.delegate.getLast();
    }

    @Override
    public DoubleList peek(int count2) {
        this.checkNegativeCount(count2);
        this.checkSizeLessThanCount(count2);
        if (count2 == 0) {
            return new DoubleArrayList();
        }
        DoubleArrayList subList = new DoubleArrayList(count2);
        int index = this.delegate.size() - 1;
        for (int i = 0; i < count2; ++i) {
            subList.add(this.delegate.get(index - i));
        }
        return subList;
    }

    @Override
    public double peekAt(int index) {
        this.rangeCheck(index);
        return this.delegate.get(this.delegate.size() - 1 - index);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index > this.delegate.size() - 1) {
            throw new IllegalArgumentException("Index " + index + " out of range.Should be between 0 and " + (this.delegate.size() - 1));
        }
    }

    @Override
    public DoubleIterator doubleIterator() {
        return new UnmodifiableDoubleIterator(this.delegate.asReversed().doubleIterator());
    }

    @Override
    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(DoubleProcedure procedure) {
        this.delegate.asReversed().forEach(procedure);
    }

    @Override
    public int count(DoublePredicate predicate) {
        return this.delegate.asReversed().count(predicate);
    }

    @Override
    public boolean anySatisfy(DoublePredicate predicate) {
        return this.delegate.asReversed().anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(DoublePredicate predicate) {
        return this.delegate.asReversed().allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(DoublePredicate predicate) {
        return this.delegate.asReversed().noneSatisfy(predicate);
    }

    @Override
    public ImmutableDoubleStack select(DoublePredicate predicate) {
        return DoubleStacks.immutable.withAllReversed(this.delegate.asReversed().select(predicate));
    }

    @Override
    public ImmutableDoubleStack reject(DoublePredicate predicate) {
        return DoubleStacks.immutable.withAllReversed(this.delegate.asReversed().reject(predicate));
    }

    @Override
    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return this.delegate.asReversed().detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> ImmutableStack<V> collect(DoubleToObjectFunction<? extends V> function) {
        return Stacks.immutable.withAllReversed(this.delegate.asReversed().collect(function));
    }

    @Override
    public double sum() {
        return this.delegate.sum();
    }

    @Override
    public double max() {
        return this.delegate.max();
    }

    @Override
    public double maxIfEmpty(double defaultValue) {
        return this.max();
    }

    @Override
    public double min() {
        return this.delegate.min();
    }

    @Override
    public double minIfEmpty(double defaultValue) {
        return this.min();
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public double[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newList(this).sortThis();
    }

    @Override
    public double[] toArray() {
        return this.delegate.asReversed().toArray();
    }

    @Override
    public boolean contains(double value) {
        return this.delegate.asReversed().contains(value);
    }

    @Override
    public boolean containsAll(double ... source) {
        return this.delegate.asReversed().containsAll(source);
    }

    @Override
    public boolean containsAll(DoubleIterable source) {
        return this.delegate.asReversed().containsAll(source);
    }

    @Override
    public MutableDoubleList toList() {
        return DoubleArrayList.newList(this);
    }

    @Override
    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSet(this);
    }

    @Override
    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBag(this);
    }

    public <V> V injectInto(V injectedValue, ObjectDoubleToObjectFunction<? super V, ? extends V> function) {
        return this.delegate.toReversed().injectInto(injectedValue, function);
    }

    @Override
    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter(this);
    }

    @Override
    public ImmutableDoubleStack toImmutable() {
        return this;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof DoubleStack)) {
            return false;
        }
        DoubleStack stack = (DoubleStack)otherStack;
        if (this.size() != stack.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (Double.compare(this.peekAt(i), stack.peekAt(i)) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode2 = 1;
        LazyDoubleIterable iterable = this.delegate.asReversed();
        DoubleIterator iterator2 = iterable.doubleIterator();
        while (iterator2.hasNext()) {
            double item = iterator2.next();
            hashCode2 = 31 * hashCode2 + (int)(Double.doubleToLongBits(item) ^ Double.doubleToLongBits(item) >>> 32);
        }
        return hashCode2;
    }

    @Override
    public String toString() {
        return this.delegate.asReversed().toString();
    }

    @Override
    public String makeString() {
        return this.delegate.asReversed().makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.asReversed().makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.asReversed().makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.asReversed().appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.asReversed().appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.asReversed().appendString(appendable, start, separator, end);
    }

    private void checkSizeLessThanCount(int count2) {
        if (this.delegate.size() < count2) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + count2 + " Size = " + this.delegate.size());
        }
    }

    private Object writeReplace() {
        return new ImmutableDoubleStackSerializationProxy(this);
    }

    private static class ImmutableDoubleStackSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private DoubleStack stack;

        public ImmutableDoubleStackSerializationProxy() {
        }

        protected ImmutableDoubleStackSerializationProxy(DoubleStack stack) {
            this.stack = stack;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.stack.size());
            try {
                this.stack.forEach(new CheckedDoubleProcedure(){

                    public void safeValue(double item) throws IOException {
                        out.writeDouble(item);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size2 = in.readInt();
            DoubleArrayList deserializedDelegate = new DoubleArrayList(size2);
            for (int i = 0; i < size2; ++i) {
                deserializedDelegate.add(in.readDouble());
            }
            this.stack = ImmutableDoubleArrayStack.newStackFromTopToBottom(deserializedDelegate);
        }

        protected Object readResolve() {
            return this.stack;
        }
    }
}

