/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableLongStack;
import org.eclipse.collections.api.stack.primitive.LongStack;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedLongProcedure;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.factory.primitive.LongStacks;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableLongArrayStack
implements ImmutableLongStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final LongArrayList delegate;

    private ImmutableLongArrayStack(long[] newElements) {
        this.checkOptimizedSize(newElements.length);
        this.delegate = new LongArrayList(newElements);
    }

    private ImmutableLongArrayStack(LongArrayList newElements) {
        this.checkOptimizedSize(newElements.size());
        this.delegate = newElements;
    }

    private void checkOptimizedSize(int length) {
        if (length <= 1) {
            throw new IllegalArgumentException("Use LongStacks.immutable.with() to instantiate an optimized collection");
        }
    }

    public static ImmutableLongArrayStack newStack(LongIterable iterable) {
        return new ImmutableLongArrayStack(iterable.toArray());
    }

    public static ImmutableLongArrayStack newStackWith(long ... elements) {
        long[] newArray = new long[elements.length];
        System.arraycopy(elements, 0, newArray, 0, elements.length);
        return new ImmutableLongArrayStack(newArray);
    }

    public static ImmutableLongArrayStack newStackFromTopToBottom(long ... items) {
        return new ImmutableLongArrayStack(LongArrayList.newListWith(items).reverseThis());
    }

    public static ImmutableLongArrayStack newStackFromTopToBottom(LongIterable items) {
        return new ImmutableLongArrayStack(LongArrayList.newList(items).reverseThis());
    }

    @Override
    public ImmutableLongStack push(long item) {
        LongArrayList newDelegate = LongArrayList.newList(this.delegate);
        newDelegate.add(item);
        return new ImmutableLongArrayStack(newDelegate);
    }

    @Override
    public ImmutableLongStack pop() {
        LongArrayList newDelegate = LongArrayList.newList(this.delegate);
        newDelegate.removeAtIndex(this.delegate.size() - 1);
        return LongStacks.immutable.with(newDelegate.toArray());
    }

    @Override
    public ImmutableLongStack pop(int count2) {
        this.checkNegativeCount(count2);
        if (count2 == 0) {
            return this;
        }
        this.checkSizeLessThanCount(count2);
        LongArrayList newDelegate = LongArrayList.newList(this.delegate);
        while (count2 > 0) {
            newDelegate.removeAtIndex(newDelegate.size() - 1);
            --count2;
        }
        return LongStacks.immutable.with(newDelegate.toArray());
    }

    private void checkNegativeCount(int count2) {
        if (count2 < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count2);
        }
    }

    @Override
    public long peek() {
        return this.delegate.getLast();
    }

    @Override
    public LongList peek(int count2) {
        this.checkNegativeCount(count2);
        this.checkSizeLessThanCount(count2);
        if (count2 == 0) {
            return new LongArrayList();
        }
        LongArrayList subList = new LongArrayList(count2);
        int index = this.delegate.size() - 1;
        for (int i = 0; i < count2; ++i) {
            subList.add(this.delegate.get(index - i));
        }
        return subList;
    }

    @Override
    public long peekAt(int index) {
        this.rangeCheck(index);
        return this.delegate.get(this.delegate.size() - 1 - index);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index > this.delegate.size() - 1) {
            throw new IllegalArgumentException("Index " + index + " out of range.Should be between 0 and " + (this.delegate.size() - 1));
        }
    }

    @Override
    public LongIterator longIterator() {
        return new UnmodifiableLongIterator(this.delegate.asReversed().longIterator());
    }

    @Override
    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(LongProcedure procedure) {
        this.delegate.asReversed().forEach(procedure);
    }

    @Override
    public int count(LongPredicate predicate) {
        return this.delegate.asReversed().count(predicate);
    }

    @Override
    public boolean anySatisfy(LongPredicate predicate) {
        return this.delegate.asReversed().anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(LongPredicate predicate) {
        return this.delegate.asReversed().allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(LongPredicate predicate) {
        return this.delegate.asReversed().noneSatisfy(predicate);
    }

    @Override
    public ImmutableLongStack select(LongPredicate predicate) {
        return LongStacks.immutable.withAllReversed(this.delegate.asReversed().select(predicate));
    }

    @Override
    public ImmutableLongStack reject(LongPredicate predicate) {
        return LongStacks.immutable.withAllReversed(this.delegate.asReversed().reject(predicate));
    }

    @Override
    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return this.delegate.asReversed().detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> ImmutableStack<V> collect(LongToObjectFunction<? extends V> function) {
        return Stacks.immutable.withAllReversed(this.delegate.asReversed().collect(function));
    }

    @Override
    public long sum() {
        return this.delegate.sum();
    }

    @Override
    public long max() {
        return this.delegate.max();
    }

    @Override
    public long maxIfEmpty(long defaultValue) {
        return this.max();
    }

    @Override
    public long min() {
        return this.delegate.min();
    }

    @Override
    public long minIfEmpty(long defaultValue) {
        return this.min();
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public long[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableLongList toSortedList() {
        return LongArrayList.newList(this).sortThis();
    }

    @Override
    public long[] toArray() {
        return this.delegate.asReversed().toArray();
    }

    @Override
    public boolean contains(long value) {
        return this.delegate.asReversed().contains(value);
    }

    @Override
    public boolean containsAll(long ... source) {
        return this.delegate.asReversed().containsAll(source);
    }

    @Override
    public boolean containsAll(LongIterable source) {
        return this.delegate.asReversed().containsAll(source);
    }

    @Override
    public MutableLongList toList() {
        return LongArrayList.newList(this);
    }

    @Override
    public MutableLongSet toSet() {
        return LongHashSet.newSet(this);
    }

    @Override
    public MutableLongBag toBag() {
        return LongHashBag.newBag(this);
    }

    public <V> V injectInto(V injectedValue, ObjectLongToObjectFunction<? super V, ? extends V> function) {
        return this.delegate.toReversed().injectInto(injectedValue, function);
    }

    @Override
    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter(this);
    }

    @Override
    public ImmutableLongStack toImmutable() {
        return this;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof LongStack)) {
            return false;
        }
        LongStack stack = (LongStack)otherStack;
        if (this.size() != stack.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.peekAt(i) == stack.peekAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode2 = 1;
        LazyLongIterable iterable = this.delegate.asReversed();
        LongIterator iterator2 = iterable.longIterator();
        while (iterator2.hasNext()) {
            long item = iterator2.next();
            hashCode2 = 31 * hashCode2 + (int)(item ^ item >>> 32);
        }
        return hashCode2;
    }

    @Override
    public String toString() {
        return this.delegate.asReversed().toString();
    }

    @Override
    public String makeString() {
        return this.delegate.asReversed().makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.asReversed().makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.asReversed().makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.asReversed().appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.asReversed().appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.asReversed().appendString(appendable, start, separator, end);
    }

    private void checkSizeLessThanCount(int count2) {
        if (this.delegate.size() < count2) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + count2 + " Size = " + this.delegate.size());
        }
    }

    private Object writeReplace() {
        return new ImmutableLongStackSerializationProxy(this);
    }

    private static class ImmutableLongStackSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private LongStack stack;

        public ImmutableLongStackSerializationProxy() {
        }

        protected ImmutableLongStackSerializationProxy(LongStack stack) {
            this.stack = stack;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.stack.size());
            try {
                this.stack.forEach(new CheckedLongProcedure(){

                    public void safeValue(long item) throws IOException {
                        out.writeLong(item);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size2 = in.readInt();
            LongArrayList deserializedDelegate = new LongArrayList(size2);
            for (int i = 0; i < size2; ++i) {
                deserializedDelegate.add(in.readLong());
            }
            this.stack = ImmutableLongArrayStack.newStackFromTopToBottom(deserializedDelegate);
        }

        protected Object readResolve() {
            return this.stack;
        }
    }
}

