/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.internal.primitive;

import java.util.Collection;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.iterator.DoubleIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DoubleIteratorIterate {
    private DoubleIteratorIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static void forEach(DoubleIterator iterator2, DoubleProcedure procedure) {
        while (iterator2.hasNext()) {
            procedure.value(iterator2.next());
        }
    }

    public static <R extends MutableDoubleCollection> R select(DoubleIterator iterator2, DoublePredicate predicate, R targetCollection) {
        while (iterator2.hasNext()) {
            double item = iterator2.next();
            if (!predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <R extends MutableDoubleCollection> R reject(DoubleIterator iterator2, DoublePredicate predicate, R targetCollection) {
        while (iterator2.hasNext()) {
            double item = iterator2.next();
            if (predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <V, R extends Collection<V>> R collect(DoubleIterator iterator2, DoubleToObjectFunction<? extends V> function, R targetCollection) {
        while (iterator2.hasNext()) {
            double item = iterator2.next();
            targetCollection.add(function.valueOf(item));
        }
        return targetCollection;
    }

    public static double detectIfNone(DoubleIterator iterator2, DoublePredicate predicate, double ifNone) {
        while (iterator2.hasNext()) {
            double item = iterator2.next();
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    public static int count(DoubleIterator iterator2, DoublePredicate predicate) {
        int count2 = 0;
        while (iterator2.hasNext()) {
            if (!predicate.accept(iterator2.next())) continue;
            ++count2;
        }
        return count2;
    }

    public static boolean anySatisfy(DoubleIterator iterator2, DoublePredicate predicate) {
        while (iterator2.hasNext()) {
            if (!predicate.accept(iterator2.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean allSatisfy(DoubleIterator iterator2, DoublePredicate predicate) {
        while (iterator2.hasNext()) {
            if (predicate.accept(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean noneSatisfy(DoubleIterator iterator2, DoublePredicate predicate) {
        while (iterator2.hasNext()) {
            if (!predicate.accept(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> T injectInto(DoubleIterator iterator2, T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        while (iterator2.hasNext()) {
            result = function.valueOf(result, iterator2.next());
        }
        return result;
    }

    public static double sum(DoubleIterator iterator2) {
        double sum2 = 0.0;
        while (iterator2.hasNext()) {
            sum2 += iterator2.next();
        }
        return sum2;
    }

    public static double max(DoubleIterator iterator2) {
        double max2 = iterator2.next();
        while (iterator2.hasNext()) {
            double next = iterator2.next();
            if (Double.compare(max2, next) >= 0) continue;
            max2 = next;
        }
        return max2;
    }

    public static double min(DoubleIterator iterator2) {
        double min2 = iterator2.next();
        while (iterator2.hasNext()) {
            double next = iterator2.next();
            if (Double.compare(next, min2) >= 0) continue;
            min2 = next;
        }
        return min2;
    }
}

