/*
 * Decompiled with CFR 0.152.
 */
package org.math.io.files;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Vector;
import org.math.io.files.DataFile;
import org.math.io.parser.ArrayString;

public class ASCIIFile
extends DataFile {
    public ASCIIFile(File f) {
        super(f);
    }

    public static String read(File f) {
        ASCIIFile af = new ASCIIFile(f);
        return af.read();
    }

    public static String[] readLines(File f) {
        ASCIIFile af = new ASCIIFile(f);
        return af.readLines();
    }

    public static String readLine(File f, int i) {
        ASCIIFile af = new ASCIIFile(f);
        return af.readLine(i);
    }

    public static double[] readDouble1DArray(File f) {
        return ArrayString.readString1DDouble(ASCIIFile.read(f));
    }

    public static double[][] readDoubleArray(File f) {
        return ArrayString.readStringDouble(ASCIIFile.read(f));
    }

    public static int[] readInt1DArray(File f) {
        return ArrayString.readString1DInt(ASCIIFile.read(f));
    }

    public static int[][] readIntArray(File f) {
        return ArrayString.readStringInt(ASCIIFile.read(f));
    }

    public static void write(File f, String t) {
        ASCIIFile af = new ASCIIFile(f);
        af.write(t, false);
    }

    public static void writeDoubleArray(File f, double[] array) {
        ASCIIFile.write(f, ArrayString.printDoubleArray(array));
    }

    public static void writeDoubleArray(File f, double[][] array) {
        ASCIIFile.write(f, ArrayString.printDoubleArray(array));
    }

    public static void writeIntArray(File f, int[] array) {
        ASCIIFile.write(f, ArrayString.printIntArray(array));
    }

    public static void writeIntArray(File f, int[][] array) {
        ASCIIFile.write(f, ArrayString.printIntArray(array));
    }

    public static void append(File f, String t) {
        ASCIIFile af = new ASCIIFile(f);
        af.write(t, true);
    }

    public String read() {
        StringBuffer text = new StringBuffer((int)this.file.length());
        BufferedReader b = null;
        try {
            FileReader fr = new FileReader(this.file);
            b = new BufferedReader(fr);
            boolean eof = false;
            String ret2 = "\n";
            while (!eof) {
                String line = b.readLine();
                if (line == null) {
                    eof = true;
                    continue;
                }
                text.append(line);
                text.append(ret2);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("File " + this.file.getName() + " is unreadable : " + e.toString());
        }
        finally {
            try {
                b.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return text.toString();
    }

    public String[] readLines() {
        Vector<String> linesVector = new Vector<String>();
        BufferedReader b = null;
        try {
            FileReader fr = new FileReader(this.file);
            b = new BufferedReader(fr);
            boolean eof = false;
            while (!eof) {
                String line = b.readLine();
                if (line == null) {
                    eof = true;
                    continue;
                }
                linesVector.add(line);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("File " + this.file.getName() + " is unreadable : " + e.toString());
        }
        finally {
            try {
                b.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        String[] lines = new String[linesVector.size()];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = (String)linesVector.get(i);
        }
        return lines;
    }

    public String readLine(int i) {
        String line = new String("");
        BufferedReader b = null;
        try {
            FileReader fr = new FileReader(this.file);
            b = new BufferedReader(fr);
            boolean eof = false;
            for (int j = 0; j < i; ++j) {
                if (eof) {
                    throw new IllegalArgumentException("Line " + i + " is not found in the file " + this.file.getName() + ".");
                }
                line = b.readLine();
                if (line != null) continue;
                eof = true;
            }
            line = b.readLine();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("File " + this.file.getName() + " is unreadable : " + e.toString());
        }
        finally {
            try {
                b.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return line;
    }

    public void write(String text, boolean append) {
        if (this.file.exists() && !append) {
            System.out.println("Warning : the file " + this.file.getName() + " already exists !");
        }
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new FileWriter(this.file, append);
            bw = new BufferedWriter(fw);
            bw.write(text);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("File " + this.file.getName() + " is unwritable : " + e.toString());
        }
        finally {
            try {
                bw.close();
                fw.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void concatenate(File f1, File f2) {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            int c;
            fis = new FileInputStream(f2);
            bis = new BufferedInputStream(fis);
            fos = new FileOutputStream(f1, true);
            bos = new BufferedOutputStream(fos);
            while ((c = bis.read()) != -1) {
                ((BufferedOutputStream)bos).write(c);
            }
        }
        catch (IOException e) {
            System.err.println("Concatenate: " + e);
        }
        finally {
            try {
                bis.close();
                fis.close();
                bos.close();
                fos.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        File f = new File("read.txt");
        System.out.println(ASCIIFile.read(f));
        String[] lines = ASCIIFile.readLines(f);
        for (int i = 0; i < lines.length; ++i) {
            System.out.println("line " + i + " : " + lines[i]);
        }
        System.out.println(ASCIIFile.readLine(f, 0));
        System.out.println(ASCIIFile.readLine(f, lines.length - 1));
        ASCIIFile.append(new File("write.txt"), Calendar.getInstance().getTime().toString());
    }
}

