/*
 * Decompiled with CFR 0.152.
 */
package utils.plotter;

import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import org.math.plot.Plot2DPanel;
import org.math.plot.plotObjects.BaseLabel;

public class ScatterPlotter {
    private static final long serialVersionUID = 5840221804907296764L;
    private JFrame frame;

    public ScatterPlotter(String s, double[] x, double[] y, Double simulatedTime) {
        int lastMillis = 15;
        if (simulatedTime != null) {
            lastMillis = simulatedTime.intValue() + 1;
        }
        Plot2DPanel plot = new Plot2DPanel();
        plot.addScatterPlot(s, x, y);
        plot.setFixedBounds(0, 0.0, (int)((double)lastMillis * 1.3));
        BaseLabel title = new BaseLabel("Fires", Color.RED, 0.5, 1.1);
        title.setFont(new Font("Courier", 1, 20));
        plot.addPlotable(title);
        this.frame = new JFrame(s);
        this.frame.setSize(1500, 700);
        this.frame.setContentPane(plot);
    }

    public ScatterPlotter(String s, double[] x, double[] y, Double simulatedTime, String filename) {
        int lastMillis = 15;
        if (simulatedTime != null) {
            lastMillis = simulatedTime.intValue() + 1;
        }
        int width = 1500;
        int height = 700;
        Plot2DPanel plot = new Plot2DPanel();
        plot.addScatterPlot(s, x, y);
        plot.setFixedBounds(0, 0.0, (int)((double)lastMillis * 1.1));
        BaseLabel title = new BaseLabel("Fires", Color.RED, 0.5, 1.1);
        title.setFont(new Font("Courier", 1, 20));
        plot.addPlotable(title);
        this.frame = new JFrame(s);
        this.frame.setSize(width, height);
        this.frame.setContentPane(plot);
        BufferedImage image = new BufferedImage(width, height, 1);
        plot.paint(image.getGraphics());
    }

    public void setVisible() {
        this.frame.setVisible(true);
    }
}

