/*
 * Decompiled with CFR 0.152.
 */
package utils.statistics;

import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import utils.statistics.CollectedFire;
import utils.statistics.StatisticsCollector;

public class FiringWriter
extends Thread {
    private final String TAG = "[Firing Writer] ";
    private String defFileName;
    private PrintWriter pw;
    private PrintWriter pwGephi;
    private PrintWriter pwMatlab;
    private DecimalFormat df = new DecimalFormat("#.################");
    private int count = 1;
    private BlockingQueue<CollectedFire> firingSpikesQueue;
    private StatisticsCollector sc;
    private int sa;

    public FiringWriter(StatisticsCollector sc, String defFileName, int sa) {
        this.sc = sc;
        this.defFileName = defFileName;
        this.sa = sa;
    }

    protected void setWriters(PrintWriter pw, PrintWriter pwGephi, PrintWriter pwMatlab) {
        this.pw = pw;
        this.pwGephi = pwGephi;
        this.pwMatlab = pwMatlab;
    }

    public void init() {
        this.firingSpikesQueue = new ArrayBlockingQueue<CollectedFire>(this.sa);
    }

    @Override
    public void run() {
        this.init();
        try {
            while (this.sc.keepRunning.booleanValue()) {
                String isExternalStr;
                CollectedFire cf = this.firingSpikesQueue.take();
                String excitStr = cf.isExcitatory() != false ? "excitatory" : "inhibitory";
                if (cf.isExternal().booleanValue()) {
                    isExternalStr = this.sc.reducedOutput != false || this.sc.superReducedOutput != false ? "1" : "true";
                } else {
                    String string = isExternalStr = this.sc.reducedOutput != false || this.sc.superReducedOutput != false ? "0" : "false";
                }
                if (this.sc.reducedOutput.booleanValue() || this.sc.superReducedOutput.booleanValue()) {
                    this.pw.println(this.df.format(cf.getFiringTime()) + ", " + cf.getFiringNodeId() + ", " + cf.getFiringNeuronId() + ", " + isExternalStr);
                } else {
                    this.pw.println(this.df.format(cf.getFiringTime()) + ", " + cf.getFiringNodeId() + ", " + cf.getFiringNeuronId() + ", " + excitStr + ", " + cf.isExternal());
                }
                if (!this.sc.matlab.booleanValue()) continue;
                this.pwMatlab.println(cf.getFiringTime().toString() + ", " + cf.getFiringNodeId() + ", " + cf.getFiringNeuronId() + ", " + (cf.isExcitatory() != false ? (char)'1' : '0') + ", " + (cf.isExternal() != false ? (char)'1' : '0'));
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void put(CollectedFire cf) {
        try {
            this.firingSpikesQueue.put(cf);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.pw.flush();
        this.pw.close();
        if (this.pwMatlab != null) {
            this.pwMatlab.flush();
            this.pwMatlab.close();
        }
    }

    protected void flush() {
        this.pw.flush();
        if (this.pwMatlab != null) {
            this.pwMatlab.flush();
        }
    }
}

