/*
 * Decompiled with CFR 0.152.
 */
package utils.tools;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.PriorityQueue;
import utils.tools.NiceNode;

public class NiceQueue
implements Serializable {
    private static final long serialVersionUID = 3248671994878955651L;
    private PriorityQueue<NiceNode> queue = new PriorityQueue();
    private HashMap<Long, NiceNode> nodesHash = new HashMap();

    public NiceQueue(String tmpHashName) {
    }

    public void insert(Double tf, Long fn) {
        NiceNode node = new NiceNode(fn, tf);
        this.queue.add(node);
        this.nodesHash.put(fn, node);
    }

    public NiceNode min() {
        return this.queue.peek();
    }

    public void _update(double x) {
        for (NiceNode niceNode : this.queue) {
            Double.valueOf(niceNode.tf - x);
            niceNode.tf = niceNode.tf;
        }
    }

    public Double getMinTime() {
        NiceNode min2 = this.min();
        if (min2 == null) {
            return null;
        }
        return min2.tf;
    }

    public NiceNode extractMin() {
        NiceNode min2 = this.queue.poll();
        if (min2 != null) {
            this.nodesHash.remove(min2.fn);
        }
        return min2;
    }

    public void delete(Long fn) {
        NiceNode q = this.nodesHash.get(fn);
        if (q != null) {
            this.queue.remove(q);
        }
    }

    public int size() {
        return this.queue.size();
    }

    public void printQueue() {
        Iterator<NiceNode> it = this.queue.iterator();
        while (it.hasNext()) {
            System.out.println(it.next().toString());
        }
    }

    public static void main(String[] args) {
        NiceQueue nq = new NiceQueue("tmp");
        for (long i = 0L; i < 10L; ++i) {
            nq.insert(new Double((23L + i + i * i % 7L) % 27L), i);
        }
        nq.printQueue();
        NiceNode nn = nq.min();
        System.out.println("\n\n\nmin node:\t" + nn.toString());
        nq.printQueue();
    }

    public NiceNode[] toArray() {
        NiceNode[] aux = new NiceNode[this.queue.size()];
        return this.queue.toArray(aux);
    }
}

