/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.multimap.set;

import java.io.Externalizable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.multimap.Multimap;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.multimap.set.ImmutableSetMultimap;
import org.eclipse.collections.api.multimap.set.MutableSetMultimap;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.map.mutable.ConcurrentHashMap;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.multimap.AbstractSynchronizedPutMultimap;
import org.eclipse.collections.impl.multimap.bag.HashBagMultimap;
import org.eclipse.collections.impl.multimap.set.ImmutableSetMultimapImpl;
import org.eclipse.collections.impl.multimap.set.UnifiedSetMultimap;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.utility.ArrayIterate;
import org.eclipse.collections.impl.utility.Iterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SynchronizedPutUnifiedSetMultimap<K, V>
extends AbstractSynchronizedPutMultimap<K, V, MutableSet<V>>
implements MutableSetMultimap<K, V>,
Externalizable {
    private static final long serialVersionUID = 42L;

    public SynchronizedPutUnifiedSetMultimap() {
    }

    public SynchronizedPutUnifiedSetMultimap(int initialCapacity) {
        super(ConcurrentHashMap.newMap(initialCapacity));
    }

    public SynchronizedPutUnifiedSetMultimap(Multimap<? extends K, ? extends V> multimap) {
        this.putAll(multimap);
    }

    public SynchronizedPutUnifiedSetMultimap(Pair<K, V> ... pairs) {
        this();
        ArrayIterate.forEach(pairs, new Procedure<Pair<K, V>>(){

            @Override
            public void value(Pair<K, V> pair) {
                SynchronizedPutUnifiedSetMultimap.this.put(pair.getOne(), pair.getTwo());
            }
        });
    }

    public SynchronizedPutUnifiedSetMultimap(Iterable<Pair<K, V>> inputIterable) {
        this();
        Iterate.forEach(inputIterable, new Procedure<Pair<K, V>>(){

            @Override
            public void value(Pair<K, V> pair) {
                SynchronizedPutUnifiedSetMultimap.this.add(pair);
            }
        });
    }

    public static <K, V> SynchronizedPutUnifiedSetMultimap<K, V> newMultimap() {
        return new SynchronizedPutUnifiedSetMultimap<K, V>();
    }

    public static <K, V> SynchronizedPutUnifiedSetMultimap<K, V> newMultimap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new SynchronizedPutUnifiedSetMultimap<K, V>(initialCapacity);
    }

    public static <K, V> SynchronizedPutUnifiedSetMultimap<K, V> newMultimap(Multimap<? extends K, ? extends V> multimap) {
        return new SynchronizedPutUnifiedSetMultimap<K, V>(multimap);
    }

    public static <K, V> SynchronizedPutUnifiedSetMultimap<K, V> newMultimap(Pair<K, V> ... pairs) {
        return new SynchronizedPutUnifiedSetMultimap<K, V>(pairs);
    }

    public static <K, V> SynchronizedPutUnifiedSetMultimap<K, V> newMultimap(Iterable<Pair<K, V>> inputIterable) {
        return new SynchronizedPutUnifiedSetMultimap<K, V>(inputIterable);
    }

    @Override
    protected MutableSet<V> createCollection() {
        return UnifiedSet.newSet(1);
    }

    @Override
    public SynchronizedPutUnifiedSetMultimap<K, V> newEmpty() {
        return new SynchronizedPutUnifiedSetMultimap<K, V>();
    }

    @Override
    public MutableSetMultimap<K, V> toMutable() {
        return new SynchronizedPutUnifiedSetMultimap<K, V>(this);
    }

    @Override
    public ImmutableSetMultimap<K, V> toImmutable() {
        final UnifiedMap map2 = UnifiedMap.newMap();
        this.map.forEachKeyValue(new Procedure2<K, MutableSet<V>>(){

            @Override
            public void value(K key, MutableSet<V> set) {
                map2.put(key, set.toImmutable());
            }
        });
        return new ImmutableSetMultimapImpl(map2);
    }

    @Override
    public UnifiedSetMultimap<K, V> selectKeysValues(Predicate2<? super K, ? super V> predicate) {
        return this.selectKeysValues(predicate, UnifiedSetMultimap.newMultimap());
    }

    @Override
    public UnifiedSetMultimap<K, V> rejectKeysValues(Predicate2<? super K, ? super V> predicate) {
        return this.rejectKeysValues(predicate, UnifiedSetMultimap.newMultimap());
    }

    @Override
    public UnifiedSetMultimap<K, V> selectKeysMultiValues(Predicate2<? super K, ? super Iterable<V>> predicate) {
        return this.selectKeysMultiValues(predicate, UnifiedSetMultimap.newMultimap());
    }

    @Override
    public UnifiedSetMultimap<K, V> rejectKeysMultiValues(Predicate2<? super K, ? super Iterable<V>> predicate) {
        return this.rejectKeysMultiValues(predicate, UnifiedSetMultimap.newMultimap());
    }

    @Override
    public <K2, V2> MutableBagMultimap<K2, V2> collectKeysValues(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        return this.collectKeysValues(function, HashBagMultimap.newMultimap());
    }

    @Override
    public <V2> MutableBagMultimap<K, V2> collectValues(Function<? super V, ? extends V2> function) {
        return this.collectValues(function, HashBagMultimap.newMultimap());
    }

    @Override
    public MutableSetMultimap<V, K> flip() {
        return Iterate.flip(this);
    }
}

