/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set;

import java.util.Collection;
import java.util.Set;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.Function3;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.Pool;
import org.eclipse.collections.api.set.SetIterable;
import org.eclipse.collections.api.set.UnsortedSetIterable;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.AbstractRichIterable;
import org.eclipse.collections.impl.block.procedure.MutatingAggregationProcedure;
import org.eclipse.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.multimap.set.UnifiedSetMultimap;
import org.eclipse.collections.impl.parallel.BatchIterable;
import org.eclipse.collections.impl.set.mutable.SynchronizedMutableSet;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.UnmodifiableMutableSet;
import org.eclipse.collections.impl.set.mutable.primitive.BooleanHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.utility.internal.IterableIterate;
import org.eclipse.collections.impl.utility.internal.MutableCollectionIterate;
import org.eclipse.collections.impl.utility.internal.SetIterables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUnifiedSet<T>
extends AbstractRichIterable<T>
implements MutableSet<T>,
Pool<T>,
BatchIterable<T> {
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int DEFAULT_INITIAL_CAPACITY = 8;
    protected float loadFactor = 0.75f;
    protected int maxSize;

    protected abstract Object[] getTable();

    protected abstract void allocateTable(int var1);

    protected abstract void rehash(int var1);

    protected abstract T detect(Predicate<? super T> var1, int var2, int var3);

    @Override
    public abstract MutableSet<T> clone();

    protected abstract boolean shortCircuit(Predicate<? super T> var1, boolean var2, boolean var3, boolean var4, int var5, int var6);

    protected abstract <P> boolean shortCircuitWith(Predicate2<? super T, ? super P> var1, P var2, boolean var3, boolean var4, boolean var5);

    protected int init(int initialCapacity) {
        int capacity;
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        return this.allocate(capacity);
    }

    protected int allocate(int capacity) {
        this.allocateTable(capacity);
        this.computeMaxSize(capacity);
        return capacity;
    }

    protected void computeMaxSize(int capacity) {
        this.maxSize = Math.min(capacity - 1, (int)((float)capacity * this.loadFactor));
    }

    protected void rehash() {
        this.rehash(this.getTable().length << 1);
    }

    protected boolean shortCircuit(Predicate<? super T> predicate, boolean expected, boolean onShortCircuit, boolean atEnd) {
        return this.shortCircuit(predicate, expected, onShortCircuit, atEnd, 0, this.getTable().length);
    }

    @Override
    public int getBatchCount(int batchSize) {
        return Math.max(1, this.getTable().length / batchSize);
    }

    @Override
    public boolean removeIf(Predicate<? super T> predicate) {
        return IterableIterate.removeIf(this, predicate);
    }

    @Override
    public <P> boolean removeIfWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return IterableIterate.removeIfWith(this, predicate, parameter);
    }

    @Override
    public <V> UnifiedSet<V> collect(Function<? super T, ? extends V> function) {
        return this.collect(function, UnifiedSet.newSet());
    }

    @Override
    public MutableBooleanSet collectBoolean(BooleanFunction<? super T> booleanFunction) {
        return this.collectBoolean(booleanFunction, new BooleanHashSet());
    }

    @Override
    public MutableByteSet collectByte(ByteFunction<? super T> byteFunction) {
        return this.collectByte(byteFunction, new ByteHashSet());
    }

    @Override
    public MutableCharSet collectChar(CharFunction<? super T> charFunction) {
        return this.collectChar(charFunction, new CharHashSet());
    }

    @Override
    public MutableDoubleSet collectDouble(DoubleFunction<? super T> doubleFunction) {
        return this.collectDouble(doubleFunction, new DoubleHashSet());
    }

    @Override
    public MutableFloatSet collectFloat(FloatFunction<? super T> floatFunction) {
        return this.collectFloat(floatFunction, new FloatHashSet());
    }

    @Override
    public MutableIntSet collectInt(IntFunction<? super T> intFunction) {
        return this.collectInt(intFunction, new IntHashSet());
    }

    @Override
    public MutableLongSet collectLong(LongFunction<? super T> longFunction) {
        return this.collectLong(longFunction, new LongHashSet());
    }

    @Override
    public MutableShortSet collectShort(ShortFunction<? super T> shortFunction) {
        return this.collectShort(shortFunction, new ShortHashSet());
    }

    @Override
    public <V> UnifiedSet<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return this.flatCollect(function, UnifiedSet.newSet());
    }

    @Override
    public <P, A> UnifiedSet<A> collectWith(Function2<? super T, ? super P, ? extends A> function, P parameter) {
        return this.collectWith(function, parameter, UnifiedSet.newSet());
    }

    @Override
    public <V> UnifiedSet<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.collectIf(predicate, function, UnifiedSet.newSet());
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        return this.detect(predicate, 0, this.getTable().length);
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        return this.shortCircuit(predicate, true, true, false);
    }

    @Override
    public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.shortCircuitWith(predicate, parameter, true, true, false);
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        return this.shortCircuit(predicate, false, false, true);
    }

    @Override
    public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.shortCircuitWith(predicate, parameter, false, false, true);
    }

    @Override
    public boolean noneSatisfy(Predicate<? super T> predicate) {
        return this.shortCircuit(predicate, true, false, true);
    }

    @Override
    public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.shortCircuitWith(predicate, parameter, true, false, true);
    }

    @Override
    public <IV, P> IV injectIntoWith(IV injectValue, final Function3<? super IV, ? super T, ? super P, ? extends IV> function, final P parameter) {
        return this.injectInto(injectValue, new Function2<IV, T, IV>(){

            @Override
            public IV value(IV argument1, T argument2) {
                return function.value(argument1, argument2, parameter);
            }
        });
    }

    @Override
    public MutableSet<T> asUnmodifiable() {
        return UnmodifiableMutableSet.of(this);
    }

    @Override
    public MutableSet<T> asSynchronized() {
        return SynchronizedMutableSet.of(this);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        return this.addAllIterable(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.removeAllIterable(collection);
    }

    @Override
    public boolean removeAllIterable(Iterable<?> iterable) {
        boolean changed = false;
        for (Object each2 : iterable) {
            changed |= this.remove(each2);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.retainAllIterable(collection);
    }

    @Override
    public <V> UnifiedSetMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.groupByEach(function, UnifiedSetMultimap.newMultimap());
    }

    @Override
    public <V> MutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        return this.groupByUniqueKey(function, UnifiedMap.newMap());
    }

    @Override
    @Deprecated
    public <S> MutableSet<Pair<T, S>> zip(Iterable<S> that) {
        return this.zip(that, UnifiedSet.newSet());
    }

    @Override
    @Deprecated
    public MutableSet<Pair<T, Integer>> zipWithIndex() {
        return this.zipWithIndex(UnifiedSet.newSet());
    }

    @Override
    public RichIterable<RichIterable<T>> chunk(int size2) {
        return MutableCollectionIterate.chunk(this, size2);
    }

    @Override
    public MutableSet<T> union(SetIterable<? extends T> set) {
        return SetIterables.unionInto(this, set, this.newEmpty());
    }

    @Override
    public <R extends Set<T>> R unionInto(SetIterable<? extends T> set, R targetSet) {
        return SetIterables.unionInto(this, set, targetSet);
    }

    @Override
    public MutableSet<T> intersect(SetIterable<? extends T> set) {
        return SetIterables.intersectInto(this, set, this.newEmpty());
    }

    @Override
    public <R extends Set<T>> R intersectInto(SetIterable<? extends T> set, R targetSet) {
        return SetIterables.intersectInto(this, set, targetSet);
    }

    @Override
    public MutableSet<T> difference(SetIterable<? extends T> subtrahendSet) {
        return SetIterables.differenceInto(this, subtrahendSet, this.newEmpty());
    }

    @Override
    public <R extends Set<T>> R differenceInto(SetIterable<? extends T> subtrahendSet, R targetSet) {
        return SetIterables.differenceInto(this, subtrahendSet, targetSet);
    }

    @Override
    public MutableSet<T> symmetricDifference(SetIterable<? extends T> setB) {
        return SetIterables.symmetricDifferenceInto(this, setB, this.newEmpty());
    }

    @Override
    public <R extends Set<T>> R symmetricDifferenceInto(SetIterable<? extends T> set, R targetSet) {
        return SetIterables.symmetricDifferenceInto(this, set, targetSet);
    }

    @Override
    public boolean isSubsetOf(SetIterable<? extends T> candidateSuperset) {
        return SetIterables.isSubsetOf(this, candidateSuperset);
    }

    @Override
    public boolean isProperSubsetOf(SetIterable<? extends T> candidateSuperset) {
        return SetIterables.isProperSubsetOf(this, candidateSuperset);
    }

    @Override
    public MutableSet<UnsortedSetIterable<T>> powerSet() {
        return SetIterables.powerSet(this);
    }

    @Override
    public <B> LazyIterable<Pair<T, B>> cartesianProduct(SetIterable<B> set) {
        return SetIterables.cartesianProduct(this, set);
    }

    @Override
    public <K2, V> MutableMap<K2, V> aggregateInPlaceBy(Function<? super T, ? extends K2> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        UnifiedMap map2 = UnifiedMap.newMap();
        this.forEach(new MutatingAggregationProcedure<T, K2, V>(map2, groupBy, zeroValueFactory, mutatingAggregator));
        return map2;
    }

    @Override
    public <K2, V> MutableMap<K2, V> aggregateBy(Function<? super T, ? extends K2> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        UnifiedMap map2 = UnifiedMap.newMap();
        this.forEach(new NonMutatingAggregationProcedure<T, K2, V>(map2, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map2;
    }
}

