/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable;

import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.impl.UnmodifiableIteratorAdapter;
import org.eclipse.collections.impl.parallel.BatchIterable;
import org.eclipse.collections.impl.set.immutable.AbstractImmutableSet;
import org.eclipse.collections.impl.set.immutable.ImmutableSetSerializationProxy;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableUnifiedSet<T>
extends AbstractImmutableSet<T>
implements Serializable,
BatchIterable<T> {
    private static final long serialVersionUID = 1L;
    private final UnifiedSet<T> delegate;

    private ImmutableUnifiedSet(UnifiedSet<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean equals(Object other) {
        return this.delegate.equals(other);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean contains(Object object) {
        return this.delegate.contains(object);
    }

    @Override
    public Iterator<T> iterator() {
        return new UnmodifiableIteratorAdapter<T>(this.delegate.iterator());
    }

    @Override
    public T getFirst() {
        return this.delegate.getFirst();
    }

    @Override
    public T getLast() {
        return this.delegate.getLast();
    }

    public static <T> ImmutableSet<T> newSetWith(T ... elements) {
        return new ImmutableUnifiedSet<T>(UnifiedSet.newSetWith(elements));
    }

    public static <T> ImmutableSet<T> newSet(Iterable<T> iterable) {
        return new ImmutableUnifiedSet<T>(UnifiedSet.newSet(iterable));
    }

    @Override
    public void each(Procedure<? super T> procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public int getBatchCount(int batchSize) {
        return this.delegate.getBatchCount(batchSize);
    }

    @Override
    public void batchForEach(Procedure<? super T> procedure, int sectionIndex, int sectionCount) {
        this.delegate.batchForEach(procedure, sectionIndex, sectionCount);
    }

    private Object writeReplace() {
        return new ImmutableSetSerializationProxy(this);
    }

    @Override
    public ParallelUnsortedSetIterable<T> asParallel(ExecutorService executorService, int batchSize) {
        return this.delegate.asParallel(executorService, batchSize);
    }
}

