/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import java.util.Arrays;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.GroupSerializerObjectArray;
import org.mapdb.serializer.SerializerUtils;

public class SerializerCharArray
extends GroupSerializerObjectArray<char[]> {
    @Override
    public void serialize(DataOutput2 out, char[] value) throws IOException {
        out.packInt(value.length);
        for (char c : value) {
            out.writeChar(c);
        }
    }

    @Override
    public char[] deserialize(DataInput2 in, int available) throws IOException {
        int size2 = in.unpackInt();
        char[] ret2 = new char[size2];
        for (int i = 0; i < size2; ++i) {
            ret2[i] = in.readChar();
        }
        return ret2;
    }

    @Override
    public boolean isTrusted() {
        return true;
    }

    @Override
    public boolean equals(char[] a1, char[] a2) {
        return Arrays.equals(a1, a2);
    }

    @Override
    public int hashCode(char[] chars, int seed) {
        int res = 0;
        for (char c : chars) {
            res = (res + c) * -1640531527;
        }
        return res;
    }

    @Override
    public int compare(char[] o1, char[] o2) {
        int len = Math.min(o1.length, o2.length);
        for (int i = 0; i < len; ++i) {
            char b1 = o1[i];
            char b2 = o2[i];
            if (b1 == b2) continue;
            return b1 - b2;
        }
        return SerializerUtils.compareInt(o1.length, o2.length);
    }

    @Override
    public char[] nextValue(char[] value) {
        value = (char[])value.clone();
        int i = value.length - 1;
        while (true) {
            char b1;
            if ((b1 = value[i]) == '\uffff') {
                if (i == 0) {
                    return null;
                }
            } else {
                value[i] = (char)(b1 + '\u0001');
                return value;
            }
            value[i] = '\u0000';
            --i;
        }
    }
}

