/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.canvas;

import java.awt.Color;
import java.awt.event.MouseEvent;
import org.math.plot.canvas.PlotCanvas;
import org.math.plot.plotObjects.Base;
import org.math.plot.plotObjects.BasePlot;
import org.math.plot.plots.BarPlot;
import org.math.plot.plots.BoxPlot3D;
import org.math.plot.plots.CloudPlot3D;
import org.math.plot.plots.GridPlot3D;
import org.math.plot.plots.HistogramPlot3D;
import org.math.plot.plots.LinePlot;
import org.math.plot.plots.ScatterPlot;
import org.math.plot.render.AWTDrawer;
import org.math.plot.render.AWTDrawer3D;
import org.math.plot.render.Projection3D;
import org.math.plot.utils.Array;
import org.math.plot.utils.Histogram;

public class Plot3DCanvas
extends PlotCanvas {
    private static final long serialVersionUID = 1L;
    public static final int ROTATION = 2;

    public Plot3DCanvas() {
        this.ActionMode = 2;
    }

    public Plot3DCanvas(Base b) {
        super(b, new BasePlot(b, "X", "Y", "Z"));
        this.ActionMode = 2;
    }

    public Plot3DCanvas(Base b, BasePlot bp) {
        super(b, bp);
        this.ActionMode = 2;
    }

    public Plot3DCanvas(double[] min2, double[] max2, String[] axesScales, String[] axesLabels) {
        super(min2, max2, axesScales, axesLabels);
        this.ActionMode = 2;
    }

    @Override
    public void initDrawer() {
        this.draw = new AWTDrawer3D(this);
    }

    @Override
    public void initBasenGrid(double[] min2, double[] max2) {
        this.initBasenGrid(min2, max2, new String[]{"lin", "lin", "lin"}, new String[]{"X", "Y", "Z"});
    }

    @Override
    public void initBasenGrid() {
        this.initBasenGrid(new double[]{0.0, 0.0, 0.0}, new double[]{1.0, 1.0, 1.0});
    }

    private static double[][] convertXYZ(double[] ... XYZ) {
        if (XYZ.length == 3 && XYZ[0].length != 3) {
            return Array.mergeColumns(XYZ[0], XYZ[1], XYZ[2]);
        }
        return XYZ;
    }

    public void setDefaultZoom(double zoom_factor) {
        ((Projection3D)((AWTDrawer3D)this.draw).projection).factor = zoom_factor;
    }

    public int addScatterPlot(String name, Color c, double[][] XYZ) {
        return this.addPlot(new ScatterPlot(name, c, Plot3DCanvas.convertXYZ(XYZ)));
    }

    public int addScatterPlot(String name, Color c, double[] X, double[] Y, double[] Z) {
        return this.addPlot(new ScatterPlot(name, c, Plot3DCanvas.convertXYZ(X, Y, Z)));
    }

    public int addLinePlot(String name, Color c, double[][] XYZ) {
        return this.addPlot(new LinePlot(name, c, Plot3DCanvas.convertXYZ(XYZ)));
    }

    public int addLinePlot(String name, Color c, double[] X, double[] Y, double[] Z) {
        return this.addPlot(new LinePlot(name, c, Plot3DCanvas.convertXYZ(X, Y, Z)));
    }

    public int addBarPlot(String name, Color c, double[][] XYZ) {
        return this.addPlot(new BarPlot(name, c, Plot3DCanvas.convertXYZ(XYZ)));
    }

    public int addBarPlot(String name, Color c, double[] X, double[] Y, double[] Z) {
        return this.addPlot(new BarPlot(name, c, Plot3DCanvas.convertXYZ(X, Y, Z)));
    }

    public int addBoxPlot(String name, Color c, double[][] XY, double[][] dX) {
        return this.addPlot(new BoxPlot3D(XY, dX, c, name));
    }

    public int addBoxPlot(String name, Color c, double[][] XYdX) {
        return this.addPlot(new BoxPlot3D(Array.getColumnsRangeCopy(XYdX, 0, 2), Array.getColumnsRangeCopy(XYdX, 3, 5), c, name));
    }

    public int addHistogramPlot(String name, Color c, double[][] XY, double[][] dX) {
        return this.addPlot(new HistogramPlot3D(name, c, XY, dX));
    }

    public int addHistogramPlot(String name, Color c, double[][] XYdX) {
        return this.addPlot(new HistogramPlot3D(name, c, Array.getColumnsRangeCopy(XYdX, 0, 2), Array.getColumnsRangeCopy(XYdX, 3, 4)));
    }

    public int addHistogramPlot(String name, Color c, double[][] XY, int nX, int nY) {
        double[][] XYZ = Histogram.histogram_classes_2D(XY, nX, nY);
        return this.addPlot(new HistogramPlot3D(name, c, XYZ, XYZ[1][0] - XYZ[0][0], XYZ[nX][1] - XYZ[0][1]));
    }

    public int addHistogramPlot(String name, Color c, double[][] XY, double[] boundsX, double[] boundsY) {
        double[][] XYZ = Histogram.histogram_classes_2D(XY, boundsX, boundsY);
        return this.addPlot(new HistogramPlot3D(name, c, XYZ, XYZ[1][0] - XYZ[0][0], XYZ[boundsX.length - 1][1] - XYZ[0][1]));
    }

    public int addHistogramPlot(String name, Color c, double[][] XY, double minX, double maxX, int nX, double minY, double maxY, int nY) {
        double[][] XYZ = Histogram.histogram_classes_2D(XY, minX, maxX, nX, minY, maxY, nY);
        return this.addPlot(new HistogramPlot3D(name, c, XYZ, XYZ[1][0] - XYZ[0][0], XYZ[nX][1] - XYZ[0][1]));
    }

    public int addGridPlot(String name, Color c, double[] X, double[] Y, double[][] Z) {
        return this.addPlot(new GridPlot3D(name, c, X, Y, Z));
    }

    public int addGridPlot(String name, Color c, double[][] XYZMatrix) {
        double[] X = new double[XYZMatrix[0].length - 1];
        System.arraycopy(XYZMatrix[0], 1, X, 0, XYZMatrix[0].length - 1);
        double[] Y = new double[XYZMatrix.length - 1];
        for (int i = 0; i < Y.length; ++i) {
            Y[i] = XYZMatrix[i + 1][0];
        }
        double[][] Z = Array.getSubMatrixRangeCopy(XYZMatrix, 1, XYZMatrix.length - 1, 1, XYZMatrix[0].length - 1);
        return this.addGridPlot(name, c, X, Y, Z);
    }

    public int addCloudPlot(String name, Color c, double[][] sampleXYZ, int nX, int nY, int nZ) {
        double[][] XYZh = Histogram.histogram_classes_3D(sampleXYZ, nX, nY, nZ);
        return this.addPlot(new CloudPlot3D(name, c, XYZh, XYZh[1][0] - XYZh[0][0], XYZh[nX][1] - XYZh[0][1], XYZh[nX][2] - XYZh[0][2]));
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.ActionMode == 2) {
            this.dragging = true;
            this.mouseCurent[0] = e.getX();
            this.mouseCurent[1] = e.getY();
            e.consume();
            int[] t = new int[]{this.mouseCurent[0] - this.mouseClick[0], this.mouseCurent[1] - this.mouseClick[1]};
            ((AWTDrawer3D)this.draw).rotate(t, new int[]{this.getWidth(), this.getHeight()});
            this.mouseClick[0] = this.mouseCurent[0];
            this.mouseClick[1] = this.mouseCurent[1];
            this.repaint();
        } else {
            super.mouseDragged(e);
        }
    }

    public void rotate(double theta, double phi) {
        Projection3D proj3d = (Projection3D)((AWTDrawer)this.draw).projection;
        proj3d.rotate(proj3d.theta + theta, proj3d.phi + phi);
    }
}

