/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.math.plot.MatrixTablePanel;
import org.math.plot.canvas.PlotCanvas;
import org.math.plot.components.LegendPanel;
import org.math.plot.plots.Plot;

public class DatasFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private PlotCanvas plotCanvas;
    private LegendPanel legend;
    public JTabbedPane panels;

    public DatasFrame(PlotCanvas p, LegendPanel l) {
        super("Data");
        this.plotCanvas = p;
        this.legend = l;
        JPanel panel = new JPanel();
        this.panels = new JTabbedPane();
        for (Plot plot : this.plotCanvas.getPlots()) {
            this.panels.add((Component)new DataPanel(plot), plot.getName());
        }
        panel.add(this.panels);
        this.setContentPane(panel);
        this.pack();
        this.setVisible(true);
    }

    public class DataPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        MatrixTablePanel XY;
        JCheckBox visible;
        JButton color;
        JPanel plottoolspanel;
        Plot plot;
        DatasFrame dframe;

        public DataPanel(Plot _plot) {
            this.plot = _plot;
            this.visible = new JCheckBox("visible");
            this.visible.setSelected(this.plot.getVisible());
            this.color = new JButton();
            this.color.setBackground(this.plot.getColor());
            this.XY = new MatrixTablePanel(DatasFrame.this.plotCanvas.reverseMapedData(this.plot.getData()));
            this.visible.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (DataPanel.this.visible.isSelected()) {
                        DataPanel.this.plot.setVisible(true);
                    } else {
                        DataPanel.this.plot.setVisible(false);
                    }
                    DatasFrame.this.plotCanvas.repaint();
                }
            });
            this.color.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color c = JColorChooser.showDialog(DatasFrame.this.plotCanvas, "Choose plot color", DataPanel.this.plot.getColor());
                    DataPanel.this.color.setBackground(c);
                    DataPanel.this.plot.setColor(c);
                    DatasFrame.this.legend.updateLegends();
                    ((DatasFrame)DatasFrame.this).plotCanvas.linkedLegendPanel.repaint();
                    DatasFrame.this.plotCanvas.repaint();
                }
            });
            this.setLayout(new BorderLayout());
            this.plottoolspanel = new JPanel();
            this.plottoolspanel.add(this.visible);
            this.plottoolspanel.add(this.color);
            this.add((Component)this.plottoolspanel, "North");
            this.add((Component)this.XY, "Center");
        }
    }
}

