/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.plots;

import java.awt.Color;
import org.math.plot.FrameView;
import org.math.plot.Plot2DPanel;
import org.math.plot.plots.LayerPlot;
import org.math.plot.plots.Plot;
import org.math.plot.render.AbstractDrawer;
import org.math.plot.utils.Array;

public class DensityLayerPlot
extends LayerPlot {
    public static int WIDTH = 2;
    int axis;
    double[] constant_Q;
    double[][] Q;

    public DensityLayerPlot(Plot p, int a, double[] quantiles) {
        this(p, a, new double[0][0]);
        this.constant_Q = quantiles;
    }

    public DensityLayerPlot(Plot p, int a, double[][] quantiles) {
        super("Density of " + p.name, p);
        if (quantiles != null && quantiles.length > 0) {
            Array.checkRowDimension(quantiles, p.getData().length);
        }
        this.Q = quantiles;
        this.axis = a;
    }

    public int getAxe() {
        return this.axis;
    }

    @Override
    public void plot(AbstractDrawer draw, Color c) {
        if (!this.plot.visible) {
            return;
        }
        draw.setColor(c);
        draw.setLineType(1);
        draw.setLineWidth(WIDTH);
        if (this.constant_Q == null) {
            for (int i = 0; i < this.plot.getData().length; ++i) {
                double norm = Double.MAX_VALUE;
                for (int j = 0; j < this.Q[i].length - 1; ++j) {
                    norm = Math.min(1.0 / (this.Q[i][j + 1] - this.Q[i][j]), norm);
                }
                double[] d0 = Array.getRowCopy(this.plot.getData(), i);
                double[] d1 = Array.getRowCopy(this.plot.getData(), i);
                double[] d2 = Array.getRowCopy(this.plot.getData(), i);
                for (int j = 0; j < this.Q[i].length - 2; ++j) {
                    d1[this.axis] = d0[this.axis] + (this.Q[i][j] + this.Q[i][j + 1]) / 2.0;
                    d2[this.axis] = d0[this.axis] + (this.Q[i][j + 1] + this.Q[i][j + 2]) / 2.0;
                    Color c1 = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(255.0 * (norm / (this.Q[i][j + 1] - this.Q[i][j]))));
                    Color c2 = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(255.0 * (norm / (this.Q[i][j + 2] - this.Q[i][j + 1]))));
                    draw.setGradient(d1, c1, d2, c2);
                    draw.drawLine(d1, d2);
                }
            }
        } else {
            double norm = Double.MAX_VALUE;
            for (int j = 0; j < this.constant_Q.length - 1; ++j) {
                norm = Math.min(1.0 / (this.constant_Q[j + 1] - this.constant_Q[j]), norm);
            }
            for (int i = 0; i < this.plot.getData().length; ++i) {
                double[] d0 = Array.getRowCopy(this.plot.getData(), i);
                double[] d1 = Array.getRowCopy(this.plot.getData(), i);
                double[] d2 = Array.getRowCopy(this.plot.getData(), i);
                for (int j = 0; j < this.constant_Q.length - 2; ++j) {
                    d1[this.axis] = d0[this.axis] + (this.constant_Q[j] + this.constant_Q[j + 1]) / 2.0;
                    d2[this.axis] = d0[this.axis] + (this.constant_Q[j + 1] + this.constant_Q[j + 2]) / 2.0;
                    Color c1 = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(255.0 * (norm / (this.constant_Q[j + 1] - this.constant_Q[j]))));
                    Color c2 = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(255.0 * (norm / (this.constant_Q[j + 2] - this.constant_Q[j + 1]))));
                    draw.setGradient(d1, c1, d2, c2);
                    draw.drawLine(d1, d2);
                }
            }
        }
        draw.resetGradient();
        draw.setLineWidth(1);
    }

    @Override
    public void setData(double[][] d) {
    }

    @Override
    public double[][] getData() {
        return null;
    }

    public static void main(String[] args) {
        Plot2DPanel p2 = new Plot2DPanel();
        for (int i = 0; i < 2; ++i) {
            double[][] XYZ = new double[10][2];
            for (int j = 0; j < XYZ.length; ++j) {
                XYZ[j][0] = Math.random();
                XYZ[j][1] = 10.0 * Math.random();
            }
            p2.addScatterPlot("toto" + i, XYZ);
        }
        p2.getPlot(0).addQuantiles(1, new double[]{-4.0, -2.0, -0.5, 0.0, 0.5, 2.0, 4.0});
        p2.getPlot(1).addQuantiles(1, new double[]{-3.0, -2.0, -1.0, 0.0, 1.0, 2.0, 3.0});
        new FrameView(p2).setDefaultCloseOperation(3);
    }
}

