/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.render;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import org.math.plot.canvas.PlotCanvas;
import org.math.plot.render.AbstractDrawer;
import org.math.plot.render.Projection;
import org.math.plot.utils.FastMath;

public abstract class AWTDrawer
extends AbstractDrawer {
    public Projection projection;

    public AWTDrawer(PlotCanvas _canvas) {
        super(_canvas);
    }

    @Override
    public void resetBaseProjection() {
        this.projection.initBaseCoordsProjection(true);
    }

    @Override
    public void setColor(Color c) {
        this.comp2D.setColor(c);
    }

    @Override
    public void setGradient(double[] xy0, Color c0, double[] xy1, Color c1) {
        int[] s0 = this.project(xy0);
        int[] s1 = this.project(xy1);
        this.comp2D.setPaint(new GradientPaint(s0[0], s0[1], c0, s1[0], s1[1], c1));
    }

    @Override
    public void setFont(Font f) {
        this.comp2D.setFont(f);
    }

    @Override
    public Color getColor() {
        return this.comp2D.getColor();
    }

    @Override
    public Font getFont() {
        return this.comp2D.getFont();
    }

    @Override
    public int[] project(double ... pC) {
        return this.projection.screenProjection(pC);
    }

    @Override
    public int[] projectBase(double ... rC) {
        return this.projection.screenProjectionBase(rC);
    }

    @Override
    public void translate(int ... t) {
        this.projection.translate(t);
    }

    @Override
    public void dilate(int[] screenOrigin, double[] screenRatio) {
        this.projection.dilate(screenOrigin, screenRatio);
    }

    @Override
    public void drawText(String label, double ... pC) {
        int hc;
        int wc;
        double h;
        int[] sC = this.projection.screenProjection(pC);
        FontRenderContext frc = this.comp2D.getFontRenderContext();
        Font font1 = this.comp2D.getFont();
        int x = sC[0];
        int y = sC[1];
        double w = font1.getStringBounds(label, frc).getWidth();
        if (!this.comp2D.hitClip(x -= (int)(w * this.text_Eastoffset), y += (int)((h = (double)font1.getSize2D()) * this.text_Northoffset), wc = (int)(w * FastMath.cos(this.text_angle) + h * FastMath.sin(this.text_angle)), hc = (int)(h * FastMath.cos(this.text_angle) + w * FastMath.sin(this.text_angle)))) {
            return;
        }
        if (this.text_angle != 0.0) {
            this.comp2D.rotate(this.text_angle, (double)x + w / 2.0, (double)y - h / 2.0);
        }
        int tmpY = y;
        String[] lines = label.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            this.comp2D.drawString(lines[i], x, tmpY);
            tmpY = (int)((double)tmpY + h);
        }
        if (this.text_angle != 0.0) {
            this.comp2D.rotate(-this.text_angle, (double)x + w / 2.0, (double)y - h / 2.0);
        }
    }

    @Override
    public void drawShadowedText(String label, float alpha, double ... pC) {
        int hc;
        int wc;
        double h;
        int[] sC = this.projection.screenProjection(pC);
        FontRenderContext frc = this.comp2D.getFontRenderContext();
        Font font1 = this.comp2D.getFont();
        int x = sC[0];
        int y = sC[1];
        double w = font1.getStringBounds(label, frc).getWidth();
        if (!this.comp2D.hitClip(x -= (int)(w * this.text_Eastoffset), y += (int)((h = (double)font1.getSize2D()) * this.text_Northoffset), wc = (int)(w * FastMath.cos(this.text_angle) + h * FastMath.sin(this.text_angle)), hc = (int)(h * FastMath.cos(this.text_angle) + w * FastMath.sin(this.text_angle)))) {
            return;
        }
        if (this.text_angle != 0.0) {
            this.comp2D.rotate(this.text_angle, (double)x + w / 2.0, (double)y - h / 2.0);
        }
        Composite cs = this.comp2D.getComposite();
        Color c = this.comp2D.getColor();
        String[] lines = label.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            this.comp2D.setColor(Color.white);
            this.comp2D.setComposite(AlphaComposite.getInstance(3, alpha));
            this.comp2D.fillRect(x, y - (int)h, (int)w, (int)h);
            this.comp2D.setComposite(cs);
            this.comp2D.setColor(c);
            this.comp2D.drawString(lines[i], x, y);
            y = (int)((double)y + h);
        }
        if (this.text_angle != 0.0) {
            this.comp2D.rotate(-this.text_angle, (double)x + w / 2.0, (double)y - h / 2.0);
        }
    }

    @Override
    public void drawTextBase(String label, double ... rC) {
        int hc;
        int wc;
        double h;
        int[] sC = this.projection.screenProjectionBase(rC);
        FontRenderContext frc = this.comp2D.getFontRenderContext();
        Font font1 = this.comp2D.getFont();
        int x = sC[0];
        int y = sC[1];
        double w = font1.getStringBounds(label, frc).getWidth();
        if (!this.comp2D.hitClip(x -= (int)(w * this.text_Eastoffset), y += (int)((h = (double)font1.getSize2D()) * this.text_Northoffset), wc = (int)(w * FastMath.cos(this.text_angle) + h * FastMath.sin(this.text_angle)), hc = (int)(h * FastMath.cos(this.text_angle) + w * FastMath.sin(this.text_angle)))) {
            return;
        }
        if (this.text_angle != 0.0) {
            this.comp2D.rotate(this.text_angle, (double)x + w / 2.0, (double)y - h / 2.0);
        }
        String[] lines = label.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            this.comp2D.drawString(lines[i], x, y);
            y = (int)((double)y + h);
        }
        if (this.text_angle != 0.0) {
            this.comp2D.rotate(-this.text_angle, (double)x + w / 2.0, (double)y - h / 2.0);
        }
    }

    @Override
    public void drawLineBase(double[] ... rC) {
        int[][] sC = new int[rC.length][];
        for (int i = 0; i < sC.length; ++i) {
            sC[i] = this.projection.screenProjectionBase(rC[i]);
        }
        this.drawLine(sC);
    }

    @Override
    public void drawLine(double[] ... pC) {
        int[][] sC = new int[pC.length][];
        for (int i = 0; i < sC.length; ++i) {
            sC[i] = this.projection.screenProjection(pC[i]);
        }
        this.drawLine(sC);
    }

    private void drawLine(int[] ... c) {
        int minx = c[0][0];
        int miny = c[0][1];
        int maxx = c[0][0] + 1;
        int maxy = c[0][1] + 1;
        int[] x = new int[c.length];
        for (int i = 0; i < c.length; ++i) {
            x[i] = c[i][0];
            minx = FastMath.min(minx, x[i]);
            maxx = FastMath.max(maxx, x[i]);
        }
        int[] y = new int[c.length];
        for (int i = 0; i < c.length; ++i) {
            y[i] = c[i][1];
            miny = FastMath.min(miny, y[i]);
            maxy = FastMath.max(maxy, y[i]);
        }
        if (this.comp2D.hitClip(minx, miny, maxx - minx, maxy - miny)) {
            BasicStroke s = null;
            switch (this.line_type) {
                case 1: {
                    s = new BasicStroke(this.line_width, 0, 1);
                    break;
                }
                case 2: {
                    s = new BasicStroke(this.line_width, 0, 1, 1.0f, new float[]{2.0f}, 0.0f);
                }
            }
            this.comp2D.setStroke(s);
            this.comp2D.drawPolyline(x, y, c.length);
        }
    }

    @Override
    public void drawRoundDot(double ... pC) {
        int[] sC = this.projection.screenProjection(pC);
        this.comp2D.fillOval(sC[0] - this.dot_radius, sC[1] - this.dot_radius, 2 * this.dot_radius, 2 * this.dot_radius);
    }

    @Override
    public void drawCrossDot(double ... pC) {
        int[] sC = this.projection.screenProjection(pC);
        this.comp2D.drawLine(sC[0] - this.dot_radius, sC[1] - this.dot_radius, sC[0] + this.dot_radius, sC[1] + this.dot_radius);
        this.comp2D.drawLine(sC[0] + this.dot_radius, sC[1] - this.dot_radius, sC[0] - this.dot_radius, sC[1] + this.dot_radius);
    }

    @Override
    public void drawPatternDot(double ... pC) {
        int[] sC = this.projection.screenProjection(pC);
        int yoffset = (int)FastMath.ceil((double)this.dot_pattern.length / 2.0);
        int xoffset = (int)FastMath.ceil((double)this.dot_pattern[0].length / 2.0);
        for (int i = 0; i < this.dot_pattern.length; ++i) {
            for (int j = 0; j < this.dot_pattern[i].length; ++j) {
                if (!this.dot_pattern[i][j]) continue;
                this.comp2D.fillRect(sC[0] - xoffset + j, sC[1] - yoffset + i, 1, 1);
            }
        }
    }

    @Override
    public void drawPolygon(double[] ... pC) {
        int[][] c = new int[pC.length][2];
        for (int i = 0; i < pC.length; ++i) {
            c[i] = this.projection.screenProjection(pC[i]);
        }
        int minx = c[0][0];
        int miny = c[0][1];
        int maxx = c[0][0] + 1;
        int maxy = c[0][1] + 1;
        int[] x = new int[c.length];
        for (int i = 0; i < c.length; ++i) {
            x[i] = c[i][0];
            minx = FastMath.min(minx, x[i]);
            maxx = FastMath.max(maxx, x[i]);
        }
        int[] y = new int[c.length];
        for (int i = 0; i < c.length; ++i) {
            y[i] = c[i][1];
            miny = FastMath.min(miny, y[i]);
            maxy = FastMath.max(maxy, y[i]);
        }
        if (this.comp2D.hitClip(minx, miny, maxx - minx, maxy - miny)) {
            this.comp2D.drawPolygon(x, y, c.length);
        }
    }

    @Override
    public void fillPolygon(float alpha, double[] ... pC) {
        int[][] c = new int[pC.length][2];
        for (int i = 0; i < pC.length; ++i) {
            c[i] = this.projection.screenProjection(pC[i]);
        }
        int minx = c[0][0];
        int miny = c[0][1];
        int maxx = c[0][0] + 1;
        int maxy = c[0][1] + 1;
        int[] x = new int[c.length];
        for (int i = 0; i < c.length; ++i) {
            x[i] = c[i][0];
            minx = FastMath.min(minx, x[i]);
            maxx = FastMath.max(maxx, x[i]);
        }
        int[] y = new int[c.length];
        for (int i = 0; i < c.length; ++i) {
            y[i] = c[i][1];
            miny = FastMath.min(miny, y[i]);
            maxy = FastMath.max(maxy, y[i]);
        }
        if (this.comp2D.hitClip(minx, miny, maxx - minx, maxy - miny)) {
            Composite cs = this.comp2D.getComposite();
            this.comp2D.setComposite(AlphaComposite.getInstance(3, alpha));
            this.comp2D.fillPolygon(x, y, c.length);
            this.comp2D.setComposite(cs);
        }
    }

    @Override
    public void drawImage(Image img, float alpha, double[] _xyzSW, double[] _xyzSE, double[] _xyzNW) {
        Composite cs = this.comp2D.getComposite();
        this.comp2D.setComposite(AlphaComposite.getInstance(3, alpha));
        AffineTransform t = this.getAffineTransform(img.getWidth(this.canvas), img.getHeight(this.canvas), _xyzSW, _xyzSE, _xyzNW);
        if (t != null) {
            this.comp2D.drawImage(img, t, this.canvas);
        }
        this.comp2D.setComposite(cs);
    }

    static boolean isDiff(double[] x, int[] y) {
        return Math.abs(x[0] - (double)y[0]) > 1.0 || Math.abs(x[1] - (double)y[1]) > 1.0;
    }

    static double sign(double x) {
        if (x != 0.0) {
            return Math.signum(x);
        }
        return 1.0;
    }

    static double sqr(double x) {
        return x * x;
    }

    public AffineTransform getAffineTransform(int width, int height, double[] _xyzSW, double[] _xyzSE, double[] _xyzNW) {
        int[] cornerNW = this.projection.screenProjection(_xyzNW);
        int[] cornerSE = this.projection.screenProjection(_xyzSE);
        int[] cornerSW = this.projection.screenProjection(_xyzSW);
        double[] vectWE = new double[]{(double)cornerSE[0] - (double)cornerSW[0], (double)cornerSE[1] - (double)cornerSW[1]};
        double normvectWE = Math.sqrt(AWTDrawer.sqr(vectWE[0]) + AWTDrawer.sqr(vectWE[1]));
        double[] vectSN = new double[]{(double)cornerNW[0] - (double)cornerSW[0], (double)cornerNW[1] - (double)cornerSW[1]};
        double normvectSN = Math.sqrt(AWTDrawer.sqr(vectSN[0]) + AWTDrawer.sqr(vectSN[1]));
        double angleSW = Math.acos((vectWE[0] * vectSN[0] + vectWE[1] * vectSN[1]) / (normvectWE * normvectSN));
        if (angleSW == 0.0) {
            return null;
        }
        AffineTransform t = new AffineTransform();
        t.translate(cornerNW[0], cornerNW[1]);
        t.scale(AWTDrawer.sign(vectWE[0]), -AWTDrawer.sign(vectSN[1]));
        t.rotate(-Math.atan(vectSN[0] / vectSN[1]));
        t.shear(0.0, 1.0 / Math.tan(Math.PI - angleSW));
        t.scale(normvectWE * Math.cos(angleSW - 1.5707963267948966) / (double)width, normvectSN / (double)height);
        double[] _cornerSE_tr = new double[2];
        double[] _cornerSE = new double[]{width, height};
        t.transform(_cornerSE, 0, _cornerSE_tr, 0, 1);
        if (AWTDrawer.isDiff(_cornerSE_tr, cornerSE)) {
            double[] vectSE_NW_1 = new double[]{(double)cornerNW[0] - (double)cornerSE[0], (double)cornerNW[1] - (double)cornerSE[1]};
            double[] vectSE_NW_2 = new double[]{(double)cornerNW[0] - _cornerSE_tr[0], (double)cornerNW[1] - _cornerSE_tr[1]};
            double normvect_1 = Math.sqrt(AWTDrawer.sqr(vectSE_NW_1[0]) + AWTDrawer.sqr(vectSE_NW_1[1]));
            double normvect_2 = Math.sqrt(AWTDrawer.sqr(vectSE_NW_1[0]) + AWTDrawer.sqr(vectSE_NW_1[1]));
            double cos_angle = (vectSE_NW_1[0] * vectSE_NW_2[0] + vectSE_NW_1[1] * vectSE_NW_2[1]) / (normvect_1 * normvect_2);
            double vect = vectSE_NW_1[0] * vectSE_NW_2[1] - vectSE_NW_1[1] * vectSE_NW_2[0];
            AffineTransform t2 = new AffineTransform();
            if (vect < 0.0) {
                t2.rotate(Math.acos(cos_angle), cornerNW[0], cornerNW[1]);
            } else {
                t2.rotate(-Math.acos(cos_angle), cornerNW[0], cornerNW[1]);
            }
            t.preConcatenate(t2);
        }
        return t;
    }
}

