/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.internal.primitive;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.impl.utility.internal.primitive.ByteIteratorIterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ByteIterableIterate {
    private ByteIterableIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static boolean isEmpty(ByteIterable iterable) {
        return !iterable.byteIterator().hasNext();
    }

    public static boolean notEmpty(ByteIterable iterable) {
        return !ByteIterableIterate.isEmpty(iterable);
    }

    public static void forEach(ByteIterable iterable, ByteProcedure procedure) {
        ByteIteratorIterate.forEach(iterable.byteIterator(), procedure);
    }

    public static <R extends MutableByteCollection> R select(ByteIterable iterable, BytePredicate predicate, R targetCollection) {
        return ByteIteratorIterate.select(iterable.byteIterator(), predicate, targetCollection);
    }

    public static <R extends MutableByteCollection> R reject(ByteIterable iterable, BytePredicate predicate, R targetCollection) {
        return ByteIteratorIterate.reject(iterable.byteIterator(), predicate, targetCollection);
    }

    public static <V, R extends Collection<V>> R collect(ByteIterable iterable, ByteToObjectFunction<? extends V> function, R targetCollection) {
        return ByteIteratorIterate.collect(iterable.byteIterator(), function, targetCollection);
    }

    public static byte detectIfNone(ByteIterable iterable, BytePredicate predicate, byte ifNone) {
        return ByteIteratorIterate.detectIfNone(iterable.byteIterator(), predicate, ifNone);
    }

    public static int count(ByteIterable iterable, BytePredicate predicate) {
        return ByteIteratorIterate.count(iterable.byteIterator(), predicate);
    }

    public static boolean anySatisfy(ByteIterable iterable, BytePredicate predicate) {
        return ByteIteratorIterate.anySatisfy(iterable.byteIterator(), predicate);
    }

    public static boolean allSatisfy(ByteIterable iterable, BytePredicate predicate) {
        return ByteIteratorIterate.allSatisfy(iterable.byteIterator(), predicate);
    }

    public static boolean noneSatisfy(ByteIterable iterable, BytePredicate predicate) {
        return ByteIteratorIterate.noneSatisfy(iterable.byteIterator(), predicate);
    }

    public static long sum(ByteIterable iterable) {
        return ByteIteratorIterate.sum(iterable.byteIterator());
    }

    public static byte max(ByteIterable iterable) {
        return ByteIteratorIterate.max(iterable.byteIterator());
    }

    public static byte maxIfEmpty(ByteIterable iterable, byte ifEmpty) {
        if (ByteIterableIterate.isEmpty(iterable)) {
            return ifEmpty;
        }
        return ByteIteratorIterate.max(iterable.byteIterator());
    }

    public static byte min(ByteIterable iterable) {
        return ByteIteratorIterate.min(iterable.byteIterator());
    }

    public static byte minIfEmpty(ByteIterable iterable, byte ifEmpty) {
        if (ByteIterableIterate.isEmpty(iterable)) {
            return ifEmpty;
        }
        return ByteIteratorIterate.min(iterable.byteIterator());
    }

    public static void appendString(ByteIterable iterable, Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            ByteIterator iterator2 = iterable.byteIterator();
            if (iterator2.hasNext()) {
                appendable.append(ByteIterableIterate.stringValueOfItem(iterable, iterator2.next()));
                while (iterator2.hasNext()) {
                    appendable.append(separator);
                    appendable.append(ByteIterableIterate.stringValueOfItem(iterable, iterator2.next()));
                }
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T injectInto(ByteIterable iterable, T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return ByteIteratorIterate.injectInto(iterable.byteIterator(), injectedValue, function);
    }

    private static <T> String stringValueOfItem(ByteIterable iterable, T item) {
        return item == iterable ? "(this " + iterable.getClass().getSimpleName() + ')' : String.valueOf(item);
    }
}

