/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.utils;

import org.math.plot.utils.NumbersUtils;

public strictfp final class FastMath {
    private static final boolean STRICT_MATH = false;
    private static final boolean USE_JDK_MATH = false;
    private static final boolean USE_REDEFINED_LOG = true;
    private static final boolean USE_REDEFINED_SQRT = true;
    private static final boolean USE_POWTABS_FOR_ASIN = true;
    public static final double PI_SUP;
    private static final double ONE_DIV_F2 = 0.5;
    private static final double ONE_DIV_F3 = 0.16666666666666666;
    private static final double ONE_DIV_F4 = 0.041666666666666664;
    private static final double TWO_POW_24;
    private static final double TWO_POW_N24;
    private static final double TWO_POW_26;
    private static final double TWO_POW_N26;
    private static final double TWO_POW_27;
    private static final double TWO_POW_N27;
    private static final double TWO_POW_N28;
    private static final double TWO_POW_52;
    private static final double TWO_POW_N54;
    private static final double TWO_POW_N55;
    private static final double TWO_POW_66;
    private static final double TWO_POW_450;
    private static final double TWO_POW_N450;
    private static final double TWO_POW_750;
    private static final double TWO_POW_N750;
    private static final double MIN_DOUBLE_NORMAL;
    private static final int MIN_DOUBLE_EXPONENT = -1074;
    private static final int MAX_DOUBLE_EXPONENT = 1023;
    private static final int MAX_FLOAT_EXPONENT = 127;
    private static final double LOG_2;
    private static final double LOG_TWO_POW_27;
    private static final double LOG_DOUBLE_MAX_VALUE;
    private static final double INV_LOG_10;
    private static final double DOUBLE_BEFORE_60;
    private static final double[] ONE_OVER_TWOPI_TAB;
    private static final double TWOPI_TAB0;
    private static final double TWOPI_TAB1;
    private static final double TWOPI_TAB2;
    private static final double TWOPI_TAB3;
    private static final double TWOPI_TAB4;
    private static final double INVPIO2;
    private static final double PIO2_HI;
    private static final double PIO2_LO;
    private static final double INVTWOPI;
    private static final double TWOPI_HI;
    private static final double TWOPI_LO;
    private static final double NORMALIZE_ANGLE_MAX_MEDIUM_DOUBLE;
    private static final double TWO_MATH_PI_IN_MINUS_PI_PI = -2.449293598153844E-16;
    private static final int SIN_COS_TABS_SIZE;
    private static final double SIN_COS_DELTA_HI;
    private static final double SIN_COS_DELTA_LO;
    private static final double SIN_COS_INDEXER;
    private static final double[] sinTab;
    private static final double[] cosTab;
    private static final double SIN_COS_MAX_VALUE_FOR_INT_MODULO;
    private static final int TAN_VIRTUAL_TABS_SIZE;
    private static final double TAN_MAX_VALUE_FOR_TABS;
    private static final int TAN_TABS_SIZE;
    private static final double TAN_DELTA_HI;
    private static final double TAN_DELTA_LO;
    private static final double TAN_INDEXER;
    private static final double[] tanTab;
    private static final double[] tanDer1DivF1Tab;
    private static final double[] tanDer2DivF2Tab;
    private static final double[] tanDer3DivF3Tab;
    private static final double[] tanDer4DivF4Tab;
    private static final double TAN_MAX_VALUE_FOR_INT_MODULO;
    private static final double ASIN_MAX_VALUE_FOR_TABS;
    private static final int ASIN_TABS_SIZE;
    private static final double ASIN_DELTA;
    private static final double ASIN_INDEXER;
    private static final double[] asinTab;
    private static final double[] asinDer1DivF1Tab;
    private static final double[] asinDer2DivF2Tab;
    private static final double[] asinDer3DivF3Tab;
    private static final double[] asinDer4DivF4Tab;
    private static final double ASIN_MAX_VALUE_FOR_POWTABS;
    private static final int ASIN_POWTABS_POWER = 84;
    private static final double ASIN_POWTABS_ONE_DIV_MAX_VALUE;
    private static final int ASIN_POWTABS_SIZE;
    private static final int ASIN_POWTABS_SIZE_MINUS_ONE;
    private static final double[] asinParamPowTab;
    private static final double[] asinPowTab;
    private static final double[] asinDer1DivF1PowTab;
    private static final double[] asinDer2DivF2PowTab;
    private static final double[] asinDer3DivF3PowTab;
    private static final double[] asinDer4DivF4PowTab;
    private static final double ASIN_PIO2_HI;
    private static final double ASIN_PIO2_LO;
    private static final double ASIN_PS0;
    private static final double ASIN_PS1;
    private static final double ASIN_PS2;
    private static final double ASIN_PS3;
    private static final double ASIN_PS4;
    private static final double ASIN_PS5;
    private static final double ASIN_QS1;
    private static final double ASIN_QS2;
    private static final double ASIN_QS3;
    private static final double ASIN_QS4;
    private static final double ATAN_MAX_VALUE_FOR_TABS;
    private static final int ATAN_TABS_SIZE;
    private static final double ATAN_DELTA;
    private static final double ATAN_INDEXER;
    private static final double[] atanTab;
    private static final double[] atanDer1DivF1Tab;
    private static final double[] atanDer2DivF2Tab;
    private static final double[] atanDer3DivF3Tab;
    private static final double[] atanDer4DivF4Tab;
    private static final double ATAN_HI3;
    private static final double ATAN_LO3;
    private static final double ATAN_AT0;
    private static final double ATAN_AT1;
    private static final double ATAN_AT2;
    private static final double ATAN_AT3;
    private static final double ATAN_AT4;
    private static final double ATAN_AT5;
    private static final double ATAN_AT6;
    private static final double ATAN_AT7;
    private static final double ATAN_AT8;
    private static final double ATAN_AT9;
    private static final double ATAN_AT10;
    private static final double EXP_OVERFLOW_LIMIT;
    private static final double EXP_UNDERFLOW_LIMIT;
    private static final double EXP_MIN_INT_LIMIT = -705.0;
    private static final int EXP_LO_DISTANCE_TO_ZERO_POT = 0;
    private static final int EXP_LO_DISTANCE_TO_ZERO = 1;
    private static final int EXP_LO_TAB_SIZE_POT;
    private static final int EXP_LO_TAB_SIZE;
    private static final int EXP_LO_TAB_MID_INDEX;
    private static final int EXP_LO_INDEXING;
    private static final int EXP_LO_INDEXING_DIV_SHIFT;
    private static final double[] expHiTab;
    private static final double[] expHiInvTab;
    private static final double[] expLoPosTab;
    private static final double[] expLoNegTab;
    private static final double EXP_QUICK_A;
    private static final double EXP_QUICK_B;
    private static final double EXP_QUICK_C;
    private static final int LOG_BITS;
    private static final int LOG_TAB_SIZE;
    private static final double[] logXLogTab;
    private static final double[] logXTab;
    private static final double[] logXInvTab;
    private static final double[] twoPowTab;
    private static final int SQRT_LO_BITS;
    private static final int SQRT_LO_TAB_SIZE;
    private static final double[] sqrtXSqrtHiTab;
    private static final double[] sqrtXSqrtLoTab;
    private static final double[] sqrtSlopeHiTab;
    private static final double[] sqrtSlopeLoTab;
    private static final int CBRT_LO_BITS;
    private static final int CBRT_LO_TAB_SIZE;
    private static final double[] cbrtXCbrtHiTab;
    private static final double[] cbrtXCbrtLoTab;
    private static final double[] cbrtSlopeHiTab;
    private static final double[] cbrtSlopeLoTab;
    public static final double E = Math.E;
    public static final double PI = Math.PI;

    public static double cos(double angle) {
        if ((angle = Math.abs(angle)) > SIN_COS_MAX_VALUE_FOR_INT_MODULO && (angle = FastMath.remainderTwoPi(angle)) < 0.0) {
            angle += Math.PI * 2;
        }
        int index = (int)(angle * SIN_COS_INDEXER + 0.5);
        double delta = angle - (double)index * SIN_COS_DELTA_HI - (double)index * SIN_COS_DELTA_LO;
        double indexCos = cosTab[index &= SIN_COS_TABS_SIZE - 2];
        double indexSin = sinTab[index];
        return indexCos + delta * (-indexSin + delta * (-indexCos * 0.5 + delta * (indexSin * 0.16666666666666666 + delta * indexCos * 0.041666666666666664)));
    }

    public static double cosQuick(double angle) {
        return cosTab[(int)(Math.abs(angle) * SIN_COS_INDEXER + 0.5) & SIN_COS_TABS_SIZE - 2];
    }

    public static double sin(double angle) {
        boolean negateResult;
        if (angle < 0.0) {
            angle = -angle;
            negateResult = true;
        } else {
            negateResult = false;
        }
        if (angle > SIN_COS_MAX_VALUE_FOR_INT_MODULO && (angle = FastMath.remainderTwoPi(angle)) < 0.0) {
            angle += Math.PI * 2;
        }
        int index = (int)(angle * SIN_COS_INDEXER + 0.5);
        double delta = angle - (double)index * SIN_COS_DELTA_HI - (double)index * SIN_COS_DELTA_LO;
        double indexSin = sinTab[index &= SIN_COS_TABS_SIZE - 2];
        double indexCos = cosTab[index];
        double result = indexSin + delta * (indexCos + delta * (-indexSin * 0.5 + delta * (-indexCos * 0.16666666666666666 + delta * indexSin * 0.041666666666666664)));
        return negateResult ? -result : result;
    }

    public static double sinQuick(double angle) {
        return cosTab[(int)(Math.abs(angle - 1.5707963267948966) * SIN_COS_INDEXER + 0.5) & SIN_COS_TABS_SIZE - 2];
    }

    public static void sinAndCos(double angle, DoubleWrapper sine, DoubleWrapper cosine) {
        boolean negateResult;
        if (angle < 0.0) {
            angle = -angle;
            negateResult = true;
        } else {
            negateResult = false;
        }
        if (angle > SIN_COS_MAX_VALUE_FOR_INT_MODULO && (angle = FastMath.remainderTwoPi(angle)) < 0.0) {
            angle += Math.PI * 2;
        }
        int index = (int)(angle * SIN_COS_INDEXER + 0.5);
        double delta = angle - (double)index * SIN_COS_DELTA_HI - (double)index * SIN_COS_DELTA_LO;
        double indexSin = sinTab[index &= SIN_COS_TABS_SIZE - 2];
        double indexCos = cosTab[index];
        double result = indexSin + delta * (indexCos + delta * (-indexSin * 0.5 + delta * (-indexCos * 0.16666666666666666 + delta * indexSin * 0.041666666666666664)));
        sine.value = negateResult ? -result : result;
        cosine.value = indexCos + delta * (-indexSin + delta * (-indexCos * 0.5 + delta * (indexSin * 0.16666666666666666 + delta * indexCos * 0.041666666666666664)));
    }

    public static double tan(double angle) {
        double result;
        boolean negateResult;
        if (Math.abs(angle) > TAN_MAX_VALUE_FOR_INT_MODULO) {
            if ((angle = FastMath.remainderTwoPi(angle)) < -1.5707963267948966) {
                angle += Math.PI;
            } else if (angle > 1.5707963267948966) {
                angle -= Math.PI;
            }
        }
        if (angle < 0.0) {
            angle = -angle;
            negateResult = true;
        } else {
            negateResult = false;
        }
        int index = (int)(angle * TAN_INDEXER + 0.5);
        double delta = angle - (double)index * TAN_DELTA_HI - (double)index * TAN_DELTA_LO;
        if ((index &= 2 * (TAN_VIRTUAL_TABS_SIZE - 1) - 1) > TAN_VIRTUAL_TABS_SIZE - 1) {
            index = 2 * (TAN_VIRTUAL_TABS_SIZE - 1) - index;
            delta = -delta;
            boolean bl = negateResult = !negateResult;
        }
        if (index < TAN_TABS_SIZE) {
            result = tanTab[index] + delta * (tanDer1DivF1Tab[index] + delta * (tanDer2DivF2Tab[index] + delta * (tanDer3DivF3Tab[index] + delta * tanDer4DivF4Tab[index])));
        } else {
            index = TAN_VIRTUAL_TABS_SIZE - 1 - index;
            result = 1.0 / (tanTab[index] - delta * (tanDer1DivF1Tab[index] - delta * (tanDer2DivF2Tab[index] - delta * (tanDer3DivF3Tab[index] - delta * tanDer4DivF4Tab[index]))));
        }
        return negateResult ? -result : result;
    }

    public static double acos(double value) {
        return 1.5707963267948966 - FastMath.asin(value);
    }

    public static double acosInRange(double value) {
        if (value <= -1.0) {
            return Math.PI;
        }
        if (value >= 1.0) {
            return 0.0;
        }
        return FastMath.acos(value);
    }

    public static double asin(double value) {
        boolean negateResult;
        if (value < 0.0) {
            value = -value;
            negateResult = true;
        } else {
            negateResult = false;
        }
        if (value <= ASIN_MAX_VALUE_FOR_TABS) {
            int index = (int)(value * ASIN_INDEXER + 0.5);
            double delta = value - (double)index * ASIN_DELTA;
            double result = asinTab[index] + delta * (asinDer1DivF1Tab[index] + delta * (asinDer2DivF2Tab[index] + delta * (asinDer3DivF3Tab[index] + delta * asinDer4DivF4Tab[index])));
            return negateResult ? -result : result;
        }
        if (value <= ASIN_MAX_VALUE_FOR_POWTABS) {
            int index = (int)(FastMath.powFast(value * ASIN_POWTABS_ONE_DIV_MAX_VALUE, 84) * (double)ASIN_POWTABS_SIZE_MINUS_ONE + 0.5);
            double delta = value - asinParamPowTab[index];
            double result = asinPowTab[index] + delta * (asinDer1DivF1PowTab[index] + delta * (asinDer2DivF2PowTab[index] + delta * (asinDer3DivF3PowTab[index] + delta * asinDer4DivF4PowTab[index])));
            return negateResult ? -result : result;
        }
        if (value < 1.0) {
            double t = (1.0 - value) * 0.5;
            double p = t * (ASIN_PS0 + t * (ASIN_PS1 + t * (ASIN_PS2 + t * (ASIN_PS3 + t * (ASIN_PS4 + t * ASIN_PS5)))));
            double q = 1.0 + t * (ASIN_QS1 + t * (ASIN_QS2 + t * (ASIN_QS3 + t * ASIN_QS4)));
            double s = FastMath.sqrt(t);
            double z = s + s * (p / q);
            double result = ASIN_PIO2_HI - (z + z - ASIN_PIO2_LO);
            return negateResult ? -result : result;
        }
        if (value == 1.0) {
            return negateResult ? -1.5707963267948966 : 1.5707963267948966;
        }
        return Double.NaN;
    }

    public static double asinInRange(double value) {
        if (value <= -1.0) {
            return -1.5707963267948966;
        }
        if (value >= 1.0) {
            return 1.5707963267948966;
        }
        return FastMath.asin(value);
    }

    public static double atan(double value) {
        boolean negateResult;
        if (value < 0.0) {
            value = -value;
            negateResult = true;
        } else {
            negateResult = false;
        }
        if (value == 1.0) {
            return negateResult ? -0.7853981633974483 : 0.7853981633974483;
        }
        if (value <= ATAN_MAX_VALUE_FOR_TABS) {
            int index = (int)(value * ATAN_INDEXER + 0.5);
            double delta = value - (double)index * ATAN_DELTA;
            double result = atanTab[index] + delta * (atanDer1DivF1Tab[index] + delta * (atanDer2DivF2Tab[index] + delta * (atanDer3DivF3Tab[index] + delta * atanDer4DivF4Tab[index])));
            return negateResult ? -result : result;
        }
        if (value < TWO_POW_66) {
            double x = -1.0 / value;
            double x2 = x * x;
            double x4 = x2 * x2;
            double s1 = x2 * (ATAN_AT0 + x4 * (ATAN_AT2 + x4 * (ATAN_AT4 + x4 * (ATAN_AT6 + x4 * (ATAN_AT8 + x4 * ATAN_AT10)))));
            double s2 = x4 * (ATAN_AT1 + x4 * (ATAN_AT3 + x4 * (ATAN_AT5 + x4 * (ATAN_AT7 + x4 * ATAN_AT9))));
            double result = ATAN_HI3 - (x * (s1 + s2) - ATAN_LO3 - x);
            return negateResult ? -result : result;
        }
        if (Double.isNaN(value)) {
            return Double.NaN;
        }
        return negateResult ? -1.5707963267948966 : 1.5707963267948966;
    }

    public static double atan2(double y, double x) {
        if (x > 0.0) {
            if (y == 0.0) {
                return 1.0 / y == Double.NEGATIVE_INFINITY ? -0.0 : 0.0;
            }
            if (x == Double.POSITIVE_INFINITY) {
                if (y == Double.POSITIVE_INFINITY) {
                    return 0.7853981633974483;
                }
                if (y == Double.NEGATIVE_INFINITY) {
                    return -0.7853981633974483;
                }
                if (y > 0.0) {
                    return 0.0;
                }
                if (y < 0.0) {
                    return -0.0;
                }
                return Double.NaN;
            }
            return FastMath.atan(y / x);
        }
        if (x < 0.0) {
            if (y == 0.0) {
                return 1.0 / y == Double.NEGATIVE_INFINITY ? -Math.PI : Math.PI;
            }
            if (x == Double.NEGATIVE_INFINITY) {
                if (y == Double.POSITIVE_INFINITY) {
                    return 2.356194490192345;
                }
                if (y == Double.NEGATIVE_INFINITY) {
                    return -2.356194490192345;
                }
                if (y > 0.0) {
                    return Math.PI;
                }
                if (y < 0.0) {
                    return -Math.PI;
                }
                return Double.NaN;
            }
            if (y > 0.0) {
                return 1.5707963267948966 + FastMath.atan(-x / y);
            }
            if (y < 0.0) {
                return -1.5707963267948966 - FastMath.atan(x / y);
            }
            return Double.NaN;
        }
        if (x == 0.0) {
            if (y == 0.0) {
                if (1.0 / x == Double.NEGATIVE_INFINITY) {
                    return 1.0 / y == Double.NEGATIVE_INFINITY ? -Math.PI : Math.PI;
                }
                return 1.0 / y == Double.NEGATIVE_INFINITY ? -0.0 : 0.0;
            }
            if (y > 0.0) {
                return 1.5707963267948966;
            }
            if (y < 0.0) {
                return -1.5707963267948966;
            }
            return Double.NaN;
        }
        return Double.NaN;
    }

    public static double cosh(double value) {
        if (value < 0.0) {
            value = -value;
        }
        if (value < LOG_TWO_POW_27) {
            if (value < TWO_POW_N27) {
                return 1.0;
            }
            double t = FastMath.exp(value);
            return 0.5 * (t + 1.0 / t);
        }
        if (value < LOG_DOUBLE_MAX_VALUE) {
            return 0.5 * FastMath.exp(value);
        }
        double t = FastMath.exp(value * 0.5);
        return 0.5 * t * t;
    }

    public static double sinh(double value) {
        double h;
        if (value < 0.0) {
            value = -value;
            h = -0.5;
        } else {
            h = 0.5;
        }
        if (value < 22.0) {
            if (value < TWO_POW_N28) {
                return h < 0.0 ? -value : value;
            }
            double t = FastMath.expm1(value);
            return h * (t + t / (t + 1.0));
        }
        if (value < LOG_DOUBLE_MAX_VALUE) {
            return h * FastMath.exp(value);
        }
        double t = FastMath.exp(value * 0.5);
        return h * t * t;
    }

    public static void sinhAndCosh(double value, DoubleWrapper hsine, DoubleWrapper hcosine) {
        double h;
        if (value < 0.0) {
            value = -value;
            h = -0.5;
        } else {
            h = 0.5;
        }
        if (value < LOG_TWO_POW_27) {
            double t;
            if (value < TWO_POW_N28) {
                hsine.value = h < 0.0 ? -value : value;
            } else {
                t = FastMath.expm1(value);
                hsine.value = h * (t + t / (t + 1.0));
            }
            if (value < TWO_POW_N27) {
                hcosine.value = 1.0;
            } else {
                t = FastMath.exp(value);
                hcosine.value = 0.5 * (t + 1.0 / t);
            }
        } else if (value < 22.0) {
            double t = FastMath.expm1(value);
            hsine.value = h * (t + t / (t + 1.0));
            hcosine.value = 0.5 * (t + 1.0);
        } else {
            if (value < LOG_DOUBLE_MAX_VALUE) {
                hsine.value = h * FastMath.exp(value);
            } else {
                double t = FastMath.exp(value * 0.5);
                hsine.value = h * t * t;
            }
            hcosine.value = Math.abs(hsine.value);
        }
    }

    public static double tanh(double value) {
        double z;
        boolean negateResult;
        if (value < 0.0) {
            value = -value;
            negateResult = true;
        } else {
            negateResult = false;
        }
        if (value < 22.0) {
            if (value < TWO_POW_N55) {
                return negateResult ? -value * (1.0 - value) : value * (1.0 + value);
            }
            if (value >= 1.0) {
                z = 1.0 - 2.0 / (FastMath.expm1(value + value) + 2.0);
            } else {
                double t = FastMath.expm1(-(value + value));
                z = -t / (t + 2.0);
            }
        } else {
            z = value != value ? Double.NaN : 1.0;
        }
        return negateResult ? -z : z;
    }

    public static double exp(double value) {
        if (value >= 0.0) {
            if (value > EXP_OVERFLOW_LIMIT) {
                return Double.POSITIVE_INFINITY;
            }
            int i = (int)(value * (double)EXP_LO_INDEXING);
            int valueInt = i >> EXP_LO_INDEXING_DIV_SHIFT;
            double delta = value - (double)valueInt - (double)(i -= valueInt << EXP_LO_INDEXING_DIV_SHIFT) * (1.0 / (double)EXP_LO_INDEXING);
            return expHiTab[valueInt] * (expLoPosTab[i + EXP_LO_TAB_MID_INDEX] * (1.0 + delta * (1.0 + delta * (0.5 + delta * (0.16666666666666666 + delta * 0.041666666666666664)))));
        }
        if (!(value >= EXP_UNDERFLOW_LIMIT)) {
            return value < EXP_UNDERFLOW_LIMIT ? 0.0 : Double.NaN;
        }
        int i = -((int)(-(value * (double)EXP_LO_INDEXING)));
        int valueInt = -(-i >> EXP_LO_INDEXING_DIV_SHIFT);
        double delta = value - (double)valueInt - (double)(i -= valueInt << EXP_LO_INDEXING_DIV_SHIFT) * (1.0 / (double)EXP_LO_INDEXING);
        double tmp = expHiInvTab[-valueInt] * (expLoPosTab[i + EXP_LO_TAB_MID_INDEX] * (1.0 + delta * (1.0 + delta * (0.5 + delta * (0.16666666666666666 + delta * 0.041666666666666664)))));
        return (double)valueInt >= -705.0 ? tmp : tmp * TWO_POW_N54;
    }

    public static double expQuick(double value) {
        return Double.longBitsToDouble((long)((int)(EXP_QUICK_A / 4.294967296E9 * value + (EXP_QUICK_B - EXP_QUICK_C) / 4.294967296E9)) << 32);
    }

    public static double expm1(double value) {
        if (Math.abs(value) < 1.0) {
            int i = (int)(value * (double)EXP_LO_INDEXING);
            double delta = value - (double)i * (1.0 / (double)EXP_LO_INDEXING);
            return expLoPosTab[i + EXP_LO_TAB_MID_INDEX] * (expLoNegTab[i + EXP_LO_TAB_MID_INDEX] + delta * (1.0 + delta * (0.5 + delta * (0.16666666666666666 + delta * (0.041666666666666664 + delta * 0.008333333333333333)))));
        }
        return FastMath.exp(value) - 1.0;
    }

    public static double log(double value) {
        if (value > 0.0) {
            double h;
            if (value == Double.POSITIVE_INFINITY) {
                return Double.POSITIVE_INFINITY;
            }
            if (value > 0.95) {
                if (value < 1.14) {
                    double z = (value - 1.0) / (value + 1.0);
                    double z2 = z * z;
                    return z * (2.0 + z2 * (0.6666666666666666 + z2 * (0.4 + z2 * (0.2857142857142857 + z2 * (0.2222222222222222 + z2 * 0.18181818181818182)))));
                }
                h = 0.0;
            } else if (value < MIN_DOUBLE_NORMAL) {
                value *= TWO_POW_52;
                h = -52.0 * LOG_2;
            } else {
                h = 0.0;
            }
            int valueBitsHi = (int)(Double.doubleToRawLongBits(value) >> 32);
            int valueExp = (valueBitsHi >> 20) - 1023;
            int xIndex = valueBitsHi << 12 >>> 32 - LOG_BITS;
            double z = value * twoPowTab[-valueExp - -1074] * logXInvTab[xIndex] - 1.0;
            z *= 1.0 - z * (0.5 - z * 0.3333333333333333);
            return h + (double)valueExp * LOG_2 + (logXLogTab[xIndex] + z);
        }
        if (value == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.NaN;
    }

    public static double logQuick(double value) {
        double h;
        if (value > 0.87) {
            if (value < 1.16) {
                return 2.0 * (value - 1.0) / (value + 1.0);
            }
            h = 0.0;
        } else if (value < MIN_DOUBLE_NORMAL) {
            value *= TWO_POW_52;
            h = -52.0 * LOG_2;
        } else {
            h = 0.0;
        }
        int valueBitsHi = (int)(Double.doubleToRawLongBits(value) >> 32);
        int valueExp = (valueBitsHi >> 20) - 1023;
        int xIndex = valueBitsHi << 12 >>> 32 - LOG_BITS;
        return h + (double)valueExp * LOG_2 + logXLogTab[xIndex];
    }

    public static double log10(double value) {
        return FastMath.log(value) * INV_LOG_10;
    }

    public static double log1p(double value) {
        if (value > -1.0) {
            if (value == Double.POSITIVE_INFINITY) {
                return Double.POSITIVE_INFINITY;
            }
            double valuePlusOne = 1.0 + value;
            if (valuePlusOne == 1.0) {
                return value;
            }
            if (Math.abs(value) < 0.15) {
                double z = value / (value + 2.0);
                double z2 = z * z;
                return z * (2.0 + z2 * (0.6666666666666666 + z2 * (0.4 + z2 * (0.2857142857142857 + z2 * (0.2222222222222222 + z2 * 0.18181818181818182)))));
            }
            int valuePlusOneBitsHi = (int)(Double.doubleToRawLongBits(valuePlusOne) >> 32) & Integer.MAX_VALUE;
            int valuePlusOneExp = (valuePlusOneBitsHi >> 20) - 1023;
            int xIndex = valuePlusOneBitsHi << 12 >>> 32 - LOG_BITS;
            double z = valuePlusOne * twoPowTab[-valuePlusOneExp - -1074] * logXInvTab[xIndex] - 1.0;
            z *= 1.0 - z * (0.5 - z * 0.3333333333333333);
            return (double)valuePlusOneExp * LOG_2 + logXLogTab[xIndex] + (z + (value - (valuePlusOne - 1.0)) / valuePlusOne);
        }
        if (value == -1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.NaN;
    }

    public static int log2(int value) {
        return NumbersUtils.log2(value);
    }

    public static int log2(long value) {
        return NumbersUtils.log2(value);
    }

    public static double pow(double value, double power) {
        if (power == 0.0) {
            return 1.0;
        }
        if (power == 1.0) {
            return value;
        }
        if (value <= 0.0) {
            int powerInfo;
            if (Math.abs(power) >= TWO_POW_52 * 2.0) {
                powerInfo = 1;
            } else if (Math.abs(power) <= 2.147483647E9) {
                int powerAsInt = (int)power;
                powerInfo = power == (double)powerAsInt ? ((powerAsInt & 1) == 0 ? 1 : -1) : 0;
            } else {
                long powerAsLong = (long)power;
                if (power == (double)powerAsLong) {
                    powerInfo = (powerAsLong & 1L) == 0L ? 1 : -1;
                } else {
                    if (power != power) {
                        return Double.NaN;
                    }
                    powerInfo = 0;
                }
            }
            if (value == 0.0) {
                if (power < 0.0) {
                    return powerInfo < 0 ? 1.0 / value : Double.POSITIVE_INFINITY;
                }
                return powerInfo < 0 ? value : 0.0;
            }
            if (value == Double.NEGATIVE_INFINITY) {
                if (powerInfo < 0) {
                    return power < 0.0 ? -0.0 : Double.NEGATIVE_INFINITY;
                }
                return power < 0.0 ? 0.0 : Double.POSITIVE_INFINITY;
            }
            return powerInfo != 0 ? (double)powerInfo * FastMath.exp(power * FastMath.log(-value)) : Double.NaN;
        }
        return FastMath.exp(power * FastMath.log(value));
    }

    public static double powQuick(double value, double power) {
        return FastMath.exp(power * FastMath.logQuick(value));
    }

    public static double powFast(double value, int power) {
        if (power > 5) {
            double oddRemains = 1.0;
            do {
                if ((power & 1) != 0) {
                    oddRemains *= value;
                }
                value *= value;
            } while ((power >>= 1) > 5);
            if (power == 3) {
                return oddRemains * value * value * value;
            }
            double v2 = value * value;
            if (power == 4) {
                return oddRemains * v2 * v2;
            }
            return oddRemains * v2 * v2 * value;
        }
        if (power >= 0) {
            if (power < 3) {
                if (power == 2) {
                    return value * value;
                }
                if (power != 0) {
                    return value;
                }
                return 1.0;
            }
            if (power == 3) {
                return value * value * value;
            }
            double v2 = value * value;
            if (power == 4) {
                return v2 * v2;
            }
            return v2 * v2 * value;
        }
        if (power == Integer.MIN_VALUE) {
            return 1.0 / (FastMath.powFast(value, Integer.MAX_VALUE) * value);
        }
        return 1.0 / FastMath.powFast(value, -power);
    }

    public static double twoPow(int power) {
        if (power >= 0) {
            if (power <= 1023) {
                return twoPowTab[power - -1074];
            }
            return Double.POSITIVE_INFINITY;
        }
        if (power >= -1074) {
            return twoPowTab[power - -1074];
        }
        return 0.0;
    }

    public static int pow2(int value) {
        return NumbersUtils.pow2(value);
    }

    public static long pow2(long value) {
        return NumbersUtils.pow2(value);
    }

    public static float pow2(float value) {
        return NumbersUtils.pow2(value);
    }

    public static double pow2(double value) {
        return NumbersUtils.pow2(value);
    }

    public static int pow3(int value) {
        return NumbersUtils.pow3(value);
    }

    public static long pow3(long value) {
        return NumbersUtils.pow3(value);
    }

    public static float pow3(float value) {
        return NumbersUtils.pow3(value);
    }

    public static double pow3(double value) {
        return NumbersUtils.pow3(value);
    }

    public static double sqrt(double value) {
        double h;
        if (!(value > 0.0)) {
            return value == 0.0 ? value : Double.NaN;
        }
        if (value == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (value < MIN_DOUBLE_NORMAL) {
            value *= TWO_POW_52;
            h = 2.0 * TWO_POW_N26;
        } else {
            h = 2.0;
        }
        int valueBitsHi = (int)(Double.doubleToRawLongBits(value) >> 32);
        int valueExponentIndex = (valueBitsHi >> 20) + 51;
        int xIndex = valueBitsHi << 12 >>> 32 - SQRT_LO_BITS;
        double result = sqrtXSqrtHiTab[valueExponentIndex] * sqrtXSqrtLoTab[xIndex];
        double slope = sqrtSlopeHiTab[valueExponentIndex] * sqrtSlopeLoTab[xIndex];
        result += ((value *= 0.25) - result * result) * slope;
        result += (value - result * result) * slope;
        return h * (result + (value - result * result) * slope);
    }

    public static double cbrt(double value) {
        double h;
        if (value < 0.0) {
            if (value == Double.NEGATIVE_INFINITY) {
                return Double.NEGATIVE_INFINITY;
            }
            if ((value = -value) < MIN_DOUBLE_NORMAL) {
                value *= TWO_POW_52 * TWO_POW_26;
                h = -2.0 * TWO_POW_N26;
            } else {
                h = -2.0;
            }
        } else {
            if (!(value < Double.POSITIVE_INFINITY)) {
                return value;
            }
            if (value < MIN_DOUBLE_NORMAL) {
                if (value == 0.0) {
                    return value;
                }
                value *= TWO_POW_52 * TWO_POW_26;
                h = 2.0 * TWO_POW_N26;
            } else {
                h = 2.0;
            }
        }
        int valueBitsHi = (int)(Double.doubleToRawLongBits(value) >> 32);
        int valueExponentIndex = (valueBitsHi >> 20) + 51;
        int xIndex = valueBitsHi << 12 >>> 32 - CBRT_LO_BITS;
        double result = cbrtXCbrtHiTab[valueExponentIndex] * cbrtXCbrtLoTab[xIndex];
        double slope = cbrtSlopeHiTab[valueExponentIndex] * cbrtSlopeLoTab[xIndex];
        result += ((value *= 0.125) - result * result * result) * slope;
        result += (value - result * result * result) * slope;
        return h * (result + (value - result * result * result) * slope);
    }

    public static double remainder(double dividend, double divisor) {
        if (Double.isInfinite(divisor)) {
            if (Double.isInfinite(dividend)) {
                return Double.NaN;
            }
            return dividend;
        }
        double value = dividend % divisor;
        if (Math.abs(value + value) > Math.abs(divisor)) {
            return value + (value > 0.0 ? -Math.abs(divisor) : Math.abs(divisor));
        }
        return value;
    }

    public static double normalizeMinusPiPi(double angle) {
        if (angle >= -Math.PI && angle <= Math.PI) {
            return angle;
        }
        double angleMinusPiPiOrSo = FastMath.remainderTwoPi(angle);
        if (angleMinusPiPiOrSo < -Math.PI) {
            return -Math.PI;
        }
        if (angleMinusPiPiOrSo > Math.PI) {
            return Math.PI;
        }
        return angleMinusPiPiOrSo;
    }

    public static double normalizeMinusPiPiFast(double angle) {
        if (angle >= -Math.PI && angle <= Math.PI) {
            return angle;
        }
        double angleMinusPiPiOrSo = FastMath.remainderTwoPiFast(angle);
        if (angleMinusPiPiOrSo < -Math.PI) {
            return -Math.PI;
        }
        if (angleMinusPiPiOrSo > Math.PI) {
            return Math.PI;
        }
        return angleMinusPiPiOrSo;
    }

    public static double normalizeZeroTwoPi(double angle) {
        if (angle >= 0.0 && angle <= Math.PI * 2) {
            return angle;
        }
        double angleMinusPiPiOrSo = FastMath.remainderTwoPi(angle);
        if (angleMinusPiPiOrSo < 0.0) {
            return angleMinusPiPiOrSo + Math.PI * 2;
        }
        return angleMinusPiPiOrSo;
    }

    public static double normalizeZeroTwoPiFast(double angle) {
        if (angle >= 0.0 && angle <= Math.PI * 2) {
            return angle;
        }
        double angleMinusPiPiOrSo = FastMath.remainderTwoPiFast(angle);
        if (angleMinusPiPiOrSo < 0.0) {
            return angleMinusPiPiOrSo + Math.PI * 2;
        }
        return angleMinusPiPiOrSo;
    }

    public static double normalizeMinusHalfPiHalfPi(double angle) {
        if (angle >= -1.5707963267948966 && angle <= 1.5707963267948966) {
            return angle;
        }
        double angleMinusPiPiOrSo = FastMath.remainderTwoPi(angle);
        if (angleMinusPiPiOrSo < -1.5707963267948966) {
            return angleMinusPiPiOrSo + Math.PI;
        }
        if (angleMinusPiPiOrSo > 1.5707963267948966) {
            return angleMinusPiPiOrSo - Math.PI;
        }
        return angleMinusPiPiOrSo;
    }

    public static double normalizeMinusHalfPiHalfPiFast(double angle) {
        if (angle >= -1.5707963267948966 && angle <= 1.5707963267948966) {
            return angle;
        }
        double angleMinusPiPiOrSo = FastMath.remainderTwoPiFast(angle);
        if (angleMinusPiPiOrSo < -1.5707963267948966) {
            return angleMinusPiPiOrSo + Math.PI;
        }
        if (angleMinusPiPiOrSo > 1.5707963267948966) {
            return angleMinusPiPiOrSo - Math.PI;
        }
        return angleMinusPiPiOrSo;
    }

    public static double hypot(double x, double y) {
        double factor;
        x = Math.abs(x);
        if ((y = Math.abs(y)) < x) {
            double a = x;
            x = y;
            y = a;
        } else if (!(y >= x)) {
            if (x == Double.POSITIVE_INFINITY || y == Double.POSITIVE_INFINITY) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }
        if (y - x == y) {
            return y;
        }
        if (x > TWO_POW_450) {
            x *= TWO_POW_N750;
            y *= TWO_POW_N750;
            factor = TWO_POW_750;
        } else if (y < TWO_POW_N450) {
            x *= TWO_POW_750;
            y *= TWO_POW_750;
            factor = TWO_POW_N750;
        } else {
            factor = 1.0;
        }
        return factor * FastMath.sqrt(x * x + y * y);
    }

    public static float ceil(float value) {
        return -FastMath.floor(-value);
    }

    public static double ceil(double value) {
        return -FastMath.floor(-value);
    }

    public static float floor(float value) {
        int exp = FastMath.getExponent(value);
        if (exp < 0) {
            if (value < 0.0f) {
                return -1.0f;
            }
            return 0.0f * value;
        }
        if (exp < 24) {
            int valueBits = Float.floatToRawIntBits(value);
            int anteCommaDigits = valueBits & -8388608 >> exp;
            if (value < 0.0f && anteCommaDigits != valueBits) {
                return Float.intBitsToFloat(anteCommaDigits) - 1.0f;
            }
            return Float.intBitsToFloat(anteCommaDigits);
        }
        return value;
    }

    public static double floor(double value) {
        if (Math.abs(value) <= 2.147483647E9) {
            if (value > 0.0) {
                return (int)value;
            }
            if (value < 0.0) {
                double anteCommaDigits = (int)value;
                if (value != anteCommaDigits) {
                    return anteCommaDigits - 1.0;
                }
                return anteCommaDigits;
            }
            return value;
        }
        if (Math.abs(value) < TWO_POW_52) {
            double highPart = (double)((int)(value * TWO_POW_N26)) * TWO_POW_26;
            if (value > 0.0) {
                return highPart + (double)((int)(value - highPart));
            }
            double anteCommaDigits = highPart + (double)((int)(value - highPart));
            if (value != anteCommaDigits) {
                return anteCommaDigits - 1.0;
            }
            return anteCommaDigits;
        }
        return value;
    }

    public static int round(float value) {
        return (int)FastMath.floor(value + 0.5f);
    }

    public static long round(double value) {
        double roundedValue = FastMath.floor(value + 0.5);
        if (Math.abs(roundedValue) <= 2.147483647E9) {
            return (int)roundedValue;
        }
        return (long)roundedValue;
    }

    public static int getExponent(float value) {
        return (Float.floatToRawIntBits(value) >> 23 & 0xFF) - 127;
    }

    public static int getExponent(double value) {
        return ((int)(Double.doubleToRawLongBits(value) >> 52) & 0x7FF) - 1023;
    }

    public static double toDegrees(double angrad) {
        return angrad * 57.29577951308232;
    }

    public static double toRadians(double angdeg) {
        return angdeg * (Math.PI / 180);
    }

    public static double toRadians(boolean sign, int degrees, int minutes, double seconds) {
        return FastMath.toRadians(FastMath.toDegrees(sign, degrees, minutes, seconds));
    }

    public static double toDegrees(boolean sign, int degrees, int minutes, double seconds) {
        double signFactor = sign ? 1.0 : -1.0;
        return signFactor * ((double)degrees + 0.016666666666666666 * ((double)minutes + 0.016666666666666666 * seconds));
    }

    public static boolean toDMS(double angrad, IntWrapper degrees, IntWrapper minutes, DoubleWrapper seconds) {
        boolean isNeg;
        double tmp = FastMath.toDegrees(FastMath.normalizeMinusPiPi(angrad));
        boolean bl = isNeg = tmp < 0.0;
        if (isNeg) {
            tmp = -tmp;
        }
        degrees.value = (int)tmp;
        tmp = (tmp - (double)degrees.value) * 60.0;
        minutes.value = (int)tmp;
        seconds.value = Math.min((tmp - (double)minutes.value) * 60.0, DOUBLE_BEFORE_60);
        return !isNeg;
    }

    public static int abs(int value) {
        return NumbersUtils.abs(value);
    }

    public static int toIntExact(long value) {
        return NumbersUtils.asInt(value);
    }

    public static int toInt(long value) {
        return NumbersUtils.toInt(value);
    }

    public static int addExact(int a, int b) {
        return NumbersUtils.plusExact(a, b);
    }

    public static long addExact(long a, long b) {
        return NumbersUtils.plusExact(a, b);
    }

    public static int addBounded(int a, int b) {
        return NumbersUtils.plusBounded(a, b);
    }

    public static long addBounded(long a, long b) {
        return NumbersUtils.plusBounded(a, b);
    }

    public static int subtractExact(int a, int b) {
        return NumbersUtils.minusExact(a, b);
    }

    public static long subtractExact(long a, long b) {
        return NumbersUtils.minusExact(a, b);
    }

    public static int subtractBounded(int a, int b) {
        return NumbersUtils.minusBounded(a, b);
    }

    public static long subtractBounded(long a, long b) {
        return NumbersUtils.minusBounded(a, b);
    }

    public static int multiplyExact(int a, int b) {
        return NumbersUtils.timesExact(a, b);
    }

    public static long multiplyExact(long a, long b) {
        return NumbersUtils.timesExact(a, b);
    }

    public static int multiplyBounded(int a, int b) {
        return NumbersUtils.timesBounded(a, b);
    }

    public static long multiplyBounded(long a, long b) {
        return NumbersUtils.timesBounded(a, b);
    }

    public static int toRange(int minValue, int maxValue, int value) {
        return NumbersUtils.toRange(minValue, maxValue, value);
    }

    public static long toRange(long minValue, long maxValue, long value) {
        return NumbersUtils.toRange(minValue, maxValue, value);
    }

    public static float toRange(float minValue, float maxValue, float value) {
        return NumbersUtils.toRange(minValue, maxValue, value);
    }

    public static double toRange(double minValue, double maxValue, double value) {
        return NumbersUtils.toRange(minValue, maxValue, value);
    }

    public static boolean isInClockwiseDomain(double startAngRad, double angSpanRad, double angRad) {
        if (Math.abs(angRad) < 2.449293598153844E-16) {
            if (angSpanRad < 0.0) {
                return false;
            }
            if (angSpanRad <= Math.PI * 2) {
                double endAngRad;
                if ((startAngRad = FastMath.normalizeMinusPiPi(startAngRad)) <= (endAngRad = FastMath.normalizeMinusPiPi(startAngRad + angSpanRad))) {
                    return angRad >= startAngRad && angRad <= endAngRad;
                }
                return angRad >= startAngRad || angRad <= endAngRad;
            }
            return angSpanRad == angSpanRad;
        }
        return FastMath.normalizeZeroTwoPi(angRad - startAngRad) <= angSpanRad;
    }

    public static boolean isNaNOrInfinite(float value) {
        return NumbersUtils.isNaNOrInfinite(value);
    }

    public static boolean isNaNOrInfinite(double value) {
        return NumbersUtils.isNaNOrInfinite(value);
    }

    public static double abs(double a) {
        return Math.abs(a);
    }

    public static float abs(float a) {
        return Math.abs(a);
    }

    public static long abs(long a) {
        return Math.abs(a);
    }

    public static double copySign(double magnitude, double sign) {
        return Math.copySign(magnitude, sign);
    }

    public static float copySign(float magnitude, float sign) {
        return Math.copySign(magnitude, sign);
    }

    public static double IEEEremainder(double f1, double f2) {
        return Math.IEEEremainder(f1, f2);
    }

    public static double max(double a, double b) {
        return Math.max(a, b);
    }

    public static float max(float a, float b) {
        return Math.max(a, b);
    }

    public static int max(int a, int b) {
        return Math.max(a, b);
    }

    public static long max(long a, long b) {
        return Math.max(a, b);
    }

    public static double min(double a, double b) {
        return Math.min(a, b);
    }

    public static float min(float a, float b) {
        return Math.min(a, b);
    }

    public static int min(int a, int b) {
        return Math.min(a, b);
    }

    public static long min(long a, long b) {
        return Math.min(a, b);
    }

    public static double nextAfter(double start, double direction) {
        return Math.nextAfter(start, direction);
    }

    public static float nextAfter(float start, float direction) {
        return Math.nextAfter(start, (double)direction);
    }

    public static double nextUp(double d) {
        return Math.nextUp(d);
    }

    public static float nextUp(float f) {
        return Math.nextUp(f);
    }

    public static double random() {
        return Math.random();
    }

    public static double rint(double a) {
        return Math.rint(a);
    }

    public static double scalb(double d, int scaleFactor) {
        return Math.scalb(d, scaleFactor);
    }

    public static float scalb(float f, int scaleFactor) {
        return Math.scalb(f, scaleFactor);
    }

    public static double signum(double d) {
        return Math.signum(d);
    }

    public static float signum(float f) {
        return Math.signum(f);
    }

    public static double ulp(double d) {
        return Math.ulp(d);
    }

    public static float ulp(float f) {
        return Math.ulp(f);
    }

    private FastMath() {
    }

    private static int getTabSizePower(int tabSizePower) {
        return tabSizePower;
    }

    private static double remainderTwoPi(double angle) {
        boolean negateResult;
        if (angle < 0.0) {
            negateResult = true;
            angle = -angle;
        } else {
            negateResult = false;
        }
        if (angle <= NORMALIZE_ANGLE_MAX_MEDIUM_DOUBLE) {
            double fn = (int)(angle * INVTWOPI + 0.5);
            double result = angle - fn * TWOPI_HI - fn * TWOPI_LO;
            return negateResult ? -result : result;
        }
        if (angle < Double.POSITIVE_INFINITY) {
            long lx = Double.doubleToRawLongBits(angle);
            long exp = (lx >> 52 & 0x7FFL) - 1046L;
            double z = Double.longBitsToDouble(lx - (exp << 52));
            double x0 = (int)z;
            z = (z - x0) * TWO_POW_24;
            double x1 = (int)z;
            double x2 = (z - x1) * TWO_POW_24;
            double result = FastMath.subRemainderTwoPi(x0, x1, x2, (int)exp, x2 == 0.0 ? 2 : 3);
            return negateResult ? -result : result;
        }
        return Double.NaN;
    }

    private static double remainderTwoPiFast(double angle) {
        boolean negateResult;
        if (angle < 0.0) {
            negateResult = true;
            angle = -angle;
        } else {
            negateResult = false;
        }
        if (angle <= TWO_POW_26 * (Math.PI * 2)) {
            double fn = (int)(angle * INVTWOPI + 0.5);
            double result = angle - fn * TWOPI_HI - fn * TWOPI_LO;
            return negateResult ? -result : result;
        }
        if (angle <= TWO_POW_52 * (Math.PI * 2)) {
            double fn = (int)(angle * (INVTWOPI / TWO_POW_26) + 0.5);
            double result = angle - fn * (TWOPI_HI * TWO_POW_26) - fn * (TWOPI_LO * TWO_POW_26);
            if (result < 0.0) {
                result = -result;
                negateResult = !negateResult;
            }
            fn = (int)(result * INVTWOPI + 0.5);
            result = result - fn * TWOPI_HI - fn * TWOPI_LO;
            return negateResult ? -result : result;
        }
        if (angle < Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        return Double.NaN;
    }

    private static double subRemainderTwoPi(double x0, double x1, double x2, int e0, int nx) {
        int iq4;
        double q4;
        double q3;
        double q2;
        double q1;
        double q0;
        double f5;
        double f6 = 0.0;
        int jx = nx - 1;
        int jv = (e0 - 3) / 24;
        int q = e0 - ((jv << 4) + (jv << 3)) - 24;
        int j = jv + 4;
        if (jx == 1) {
            f5 = j >= 0 ? ONE_OVER_TWOPI_TAB[j] : 0.0;
            double f4 = j >= 1 ? ONE_OVER_TWOPI_TAB[j - 1] : 0.0;
            double f3 = j >= 2 ? ONE_OVER_TWOPI_TAB[j - 2] : 0.0;
            double f2 = j >= 3 ? ONE_OVER_TWOPI_TAB[j - 3] : 0.0;
            double f1 = j >= 4 ? ONE_OVER_TWOPI_TAB[j - 4] : 0.0;
            double f0 = j >= 5 ? ONE_OVER_TWOPI_TAB[j - 5] : 0.0;
            q0 = x0 * f1 + x1 * f0;
            q1 = x0 * f2 + x1 * f1;
            q2 = x0 * f3 + x1 * f2;
            q3 = x0 * f4 + x1 * f3;
            q4 = x0 * f5 + x1 * f4;
        } else {
            f6 = j >= 0 ? ONE_OVER_TWOPI_TAB[j] : 0.0;
            f5 = j >= 1 ? ONE_OVER_TWOPI_TAB[j - 1] : 0.0;
            double f4 = j >= 2 ? ONE_OVER_TWOPI_TAB[j - 2] : 0.0;
            double f3 = j >= 3 ? ONE_OVER_TWOPI_TAB[j - 3] : 0.0;
            double f2 = j >= 4 ? ONE_OVER_TWOPI_TAB[j - 4] : 0.0;
            double f1 = j >= 5 ? ONE_OVER_TWOPI_TAB[j - 5] : 0.0;
            double f0 = j >= 6 ? ONE_OVER_TWOPI_TAB[j - 6] : 0.0;
            q0 = x0 * f2 + x1 * f1 + x2 * f0;
            q1 = x0 * f3 + x1 * f2 + x2 * f1;
            q2 = x0 * f4 + x1 * f3 + x2 * f2;
            q3 = x0 * f5 + x1 * f4 + x2 * f3;
            q4 = x0 * f6 + x1 * f5 + x2 * f4;
        }
        double z = q4;
        double fw = (int)(TWO_POW_N24 * z);
        int iq0 = (int)(z - TWO_POW_24 * fw);
        z = q3 + fw;
        fw = (int)(TWO_POW_N24 * z);
        int iq1 = (int)(z - TWO_POW_24 * fw);
        z = q2 + fw;
        fw = (int)(TWO_POW_N24 * z);
        int iq2 = (int)(z - TWO_POW_24 * fw);
        z = q1 + fw;
        fw = (int)(TWO_POW_N24 * z);
        int iq3 = (int)(z - TWO_POW_24 * fw);
        z = q0 + fw;
        double twoPowQ = twoPowTab[q - -1074];
        z = z * twoPowQ % 8.0;
        z -= (double)((int)z);
        int ih = q > 0 ? (iq3 &= 0xFFFFFF >> q) >> 23 - q : (q == 0 ? iq3 >> 23 : (z >= 0.5 ? 2 : 0));
        if (ih > 0) {
            boolean carry;
            if (iq0 != 0) {
                carry = true;
                iq0 = 0x1000000 - iq0;
                iq1 = 0xFFFFFF - iq1;
                iq2 = 0xFFFFFF - iq2;
                iq3 = 0xFFFFFF - iq3;
            } else if (iq1 != 0) {
                carry = true;
                iq1 = 0x1000000 - iq1;
                iq2 = 0xFFFFFF - iq2;
                iq3 = 0xFFFFFF - iq3;
            } else if (iq2 != 0) {
                carry = true;
                iq2 = 0x1000000 - iq2;
                iq3 = 0xFFFFFF - iq3;
            } else if (iq3 != 0) {
                carry = true;
                iq3 = 0x1000000 - iq3;
            } else {
                carry = false;
            }
            if (q > 0) {
                switch (q) {
                    case 1: {
                        iq3 &= 0x7FFFFF;
                        break;
                    }
                    case 2: {
                        iq3 &= 0x3FFFFF;
                    }
                }
            }
            if (ih == 2) {
                z = 1.0 - z;
                if (carry) {
                    z -= twoPowQ;
                }
            }
        }
        if (z == 0.0) {
            double q5;
            if (jx == 1) {
                f6 = ONE_OVER_TWOPI_TAB[jv + 5];
                q5 = x0 * f6 + x1 * f5;
            } else {
                double f7 = ONE_OVER_TWOPI_TAB[jv + 5];
                q5 = x0 * f7 + x1 * f6 + x2 * f5;
            }
            z = q5;
            fw = (int)(TWO_POW_N24 * z);
            iq0 = (int)(z - TWO_POW_24 * fw);
            z = q4 + fw;
            fw = (int)(TWO_POW_N24 * z);
            iq1 = (int)(z - TWO_POW_24 * fw);
            z = q3 + fw;
            fw = (int)(TWO_POW_N24 * z);
            iq2 = (int)(z - TWO_POW_24 * fw);
            z = q2 + fw;
            fw = (int)(TWO_POW_N24 * z);
            iq3 = (int)(z - TWO_POW_24 * fw);
            z = q1 + fw;
            fw = (int)(TWO_POW_N24 * z);
            iq4 = (int)(z - TWO_POW_24 * fw);
            z = q0 + fw;
            z = z * twoPowQ % 8.0;
            z -= (double)((int)z);
            ih = q > 0 ? (iq4 &= 0xFFFFFF >> q) >> 23 - q : (q == 0 ? iq4 >> 23 : (z >= 0.5 ? 2 : 0));
            if (ih > 0) {
                if (iq0 != 0) {
                    iq0 = 0x1000000 - iq0;
                    iq1 = 0xFFFFFF - iq1;
                    iq2 = 0xFFFFFF - iq2;
                    iq3 = 0xFFFFFF - iq3;
                    iq4 = 0xFFFFFF - iq4;
                } else if (iq1 != 0) {
                    iq1 = 0x1000000 - iq1;
                    iq2 = 0xFFFFFF - iq2;
                    iq3 = 0xFFFFFF - iq3;
                    iq4 = 0xFFFFFF - iq4;
                } else if (iq2 != 0) {
                    iq2 = 0x1000000 - iq2;
                    iq3 = 0xFFFFFF - iq3;
                    iq4 = 0xFFFFFF - iq4;
                } else if (iq3 != 0) {
                    iq3 = 0x1000000 - iq3;
                    iq4 = 0xFFFFFF - iq4;
                } else if (iq4 != 0) {
                    iq4 = 0x1000000 - iq4;
                }
                if (q > 0) {
                    switch (q) {
                        case 1: {
                            iq4 &= 0x7FFFFF;
                            break;
                        }
                        case 2: {
                            iq4 &= 0x3FFFFF;
                        }
                    }
                }
            }
            fw = twoPowQ * TWO_POW_N24;
        } else {
            iq4 = (int)(z / twoPowQ);
            fw = twoPowQ;
        }
        q4 = fw * (double)iq4;
        q3 = (fw *= TWO_POW_N24) * (double)iq3;
        q2 = (fw *= TWO_POW_N24) * (double)iq2;
        q1 = (fw *= TWO_POW_N24) * (double)iq1;
        q0 = (fw *= TWO_POW_N24) * (double)iq0;
        fw *= TWO_POW_N24;
        fw = TWOPI_TAB0 * q4;
        fw += TWOPI_TAB0 * q3 + TWOPI_TAB1 * q4;
        fw += TWOPI_TAB0 * q2 + TWOPI_TAB1 * q3 + TWOPI_TAB2 * q4;
        fw += TWOPI_TAB0 * q1 + TWOPI_TAB1 * q2 + TWOPI_TAB2 * q3 + TWOPI_TAB3 * q4;
        return ih == 0 ? fw : -(fw += TWOPI_TAB0 * q0 + TWOPI_TAB1 * q1 + TWOPI_TAB2 * q2 + TWOPI_TAB3 * q3 + TWOPI_TAB4 * q4);
    }

    static {
        int i;
        double oneMinusXSqInv3_5;
        double oneMinusXSqInv2_5;
        double oneMinusXSqInv1_5;
        double oneMinusXSqInv0_5;
        double oneMinusXSqInv;
        double x;
        double angle;
        int i2;
        PI_SUP = Math.nextUp(Math.PI);
        TWO_POW_24 = Double.longBitsToDouble(4715268809856909312L);
        TWO_POW_N24 = Double.longBitsToDouble(4499096027743125504L);
        TWO_POW_26 = Double.longBitsToDouble(4724276009111650304L);
        TWO_POW_N26 = Double.longBitsToDouble(4490088828488384512L);
        TWO_POW_27 = Double.longBitsToDouble(4728779608739020800L);
        TWO_POW_N27 = Double.longBitsToDouble(4485585228861014016L);
        TWO_POW_N28 = Double.longBitsToDouble(0x3E30000000000000L);
        TWO_POW_52 = Double.longBitsToDouble(0x4330000000000000L);
        TWO_POW_N54 = Double.longBitsToDouble(4363988038922010624L);
        TWO_POW_N55 = Double.longBitsToDouble(4359484439294640128L);
        TWO_POW_66 = Double.longBitsToDouble(0x4410000000000000L);
        TWO_POW_450 = Double.longBitsToDouble(6633802251116740608L);
        TWO_POW_N450 = Double.longBitsToDouble(2580562586483294208L);
        TWO_POW_750 = Double.longBitsToDouble(7984882139327889408L);
        TWO_POW_N750 = Double.longBitsToDouble(0x1110000000000000L);
        MIN_DOUBLE_NORMAL = Double.longBitsToDouble(0x10000000000000L);
        LOG_2 = StrictMath.log(2.0);
        LOG_TWO_POW_27 = StrictMath.log(TWO_POW_27);
        LOG_DOUBLE_MAX_VALUE = StrictMath.log(Double.MAX_VALUE);
        INV_LOG_10 = 1.0 / StrictMath.log(10.0);
        DOUBLE_BEFORE_60 = Math.nextAfter(60.0, 0.0);
        ONE_OVER_TWOPI_TAB = new double[]{2670176.0, 1.4390161E7, 346751.0, 644596.0, 8211767.0, 7354072.0, 1.0839631E7, 1106960.0, 8361048.0, 1.539883E7, 1.5816813E7, 1.317979E7, 9474932.0, 1.2059026E7, 4962946.0, 7627911.0, 4163450.0, 1.3053002E7, 6934458.0, 2133373.0, 4959953.0, 2177639.0, 1837485.0, 1564560.0, 5137525.0, 9330900.0, 1.3532455E7, 2168802.0, 1.5695434E7, 968702.0, 2490359.0, 8480259.0, 1.65017E7, 6477442.0, 1.0176475E7, 5087155.0, 1.3234882E7, 7197649.0, 9427367.0, 9960075.0, 6113774.0, 1.1664121E7, 8150735.0, 4312701.0, 1.4849188E7, 1.2229374E7, 1.4150727E7};
        TWOPI_TAB0 = Double.longBitsToDouble(4618760255839404032L);
        TWOPI_TAB1 = Double.longBitsToDouble(4509304086968926208L);
        TWOPI_TAB2 = Double.longBitsToDouble(4402346256551116800L);
        TWOPI_TAB3 = Double.longBitsToDouble(4294406894572797952L);
        TWOPI_TAB4 = Double.longBitsToDouble(4183874305429340160L);
        INVPIO2 = Double.longBitsToDouble(4603909380684499075L);
        PIO2_HI = Double.longBitsToDouble(4609753056924401664L);
        PIO2_LO = Double.longBitsToDouble(4454258360616903473L);
        INVTWOPI = INVPIO2 / 4.0;
        TWOPI_HI = 4.0 * PIO2_HI;
        TWOPI_LO = 4.0 * PIO2_LO;
        NORMALIZE_ANGLE_MAX_MEDIUM_DOUBLE = StrictMath.pow(2.0, 20.0) * (Math.PI * 2);
        SIN_COS_TABS_SIZE = (1 << FastMath.getTabSizePower(11)) + 1;
        SIN_COS_DELTA_HI = TWOPI_HI / (double)(SIN_COS_TABS_SIZE - 1);
        SIN_COS_DELTA_LO = TWOPI_LO / (double)(SIN_COS_TABS_SIZE - 1);
        SIN_COS_INDEXER = 1.0 / (SIN_COS_DELTA_HI + SIN_COS_DELTA_LO);
        sinTab = new double[SIN_COS_TABS_SIZE];
        cosTab = new double[SIN_COS_TABS_SIZE];
        SIN_COS_MAX_VALUE_FOR_INT_MODULO = 4194303.0 / SIN_COS_INDEXER * 0.99;
        TAN_VIRTUAL_TABS_SIZE = (1 << FastMath.getTabSizePower(12)) + 1;
        TAN_MAX_VALUE_FOR_TABS = Math.toRadians(77.0);
        TAN_TABS_SIZE = (int)(TAN_MAX_VALUE_FOR_TABS / 1.5707963267948966 * (double)(TAN_VIRTUAL_TABS_SIZE - 1)) + 1;
        TAN_DELTA_HI = PIO2_HI / (double)(TAN_VIRTUAL_TABS_SIZE - 1);
        TAN_DELTA_LO = PIO2_LO / (double)(TAN_VIRTUAL_TABS_SIZE - 1);
        TAN_INDEXER = 1.0 / (TAN_DELTA_HI + TAN_DELTA_LO);
        tanTab = new double[TAN_TABS_SIZE];
        tanDer1DivF1Tab = new double[TAN_TABS_SIZE];
        tanDer2DivF2Tab = new double[TAN_TABS_SIZE];
        tanDer3DivF3Tab = new double[TAN_TABS_SIZE];
        tanDer4DivF4Tab = new double[TAN_TABS_SIZE];
        TAN_MAX_VALUE_FOR_INT_MODULO = 4194303.0 / TAN_INDEXER * 0.99;
        ASIN_MAX_VALUE_FOR_TABS = StrictMath.sin(Math.toRadians(73.0));
        ASIN_TABS_SIZE = (1 << FastMath.getTabSizePower(13)) + 1;
        ASIN_DELTA = ASIN_MAX_VALUE_FOR_TABS / (double)(ASIN_TABS_SIZE - 1);
        ASIN_INDEXER = 1.0 / ASIN_DELTA;
        asinTab = new double[ASIN_TABS_SIZE];
        asinDer1DivF1Tab = new double[ASIN_TABS_SIZE];
        asinDer2DivF2Tab = new double[ASIN_TABS_SIZE];
        asinDer3DivF3Tab = new double[ASIN_TABS_SIZE];
        asinDer4DivF4Tab = new double[ASIN_TABS_SIZE];
        ASIN_MAX_VALUE_FOR_POWTABS = StrictMath.sin(Math.toRadians(88.6));
        ASIN_POWTABS_ONE_DIV_MAX_VALUE = 1.0 / ASIN_MAX_VALUE_FOR_POWTABS;
        ASIN_POWTABS_SIZE = (1 << FastMath.getTabSizePower(12)) + 1;
        ASIN_POWTABS_SIZE_MINUS_ONE = ASIN_POWTABS_SIZE - 1;
        asinParamPowTab = new double[ASIN_POWTABS_SIZE];
        asinPowTab = new double[ASIN_POWTABS_SIZE];
        asinDer1DivF1PowTab = new double[ASIN_POWTABS_SIZE];
        asinDer2DivF2PowTab = new double[ASIN_POWTABS_SIZE];
        asinDer3DivF3PowTab = new double[ASIN_POWTABS_SIZE];
        asinDer4DivF4PowTab = new double[ASIN_POWTABS_SIZE];
        ASIN_PIO2_HI = Double.longBitsToDouble(4609753056924675352L);
        ASIN_PIO2_LO = Double.longBitsToDouble(4364452196894661639L);
        ASIN_PS0 = Double.longBitsToDouble(4595172819793696085L);
        ASIN_PS1 = Double.longBitsToDouble(-4623835544539140227L);
        ASIN_PS2 = Double.longBitsToDouble(4596417465768494165L);
        ASIN_PS3 = Double.longBitsToDouble(-4637438604930937029L);
        ASIN_PS4 = Double.longBitsToDouble(4560439845004096136L);
        ASIN_PS5 = Double.longBitsToDouble(4540259411154564873L);
        ASIN_QS1 = Double.longBitsToDouble(-4610777653840302773L);
        ASIN_QS2 = Double.longBitsToDouble(4611733184086379208L);
        ASIN_QS3 = Double.longBitsToDouble(-4618997306433404583L);
        ASIN_QS4 = Double.longBitsToDouble(4590215604441354882L);
        ATAN_MAX_VALUE_FOR_TABS = StrictMath.tan(Math.toRadians(74.0));
        ATAN_TABS_SIZE = (1 << FastMath.getTabSizePower(12)) + 1;
        ATAN_DELTA = ATAN_MAX_VALUE_FOR_TABS / (double)(ATAN_TABS_SIZE - 1);
        ATAN_INDEXER = 1.0 / ATAN_DELTA;
        atanTab = new double[ATAN_TABS_SIZE];
        atanDer1DivF1Tab = new double[ATAN_TABS_SIZE];
        atanDer2DivF2Tab = new double[ATAN_TABS_SIZE];
        atanDer3DivF3Tab = new double[ATAN_TABS_SIZE];
        atanDer4DivF4Tab = new double[ATAN_TABS_SIZE];
        ATAN_HI3 = Double.longBitsToDouble(4609753056924675352L);
        ATAN_LO3 = Double.longBitsToDouble(4364452196894661639L);
        ATAN_AT0 = Double.longBitsToDouble(4599676419421066509L);
        ATAN_AT1 = Double.longBitsToDouble(-4626998257160492092L);
        ATAN_AT2 = Double.longBitsToDouble(4594314991288484863L);
        ATAN_AT3 = Double.longBitsToDouble(-4630701217362536847L);
        ATAN_AT4 = Double.longBitsToDouble(4591215095208222830L);
        ATAN_AT5 = Double.longBitsToDouble(-4633165035261879699L);
        ATAN_AT6 = Double.longBitsToDouble(4589464229703073105L);
        ATAN_AT7 = Double.longBitsToDouble(-4634804155249132134L);
        ATAN_AT8 = Double.longBitsToDouble(4587333258118041067L);
        ATAN_AT9 = Double.longBitsToDouble(-4637946461342241745L);
        ATAN_AT10 = Double.longBitsToDouble(4580351289466214929L);
        EXP_OVERFLOW_LIMIT = Double.longBitsToDouble(4649454530587146735L);
        EXP_UNDERFLOW_LIMIT = Double.longBitsToDouble(-4573606559926636463L);
        EXP_LO_TAB_SIZE_POT = FastMath.getTabSizePower(11);
        EXP_LO_TAB_SIZE = (1 << EXP_LO_TAB_SIZE_POT) + 1;
        EXP_LO_TAB_MID_INDEX = (EXP_LO_TAB_SIZE - 1) / 2;
        EXP_LO_INDEXING = EXP_LO_TAB_MID_INDEX / 1;
        EXP_LO_INDEXING_DIV_SHIFT = EXP_LO_TAB_SIZE_POT - 1 - 0;
        expHiTab = new double[1 + (int)EXP_OVERFLOW_LIMIT];
        expHiInvTab = new double[1 - (int)EXP_UNDERFLOW_LIMIT];
        expLoPosTab = new double[EXP_LO_TAB_SIZE];
        expLoNegTab = new double[EXP_LO_TAB_SIZE];
        EXP_QUICK_A = TWO_POW_52 / LOG_2;
        EXP_QUICK_B = 1023.0 * TWO_POW_52;
        EXP_QUICK_C = Math.ceil((StrictMath.log(LOG_2 + 0.7357588823428847) - LOG_2 - StrictMath.log(LOG_2)) * EXP_QUICK_A);
        LOG_BITS = FastMath.getTabSizePower(12);
        LOG_TAB_SIZE = 1 << LOG_BITS;
        logXLogTab = new double[LOG_TAB_SIZE];
        logXTab = new double[LOG_TAB_SIZE];
        logXInvTab = new double[LOG_TAB_SIZE];
        twoPowTab = new double[2098];
        SQRT_LO_BITS = FastMath.getTabSizePower(12);
        SQRT_LO_TAB_SIZE = 1 << SQRT_LO_BITS;
        sqrtXSqrtHiTab = new double[2098];
        sqrtXSqrtLoTab = new double[SQRT_LO_TAB_SIZE];
        sqrtSlopeHiTab = new double[2098];
        sqrtSlopeLoTab = new double[SQRT_LO_TAB_SIZE];
        CBRT_LO_BITS = FastMath.getTabSizePower(12);
        CBRT_LO_TAB_SIZE = 1 << CBRT_LO_BITS;
        cbrtXCbrtHiTab = new double[2098];
        cbrtXCbrtLoTab = new double[CBRT_LO_TAB_SIZE];
        cbrtSlopeHiTab = new double[2098];
        cbrtSlopeLoTab = new double[CBRT_LO_TAB_SIZE];
        int SIN_COS_PI_INDEX = (SIN_COS_TABS_SIZE - 1) / 2;
        int SIN_COS_PI_MUL_2_INDEX = 2 * SIN_COS_PI_INDEX;
        int SIN_COS_PI_MUL_0_5_INDEX = SIN_COS_PI_INDEX / 2;
        int SIN_COS_PI_MUL_1_5_INDEX = 3 * SIN_COS_PI_INDEX / 2;
        for (i2 = 0; i2 < SIN_COS_TABS_SIZE; ++i2) {
            angle = (double)i2 * SIN_COS_DELTA_HI + (double)i2 * SIN_COS_DELTA_LO;
            double sinAngle = StrictMath.sin(angle);
            double cosAngle = StrictMath.cos(angle);
            if (i2 == SIN_COS_PI_INDEX) {
                sinAngle = 0.0;
            } else if (i2 == SIN_COS_PI_MUL_2_INDEX) {
                sinAngle = 0.0;
            } else if (i2 == SIN_COS_PI_MUL_0_5_INDEX) {
                cosAngle = 0.0;
            } else if (i2 == SIN_COS_PI_MUL_1_5_INDEX) {
                cosAngle = 0.0;
            }
            FastMath.sinTab[i2] = sinAngle;
            FastMath.cosTab[i2] = cosAngle;
        }
        for (i2 = 0; i2 < TAN_TABS_SIZE; ++i2) {
            angle = (double)i2 * TAN_DELTA_HI + (double)i2 * TAN_DELTA_LO;
            FastMath.tanTab[i2] = StrictMath.tan(angle);
            double cosAngle = StrictMath.cos(angle);
            double sinAngle = StrictMath.sin(angle);
            double cosAngleInv = 1.0 / cosAngle;
            double cosAngleInv2 = cosAngleInv * cosAngleInv;
            double cosAngleInv3 = cosAngleInv2 * cosAngleInv;
            double cosAngleInv4 = cosAngleInv2 * cosAngleInv2;
            double cosAngleInv5 = cosAngleInv3 * cosAngleInv2;
            FastMath.tanDer1DivF1Tab[i2] = cosAngleInv2;
            FastMath.tanDer2DivF2Tab[i2] = 2.0 * sinAngle * cosAngleInv3 * 0.5;
            FastMath.tanDer3DivF3Tab[i2] = 2.0 * (1.0 + 2.0 * sinAngle * sinAngle) * cosAngleInv4 * 0.16666666666666666;
            FastMath.tanDer4DivF4Tab[i2] = 8.0 * sinAngle * (2.0 + sinAngle * sinAngle) * cosAngleInv5 * 0.041666666666666664;
        }
        for (i2 = 0; i2 < ASIN_TABS_SIZE; ++i2) {
            x = (double)i2 * ASIN_DELTA;
            FastMath.asinTab[i2] = StrictMath.asin(x);
            oneMinusXSqInv = 1.0 / (1.0 - x * x);
            oneMinusXSqInv0_5 = StrictMath.sqrt(oneMinusXSqInv);
            oneMinusXSqInv1_5 = oneMinusXSqInv0_5 * oneMinusXSqInv;
            oneMinusXSqInv2_5 = oneMinusXSqInv1_5 * oneMinusXSqInv;
            oneMinusXSqInv3_5 = oneMinusXSqInv2_5 * oneMinusXSqInv;
            FastMath.asinDer1DivF1Tab[i2] = oneMinusXSqInv0_5;
            FastMath.asinDer2DivF2Tab[i2] = x * oneMinusXSqInv1_5 * 0.5;
            FastMath.asinDer3DivF3Tab[i2] = (1.0 + 2.0 * x * x) * oneMinusXSqInv2_5 * 0.16666666666666666;
            FastMath.asinDer4DivF4Tab[i2] = (5.0 + 2.0 * x * (2.0 + x * (5.0 - 2.0 * x))) * oneMinusXSqInv3_5 * 0.041666666666666664;
        }
        for (i2 = 0; i2 < ASIN_POWTABS_SIZE; ++i2) {
            FastMath.asinParamPowTab[i2] = x = StrictMath.pow((double)i2 * (1.0 / (double)ASIN_POWTABS_SIZE_MINUS_ONE), 0.011904761904761904) * ASIN_MAX_VALUE_FOR_POWTABS;
            FastMath.asinPowTab[i2] = StrictMath.asin(x);
            oneMinusXSqInv = 1.0 / (1.0 - x * x);
            oneMinusXSqInv0_5 = StrictMath.sqrt(oneMinusXSqInv);
            oneMinusXSqInv1_5 = oneMinusXSqInv0_5 * oneMinusXSqInv;
            oneMinusXSqInv2_5 = oneMinusXSqInv1_5 * oneMinusXSqInv;
            oneMinusXSqInv3_5 = oneMinusXSqInv2_5 * oneMinusXSqInv;
            FastMath.asinDer1DivF1PowTab[i2] = oneMinusXSqInv0_5;
            FastMath.asinDer2DivF2PowTab[i2] = x * oneMinusXSqInv1_5 * 0.5;
            FastMath.asinDer3DivF3PowTab[i2] = (1.0 + 2.0 * x * x) * oneMinusXSqInv2_5 * 0.16666666666666666;
            FastMath.asinDer4DivF4PowTab[i2] = (5.0 + 2.0 * x * (2.0 + x * (5.0 - 2.0 * x))) * oneMinusXSqInv3_5 * 0.041666666666666664;
        }
        for (i2 = 0; i2 < ATAN_TABS_SIZE; ++i2) {
            x = (double)i2 * ATAN_DELTA;
            double onePlusXSqInv = 1.0 / (1.0 + x * x);
            double onePlusXSqInv2 = onePlusXSqInv * onePlusXSqInv;
            double onePlusXSqInv3 = onePlusXSqInv2 * onePlusXSqInv;
            double onePlusXSqInv4 = onePlusXSqInv2 * onePlusXSqInv2;
            FastMath.atanTab[i2] = StrictMath.atan(x);
            FastMath.atanDer1DivF1Tab[i2] = onePlusXSqInv;
            FastMath.atanDer2DivF2Tab[i2] = -2.0 * x * onePlusXSqInv2 * 0.5;
            FastMath.atanDer3DivF3Tab[i2] = (-2.0 + 6.0 * x * x) * onePlusXSqInv3 * 0.16666666666666666;
            FastMath.atanDer4DivF4Tab[i2] = 24.0 * x * (1.0 - x * x) * onePlusXSqInv4 * 0.041666666666666664;
        }
        for (i2 = 0; i2 < EXP_LO_TAB_SIZE; ++i2) {
            x = -1.0 + (double)i2 / (double)EXP_LO_INDEXING;
            FastMath.expLoPosTab[i2] = StrictMath.exp(x);
            FastMath.expLoNegTab[i2] = -StrictMath.expm1(-x);
        }
        for (i2 = 0; i2 <= (int)EXP_OVERFLOW_LIMIT; ++i2) {
            FastMath.expHiTab[i2] = StrictMath.exp(i2);
        }
        for (i2 = 0; i2 <= -((int)EXP_UNDERFLOW_LIMIT); ++i2) {
            FastMath.expHiInvTab[i2] = (double)(-i2) >= -705.0 ? StrictMath.exp(-i2) : StrictMath.exp(54.0 * LOG_2 - (double)i2);
        }
        for (i2 = 0; i2 < LOG_TAB_SIZE; ++i2) {
            x = 1.0 + (double)i2 * (1.0 / (double)LOG_TAB_SIZE);
            FastMath.logXLogTab[i2] = StrictMath.log(x);
            FastMath.logXTab[i2] = x;
            FastMath.logXInvTab[i2] = 1.0 / x;
        }
        for (i2 = -1074; i2 <= 1023; ++i2) {
            FastMath.twoPowTab[i2 - -1074] = StrictMath.pow(2.0, i2);
        }
        for (i2 = -1074; i2 <= 1023; ++i2) {
            double twoPowExpDiv2 = StrictMath.pow(2.0, (double)i2 * 0.5);
            FastMath.sqrtXSqrtHiTab[i2 - -1074] = twoPowExpDiv2 * 0.5;
            FastMath.sqrtSlopeHiTab[i2 - -1074] = 1.0 / twoPowExpDiv2;
        }
        FastMath.sqrtXSqrtLoTab[0] = 1.0;
        FastMath.sqrtSlopeLoTab[0] = 1.0;
        long SQRT_LO_MASK = 0x3FF0000000000000L | 0xFFFFFFFFFFFFFL >> SQRT_LO_BITS;
        for (i = 1; i < SQRT_LO_TAB_SIZE; ++i) {
            double sqrtX;
            long xBits = SQRT_LO_MASK | (long)(i - 1) << 52 - SQRT_LO_BITS;
            FastMath.sqrtXSqrtLoTab[i] = sqrtX = StrictMath.sqrt(Double.longBitsToDouble(xBits));
            FastMath.sqrtSlopeLoTab[i] = 1.0 / sqrtX;
        }
        for (i = -1074; i <= 1023; ++i) {
            double twoPowExpDiv3 = StrictMath.pow(2.0, (double)i / 3.0);
            FastMath.cbrtXCbrtHiTab[i - -1074] = twoPowExpDiv3 * 0.5;
            double tmp = 1.0 / twoPowExpDiv3;
            FastMath.cbrtSlopeHiTab[i - -1074] = 1.3333333333333333 * tmp * tmp;
        }
        FastMath.cbrtXCbrtLoTab[0] = 1.0;
        FastMath.cbrtSlopeLoTab[0] = 1.0;
        long CBRT_LO_MASK = 0x3FF0000000000000L | 0xFFFFFFFFFFFFFL >> CBRT_LO_BITS;
        for (int i3 = 1; i3 < CBRT_LO_TAB_SIZE; ++i3) {
            double cbrtX;
            long xBits = CBRT_LO_MASK | (long)(i3 - 1) << 52 - CBRT_LO_BITS;
            FastMath.cbrtXCbrtLoTab[i3] = cbrtX = StrictMath.cbrt(Double.longBitsToDouble(xBits));
            FastMath.cbrtSlopeLoTab[i3] = 1.0 / (cbrtX * cbrtX);
        }
    }

    public strictfp class IntWrapper {
        public int value;

        public String toString() {
            return Integer.toString(this.value);
        }
    }

    public strictfp class DoubleWrapper {
        public double value;

        public String toString() {
            return Double.toString(this.value);
        }
    }
}

