from neuron import h, rxd
from pylab import *
from matplotlib import pyplot
import scipy.io
import time
import re
import mytools

h.load_file('stdrun.hoc')

dend = h.Section(name='dend')
dend.L=1
dend.diam=0.79788
cyt = rxd.Region([dend], name='cyt', nrn_region='i')

mesh_input_file = open('mesh_general.out','r')
mesh_firstline = mesh_input_file.readline()
mesh_secondline = mesh_input_file.readline()
mesh_values = mesh_secondline.split()
my_volume = float(mesh_values[-2])*1e-15 #litres
mesh_input_file.close()

Duration = 1000
tolerance = 1e-6
Ca_input_onset = 800
Ca_input_N     = 100
Ca_input_freq  = 100
Ca_input_dur   = 0.005
Ca_input_flux  = 600.0
L_input_flux   = 2.0
Glu_input_flux = 50.0
ACh_input_flux = 2.0
Ntrains        = 1
trainT = 3000
initfile = ''
addition = ''
blocked = []
blockeds = []
block_factor = 1.0
alteredk = []
alteredks = []
altered_factor = 1.0
tolstochange = 'Gs,Calbin,CalbinC,PMCA,PMCACa,PP2B,Gi,GiaGDP,Gibg,Gsbg,GsaGDP,CaOut,CaOutLeak,Leak,PDE1,Ng,NgCaM,NgpCaM,CaM,CaMCa2,CaMCa4,fixedbuffer,fixedbufferCa,DGL,CaDGL'.split(',')
tolschange = [float(x) for x in '3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,2,2,1,1'.split(',')]

if len(sys.argv) > 1:
  Duration = int(sys.argv[1])
if len(sys.argv) > 2:
  tolerance = float(sys.argv[2])
if len(sys.argv) > 3:
  Ca_input_onset = float(sys.argv[3])
if len(sys.argv) > 4:
  Ca_input_N     = int(sys.argv[4])
if len(sys.argv) > 5:
  Ca_input_freq  = float(sys.argv[5])
if len(sys.argv) > 6:
  Ca_input_dur   = float(sys.argv[6])
if len(sys.argv) > 7:
  Ca_input_flux  = float(sys.argv[7])
if len(sys.argv) > 8:
  L_input_flux   = float(sys.argv[8])
if len(sys.argv) > 9:
  Glu_input_flux = float(sys.argv[9])
if len(sys.argv) > 10:
  ACh_input_flux = float(sys.argv[10])
if len(sys.argv) > 11:
  Ntrains  = int(float(sys.argv[11]))
if len(sys.argv) > 12:
  trainT  = float(sys.argv[12])
if len(sys.argv) > 13:
  initfile = sys.argv[13]
if len(sys.argv) > 14:
  blocked = sys.argv[14]
  blockeds = blocked.split(',')
if len(sys.argv) > 15:
  block_factor = sys.argv[15]
  block_factors = [float(x) for x in block_factor.split(',')]
if type(blocked) is not list:
  addition = '_'+blocked+'x'+str(block_factor)
if len(sys.argv) > 16:
  alteredk = sys.argv[16]
  alteredks = [int(x) for x in alteredk.split(',')]
if len(sys.argv) > 17:
  alteredk_factor = sys.argv[17]
  alteredk_factors = [float(x) for x in alteredk_factor.split(',')]
if type(alteredk) is not list:
  addition = addition+'_k'+alteredk+'x'+str(alteredk_factor)
filename = 'nrn_tstop'+str(Duration)+'_tol'+str(tolerance)+addition+'_onset'+str(Ca_input_onset)+'_n'+str(Ca_input_N)+'_freq'+str(Ca_input_freq)+'_dur'+str(Ca_input_dur)+'_flux'+str(Ca_input_flux)+'_Lflux'+str(L_input_flux)+'_Gluflux'+str(Glu_input_flux)+'_AChflux'+str(ACh_input_flux)+'_Ntrains'+str(Ntrains)+'_trainT'+str(trainT)
toBeRemovedIfNecessary = ['_tol1e-06','_tstop15000000','3560000_600000','_Ninputs1','_pulseamp5.0']
for i in range(0,len(toBeRemovedIfNecessary)):
  if len(filename) > 254:
    filename = filename.replace(toBeRemovedIfNecessary[i],'')
if len(sys.argv) > 18:
  filename = sys.argv[18]
if len(sys.argv) > 19:
  toltochange = 'Gs,Calbin,CalbinC,PMCA,PMCACa,PP2B,Gi,GiaGDP,Gibg,Gsbg,GsaGDP,CaOut,CaOutLeak,Leak,PDE1,Ng,NgCaM,NgpCaM,CaM,CaMCa2,CaMCa4,fixedbuffer,fixedbufferCa,DGL,CaDGL,'+sys.argv[19]
  tolstochange = toltochange.split(',')
if len(sys.argv) > 20:
  tolchange = '3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,2,2,1,1,'+sys.argv[20]
  tolschange = [float(x) for x in tolchange.split(',')]

initvalues = [9.999999999999999e-19, 1.9, 9.999999999999999e-19, 0.00513, 0.15, 0.015, 2.5, 0.0005, 9.999999999999999e-19, 0.006, 0.006, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-06, 0.0015999999999999999, 0.013, 0.0026, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 0.00019999999999999998, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 2.0, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-05, 9.999999999999999e-19, 9.999999999999999e-19, 0.012, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 0.00098, 0.02, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 0.06, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 0.000987, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 0.023, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 0.0063999999999999994, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 0.0021999999999999997, 9.999999999999999e-19, 9.999999999999999e-19, 0.00042899999999999997, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 0.00017999999999999998, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 8.999999999999999e-05, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 0.003039, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 0.5, 9.999999999999999e-19, 9.999999999999999e-19, 0.0007999999999999999, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 1.0, 0.0014, 9.999999999999999e-19, 9.999999999999999e-19, 0.00025, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 0.024, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 0.00029, 0.00039999999999999996, 0.015, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 8.999999999999999e-05, 0.0003, 9.999999999999999e-19, 9.999999999999999e-19, 0.0015999999999999999, 0.00025, 8.999999999999999e-05, 9.999999999999999e-19, 9.999999999999999e-19, 0.0006, 1.4e-05, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 0.000256, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 0.0005, 9.999999999999999e-19, 0.00045, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 0.001, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19, 9.999999999999999e-19]

species = ['Ca', 'CaOut', 'CaOutLeak', 'Leak', 'Calbin', 'CalbinC', 'LOut', 'Epac1', 'Epac1cAMP', 'PMCA', 'NCX', 'PMCACa', 'NCXCa', 'L', 'R', 'Gs', 'Gi', 'LR', 'LRGs', 'PKAcLR', 'PKAcpLR', 'PKAcppLR', 'PKAcpppLR', 'pLR', 'ppLR', 'pppLR', 'ppppLR', 'ppppLRGi', 'ppppLRGibg', 'PKAcR', 'PKAcpR', 'PKAcppR', 'PKAcpppR', 'pR', 'ppR', 'pppR', 'ppppR', 'ppppRGi', 'ppppRGibg', 'GsR', 'GsaGTP', 'GsaGDP', 'GiaGTP', 'GiaGDP', 'Gibg', 'Gsbg', 'LRGsbg', 'AC1', 'AC1GsaGTP', 'AC1GsaGTPCaMCa4', 'AC1GsaGTPCaMCa4ATP', 'AC1GiaGTP', 'AC1GiaGTPCaMCa4', 'AC1GiaGTPCaMCa4ATP', 'AC1GsaGTPGiaGTP', 'AC1GsaGTPGiaGTPCaMCa4', 'AC1GsGiCaMCa4ATP', 'ATP', 'cAMP', 'AC1CaMCa4', 'AC1CaMCa4ATP', 'AC8', 'AC8CaMCa4', 'AC8CaMCa4ATP', 'PDE1A', 'PDE1ACaMCa4', 'PDE1ACaMCa4cAMP', 'PDE1A_PKAc', 'PDE1Ap', 'PDE1ApCaMCa4', 'PDE1ApCaMCa4cAMP', 'AMP', 'Ng', 'NgCaM', 'Ngp', 'NgpCaM', 'NgPKCtCa', 'NgCaMPKCtCa', 'NgPKCtAACa', 'NgCaMPKCtAACa', 'NgPKCtDAGCa', 'NgCaMPKCtDAGCa', 'NgPKCtAADAGCa', 'NgCaMPKCtAADAGCa', 'NgCaMCa2', 'NgpCaMCa2', 'NgCaMCa2PKCtCa', 'NgCaMCa2PKCtAACa', 'NgCaMCa2PKCtDAGCa', 'NgCaMCa2PKCtAADAGCa', 'NgCaMCa3', 'NgpCaMCa3', 'NgCaMCa3PKCtCa', 'NgCaMCa3PKCtAACa', 'NgCaMCa3PKCtDAGCa', 'NgCaMCa3PKCtAADAGCa', 'NgCaMCa4', 'NgpCaMCa4', 'NgCaMCa4PKCtCa', 'NgCaMCa4PKCtAACa', 'NgCaMCa4PKCtDAGCa', 'NgCaMCa4PKCtAADAGCa', 'NgpPP1', 'NgpPP2A', 'NgpPP2BCaMCa4', 'CaM', 'CaMCa2', 'CaMCa3', 'CaMCa4', 'PP2B', 'PP2BCaM', 'PP2BCaMCa2', 'PP2BCaMCa3', 'PP2BCaMCa4', 'CK', 'CKCaMCa4', 'CKpCaMCa4', 'CKp', 'Complex', 'pComplex', 'CKpPP1', 'CKpCaMCa4PP1', 'PKA', 'PKAcAMP4', 'PKAr', 'PKAc', 'I1', 'I1PKAc', 'Ip35', 'PP1', 'Ip35PP1', 'Ip35PP2BCaMCa4', 'Ip35PP1PP2BCaMCa4', 'PP1PP2BCaMCa4', 'GluR1', 'GluR1_S845', 'GluR1_S831', 'GluR1_S845_S831', 'GluR1_PKAc', 'GluR1_CKCam', 'GluR1_CKpCam', 'GluR1_CKp', 'GluR1_PKCtCa', 'GluR1_PKCtAACa', 'GluR1_PKCtDAGCa', 'GluR1_PKCtAADAGCa', 'GluR1_S845_CKCam', 'GluR1_S845_CKpCam', 'GluR1_S845_CKp', 'GluR1_S845_PKCtCa', 'GluR1_S845_PKCtAACa', 'GluR1_S845_PKCtDAGCa', 'GluR1_S845_PKCtAADAGCa', 'GluR1_S831_PKAc', 'GluR1_S845_PP1', 'GluR1_S845_S831_PP1', 'GluR1_S831_PP1', 'GluR1_S845_PP2B', 'GluR1_S845_S831_PP2B', 'GluR1_memb', 'GluR1_memb_S845', 'GluR1_memb_S831', 'GluR1_memb_S845_S831', 'GluR1_memb_PKAc', 'GluR1_memb_CKCam', 'GluR1_memb_CKpCam', 'GluR1_memb_CKp', 'GluR1_memb_PKCtCa', 'GluR1_memb_PKCtAACa', 'GluR1_memb_PKCtDAGCa', 'GluR1_memb_PKCtAADAGCa', 'GluR1_memb_S845_CKCam', 'GluR1_memb_S845_CKpCam', 'GluR1_memb_S845_CKp', 'GluR1_memb_S845_PKCtCa', 'GluR1_memb_S845_PKCtAACa', 'GluR1_memb_S845_PKCtDAGCa', 'GluR1_memb_S845_PKCtAADAGCa', 'GluR1_memb_S831_PKAc', 'GluR1_memb_S845_PP1', 'GluR1_memb_S845_S831_PP1', 'GluR1_memb_S831_PP1', 'GluR1_memb_S845_PP2B', 'GluR1_memb_S845_S831_PP2B', 'PDE4', 'PDE4cAMP', 'PKAcPDE4', 'PDE4p', 'PDE4pcAMP', 'PKAc_PDE4_cAMP', 'fixedbuffer', 'fixedbufferCa', 'Glu', 'MGluR', 'MGluR_Glu', 'MGluR_Glu_desens', 'MGluR_Gqabg_Glu', 'GluOut', 'Gqabg', 'GqaGTP', 'GqaGDP', 'PLC', 'PLCCa', 'PLCCaGqaGTP', 'PLCGqaGTP', 'Pip2', 'PLCCaPip2', 'PLCCaGqaGTPPip2', 'Ip3', 'PLCCaDAG', 'PLCCaGqaGTPDAG', 'PIkinase', 'Ip3degPIk', 'PKC', 'PKCCa', 'PKCAACa', 'PKCtCa', 'PKCtAACa', 'PKCtDAGCa', 'PKCtAADAGCa', 'DAG', 'DAGK', 'DAGKdag', 'PA', 'DGL', 'CaDGL', 'DAGCaDGL', '2AG', '2AGdegrad', 'Ip3degrad', 'GluR2', 'GluR2_PKCtCa', 'GluR2_PKCtAACa', 'GluR2_PKCtDAGCa', 'GluR2_PKCtAADAGCa', 'GluR2_S880', 'GluR2_S880_PP2A', 'GluR2_memb', 'GluR2_memb_PKCtCa', 'GluR2_memb_PKCtAACa', 'GluR2_memb_PKCtDAGCa', 'GluR2_memb_PKCtAADAGCa', 'GluR2_memb_S880', 'GluR2_memb_S880_PP2A', 'PP2A', 'ACh', 'M1R', 'AChM1R', 'M1RGq', 'AChM1RGq', 'PLA2', 'CaPLA2', 'Ca2PLA2', 'Ca2PLA2act', 'Ca2PLA2actPip2', 'AA']

print("my_volume = "+str(my_volume)+" l ?= "+str(dend.L*(dend.diam/2)**2*3.14159265358)+" um3")
if len(initfile) > 3 and initfile != 'None':
  DATA_init = scipy.io.loadmat(initfile)
  for ispec in range(0,len(species)):
    initvalues[ispec] = DATA_init['DATA'][1+ispec,-1]
    if species[ispec] not in DATA_init['headers'][1+ispec]:
      print("Warning: mismatch in DATA_init, ispec = "+str(ispec))
tolscales = [1.0 for i in range(0,len(species))]
for ispec in range(0,len(species)):
  for iblock in range(0,len(blockeds)):
    if re.match(blockeds[iblock]+'$',species[ispec]):
      initvalues[ispec] = block_factors[iblock]*initvalues[ispec]
  for itol in range(0,len(tolstochange)):
    if tolstochange[itol] == species[ispec]:
      tolscales[ispec] = tolscales[ispec]*10**(-tolschange[itol])
specs = []
for ispec in range(0,len(species)):
  specs.append(rxd.Species(cyt, name='spec'+str(ispec), charge=0, initial=initvalues[ispec], atolscale=tolscales[ispec]))
  if tolscales[ispec] != 1.0:
    print('spec'+str(ispec)+' ('+species[ispec]+') atolscale = '+str(tolscales[ispec]))
Ca_flux_rate = rxd.Parameter(cyt, initial=0)
L_flux_rate = rxd.Parameter(cyt, initial=0)
Glu_flux_rate = rxd.Parameter(cyt, initial=0)
ACh_flux_rate = rxd.Parameter(cyt, initial=0)
ks = [1.0]*577
ks[0]   = 50.0                  # Ca + PMCA <-> PMCACa (forward)
ks[1]   = 0.007                 # Ca + PMCA <-> PMCACa (backward)
ks[2]   = 0.0035                # PMCACa --> PMCA + CaOut (forward)
ks[3]   = 16.799999999999997    # Ca + NCX <-> NCXCa (forward)
ks[4]   = 0.0112                # Ca + NCX <-> NCXCa (backward)
ks[5]   = 0.0056                # NCXCa --> NCX + CaOut (forward)
ks[6]   = 1.5                   # CaOut + Leak <-> CaOutLeak (forward)
ks[7]   = 0.0011                # CaOut + Leak <-> CaOutLeak (backward)
ks[8]   = 0.0011                # CaOutLeak --> Ca + Leak (forward)
ks[9]   = 28.0                  # Ca + Calbin <-> CalbinC (forward)
ks[10]  = 0.0196                # Ca + Calbin <-> CalbinC (backward)
ks[11]  = 0.0005                # L --> LOut (forward)
ks[12]  = 5.555000000000001     # L + R <-> LR (forward)
ks[13]  = 0.005                 # L + R <-> LR (backward)
ks[14]  = 0.6                   # LR + Gs <-> LRGs (forward)
ks[15]  = 1e-06                 # LR + Gs <-> LRGs (backward)
ks[16]  = 0.04                  # Gs + R <-> GsR (forward)
ks[17]  = 3e-07                 # Gs + R <-> GsR (backward)
ks[18]  = 2.5                   # GsR + L <-> LRGs (forward)
ks[19]  = 0.0005                # GsR + L <-> LRGs (backward)
ks[20]  = 0.02                  # LRGs --> LRGsbg + GsaGTP (forward)
ks[21]  = 0.08                  # LRGsbg --> LR + Gsbg (forward)
ks[22]  = 0.7999999999999999    # LR + PKAc <-> PKAcLR (forward)
ks[23]  = 0.00448               # LR + PKAc <-> PKAcLR (backward)
ks[24]  = 0.001                 # PKAcLR --> pLR + PKAc (forward)
ks[25]  = 0.7999999999999999    # pLR + PKAc <-> PKAcpLR (forward)
ks[26]  = 0.00448               # pLR + PKAc <-> PKAcpLR (backward)
ks[27]  = 0.001                 # PKAcpLR --> ppLR + PKAc (forward)
ks[28]  = 17.119999999999997    # ppLR + PKAc <-> PKAcppLR (forward)
ks[29]  = 0.00448               # ppLR + PKAc <-> PKAcppLR (backward)
ks[30]  = 0.001                 # PKAcppLR --> pppLR + PKAc (forward)
ks[31]  = 1712.0                # pppLR + PKAc <-> PKAcpppLR (forward)
ks[32]  = 0.00448               # pppLR + PKAc <-> PKAcpppLR (backward)
ks[33]  = 0.001                 # PKAcpppLR --> ppppLR + PKAc (forward)
ks[34]  = 150.0                 # ppppLR + Gi <-> ppppLRGi (forward)
ks[35]  = 0.00025               # ppppLR + Gi <-> ppppLRGi (backward)
ks[36]  = 0.000125              # ppppLRGi --> ppppLRGibg + GiaGTP (forward)
ks[37]  = 0.001                 # ppppLRGibg --> ppppLR + Gibg (forward)
ks[38]  = 2.5e-06               # pLR --> LR (forward)
ks[39]  = 2.5e-06               # ppLR --> pLR (forward)
ks[40]  = 2.5e-06               # pppLR --> ppLR (forward)
ks[41]  = 2.5e-06               # ppppLR --> pppLR (forward)
ks[42]  = 0.04                  # R + PKAc <-> PKAcR (forward)
ks[43]  = 0.00448               # R + PKAc <-> PKAcR (backward)
ks[44]  = 0.001                 # PKAcR --> pR + PKAc (forward)
ks[45]  = 0.39999999999999997   # pR + PKAc <-> PKAcpR (forward)
ks[46]  = 0.00448               # pR + PKAc <-> PKAcpR (backward)
ks[47]  = 0.001                 # PKAcpR --> ppR + PKAc (forward)
ks[48]  = 4.0                   # ppR + PKAc <-> PKAcppR (forward)
ks[49]  = 0.00448               # ppR + PKAc <-> PKAcppR (backward)
ks[50]  = 0.001                 # PKAcppR --> pppR + PKAc (forward)
ks[51]  = 400.0                 # pppR + PKAc <-> PKAcpppR (forward)
ks[52]  = 0.00448               # pppR + PKAc <-> PKAcpppR (backward)
ks[53]  = 0.001                 # PKAcpppR --> ppppR + PKAc (forward)
ks[54]  = 75.0                  # ppppR + Gi <-> ppppRGi (forward)
ks[55]  = 0.000125              # ppppR + Gi <-> ppppRGi (backward)
ks[56]  = 6.25e-05              # ppppRGi --> ppppRGibg + GiaGTP (forward)
ks[57]  = 0.001                 # ppppRGibg --> ppppR + Gibg (forward)
ks[58]  = 2.5e-06               # pR --> R (forward)
ks[59]  = 2.5e-06               # ppR --> pR (forward)
ks[60]  = 2.5e-06               # pppR --> ppR (forward)
ks[61]  = 2.5e-06               # ppppR --> pppR (forward)
ks[62]  = 0.01                  # GsaGTP --> GsaGDP (forward)
ks[63]  = 100000.0              # GsaGDP + Gsbg --> Gs (forward)
ks[64]  = 0.000125              # GiaGTP --> GiaGDP (forward)
ks[65]  = 1250.0                # GiaGDP + Gibg --> Gi (forward)
ks[66]  = 38.5                  # GsaGTP + AC1 <-> AC1GsaGTP (forward)
ks[67]  = 0.01                  # GsaGTP + AC1 <-> AC1GsaGTP (backward)
ks[68]  = 6.0                   # AC1GsaGTP + CaMCa4 <-> AC1GsaGTPCaMCa4 (forward)
ks[69]  = 0.0009                # AC1GsaGTP + CaMCa4 <-> AC1GsaGTPCaMCa4 (backward)
ks[70]  = 10.0                  # AC1GsaGTPCaMCa4 + ATP <-> AC1GsaGTPCaMCa4ATP (forward)
ks[71]  = 0.07                  # AC1GsaGTPCaMCa4 + ATP <-> AC1GsaGTPCaMCa4ATP (backward)
ks[72]  = 0.05684               # AC1GsaGTPCaMCa4ATP --> cAMP + AC1GsaGTPCaMCa4 (forward)
ks[73]  = 62.5                  # GiaGTP + AC1GsaGTP <-> AC1GsaGTPGiaGTP (forward)
ks[74]  = 0.01                  # GiaGTP + AC1GsaGTP <-> AC1GsaGTPGiaGTP (backward)
ks[75]  = 6.0                   # AC1GsaGTPGiaGTP + CaMCa4 <-> AC1GsaGTPGiaGTPCaMCa4 (forward)
ks[76]  = 0.0009                # AC1GsaGTPGiaGTP + CaMCa4 <-> AC1GsaGTPGiaGTPCaMCa4 (backward)
ks[77]  = 10.0                  # AC1GsaGTPGiaGTPCaMCa4 + ATP <-> AC1GsGiCaMCa4ATP (forward)
ks[78]  = 0.07                  # AC1GsaGTPGiaGTPCaMCa4 + ATP <-> AC1GsGiCaMCa4ATP (backward)
ks[79]  = 0.002842              # AC1GsGiCaMCa4ATP --> cAMP + AC1GsaGTPGiaGTPCaMCa4 (forward)
ks[80]  = 62.5                  # GiaGTP + AC1CaMCa4 <-> AC1GiaGTPCaMCa4 (forward)
ks[81]  = 0.01                  # GiaGTP + AC1CaMCa4 <-> AC1GiaGTPCaMCa4 (backward)
ks[82]  = 10.0                  # AC1GiaGTPCaMCa4 + ATP <-> AC1GiaGTPCaMCa4ATP (forward)
ks[83]  = 0.07                  # AC1GiaGTPCaMCa4 + ATP <-> AC1GiaGTPCaMCa4ATP (backward)
ks[84]  = 0.0005684             # AC1GiaGTPCaMCa4ATP --> cAMP + AC1GiaGTPCaMCa4 (forward)
ks[85]  = 6.0                   # AC1 + CaMCa4 <-> AC1CaMCa4 (forward)
ks[86]  = 0.0009                # AC1 + CaMCa4 <-> AC1CaMCa4 (backward)
ks[87]  = 10.0                  # AC1CaMCa4 + ATP <-> AC1CaMCa4ATP (forward)
ks[88]  = 0.07                  # AC1CaMCa4 + ATP <-> AC1CaMCa4ATP (backward)
ks[89]  = 0.005684              # AC1CaMCa4ATP --> cAMP + AC1CaMCa4 (forward)
ks[90]  = 62.5                  # AC1GiaGTP + GsaGTP <-> AC1GsaGTPGiaGTP (forward)
ks[91]  = 0.01                  # AC1GiaGTP + GsaGTP <-> AC1GsaGTPGiaGTP (backward)
ks[92]  = 1.25                  # AC8 + CaMCa4 <-> AC8CaMCa4 (forward)
ks[93]  = 0.001                 # AC8 + CaMCa4 <-> AC8CaMCa4 (backward)
ks[94]  = 10.0                  # AC8CaMCa4 + ATP <-> AC8CaMCa4ATP (forward)
ks[95]  = 0.07                  # AC8CaMCa4 + ATP <-> AC8CaMCa4ATP (backward)
ks[96]  = 0.002842              # AC8CaMCa4ATP --> cAMP + AC8CaMCa4 (forward)
ks[97]  = 17000.0               # CaM + Ca*2 <-> CaMCa2 (forward)
ks[98]  = 0.035                 # CaM + Ca*2 <-> CaMCa2 (backward)
ks[99]  = 14.0                  # CaMCa2 + Ca <-> CaMCa3 (forward)
ks[100] = 0.228                 # CaMCa2 + Ca <-> CaMCa3 (backward)
ks[101] = 26.0                  # CaMCa3 + Ca <-> CaMCa4 (forward)
ks[102] = 0.064                 # CaMCa3 + Ca <-> CaMCa4 (backward)
ks[103] = 15806.7               # NgCaM + Ca*2 <-> NgCaMCa2 (forward)
ks[104] = 1.72117               # NgCaM + Ca*2 <-> NgCaMCa2 (backward)
ks[105] = 14.0                  # NgCaMCa2 + Ca <-> NgCaMCa3 (forward)
ks[106] = 0.228                 # NgCaMCa2 + Ca <-> NgCaMCa3 (backward)
ks[107] = 26.0                  # NgCaMCa3 + Ca <-> NgCaMCa4 (forward)
ks[108] = 0.064                 # NgCaMCa3 + Ca <-> NgCaMCa4 (backward)
ks[109] = 15806.7               # NgpCaM + Ca*2 <-> NgpCaMCa2 (forward)
ks[110] = 1.72117               # NgpCaM + Ca*2 <-> NgpCaMCa2 (backward)
ks[111] = 14.0                  # NgpCaMCa2 + Ca <-> NgpCaMCa3 (forward)
ks[112] = 0.228                 # NgpCaMCa2 + Ca <-> NgpCaMCa3 (backward)
ks[113] = 26.0                  # NgpCaMCa3 + Ca <-> NgpCaMCa4 (forward)
ks[114] = 0.064                 # NgpCaMCa3 + Ca <-> NgpCaMCa4 (backward)
ks[115] = 28.0                  # CaM + Ng <-> NgCaM (forward)
ks[116] = 0.036                 # CaM + Ng <-> NgCaM (backward)
ks[117] = 0.0                   # CaM + Ngp <-> NgpCaM (forward)
ks[118] = 0.036                 # CaM + Ngp <-> NgpCaM (backward)
ks[119] = 2.0                   # CaMCa2 + Ng <-> NgCaMCa2 (forward)
ks[120] = 0.136                 # CaMCa2 + Ng <-> NgCaMCa2 (backward)
ks[121] = 0.0                   # CaMCa2 + Ngp <-> NgpCaMCa2 (forward)
ks[122] = 0.136                 # CaMCa2 + Ngp <-> NgpCaMCa2 (backward)
ks[123] = 2.0                   # CaMCa3 + Ng <-> NgCaMCa3 (forward)
ks[124] = 0.136                 # CaMCa3 + Ng <-> NgCaMCa3 (backward)
ks[125] = 0.0                   # CaMCa3 + Ngp <-> NgpCaMCa3 (forward)
ks[126] = 0.136                 # CaMCa3 + Ngp <-> NgpCaMCa3 (backward)
ks[127] = 2.0                   # CaMCa4 + Ng <-> NgCaMCa4 (forward)
ks[128] = 0.136                 # CaMCa4 + Ng <-> NgCaMCa4 (backward)
ks[129] = 0.0                   # CaMCa4 + Ngp <-> NgpCaMCa4 (forward)
ks[130] = 0.136                 # CaMCa4 + Ngp <-> NgpCaMCa4 (backward)
ks[131] = 0.45999999999999996   # CaM + PP2B <-> PP2BCaM (forward)
ks[132] = 1.2e-06               # CaM + PP2B <-> PP2BCaM (backward)
ks[133] = 0.45999999999999996   # CaMCa2 + PP2B <-> PP2BCaMCa2 (forward)
ks[134] = 1.2e-06               # CaMCa2 + PP2B <-> PP2BCaMCa2 (backward)
ks[135] = 4.6                   # CaMCa3 + PP2B <-> PP2BCaMCa3 (forward)
ks[136] = 1.2e-06               # CaMCa3 + PP2B <-> PP2BCaMCa3 (backward)
ks[137] = 46.0                  # CaMCa4 + PP2B <-> PP2BCaMCa4 (forward)
ks[138] = 1.2e-06               # CaMCa4 + PP2B <-> PP2BCaMCa4 (backward)
ks[139] = 17000.0               # PP2BCaM + Ca*2 <-> PP2BCaMCa2 (forward)
ks[140] = 0.035                 # PP2BCaM + Ca*2 <-> PP2BCaMCa2 (backward)
ks[141] = 14.0                  # PP2BCaMCa2 + Ca <-> PP2BCaMCa3 (forward)
ks[142] = 0.0228                # PP2BCaMCa2 + Ca <-> PP2BCaMCa3 (backward)
ks[143] = 26.0                  # PP2BCaMCa3 + Ca <-> PP2BCaMCa4 (forward)
ks[144] = 0.0064                # PP2BCaMCa3 + Ca <-> PP2BCaMCa4 (backward)
ks[145] = 10.0                  # CaMCa4 + CK <-> CKCaMCa4 (forward)
ks[146] = 0.003                 # CaMCa4 + CK <-> CKCaMCa4 (backward)
ks[147] = 0.09999999999999999   # CKCaMCa4*2 <-> Complex (forward)
ks[148] = 0.01                  # CKCaMCa4*2 <-> Complex (backward)
ks[149] = 0.09999999999999999   # CKpCaMCa4 + CKCaMCa4 <-> pComplex (forward)
ks[150] = 0.01                  # CKpCaMCa4 + CKCaMCa4 <-> pComplex (backward)
ks[151] = 0.09999999999999999   # CKpCaMCa4 + Complex --> CKpCaMCa4 + pComplex (forward)
ks[152] = 0.09999999999999999   # CKCaMCa4 + Complex --> CKCaMCa4 + pComplex (forward)
ks[153] = 10.0                  # Complex*2 --> Complex + pComplex (forward)
ks[154] = 30.0                  # Complex + pComplex --> pComplex*2 (forward)
ks[155] = 8e-07                 # CKpCaMCa4 <-> CaMCa4 + CKp (forward)
ks[156] = 10.0                  # CKpCaMCa4 <-> CaMCa4 + CKp (backward)
ks[157] = 0.004                 # CKp + PP1 <-> CKpPP1 (forward)
ks[158] = 0.00034               # CKp + PP1 <-> CKpPP1 (backward)
ks[159] = 8.6e-05               # CKpPP1 --> PP1 + CK (forward)
ks[160] = 0.004                 # CKpCaMCa4 + PP1 <-> CKpCaMCa4PP1 (forward)
ks[161] = 0.00034               # CKpCaMCa4 + PP1 <-> CKpCaMCa4PP1 (backward)
ks[162] = 8.6e-05               # CKpCaMCa4PP1 --> PP1 + CKCaMCa4 (forward)
ks[163] = 1600000000.0          # PKA + cAMP*4 <-> PKAcAMP4 (forward)
ks[164] = 6e-05                 # PKA + cAMP*4 <-> PKAcAMP4 (backward)
ks[165] = 0.031                 # Epac1 + cAMP <-> Epac1cAMP (forward)
ks[166] = 6.51e-05              # Epac1 + cAMP <-> Epac1cAMP (backward)
ks[167] = 1.4                   # I1 + PKAc <-> I1PKAc (forward)
ks[168] = 0.0056                # I1 + PKAc <-> I1PKAc (backward)
ks[169] = 0.0014                # I1PKAc --> Ip35 + PKAc (forward)
ks[170] = 1.0                   # Ip35 + PP1 <-> Ip35PP1 (forward)
ks[171] = 1.1e-06               # Ip35 + PP1 <-> Ip35PP1 (backward)
ks[172] = 96.25                 # Ip35 + PP2BCaMCa4 <-> Ip35PP2BCaMCa4 (forward)
ks[173] = 0.33                  # Ip35 + PP2BCaMCa4 <-> Ip35PP2BCaMCa4 (backward)
ks[174] = 0.055                 # Ip35PP2BCaMCa4 --> I1 + PP2BCaMCa4 (forward)
ks[175] = 96.25                 # Ip35PP1 + PP2BCaMCa4 <-> Ip35PP1PP2BCaMCa4 (forward)
ks[176] = 0.33                  # Ip35PP1 + PP2BCaMCa4 <-> Ip35PP1PP2BCaMCa4 (backward)
ks[177] = 0.055                 # Ip35PP1PP2BCaMCa4 --> I1 + PP1PP2BCaMCa4 (forward)
ks[178] = 0.0015                # PP1PP2BCaMCa4 --> PP1 + PP2BCaMCa4 (forward)
ks[179] = 4.0                   # GluR1 + PKAc <-> GluR1_PKAc (forward)
ks[180] = 0.024                 # GluR1 + PKAc <-> GluR1_PKAc (backward)
ks[181] = 0.006                 # GluR1_PKAc --> GluR1_S845 + PKAc (forward)
ks[182] = 0.02224               # GluR1 + CKCaMCa4 <-> GluR1_CKCam (forward)
ks[183] = 0.0016                # GluR1 + CKCaMCa4 <-> GluR1_CKCam (backward)
ks[184] = 0.0004                # GluR1_CKCam --> GluR1_S831 + CKCaMCa4 (forward)
ks[185] = 0.027800000000000002  # GluR1 + CKpCaMCa4 <-> GluR1_CKpCam (forward)
ks[186] = 0.002                 # GluR1 + CKpCaMCa4 <-> GluR1_CKpCam (backward)
ks[187] = 0.0005                # GluR1_CKpCam --> GluR1_S831 + CKpCaMCa4 (forward)
ks[188] = 0.02224               # GluR1 + CKp <-> GluR1_CKp (forward)
ks[189] = 0.0016                # GluR1 + CKp <-> GluR1_CKp (backward)
ks[190] = 0.0004                # GluR1_CKp --> GluR1_S831 + CKp (forward)
ks[191] = 0.027800000000000002  # GluR1 + PKCtCa <-> GluR1_PKCtCa (forward)
ks[192] = 0.002                 # GluR1 + PKCtCa <-> GluR1_PKCtCa (backward)
ks[193] = 0.0005                # GluR1_PKCtCa --> GluR1_S831 + PKCtCa (forward)
ks[194] = 0.027800000000000002  # GluR1 + PKCtAACa <-> GluR1_PKCtAACa (forward)
ks[195] = 0.002                 # GluR1 + PKCtAACa <-> GluR1_PKCtAACa (backward)
ks[196] = 0.0005                # GluR1_PKCtAACa --> GluR1_S831 + PKCtAACa (forward)
ks[197] = 0.027800000000000002  # GluR1 + PKCtDAGCa <-> GluR1_PKCtDAGCa (forward)
ks[198] = 0.002                 # GluR1 + PKCtDAGCa <-> GluR1_PKCtDAGCa (backward)
ks[199] = 0.0005                # GluR1_PKCtDAGCa --> GluR1_S831 + PKCtDAGCa (forward)
ks[200] = 0.027800000000000002  # GluR1 + PKCtAADAGCa <-> GluR1_PKCtAADAGCa (forward)
ks[201] = 0.002                 # GluR1 + PKCtAADAGCa <-> GluR1_PKCtAADAGCa (backward)
ks[202] = 0.0005                # GluR1_PKCtAADAGCa --> GluR1_S831 + PKCtAADAGCa (forward)
ks[203] = 0.02224               # GluR1_S845 + CKCaMCa4 <-> GluR1_S845_CKCam (forward)
ks[204] = 0.0016                # GluR1_S845 + CKCaMCa4 <-> GluR1_S845_CKCam (backward)
ks[205] = 0.0004                # GluR1_S845_CKCam --> GluR1_S845_S831 + CKCaMCa4 (forward)
ks[206] = 0.027800000000000002  # GluR1_S845 + CKpCaMCa4 <-> GluR1_S845_CKpCam (forward)
ks[207] = 0.002                 # GluR1_S845 + CKpCaMCa4 <-> GluR1_S845_CKpCam (backward)
ks[208] = 0.0005                # GluR1_S845_CKpCam --> GluR1_S845_S831 + CKpCaMCa4 (forward)
ks[209] = 0.02224               # GluR1_S845 + CKp <-> GluR1_S845_CKp (forward)
ks[210] = 0.0016                # GluR1_S845 + CKp <-> GluR1_S845_CKp (backward)
ks[211] = 0.0004                # GluR1_S845_CKp --> GluR1_S845_S831 + CKp (forward)
ks[212] = 0.027800000000000002  # GluR1_S845 + PKCtCa <-> GluR1_S845_PKCtCa (forward)
ks[213] = 0.002                 # GluR1_S845 + PKCtCa <-> GluR1_S845_PKCtCa (backward)
ks[214] = 0.0005                # GluR1_S845_PKCtCa --> GluR1_S845_S831 + PKCtCa (forward)
ks[215] = 0.027800000000000002  # GluR1_S845 + PKCtAACa <-> GluR1_S845_PKCtAACa (forward)
ks[216] = 0.002                 # GluR1_S845 + PKCtAACa <-> GluR1_S845_PKCtAACa (backward)
ks[217] = 0.0005                # GluR1_S845_PKCtAACa --> GluR1_S845_S831 + PKCtAACa (forward)
ks[218] = 0.027800000000000002  # GluR1_S845 + PKCtDAGCa <-> GluR1_S845_PKCtDAGCa (forward)
ks[219] = 0.002                 # GluR1_S845 + PKCtDAGCa <-> GluR1_S845_PKCtDAGCa (backward)
ks[220] = 0.0005                # GluR1_S845_PKCtDAGCa --> GluR1_S845_S831 + PKCtDAGCa (forward)
ks[221] = 0.027800000000000002  # GluR1_S845 + PKCtAADAGCa <-> GluR1_S845_PKCtAADAGCa (forward)
ks[222] = 0.002                 # GluR1_S845 + PKCtAADAGCa <-> GluR1_S845_PKCtAADAGCa (backward)
ks[223] = 0.0005                # GluR1_S845_PKCtAADAGCa --> GluR1_S845_S831 + PKCtAADAGCa (forward)
ks[224] = 4.0                   # GluR1_S831 + PKAc <-> GluR1_S831_PKAc (forward)
ks[225] = 0.024                 # GluR1_S831 + PKAc <-> GluR1_S831_PKAc (backward)
ks[226] = 0.006                 # GluR1_S831_PKAc --> GluR1_S845_S831 + PKAc (forward)
ks[227] = 0.03                  # GluR1_S845 + PP1 <-> GluR1_S845_PP1 (forward)
ks[228] = 0.00068               # GluR1_S845 + PP1 <-> GluR1_S845_PP1 (backward)
ks[229] = 0.00017               # GluR1_S845_PP1 --> GluR1 + PP1 (forward)
ks[230] = 0.03                  # GluR1_S845_S831 + PP1 <-> GluR1_S845_S831_PP1 (forward)
ks[231] = 0.0014                # GluR1_S845_S831 + PP1 <-> GluR1_S845_S831_PP1 (backward)
ks[232] = 0.00035               # GluR1_S845_S831_PP1 --> GluR1_S845 + PP1 (forward)
ks[233] = 0.00035               # GluR1_S845_S831_PP1 --> GluR1_S831 + PP1 (forward)
ks[234] = 0.03                  # GluR1_S831 + PP1 <-> GluR1_S831_PP1 (forward)
ks[235] = 0.0014                # GluR1_S831 + PP1 <-> GluR1_S831_PP1 (backward)
ks[236] = 0.00035               # GluR1_S831_PP1 --> GluR1 + PP1 (forward)
ks[237] = 2.01                  # GluR1_S845 + PP2BCaMCa4 <-> GluR1_S845_PP2B (forward)
ks[238] = 0.008                 # GluR1_S845 + PP2BCaMCa4 <-> GluR1_S845_PP2B (backward)
ks[239] = 0.002                 # GluR1_S845_PP2B --> GluR1 + PP2BCaMCa4 (forward)
ks[240] = 2.01                  # GluR1_S845_S831 + PP2BCaMCa4 <-> GluR1_S845_S831_PP2B (forward)
ks[241] = 0.008                 # GluR1_S845_S831 + PP2BCaMCa4 <-> GluR1_S845_S831_PP2B (backward)
ks[242] = 0.002                 # GluR1_S845_S831_PP2B --> GluR1_S831 + PP2BCaMCa4 (forward)
ks[243] = 4.0                   # GluR1_memb + PKAc <-> GluR1_memb_PKAc (forward)
ks[244] = 0.024                 # GluR1_memb + PKAc <-> GluR1_memb_PKAc (backward)
ks[245] = 0.006                 # GluR1_memb_PKAc --> GluR1_memb_S845 + PKAc (forward)
ks[246] = 0.02224               # GluR1_memb + CKCaMCa4 <-> GluR1_memb_CKCam (forward)
ks[247] = 0.0016                # GluR1_memb + CKCaMCa4 <-> GluR1_memb_CKCam (backward)
ks[248] = 0.0004                # GluR1_memb_CKCam --> GluR1_memb_S831 + CKCaMCa4 (forward)
ks[249] = 0.027800000000000002  # GluR1_memb + CKpCaMCa4 <-> GluR1_memb_CKpCam (forward)
ks[250] = 0.002                 # GluR1_memb + CKpCaMCa4 <-> GluR1_memb_CKpCam (backward)
ks[251] = 0.0005                # GluR1_memb_CKpCam --> GluR1_memb_S831 + CKpCaMCa4 (forward)
ks[252] = 0.02224               # GluR1_memb + CKp <-> GluR1_memb_CKp (forward)
ks[253] = 0.0016                # GluR1_memb + CKp <-> GluR1_memb_CKp (backward)
ks[254] = 0.0004                # GluR1_memb_CKp --> GluR1_memb_S831 + CKp (forward)
ks[255] = 0.027800000000000002  # GluR1_memb + PKCtCa <-> GluR1_memb_PKCtCa (forward)
ks[256] = 0.002                 # GluR1_memb + PKCtCa <-> GluR1_memb_PKCtCa (backward)
ks[257] = 0.0005                # GluR1_memb_PKCtCa --> GluR1_memb_S831 + PKCtCa (forward)
ks[258] = 0.027800000000000002  # GluR1_memb + PKCtAACa <-> GluR1_memb_PKCtAACa (forward)
ks[259] = 0.002                 # GluR1_memb + PKCtAACa <-> GluR1_memb_PKCtAACa (backward)
ks[260] = 0.0005                # GluR1_memb_PKCtAACa --> GluR1_memb_S831 + PKCtAACa (forward)
ks[261] = 0.027800000000000002  # GluR1_memb + PKCtDAGCa <-> GluR1_memb_PKCtDAGCa (forward)
ks[262] = 0.002                 # GluR1_memb + PKCtDAGCa <-> GluR1_memb_PKCtDAGCa (backward)
ks[263] = 0.0005                # GluR1_memb_PKCtDAGCa --> GluR1_memb_S831 + PKCtDAGCa (forward)
ks[264] = 0.027800000000000002  # GluR1_memb + PKCtAADAGCa <-> GluR1_memb_PKCtAADAGCa (forward)
ks[265] = 0.002                 # GluR1_memb + PKCtAADAGCa <-> GluR1_memb_PKCtAADAGCa (backward)
ks[266] = 0.0005                # GluR1_memb_PKCtAADAGCa --> GluR1_memb_S831 + PKCtAADAGCa (forward)
ks[267] = 0.02224               # GluR1_memb_S845 + CKCaMCa4 <-> GluR1_memb_S845_CKCam (forward)
ks[268] = 0.0016                # GluR1_memb_S845 + CKCaMCa4 <-> GluR1_memb_S845_CKCam (backward)
ks[269] = 0.0004                # GluR1_memb_S845_CKCam --> GluR1_memb_S845_S831 + CKCaMCa4 (forward)
ks[270] = 0.027800000000000002  # GluR1_memb_S845 + CKpCaMCa4 <-> GluR1_memb_S845_CKpCam (forward)
ks[271] = 0.002                 # GluR1_memb_S845 + CKpCaMCa4 <-> GluR1_memb_S845_CKpCam (backward)
ks[272] = 0.0005                # GluR1_memb_S845_CKpCam --> GluR1_memb_S845_S831 + CKpCaMCa4 (forward)
ks[273] = 0.02224               # GluR1_memb_S845 + CKp <-> GluR1_memb_S845_CKp (forward)
ks[274] = 0.0016                # GluR1_memb_S845 + CKp <-> GluR1_memb_S845_CKp (backward)
ks[275] = 0.0004                # GluR1_memb_S845_CKp --> GluR1_memb_S845_S831 + CKp (forward)
ks[276] = 0.027800000000000002  # GluR1_memb_S845 + PKCtCa <-> GluR1_memb_S845_PKCtCa (forward)
ks[277] = 0.002                 # GluR1_memb_S845 + PKCtCa <-> GluR1_memb_S845_PKCtCa (backward)
ks[278] = 0.0005                # GluR1_memb_S845_PKCtCa --> GluR1_memb_S845_S831 + PKCtCa (forward)
ks[279] = 0.027800000000000002  # GluR1_memb_S845 + PKCtAACa <-> GluR1_memb_S845_PKCtAACa (forward)
ks[280] = 0.002                 # GluR1_memb_S845 + PKCtAACa <-> GluR1_memb_S845_PKCtAACa (backward)
ks[281] = 0.0005                # GluR1_memb_S845_PKCtAACa --> GluR1_memb_S845_S831 + PKCtAACa (forward)
ks[282] = 0.027800000000000002  # GluR1_memb_S845 + PKCtDAGCa <-> GluR1_memb_S845_PKCtDAGCa (forward)
ks[283] = 0.002                 # GluR1_memb_S845 + PKCtDAGCa <-> GluR1_memb_S845_PKCtDAGCa (backward)
ks[284] = 0.0005                # GluR1_memb_S845_PKCtDAGCa --> GluR1_memb_S845_S831 + PKCtDAGCa (forward)
ks[285] = 0.027800000000000002  # GluR1_memb_S845 + PKCtAADAGCa <-> GluR1_memb_S845_PKCtAADAGCa (forward)
ks[286] = 0.002                 # GluR1_memb_S845 + PKCtAADAGCa <-> GluR1_memb_S845_PKCtAADAGCa (backward)
ks[287] = 0.0005                # GluR1_memb_S845_PKCtAADAGCa --> GluR1_memb_S845_S831 + PKCtAADAGCa (forward)
ks[288] = 4.0                   # GluR1_memb_S831 + PKAc <-> GluR1_memb_S831_PKAc (forward)
ks[289] = 0.024                 # GluR1_memb_S831 + PKAc <-> GluR1_memb_S831_PKAc (backward)
ks[290] = 0.006                 # GluR1_memb_S831_PKAc --> GluR1_memb_S845_S831 + PKAc (forward)
ks[291] = 0.03                  # GluR1_memb_S845 + PP1 <-> GluR1_memb_S845_PP1 (forward)
ks[292] = 0.00068               # GluR1_memb_S845 + PP1 <-> GluR1_memb_S845_PP1 (backward)
ks[293] = 0.00017               # GluR1_memb_S845_PP1 --> GluR1_memb + PP1 (forward)
ks[294] = 0.03                  # GluR1_memb_S845_S831 + PP1 <-> GluR1_memb_S845_S831_PP1 (forward)
ks[295] = 0.0014                # GluR1_memb_S845_S831 + PP1 <-> GluR1_memb_S845_S831_PP1 (backward)
ks[296] = 0.00035               # GluR1_memb_S845_S831_PP1 --> GluR1_memb_S845 + PP1 (forward)
ks[297] = 0.00035               # GluR1_memb_S845_S831_PP1 --> GluR1_memb_S831 + PP1 (forward)
ks[298] = 0.03                  # GluR1_memb_S831 + PP1 <-> GluR1_memb_S831_PP1 (forward)
ks[299] = 0.0014                # GluR1_memb_S831 + PP1 <-> GluR1_memb_S831_PP1 (backward)
ks[300] = 0.00035               # GluR1_memb_S831_PP1 --> GluR1_memb + PP1 (forward)
ks[301] = 2.01                  # GluR1_memb_S845 + PP2BCaMCa4 <-> GluR1_memb_S845_PP2B (forward)
ks[302] = 0.008                 # GluR1_memb_S845 + PP2BCaMCa4 <-> GluR1_memb_S845_PP2B (backward)
ks[303] = 0.002                 # GluR1_memb_S845_PP2B --> GluR1_memb + PP2BCaMCa4 (forward)
ks[304] = 2.01                  # GluR1_memb_S845_S831 + PP2BCaMCa4 <-> GluR1_memb_S845_S831_PP2B (forward)
ks[305] = 0.008                 # GluR1_memb_S845_S831 + PP2BCaMCa4 <-> GluR1_memb_S845_S831_PP2B (backward)
ks[306] = 0.002                 # GluR1_memb_S845_S831_PP2B --> GluR1_memb_S831 + PP2BCaMCa4 (forward)
ks[307] = 8e-07                 # GluR1_memb --> GluR1 (forward)
ks[308] = 8e-07                 # GluR1_memb_PKAc --> GluR1_PKAc (forward)
ks[309] = 8e-07                 # GluR1_memb_CKCam --> GluR1_CKCam (forward)
ks[310] = 8e-07                 # GluR1_memb_CKpCam --> GluR1_CKpCam (forward)
ks[311] = 8e-07                 # GluR1_memb_CKp --> GluR1_CKp (forward)
ks[312] = 8e-07                 # GluR1_memb_PKCtCa --> GluR1_PKCtCa (forward)
ks[313] = 8e-07                 # GluR1_memb_PKCtAACa --> GluR1_PKCtAACa (forward)
ks[314] = 8e-07                 # GluR1_memb_PKCtDAGCa --> GluR1_PKCtDAGCa (forward)
ks[315] = 8e-07                 # GluR1_memb_PKCtAADAGCa --> GluR1_PKCtAADAGCa (forward)
ks[316] = 8e-07                 # GluR1_memb_S831 --> GluR1_S831 (forward)
ks[317] = 8e-07                 # GluR1_memb_S831_PKAc --> GluR1_S831_PKAc (forward)
ks[318] = 8e-07                 # GluR1_memb_S831_PP1 --> GluR1_S831_PP1 (forward)
ks[319] = 3.28e-05              # GluR1_S845 <-> GluR1_memb_S845 (forward)
ks[320] = 8e-07                 # GluR1_S845 <-> GluR1_memb_S845 (backward)
ks[321] = 3.28e-05              # GluR1_S845_CKCam <-> GluR1_memb_S845_CKCam (forward)
ks[322] = 8e-07                 # GluR1_S845_CKCam <-> GluR1_memb_S845_CKCam (backward)
ks[323] = 3.28e-05              # GluR1_S845_CKpCam <-> GluR1_memb_S845_CKpCam (forward)
ks[324] = 8e-07                 # GluR1_S845_CKpCam <-> GluR1_memb_S845_CKpCam (backward)
ks[325] = 3.28e-05              # GluR1_S845_CKp <-> GluR1_memb_S845_CKp (forward)
ks[326] = 8e-07                 # GluR1_S845_CKp <-> GluR1_memb_S845_CKp (backward)
ks[327] = 3.28e-05              # GluR1_S845_PKCtCa <-> GluR1_memb_S845_PKCtCa (forward)
ks[328] = 8e-07                 # GluR1_S845_PKCtCa <-> GluR1_memb_S845_PKCtCa (backward)
ks[329] = 3.28e-05              # GluR1_S845_PKCtAACa <-> GluR1_memb_S845_PKCtAACa (forward)
ks[330] = 8e-07                 # GluR1_S845_PKCtAACa <-> GluR1_memb_S845_PKCtAACa (backward)
ks[331] = 3.28e-05              # GluR1_S845_PKCtDAGCa <-> GluR1_memb_S845_PKCtDAGCa (forward)
ks[332] = 8e-07                 # GluR1_S845_PKCtDAGCa <-> GluR1_memb_S845_PKCtDAGCa (backward)
ks[333] = 3.28e-05              # GluR1_S845_PKCtAADAGCa <-> GluR1_memb_S845_PKCtAADAGCa (forward)
ks[334] = 8e-07                 # GluR1_S845_PKCtAADAGCa <-> GluR1_memb_S845_PKCtAADAGCa (backward)
ks[335] = 3.28e-05              # GluR1_S845_S831 <-> GluR1_memb_S845_S831 (forward)
ks[336] = 8e-07                 # GluR1_S845_S831 <-> GluR1_memb_S845_S831 (backward)
ks[337] = 3.28e-05              # GluR1_S845_PP1 <-> GluR1_memb_S845_PP1 (forward)
ks[338] = 8e-07                 # GluR1_S845_PP1 <-> GluR1_memb_S845_PP1 (backward)
ks[339] = 3.28e-05              # GluR1_S845_S831_PP1 <-> GluR1_memb_S845_S831_PP1 (forward)
ks[340] = 8e-07                 # GluR1_S845_S831_PP1 <-> GluR1_memb_S845_S831_PP1 (backward)
ks[341] = 3.28e-05              # GluR1_S845_PP2B <-> GluR1_memb_S845_PP2B (forward)
ks[342] = 8e-07                 # GluR1_S845_PP2B <-> GluR1_memb_S845_PP2B (backward)
ks[343] = 3.28e-05              # GluR1_S845_S831_PP2B <-> GluR1_memb_S845_S831_PP2B (forward)
ks[344] = 8e-07                 # GluR1_S845_S831_PP2B <-> GluR1_memb_S845_S831_PP2B (backward)
ks[345] = 100.0                 # PDE1A + CaMCa4 <-> PDE1ACaMCa4 (forward)
ks[346] = 5e-05                 # PDE1A + CaMCa4 <-> PDE1ACaMCa4 (backward)
ks[347] = 23.7                  # PDE1ACaMCa4 + cAMP <-> PDE1ACaMCa4cAMP (forward)
ks[348] = 0.664                 # PDE1ACaMCa4 + cAMP <-> PDE1ACaMCa4cAMP (backward)
ks[349] = 0.166                 # PDE1ACaMCa4cAMP --> PDE1ACaMCa4 + AMP (forward)
ks[350] = 11.9                  # PDE1A + PKAc <-> PDE1A_PKAc (forward)
ks[351] = 0.004                 # PDE1A + PKAc <-> PDE1A_PKAc (backward)
ks[352] = 0.001                 # PDE1A_PKAc --> PDE1Ap + PKAc (forward)
ks[353] = 100.0                 # PDE1Ap + CaMCa4 <-> PDE1ApCaMCa4 (forward)
ks[354] = 0.001                 # PDE1Ap + CaMCa4 <-> PDE1ApCaMCa4 (backward)
ks[355] = 23.7                  # PDE1ApCaMCa4 + cAMP <-> PDE1ApCaMCa4cAMP (forward)
ks[356] = 0.664                 # PDE1ApCaMCa4 + cAMP <-> PDE1ApCaMCa4cAMP (backward)
ks[357] = 0.166                 # PDE1ApCaMCa4cAMP --> PDE1ApCaMCa4 + AMP (forward)
ks[358] = 0.00012               # PDE1Ap --> PDE1A (forward)
ks[359] = 0.001                 # AMP --> ATP (forward)
ks[360] = 0.049999999999999996  # PDE4 + cAMP <-> PDE4cAMP (forward)
ks[361] = 0.00016               # PDE4 + cAMP <-> PDE4cAMP (backward)
ks[362] = 4e-05                 # PDE4cAMP --> PDE4 + AMP (forward)
ks[363] = 0.25                  # PKAc + PDE4 <-> PKAcPDE4 (forward)
ks[364] = 8e-05                 # PKAc + PDE4 <-> PKAcPDE4 (backward)
ks[365] = 2e-05                 # PKAcPDE4 --> PDE4p + PKAc (forward)
ks[366] = 2e-05                 # PDE4p --> PDE4 (forward)
ks[367] = 0.19999999999999998   # PDE4p + cAMP <-> PDE4pcAMP (forward)
ks[368] = 0.00064               # PDE4p + cAMP <-> PDE4pcAMP (backward)
ks[369] = 0.00016               # PDE4pcAMP --> PDE4p + AMP (forward)
ks[370] = 0.25                  # PDE4cAMP + PKAc <-> PKAc_PDE4_cAMP (forward)
ks[371] = 8e-05                 # PDE4cAMP + PKAc <-> PKAc_PDE4_cAMP (backward)
ks[372] = 2e-05                 # PKAc_PDE4_cAMP --> PDE4pcAMP + PKAc (forward)
ks[373] = 0.00024               # PKAcAMP4 <-> PKAr + PKAc*2 (forward)
ks[374] = 25.5                  # PKAcAMP4 <-> PKAr + PKAc*2 (backward)
ks[375] = 400.0                 # Ca + fixedbuffer <-> fixedbufferCa (forward)
ks[376] = 20.0                  # Ca + fixedbuffer <-> fixedbufferCa (backward)
ks[377] = 0.0005                # Glu --> GluOut (forward)
ks[378] = 0.39999999999999997   # Ca + PLC <-> PLCCa (forward)
ks[379] = 0.001                 # Ca + PLC <-> PLCCa (backward)
ks[380] = 0.7                   # GqaGTP + PLC <-> PLCGqaGTP (forward)
ks[381] = 0.0007                # GqaGTP + PLC <-> PLCGqaGTP (backward)
ks[382] = 80.0                  # Ca + PLCGqaGTP <-> PLCCaGqaGTP (forward)
ks[383] = 0.04                  # Ca + PLCGqaGTP <-> PLCCaGqaGTP (backward)
ks[384] = 100.0                 # GqaGTP + PLCCa <-> PLCCaGqaGTP (forward)
ks[385] = 0.01                  # GqaGTP + PLCCa <-> PLCCaGqaGTP (backward)
ks[386] = 0.03                  # PLCCa + Pip2 <-> PLCCaPip2 (forward)
ks[387] = 0.01                  # PLCCa + Pip2 <-> PLCCaPip2 (backward)
ks[388] = 0.0003                # PLCCaPip2 --> PLCCaDAG + Ip3 (forward)
ks[389] = 0.2                   # PLCCaDAG --> PLCCa + DAG (forward)
ks[390] = 15.0                  # PLCCaGqaGTP + Pip2 <-> PLCCaGqaGTPPip2 (forward)
ks[391] = 0.075                 # PLCCaGqaGTP + Pip2 <-> PLCCaGqaGTPPip2 (backward)
ks[392] = 0.25                  # PLCCaGqaGTPPip2 --> PLCCaGqaGTPDAG + Ip3 (forward)
ks[393] = 1.0                   # PLCCaGqaGTPDAG --> PLCCaGqaGTP + DAG (forward)
ks[394] = 2.0                   # Ip3degrad + PIkinase <-> Ip3degPIk (forward)
ks[395] = 0.001                 # Ip3degrad + PIkinase <-> Ip3degPIk (backward)
ks[396] = 0.001                 # Ip3degPIk --> PIkinase + Pip2 (forward)
ks[397] = 0.012                 # PLCGqaGTP --> PLC + GqaGTP (forward)
ks[398] = 0.012                 # PLCCaGqaGTP --> PLCCa + GqaGTP (forward)
ks[399] = 0.001                 # GqaGTP --> GqaGDP (forward)
ks[400] = 0.01                  # GqaGDP --> Gqabg (forward)
ks[401] = 125.0                 # Ca + DGL <-> CaDGL (forward)
ks[402] = 0.05                  # Ca + DGL <-> CaDGL (backward)
ks[403] = 0.5                   # DAG + CaDGL <-> DAGCaDGL (forward)
ks[404] = 0.001                 # DAG + CaDGL <-> DAGCaDGL (backward)
ks[405] = 0.00025               # DAGCaDGL --> CaDGL + _2AG (forward)
ks[406] = 0.01                  # Ip3 --> Ip3degrad (forward)
ks[407] = 0.005                 # _2AG --> _2AGdegrad (forward)
ks[408] = 0.07                  # DAG + DAGK <-> DAGKdag (forward)
ks[409] = 0.0008                # DAG + DAGK <-> DAGKdag (backward)
ks[410] = 0.0002                # DAGKdag --> PA + DAGK (forward)
ks[411] = 13.299999999999999    # Ca + PKC <-> PKCCa (forward)
ks[412] = 0.012                 # Ca + PKC <-> PKCCa (backward)
ks[413] = 4.0                   # PKCCa + AA <-> PKCAACa (forward)
ks[414] = 0.001                 # PKCCa + AA <-> PKCAACa (backward)
ks[415] = 0.0                   # PKCCa <-> PKCtCa (forward)
ks[416] = 0.005                 # PKCCa <-> PKCtCa (backward)
ks[417] = 0.003                 # PKCAACa <-> PKCtAACa (forward)
ks[418] = 0.005                 # PKCAACa <-> PKCtAACa (backward)
ks[419] = 0.7999999999999999    # PKCtCa + DAG <-> PKCtDAGCa (forward)
ks[420] = 0.001                 # PKCtCa + DAG <-> PKCtDAGCa (backward)
ks[421] = 0.7999999999999999    # PKCtAACa + DAG <-> PKCtAADAGCa (forward)
ks[422] = 5e-05                 # PKCtAACa + DAG <-> PKCtAADAGCa (backward)
ks[423] = 4.0                   # PKCtDAGCa + AA <-> PKCtAADAGCa (forward)
ks[424] = 5e-05                 # PKCtDAGCa + AA <-> PKCtAADAGCa (backward)
ks[425] = 4.0                   # PKCtCa + AA <-> PKCtAACa (forward)
ks[426] = 0.001                 # PKCtCa + AA <-> PKCtAACa (backward)
ks[427] = 0.016800000000000002  # Glu + MGluR <-> MGluR_Glu (forward)
ks[428] = 0.0001                # Glu + MGluR <-> MGluR_Glu (backward)
ks[429] = 6.25e-05              # MGluR_Glu <-> MGluR_Glu_desens (forward)
ks[430] = 1e-06                 # MGluR_Glu <-> MGluR_Glu_desens (backward)
ks[431] = 9.0                   # Gqabg + MGluR_Glu <-> MGluR_Gqabg_Glu (forward)
ks[432] = 0.00136               # Gqabg + MGluR_Glu <-> MGluR_Gqabg_Glu (backward)
ks[433] = 0.0015                # MGluR_Gqabg_Glu --> GqaGTP + MGluR_Glu (forward)
ks[434] = 4.0                   # GluR2 + PKCtCa <-> GluR2_PKCtCa (forward)
ks[435] = 0.0008                # GluR2 + PKCtCa <-> GluR2_PKCtCa (backward)
ks[436] = 0.0047                # GluR2_PKCtCa --> GluR2_S880 + PKCtCa (forward)
ks[437] = 4.0                   # GluR2 + PKCtAACa <-> GluR2_PKCtAACa (forward)
ks[438] = 0.0008                # GluR2 + PKCtAACa <-> GluR2_PKCtAACa (backward)
ks[439] = 0.0047                # GluR2_PKCtAACa --> GluR2_S880 + PKCtAACa (forward)
ks[440] = 4.0                   # GluR2 + PKCtDAGCa <-> GluR2_PKCtDAGCa (forward)
ks[441] = 0.0008                # GluR2 + PKCtDAGCa <-> GluR2_PKCtDAGCa (backward)
ks[442] = 0.0047                # GluR2_PKCtDAGCa --> GluR2_S880 + PKCtDAGCa (forward)
ks[443] = 4.0                   # GluR2 + PKCtAADAGCa <-> GluR2_PKCtAADAGCa (forward)
ks[444] = 0.0008                # GluR2 + PKCtAADAGCa <-> GluR2_PKCtAADAGCa (backward)
ks[445] = 0.0047                # GluR2_PKCtAADAGCa --> GluR2_S880 + PKCtAADAGCa (forward)
ks[446] = 0.5                   # GluR2_S880 + PP2A <-> GluR2_S880_PP2A (forward)
ks[447] = 0.005                 # GluR2_S880 + PP2A <-> GluR2_S880_PP2A (backward)
ks[448] = 0.00015               # GluR2_S880_PP2A --> GluR2 + PP2A (forward)
ks[449] = 4.0                   # GluR2_memb + PKCtCa <-> GluR2_memb_PKCtCa (forward)
ks[450] = 0.0008                # GluR2_memb + PKCtCa <-> GluR2_memb_PKCtCa (backward)
ks[451] = 0.0047                # GluR2_memb_PKCtCa --> GluR2_memb_S880 + PKCtCa (forward)
ks[452] = 4.0                   # GluR2_memb + PKCtAACa <-> GluR2_memb_PKCtAACa (forward)
ks[453] = 0.0008                # GluR2_memb + PKCtAACa <-> GluR2_memb_PKCtAACa (backward)
ks[454] = 0.0047                # GluR2_memb_PKCtAACa --> GluR2_memb_S880 + PKCtAACa (forward)
ks[455] = 4.0                   # GluR2_memb + PKCtDAGCa <-> GluR2_memb_PKCtDAGCa (forward)
ks[456] = 0.0008                # GluR2_memb + PKCtDAGCa <-> GluR2_memb_PKCtDAGCa (backward)
ks[457] = 0.0047                # GluR2_memb_PKCtDAGCa --> GluR2_memb_S880 + PKCtDAGCa (forward)
ks[458] = 4.0                   # GluR2_memb + PKCtAADAGCa <-> GluR2_memb_PKCtAADAGCa (forward)
ks[459] = 0.0008                # GluR2_memb + PKCtAADAGCa <-> GluR2_memb_PKCtAADAGCa (backward)
ks[460] = 0.0047                # GluR2_memb_PKCtAADAGCa --> GluR2_memb_S880 + PKCtAADAGCa (forward)
ks[461] = 0.5                   # GluR2_memb_S880 + PP2A <-> GluR2_memb_S880_PP2A (forward)
ks[462] = 0.005                 # GluR2_memb_S880 + PP2A <-> GluR2_memb_S880_PP2A (backward)
ks[463] = 0.00015               # GluR2_memb_S880_PP2A --> GluR2_memb + PP2A (forward)
ks[464] = 0.00024545            # GluR2 <-> GluR2_memb (forward)
ks[465] = 0.0003                # GluR2 <-> GluR2_memb (backward)
ks[466] = 0.00024545            # GluR2_PKCtCa <-> GluR2_memb_PKCtCa (forward)
ks[467] = 0.0003                # GluR2_PKCtCa <-> GluR2_memb_PKCtCa (backward)
ks[468] = 0.00024545            # GluR2_PKCtAACa <-> GluR2_memb_PKCtAACa (forward)
ks[469] = 0.0003                # GluR2_PKCtAACa <-> GluR2_memb_PKCtAACa (backward)
ks[470] = 0.00024545            # GluR2_PKCtDAGCa <-> GluR2_memb_PKCtDAGCa (forward)
ks[471] = 0.0003                # GluR2_PKCtDAGCa <-> GluR2_memb_PKCtDAGCa (backward)
ks[472] = 0.00024545            # GluR2_PKCtAADAGCa <-> GluR2_memb_PKCtAADAGCa (forward)
ks[473] = 0.0003                # GluR2_PKCtAADAGCa <-> GluR2_memb_PKCtAADAGCa (backward)
ks[474] = 0.0055                # GluR2_S880 <-> GluR2_memb_S880 (forward)
ks[475] = 0.07                  # GluR2_S880 <-> GluR2_memb_S880 (backward)
ks[476] = 0.0055                # GluR2_S880_PP2A <-> GluR2_memb_S880_PP2A (forward)
ks[477] = 0.07                  # GluR2_S880_PP2A <-> GluR2_memb_S880_PP2A (backward)
ks[478] = 0.095                 # ACh + M1R <-> AChM1R (forward)
ks[479] = 0.0025                # ACh + M1R <-> AChM1R (backward)
ks[480] = 24.0                  # Gqabg + AChM1R <-> AChM1RGq (forward)
ks[481] = 0.00042               # Gqabg + AChM1R <-> AChM1RGq (backward)
ks[482] = 0.576                 # Gqabg + M1R <-> M1RGq (forward)
ks[483] = 0.00042               # Gqabg + M1R <-> M1RGq (backward)
ks[484] = 3.9600000000000004    # ACh + M1RGq <-> AChM1RGq (forward)
ks[485] = 0.0025                # ACh + M1RGq <-> AChM1RGq (backward)
ks[486] = 0.0005                # AChM1RGq --> GqaGTP + AChM1R (forward)
ks[487] = 0.0005                # ACh --> ACh*0 (forward)
ks[488] = 17.7                  # Ca + PLA2 <-> CaPLA2 (forward)
ks[489] = 0.154                 # Ca + PLA2 <-> CaPLA2 (backward)
ks[490] = 16.3                  # Ca + CaPLA2 <-> Ca2PLA2 (forward)
ks[491] = 0.102                 # Ca + CaPLA2 <-> Ca2PLA2 (backward)
ks[492] = 0.0015                # Ca2PLA2 <-> Ca2PLA2act (forward)
ks[493] = 0.008                 # Ca2PLA2 <-> Ca2PLA2act (backward)
ks[494] = 22.0                  # Ca2PLA2act + Pip2 <-> Ca2PLA2actPip2 (forward)
ks[495] = 0.444                 # Ca2PLA2act + Pip2 <-> Ca2PLA2actPip2 (backward)
ks[496] = 0.111                 # Ca2PLA2actPip2 --> Ca2PLA2act + AA (forward)
ks[497] = 0.01                  # AA --> Pip2 (forward)
ks[498] = 0.06772               # Ng + PKCtCa <-> NgPKCtCa (forward)
ks[499] = 2.8e-09               # Ng + PKCtCa <-> NgPKCtCa (backward)
ks[500] = 1.775                 # NgPKCtCa --> Ngp + PKCtCa (forward)
ks[501] = 0.06772               # NgCaM + PKCtCa <-> NgCaMPKCtCa (forward)
ks[502] = 2.8e-09               # NgCaM + PKCtCa <-> NgCaMPKCtCa (backward)
ks[503] = 0.06772               # NgCaMCa2 + PKCtCa <-> NgCaMCa2PKCtCa (forward)
ks[504] = 2.8e-09               # NgCaMCa2 + PKCtCa <-> NgCaMCa2PKCtCa (backward)
ks[505] = 0.06772               # NgCaMCa3 + PKCtCa <-> NgCaMCa3PKCtCa (forward)
ks[506] = 2.8e-09               # NgCaMCa3 + PKCtCa <-> NgCaMCa3PKCtCa (backward)
ks[507] = 0.06772               # NgCaMCa4 + PKCtCa <-> NgCaMCa4PKCtCa (forward)
ks[508] = 2.8e-09               # NgCaMCa4 + PKCtCa <-> NgCaMCa4PKCtCa (backward)
ks[509] = 7.76e-06              # NgCaMPKCtCa --> NgpCaM + PKCtCa (forward)
ks[510] = 7.76e-06              # NgCaMCa2PKCtCa --> NgpCaMCa2 + PKCtCa (forward)
ks[511] = 7.76e-06              # NgCaMCa3PKCtCa --> NgpCaMCa3 + PKCtCa (forward)
ks[512] = 7.76e-06              # NgCaMCa4PKCtCa --> NgpCaMCa4 + PKCtCa (forward)
ks[513] = 0.06772               # Ng + PKCtAACa <-> NgPKCtAACa (forward)
ks[514] = 2.8e-09               # Ng + PKCtAACa <-> NgPKCtAACa (backward)
ks[515] = 1.775                 # NgPKCtAACa --> Ngp + PKCtAACa (forward)
ks[516] = 0.06772               # NgCaM + PKCtAACa <-> NgCaMPKCtAACa (forward)
ks[517] = 2.8e-09               # NgCaM + PKCtAACa <-> NgCaMPKCtAACa (backward)
ks[518] = 0.06772               # NgCaMCa2 + PKCtAACa <-> NgCaMCa2PKCtAACa (forward)
ks[519] = 2.8e-09               # NgCaMCa2 + PKCtAACa <-> NgCaMCa2PKCtAACa (backward)
ks[520] = 0.06772               # NgCaMCa3 + PKCtAACa <-> NgCaMCa3PKCtAACa (forward)
ks[521] = 2.8e-09               # NgCaMCa3 + PKCtAACa <-> NgCaMCa3PKCtAACa (backward)
ks[522] = 0.06772               # NgCaMCa4 + PKCtAACa <-> NgCaMCa4PKCtAACa (forward)
ks[523] = 2.8e-09               # NgCaMCa4 + PKCtAACa <-> NgCaMCa4PKCtAACa (backward)
ks[524] = 7.76e-06              # NgCaMPKCtAACa --> NgpCaM + PKCtAACa (forward)
ks[525] = 7.76e-06              # NgCaMCa2PKCtAACa --> NgpCaMCa2 + PKCtAACa (forward)
ks[526] = 7.76e-06              # NgCaMCa3PKCtAACa --> NgpCaMCa3 + PKCtAACa (forward)
ks[527] = 7.76e-06              # NgCaMCa4PKCtAACa --> NgpCaMCa4 + PKCtAACa (forward)
ks[528] = 0.06772               # Ng + PKCtDAGCa <-> NgPKCtDAGCa (forward)
ks[529] = 2.8e-09               # Ng + PKCtDAGCa <-> NgPKCtDAGCa (backward)
ks[530] = 1.775                 # NgPKCtDAGCa --> Ngp + PKCtDAGCa (forward)
ks[531] = 0.06772               # NgCaM + PKCtDAGCa <-> NgCaMPKCtDAGCa (forward)
ks[532] = 2.8e-09               # NgCaM + PKCtDAGCa <-> NgCaMPKCtDAGCa (backward)
ks[533] = 0.06772               # NgCaMCa2 + PKCtDAGCa <-> NgCaMCa2PKCtDAGCa (forward)
ks[534] = 2.8e-09               # NgCaMCa2 + PKCtDAGCa <-> NgCaMCa2PKCtDAGCa (backward)
ks[535] = 0.06772               # NgCaMCa3 + PKCtDAGCa <-> NgCaMCa3PKCtDAGCa (forward)
ks[536] = 2.8e-09               # NgCaMCa3 + PKCtDAGCa <-> NgCaMCa3PKCtDAGCa (backward)
ks[537] = 0.06772               # NgCaMCa4 + PKCtDAGCa <-> NgCaMCa4PKCtDAGCa (forward)
ks[538] = 2.8e-09               # NgCaMCa4 + PKCtDAGCa <-> NgCaMCa4PKCtDAGCa (backward)
ks[539] = 7.76e-06              # NgCaMPKCtDAGCa --> NgpCaM + PKCtDAGCa (forward)
ks[540] = 7.76e-06              # NgCaMCa2PKCtDAGCa --> NgpCaMCa2 + PKCtDAGCa (forward)
ks[541] = 7.76e-06              # NgCaMCa3PKCtDAGCa --> NgpCaMCa3 + PKCtDAGCa (forward)
ks[542] = 7.76e-06              # NgCaMCa4PKCtDAGCa --> NgpCaMCa4 + PKCtDAGCa (forward)
ks[543] = 0.06772               # Ng + PKCtAADAGCa <-> NgPKCtAADAGCa (forward)
ks[544] = 2.8e-09               # Ng + PKCtAADAGCa <-> NgPKCtAADAGCa (backward)
ks[545] = 1.775                 # NgPKCtAADAGCa --> Ngp + PKCtAADAGCa (forward)
ks[546] = 0.06772               # NgCaM + PKCtAADAGCa <-> NgCaMPKCtAADAGCa (forward)
ks[547] = 2.8e-09               # NgCaM + PKCtAADAGCa <-> NgCaMPKCtAADAGCa (backward)
ks[548] = 0.06772               # NgCaMCa2 + PKCtAADAGCa <-> NgCaMCa2PKCtAADAGCa (forward)
ks[549] = 2.8e-09               # NgCaMCa2 + PKCtAADAGCa <-> NgCaMCa2PKCtAADAGCa (backward)
ks[550] = 0.06772               # NgCaMCa3 + PKCtAADAGCa <-> NgCaMCa3PKCtAADAGCa (forward)
ks[551] = 2.8e-09               # NgCaMCa3 + PKCtAADAGCa <-> NgCaMCa3PKCtAADAGCa (backward)
ks[552] = 0.06772               # NgCaMCa4 + PKCtAADAGCa <-> NgCaMCa4PKCtAADAGCa (forward)
ks[553] = 2.8e-09               # NgCaMCa4 + PKCtAADAGCa <-> NgCaMCa4PKCtAADAGCa (backward)
ks[554] = 7.76e-06              # NgCaMPKCtAADAGCa --> NgpCaM + PKCtAADAGCa (forward)
ks[555] = 7.76e-06              # NgCaMCa2PKCtAADAGCa --> NgpCaMCa2 + PKCtAADAGCa (forward)
ks[556] = 7.76e-06              # NgCaMCa3PKCtAADAGCa --> NgpCaMCa3 + PKCtAADAGCa (forward)
ks[557] = 7.76e-06              # NgCaMCa4PKCtAADAGCa --> NgpCaMCa4 + PKCtAADAGCa (forward)
ks[558] = 0.0033900000000000002 # Ngp + PP1 <-> NgpPP1 (forward)
ks[559] = 0.0014                # Ngp + PP1 <-> NgpPP1 (backward)
ks[560] = 0.00035               # NgpPP1 --> Ng + PP1 (forward)
ks[561] = 0.9098999999999999    # Ngp + PP2A <-> NgpPP2A (forward)
ks[562] = 0.005                 # Ngp + PP2A <-> NgpPP2A (backward)
ks[563] = 0.00015               # NgpPP2A --> Ng + PP2A (forward)
ks[564] = 0.34689000000000003   # Ngp + PP2BCaMCa4 <-> NgpPP2BCaMCa4 (forward)
ks[565] = 0.008                 # Ngp + PP2BCaMCa4 <-> NgpPP2BCaMCa4 (backward)
ks[566] = 0.002                 # NgpPP2BCaMCa4 --> Ng + PP2BCaMCa4 (forward)
ks[567] = 1.0                   # GluR1 --> GluR1_S845 (forward)
ks[568] = 1.0                   # GluR1_S831 --> GluR1_S845_S831 (forward)
ks[569] = 1.0                   # GluR1_memb --> GluR1_memb_S845 (forward)
ks[570] = 1.0                   # GluR1_memb_S831 --> GluR1_memb_S845_S831 (forward)
ks[571] = 1.0                   # GluR1 --> GluR1_S831 (forward)
ks[572] = 1.0                   # GluR1_S845 --> GluR1_S845_S831 (forward)
ks[573] = 1.0                   # GluR1_memb --> GluR1_memb_S831 (forward)
ks[574] = 1.0                   # GluR1_memb_S845 --> GluR1_memb_S845_S831 (forward)
ks[575] = 1.0                   # GluR2 --> GluR2_S880 (forward)
ks[576] = 1.0                   # GluR2_memb --> GluR2_memb_S880 (forward)

for ialteredk in range(0,len(alteredks)):
  ks[alteredks[ialteredk]] = alteredk_factors[ialteredk]*ks[alteredks[ialteredk]]
reaction000 = rxd.Reaction(specs[0] + specs[9], specs[11], ks[0], ks[1])
reaction001 = rxd.Reaction(specs[11], specs[9] + specs[1], ks[2])
reaction002 = rxd.Reaction(specs[0] + specs[10], specs[12], ks[3], ks[4])
reaction003 = rxd.Reaction(specs[12], specs[10] + specs[1], ks[5])
reaction004 = rxd.Reaction(specs[1] + specs[3], specs[2], ks[6], ks[7])
reaction005 = rxd.Reaction(specs[2], specs[0] + specs[3], ks[8])
reaction006 = rxd.Reaction(specs[0] + specs[4], specs[5], ks[9], ks[10])
reaction007 = rxd.Reaction(specs[13], specs[6], ks[11])
reaction008 = rxd.Reaction(specs[13] + specs[14], specs[17], ks[12], ks[13])
reaction009 = rxd.Reaction(specs[17] + specs[15], specs[18], ks[14], ks[15])
reaction010 = rxd.Reaction(specs[15] + specs[14], specs[39], ks[16], ks[17])
reaction011 = rxd.Reaction(specs[39] + specs[13], specs[18], ks[18], ks[19])
reaction012 = rxd.Reaction(specs[18], specs[46] + specs[40], ks[20])
reaction013 = rxd.Reaction(specs[46], specs[17] + specs[45], ks[21])
reaction014 = rxd.Reaction(specs[17] + specs[125], specs[19], ks[22], ks[23])
reaction015 = rxd.Reaction(specs[19], specs[23] + specs[125], ks[24])
reaction016 = rxd.Reaction(specs[23] + specs[125], specs[20], ks[25], ks[26])
reaction017 = rxd.Reaction(specs[20], specs[24] + specs[125], ks[27])
reaction018 = rxd.Reaction(specs[24] + specs[125], specs[21], ks[28], ks[29])
reaction019 = rxd.Reaction(specs[21], specs[25] + specs[125], ks[30])
reaction020 = rxd.Reaction(specs[25] + specs[125], specs[22], ks[31], ks[32])
reaction021 = rxd.Reaction(specs[22], specs[26] + specs[125], ks[33])
reaction022 = rxd.Reaction(specs[26] + specs[16], specs[27], ks[34], ks[35])
reaction023 = rxd.Reaction(specs[27], specs[28] + specs[42], ks[36])
reaction024 = rxd.Reaction(specs[28], specs[26] + specs[44], ks[37])
reaction025 = rxd.Reaction(specs[23], specs[17], ks[38])
reaction026 = rxd.Reaction(specs[24], specs[23], ks[39])
reaction027 = rxd.Reaction(specs[25], specs[24], ks[40])
reaction028 = rxd.Reaction(specs[26], specs[25], ks[41])
reaction029 = rxd.Reaction(specs[14] + specs[125], specs[29], ks[42], ks[43])
reaction030 = rxd.Reaction(specs[29], specs[33] + specs[125], ks[44])
reaction031 = rxd.Reaction(specs[33] + specs[125], specs[30], ks[45], ks[46])
reaction032 = rxd.Reaction(specs[30], specs[34] + specs[125], ks[47])
reaction033 = rxd.Reaction(specs[34] + specs[125], specs[31], ks[48], ks[49])
reaction034 = rxd.Reaction(specs[31], specs[35] + specs[125], ks[50])
reaction035 = rxd.Reaction(specs[35] + specs[125], specs[32], ks[51], ks[52])
reaction036 = rxd.Reaction(specs[32], specs[36] + specs[125], ks[53])
reaction037 = rxd.Reaction(specs[36] + specs[16], specs[37], ks[54], ks[55])
reaction038 = rxd.Reaction(specs[37], specs[38] + specs[42], ks[56])
reaction039 = rxd.Reaction(specs[38], specs[36] + specs[44], ks[57])
reaction040 = rxd.Reaction(specs[33], specs[14], ks[58])
reaction041 = rxd.Reaction(specs[34], specs[33], ks[59])
reaction042 = rxd.Reaction(specs[35], specs[34], ks[60])
reaction043 = rxd.Reaction(specs[36], specs[35], ks[61])
reaction044 = rxd.Reaction(specs[40], specs[41], ks[62])
reaction045 = rxd.Reaction(specs[41] + specs[45], specs[15], ks[63])
reaction046 = rxd.Reaction(specs[42], specs[43], ks[64])
reaction047 = rxd.Reaction(specs[43] + specs[44], specs[16], ks[65])
reaction048 = rxd.Reaction(specs[40] + specs[47], specs[48], ks[66], ks[67])
reaction049 = rxd.Reaction(specs[48] + specs[108], specs[49], ks[68], ks[69])
reaction050 = rxd.Reaction(specs[49] + specs[57], specs[50], ks[70], ks[71])
reaction051 = rxd.Reaction(specs[50], specs[58] + specs[49], ks[72])
reaction052 = rxd.Reaction(specs[42] + specs[48], specs[54], ks[73], ks[74])
reaction053 = rxd.Reaction(specs[54] + specs[108], specs[55], ks[75], ks[76])
reaction054 = rxd.Reaction(specs[55] + specs[57], specs[56], ks[77], ks[78])
reaction055 = rxd.Reaction(specs[56], specs[58] + specs[55], ks[79])
reaction056 = rxd.Reaction(specs[42] + specs[59], specs[52], ks[80], ks[81])
reaction057 = rxd.Reaction(specs[52] + specs[57], specs[53], ks[82], ks[83])
reaction058 = rxd.Reaction(specs[53], specs[58] + specs[52], ks[84])
reaction059 = rxd.Reaction(specs[47] + specs[108], specs[59], ks[85], ks[86])
reaction060 = rxd.Reaction(specs[59] + specs[57], specs[60], ks[87], ks[88])
reaction061 = rxd.Reaction(specs[60], specs[58] + specs[59], ks[89])
reaction062 = rxd.Reaction(specs[51] + specs[40], specs[54], ks[90], ks[91])
reaction063 = rxd.Reaction(specs[61] + specs[108], specs[62], ks[92], ks[93])
reaction064 = rxd.Reaction(specs[62] + specs[57], specs[63], ks[94], ks[95])
reaction065 = rxd.Reaction(specs[63], specs[58] + specs[62], ks[96])
reaction066 = rxd.Reaction(specs[105] + specs[0]*2, specs[106], ks[97], ks[98])
reaction067 = rxd.Reaction(specs[106] + specs[0], specs[107], ks[99], ks[100])
reaction068 = rxd.Reaction(specs[107] + specs[0], specs[108], ks[101], ks[102])
reaction069 = rxd.Reaction(specs[73] + specs[0]*2, specs[84], ks[103], ks[104])
reaction070 = rxd.Reaction(specs[84] + specs[0], specs[90], ks[105], ks[106])
reaction071 = rxd.Reaction(specs[90] + specs[0], specs[96], ks[107], ks[108])
reaction072 = rxd.Reaction(specs[75] + specs[0]*2, specs[85], ks[109], ks[110])
reaction073 = rxd.Reaction(specs[85] + specs[0], specs[91], ks[111], ks[112])
reaction074 = rxd.Reaction(specs[91] + specs[0], specs[97], ks[113], ks[114])
reaction075 = rxd.Reaction(specs[105] + specs[72], specs[73], ks[115], ks[116])
reaction076 = rxd.Reaction(specs[105] + specs[74], specs[75], ks[117], ks[118])
reaction077 = rxd.Reaction(specs[106] + specs[72], specs[84], ks[119], ks[120])
reaction078 = rxd.Reaction(specs[106] + specs[74], specs[85], ks[121], ks[122])
reaction079 = rxd.Reaction(specs[107] + specs[72], specs[90], ks[123], ks[124])
reaction080 = rxd.Reaction(specs[107] + specs[74], specs[91], ks[125], ks[126])
reaction081 = rxd.Reaction(specs[108] + specs[72], specs[96], ks[127], ks[128])
reaction082 = rxd.Reaction(specs[108] + specs[74], specs[97], ks[129], ks[130])
reaction083 = rxd.Reaction(specs[105] + specs[109], specs[110], ks[131], ks[132])
reaction084 = rxd.Reaction(specs[106] + specs[109], specs[111], ks[133], ks[134])
reaction085 = rxd.Reaction(specs[107] + specs[109], specs[112], ks[135], ks[136])
reaction086 = rxd.Reaction(specs[108] + specs[109], specs[113], ks[137], ks[138])
reaction087 = rxd.Reaction(specs[110] + specs[0]*2, specs[111], ks[139], ks[140])
reaction088 = rxd.Reaction(specs[111] + specs[0], specs[112], ks[141], ks[142])
reaction089 = rxd.Reaction(specs[112] + specs[0], specs[113], ks[143], ks[144])
reaction090 = rxd.Reaction(specs[108] + specs[114], specs[115], ks[145], ks[146])
reaction091 = rxd.Reaction(specs[115]*2, specs[118], ks[147], ks[148])
reaction092 = rxd.Reaction(specs[116] + specs[115], specs[119], ks[149], ks[150])
reaction093 = rxd.Reaction(specs[116] + specs[118], specs[116] + specs[119], ks[151])
reaction094 = rxd.Reaction(specs[115] + specs[118], specs[115] + specs[119], ks[152])
reaction095 = rxd.Reaction(specs[118]*2, specs[118] + specs[119], ks[153])
reaction096 = rxd.Reaction(specs[118] + specs[119], specs[119]*2, ks[154])
reaction097 = rxd.Reaction(specs[116], specs[108] + specs[117], ks[155], ks[156])
reaction098 = rxd.Reaction(specs[117] + specs[129], specs[120], ks[157], ks[158])
reaction099 = rxd.Reaction(specs[120], specs[129] + specs[114], ks[159])
reaction100 = rxd.Reaction(specs[116] + specs[129], specs[121], ks[160], ks[161])
reaction101 = rxd.Reaction(specs[121], specs[129] + specs[115], ks[162])
reaction102 = rxd.Reaction(specs[122] + specs[58]*4, specs[123], ks[163], ks[164])
reaction103 = rxd.Reaction(specs[7] + specs[58], specs[8], ks[165], ks[166])
reaction104 = rxd.Reaction(specs[126] + specs[125], specs[127], ks[167], ks[168])
reaction105 = rxd.Reaction(specs[127], specs[128] + specs[125], ks[169])
reaction106 = rxd.Reaction(specs[128] + specs[129], specs[130], ks[170], ks[171])
reaction107 = rxd.Reaction(specs[128] + specs[113], specs[131], ks[172], ks[173])
reaction108 = rxd.Reaction(specs[131], specs[126] + specs[113], ks[174])
reaction109 = rxd.Reaction(specs[130] + specs[113], specs[132], ks[175], ks[176])
reaction110 = rxd.Reaction(specs[132], specs[126] + specs[133], ks[177])
reaction111 = rxd.Reaction(specs[133], specs[129] + specs[113], ks[178])
reaction112 = rxd.Reaction(specs[134] + specs[125], specs[138], ks[179], ks[180])
reaction113 = rxd.Reaction(specs[138], specs[135] + specs[125], ks[181])
reaction114 = rxd.Reaction(specs[134] + specs[115], specs[139], ks[182], ks[183])
reaction115 = rxd.Reaction(specs[139], specs[136] + specs[115], ks[184])
reaction116 = rxd.Reaction(specs[134] + specs[116], specs[140], ks[185], ks[186])
reaction117 = rxd.Reaction(specs[140], specs[136] + specs[116], ks[187])
reaction118 = rxd.Reaction(specs[134] + specs[117], specs[141], ks[188], ks[189])
reaction119 = rxd.Reaction(specs[141], specs[136] + specs[117], ks[190])
reaction120 = rxd.Reaction(specs[134] + specs[216], specs[142], ks[191], ks[192])
reaction121 = rxd.Reaction(specs[142], specs[136] + specs[216], ks[193])
reaction122 = rxd.Reaction(specs[134] + specs[217], specs[143], ks[194], ks[195])
reaction123 = rxd.Reaction(specs[143], specs[136] + specs[217], ks[196])
reaction124 = rxd.Reaction(specs[134] + specs[218], specs[144], ks[197], ks[198])
reaction125 = rxd.Reaction(specs[144], specs[136] + specs[218], ks[199])
reaction126 = rxd.Reaction(specs[134] + specs[219], specs[145], ks[200], ks[201])
reaction127 = rxd.Reaction(specs[145], specs[136] + specs[219], ks[202])
reaction128 = rxd.Reaction(specs[135] + specs[115], specs[146], ks[203], ks[204])
reaction129 = rxd.Reaction(specs[146], specs[137] + specs[115], ks[205])
reaction130 = rxd.Reaction(specs[135] + specs[116], specs[147], ks[206], ks[207])
reaction131 = rxd.Reaction(specs[147], specs[137] + specs[116], ks[208])
reaction132 = rxd.Reaction(specs[135] + specs[117], specs[148], ks[209], ks[210])
reaction133 = rxd.Reaction(specs[148], specs[137] + specs[117], ks[211])
reaction134 = rxd.Reaction(specs[135] + specs[216], specs[149], ks[212], ks[213])
reaction135 = rxd.Reaction(specs[149], specs[137] + specs[216], ks[214])
reaction136 = rxd.Reaction(specs[135] + specs[217], specs[150], ks[215], ks[216])
reaction137 = rxd.Reaction(specs[150], specs[137] + specs[217], ks[217])
reaction138 = rxd.Reaction(specs[135] + specs[218], specs[151], ks[218], ks[219])
reaction139 = rxd.Reaction(specs[151], specs[137] + specs[218], ks[220])
reaction140 = rxd.Reaction(specs[135] + specs[219], specs[152], ks[221], ks[222])
reaction141 = rxd.Reaction(specs[152], specs[137] + specs[219], ks[223])
reaction142 = rxd.Reaction(specs[136] + specs[125], specs[153], ks[224], ks[225])
reaction143 = rxd.Reaction(specs[153], specs[137] + specs[125], ks[226])
reaction144 = rxd.Reaction(specs[135] + specs[129], specs[154], ks[227], ks[228])
reaction145 = rxd.Reaction(specs[154], specs[134] + specs[129], ks[229])
reaction146 = rxd.Reaction(specs[137] + specs[129], specs[155], ks[230], ks[231])
reaction147 = rxd.Reaction(specs[155], specs[135] + specs[129], ks[232])
reaction148 = rxd.Reaction(specs[155], specs[136] + specs[129], ks[233])
reaction149 = rxd.Reaction(specs[136] + specs[129], specs[156], ks[234], ks[235])
reaction150 = rxd.Reaction(specs[156], specs[134] + specs[129], ks[236])
reaction151 = rxd.Reaction(specs[135] + specs[113], specs[157], ks[237], ks[238])
reaction152 = rxd.Reaction(specs[157], specs[134] + specs[113], ks[239])
reaction153 = rxd.Reaction(specs[137] + specs[113], specs[158], ks[240], ks[241])
reaction154 = rxd.Reaction(specs[158], specs[136] + specs[113], ks[242])
reaction155 = rxd.Reaction(specs[159] + specs[125], specs[163], ks[243], ks[244])
reaction156 = rxd.Reaction(specs[163], specs[160] + specs[125], ks[245])
reaction157 = rxd.Reaction(specs[159] + specs[115], specs[164], ks[246], ks[247])
reaction158 = rxd.Reaction(specs[164], specs[161] + specs[115], ks[248])
reaction159 = rxd.Reaction(specs[159] + specs[116], specs[165], ks[249], ks[250])
reaction160 = rxd.Reaction(specs[165], specs[161] + specs[116], ks[251])
reaction161 = rxd.Reaction(specs[159] + specs[117], specs[166], ks[252], ks[253])
reaction162 = rxd.Reaction(specs[166], specs[161] + specs[117], ks[254])
reaction163 = rxd.Reaction(specs[159] + specs[216], specs[167], ks[255], ks[256])
reaction164 = rxd.Reaction(specs[167], specs[161] + specs[216], ks[257])
reaction165 = rxd.Reaction(specs[159] + specs[217], specs[168], ks[258], ks[259])
reaction166 = rxd.Reaction(specs[168], specs[161] + specs[217], ks[260])
reaction167 = rxd.Reaction(specs[159] + specs[218], specs[169], ks[261], ks[262])
reaction168 = rxd.Reaction(specs[169], specs[161] + specs[218], ks[263])
reaction169 = rxd.Reaction(specs[159] + specs[219], specs[170], ks[264], ks[265])
reaction170 = rxd.Reaction(specs[170], specs[161] + specs[219], ks[266])
reaction171 = rxd.Reaction(specs[160] + specs[115], specs[171], ks[267], ks[268])
reaction172 = rxd.Reaction(specs[171], specs[162] + specs[115], ks[269])
reaction173 = rxd.Reaction(specs[160] + specs[116], specs[172], ks[270], ks[271])
reaction174 = rxd.Reaction(specs[172], specs[162] + specs[116], ks[272])
reaction175 = rxd.Reaction(specs[160] + specs[117], specs[173], ks[273], ks[274])
reaction176 = rxd.Reaction(specs[173], specs[162] + specs[117], ks[275])
reaction177 = rxd.Reaction(specs[160] + specs[216], specs[174], ks[276], ks[277])
reaction178 = rxd.Reaction(specs[174], specs[162] + specs[216], ks[278])
reaction179 = rxd.Reaction(specs[160] + specs[217], specs[175], ks[279], ks[280])
reaction180 = rxd.Reaction(specs[175], specs[162] + specs[217], ks[281])
reaction181 = rxd.Reaction(specs[160] + specs[218], specs[176], ks[282], ks[283])
reaction182 = rxd.Reaction(specs[176], specs[162] + specs[218], ks[284])
reaction183 = rxd.Reaction(specs[160] + specs[219], specs[177], ks[285], ks[286])
reaction184 = rxd.Reaction(specs[177], specs[162] + specs[219], ks[287])
reaction185 = rxd.Reaction(specs[161] + specs[125], specs[178], ks[288], ks[289])
reaction186 = rxd.Reaction(specs[178], specs[162] + specs[125], ks[290])
reaction187 = rxd.Reaction(specs[160] + specs[129], specs[179], ks[291], ks[292])
reaction188 = rxd.Reaction(specs[179], specs[159] + specs[129], ks[293])
reaction189 = rxd.Reaction(specs[162] + specs[129], specs[180], ks[294], ks[295])
reaction190 = rxd.Reaction(specs[180], specs[160] + specs[129], ks[296])
reaction191 = rxd.Reaction(specs[180], specs[161] + specs[129], ks[297])
reaction192 = rxd.Reaction(specs[161] + specs[129], specs[181], ks[298], ks[299])
reaction193 = rxd.Reaction(specs[181], specs[159] + specs[129], ks[300])
reaction194 = rxd.Reaction(specs[160] + specs[113], specs[182], ks[301], ks[302])
reaction195 = rxd.Reaction(specs[182], specs[159] + specs[113], ks[303])
reaction196 = rxd.Reaction(specs[162] + specs[113], specs[183], ks[304], ks[305])
reaction197 = rxd.Reaction(specs[183], specs[161] + specs[113], ks[306])
reaction198 = rxd.Reaction(specs[159], specs[134], ks[307])
reaction199 = rxd.Reaction(specs[163], specs[138], ks[308])
reaction200 = rxd.Reaction(specs[164], specs[139], ks[309])
reaction201 = rxd.Reaction(specs[165], specs[140], ks[310])
reaction202 = rxd.Reaction(specs[166], specs[141], ks[311])
reaction203 = rxd.Reaction(specs[167], specs[142], ks[312])
reaction204 = rxd.Reaction(specs[168], specs[143], ks[313])
reaction205 = rxd.Reaction(specs[169], specs[144], ks[314])
reaction206 = rxd.Reaction(specs[170], specs[145], ks[315])
reaction207 = rxd.Reaction(specs[161], specs[136], ks[316])
reaction208 = rxd.Reaction(specs[178], specs[153], ks[317])
reaction209 = rxd.Reaction(specs[181], specs[156], ks[318])
reaction210 = rxd.Reaction(specs[135], specs[160], ks[319], ks[320])
reaction211 = rxd.Reaction(specs[146], specs[171], ks[321], ks[322])
reaction212 = rxd.Reaction(specs[147], specs[172], ks[323], ks[324])
reaction213 = rxd.Reaction(specs[148], specs[173], ks[325], ks[326])
reaction214 = rxd.Reaction(specs[149], specs[174], ks[327], ks[328])
reaction215 = rxd.Reaction(specs[150], specs[175], ks[329], ks[330])
reaction216 = rxd.Reaction(specs[151], specs[176], ks[331], ks[332])
reaction217 = rxd.Reaction(specs[152], specs[177], ks[333], ks[334])
reaction218 = rxd.Reaction(specs[137], specs[162], ks[335], ks[336])
reaction219 = rxd.Reaction(specs[154], specs[179], ks[337], ks[338])
reaction220 = rxd.Reaction(specs[155], specs[180], ks[339], ks[340])
reaction221 = rxd.Reaction(specs[157], specs[182], ks[341], ks[342])
reaction222 = rxd.Reaction(specs[158], specs[183], ks[343], ks[344])
reaction223 = rxd.Reaction(specs[64] + specs[108], specs[65], ks[345], ks[346])
reaction224 = rxd.Reaction(specs[65] + specs[58], specs[66], ks[347], ks[348])
reaction225 = rxd.Reaction(specs[66], specs[65] + specs[71], ks[349])
reaction226 = rxd.Reaction(specs[64] + specs[125], specs[67], ks[350], ks[351])
reaction227 = rxd.Reaction(specs[67], specs[68] + specs[125], ks[352])
reaction228 = rxd.Reaction(specs[68] + specs[108], specs[69], ks[353], ks[354])
reaction229 = rxd.Reaction(specs[69] + specs[58], specs[70], ks[355], ks[356])
reaction230 = rxd.Reaction(specs[70], specs[69] + specs[71], ks[357])
reaction231 = rxd.Reaction(specs[68], specs[64], ks[358])
reaction232 = rxd.Reaction(specs[71], specs[57], ks[359])
reaction233 = rxd.Reaction(specs[184] + specs[58], specs[185], ks[360], ks[361])
reaction234 = rxd.Reaction(specs[185], specs[184] + specs[71], ks[362])
reaction235 = rxd.Reaction(specs[125] + specs[184], specs[186], ks[363], ks[364])
reaction236 = rxd.Reaction(specs[186], specs[187] + specs[125], ks[365])
reaction237 = rxd.Reaction(specs[187], specs[184], ks[366])
reaction238 = rxd.Reaction(specs[187] + specs[58], specs[188], ks[367], ks[368])
reaction239 = rxd.Reaction(specs[188], specs[187] + specs[71], ks[369])
reaction240 = rxd.Reaction(specs[185] + specs[125], specs[189], ks[370], ks[371])
reaction241 = rxd.Reaction(specs[189], specs[188] + specs[125], ks[372])
reaction242 = rxd.Reaction(specs[123], specs[124] + specs[125]*2, ks[373]*specs[123], ks[374]*specs[124]*specs[125], custom_dynamics=True)
reaction243 = rxd.Reaction(specs[0] + specs[190], specs[191], ks[375], ks[376])
reaction244 = rxd.Reaction(specs[192], specs[197], ks[377])
reaction245 = rxd.Reaction(specs[0] + specs[201], specs[202], ks[378], ks[379])
reaction246 = rxd.Reaction(specs[199] + specs[201], specs[204], ks[380], ks[381])
reaction247 = rxd.Reaction(specs[0] + specs[204], specs[203], ks[382], ks[383])
reaction248 = rxd.Reaction(specs[199] + specs[202], specs[203], ks[384], ks[385])
reaction249 = rxd.Reaction(specs[202] + specs[205], specs[206], ks[386], ks[387])
reaction250 = rxd.Reaction(specs[206], specs[209] + specs[208], ks[388])
reaction251 = rxd.Reaction(specs[209], specs[202] + specs[220], ks[389])
reaction252 = rxd.Reaction(specs[203] + specs[205], specs[207], ks[390], ks[391])
reaction253 = rxd.Reaction(specs[207], specs[210] + specs[208], ks[392])
reaction254 = rxd.Reaction(specs[210], specs[203] + specs[220], ks[393])
reaction255 = rxd.Reaction(specs[229] + specs[211], specs[212], ks[394], ks[395])
reaction256 = rxd.Reaction(specs[212], specs[211] + specs[205], ks[396])
reaction257 = rxd.Reaction(specs[204], specs[201] + specs[199], ks[397])
reaction258 = rxd.Reaction(specs[203], specs[202] + specs[199], ks[398])
reaction259 = rxd.Reaction(specs[199], specs[200], ks[399])
reaction260 = rxd.Reaction(specs[200], specs[198], ks[400])
reaction261 = rxd.Reaction(specs[0] + specs[224], specs[225], ks[401], ks[402])
reaction262 = rxd.Reaction(specs[220] + specs[225], specs[226], ks[403], ks[404])
reaction263 = rxd.Reaction(specs[226], specs[225] + specs[227], ks[405])
reaction264 = rxd.Reaction(specs[208], specs[229], ks[406])
reaction265 = rxd.Reaction(specs[227], specs[228], ks[407])
reaction266 = rxd.Reaction(specs[220] + specs[221], specs[222], ks[408], ks[409])
reaction267 = rxd.Reaction(specs[222], specs[223] + specs[221], ks[410])
reaction268 = rxd.Reaction(specs[0] + specs[213], specs[214], ks[411], ks[412])
reaction269 = rxd.Reaction(specs[214] + specs[255], specs[215], ks[413], ks[414])
reaction270 = rxd.Reaction(specs[214], specs[216], ks[415], ks[416])
reaction271 = rxd.Reaction(specs[215], specs[217], ks[417], ks[418])
reaction272 = rxd.Reaction(specs[216] + specs[220], specs[218], ks[419], ks[420])
reaction273 = rxd.Reaction(specs[217] + specs[220], specs[219], ks[421], ks[422])
reaction274 = rxd.Reaction(specs[218] + specs[255], specs[219], ks[423], ks[424])
reaction275 = rxd.Reaction(specs[216] + specs[255], specs[217], ks[425], ks[426])
reaction276 = rxd.Reaction(specs[192] + specs[193], specs[194], ks[427], ks[428])
reaction277 = rxd.Reaction(specs[194], specs[195], ks[429], ks[430])
reaction278 = rxd.Reaction(specs[198] + specs[194], specs[196], ks[431], ks[432])
reaction279 = rxd.Reaction(specs[196], specs[199] + specs[194], ks[433])
reaction280 = rxd.Reaction(specs[230] + specs[216], specs[231], ks[434], ks[435])
reaction281 = rxd.Reaction(specs[231], specs[235] + specs[216], ks[436])
reaction282 = rxd.Reaction(specs[230] + specs[217], specs[232], ks[437], ks[438])
reaction283 = rxd.Reaction(specs[232], specs[235] + specs[217], ks[439])
reaction284 = rxd.Reaction(specs[230] + specs[218], specs[233], ks[440], ks[441])
reaction285 = rxd.Reaction(specs[233], specs[235] + specs[218], ks[442])
reaction286 = rxd.Reaction(specs[230] + specs[219], specs[234], ks[443], ks[444])
reaction287 = rxd.Reaction(specs[234], specs[235] + specs[219], ks[445])
reaction288 = rxd.Reaction(specs[235] + specs[244], specs[236], ks[446], ks[447])
reaction289 = rxd.Reaction(specs[236], specs[230] + specs[244], ks[448])
reaction290 = rxd.Reaction(specs[237] + specs[216], specs[238], ks[449], ks[450])
reaction291 = rxd.Reaction(specs[238], specs[242] + specs[216], ks[451])
reaction292 = rxd.Reaction(specs[237] + specs[217], specs[239], ks[452], ks[453])
reaction293 = rxd.Reaction(specs[239], specs[242] + specs[217], ks[454])
reaction294 = rxd.Reaction(specs[237] + specs[218], specs[240], ks[455], ks[456])
reaction295 = rxd.Reaction(specs[240], specs[242] + specs[218], ks[457])
reaction296 = rxd.Reaction(specs[237] + specs[219], specs[241], ks[458], ks[459])
reaction297 = rxd.Reaction(specs[241], specs[242] + specs[219], ks[460])
reaction298 = rxd.Reaction(specs[242] + specs[244], specs[243], ks[461], ks[462])
reaction299 = rxd.Reaction(specs[243], specs[237] + specs[244], ks[463])
reaction300 = rxd.Reaction(specs[230], specs[237], ks[464], ks[465])
reaction301 = rxd.Reaction(specs[231], specs[238], ks[466], ks[467])
reaction302 = rxd.Reaction(specs[232], specs[239], ks[468], ks[469])
reaction303 = rxd.Reaction(specs[233], specs[240], ks[470], ks[471])
reaction304 = rxd.Reaction(specs[234], specs[241], ks[472], ks[473])
reaction305 = rxd.Reaction(specs[235], specs[242], ks[474], ks[475])
reaction306 = rxd.Reaction(specs[236], specs[243], ks[476], ks[477])
reaction307 = rxd.Reaction(specs[245] + specs[246], specs[247], ks[478], ks[479])
reaction308 = rxd.Reaction(specs[198] + specs[247], specs[249], ks[480], ks[481])
reaction309 = rxd.Reaction(specs[198] + specs[246], specs[248], ks[482], ks[483])
reaction310 = rxd.Reaction(specs[245] + specs[248], specs[249], ks[484], ks[485])
reaction311 = rxd.Reaction(specs[249], specs[199] + specs[247], ks[486])
reaction312 = rxd.Reaction(specs[245], specs[245]*0, ks[487])
reaction313 = rxd.Reaction(specs[0] + specs[250], specs[251], ks[488], ks[489])
reaction314 = rxd.Reaction(specs[0] + specs[251], specs[252], ks[490], ks[491])
reaction315 = rxd.Reaction(specs[252], specs[253], ks[492], ks[493])
reaction316 = rxd.Reaction(specs[253] + specs[205], specs[254], ks[494], ks[495])
reaction317 = rxd.Reaction(specs[254], specs[253] + specs[255], ks[496])
reaction318 = rxd.Reaction(specs[255], specs[205], ks[497])
reaction319 = rxd.Reaction(specs[72] + specs[216], specs[76], ks[498], ks[499])
reaction320 = rxd.Reaction(specs[76], specs[74] + specs[216], ks[500])
reaction321 = rxd.Reaction(specs[73] + specs[216], specs[77], ks[501], ks[502])
reaction322 = rxd.Reaction(specs[84] + specs[216], specs[86], ks[503], ks[504])
reaction323 = rxd.Reaction(specs[90] + specs[216], specs[92], ks[505], ks[506])
reaction324 = rxd.Reaction(specs[96] + specs[216], specs[98], ks[507], ks[508])
reaction325 = rxd.Reaction(specs[77], specs[75] + specs[216], ks[509])
reaction326 = rxd.Reaction(specs[86], specs[85] + specs[216], ks[510])
reaction327 = rxd.Reaction(specs[92], specs[91] + specs[216], ks[511])
reaction328 = rxd.Reaction(specs[98], specs[97] + specs[216], ks[512])
reaction329 = rxd.Reaction(specs[72] + specs[217], specs[78], ks[513], ks[514])
reaction330 = rxd.Reaction(specs[78], specs[74] + specs[217], ks[515])
reaction331 = rxd.Reaction(specs[73] + specs[217], specs[79], ks[516], ks[517])
reaction332 = rxd.Reaction(specs[84] + specs[217], specs[87], ks[518], ks[519])
reaction333 = rxd.Reaction(specs[90] + specs[217], specs[93], ks[520], ks[521])
reaction334 = rxd.Reaction(specs[96] + specs[217], specs[99], ks[522], ks[523])
reaction335 = rxd.Reaction(specs[79], specs[75] + specs[217], ks[524])
reaction336 = rxd.Reaction(specs[87], specs[85] + specs[217], ks[525])
reaction337 = rxd.Reaction(specs[93], specs[91] + specs[217], ks[526])
reaction338 = rxd.Reaction(specs[99], specs[97] + specs[217], ks[527])
reaction339 = rxd.Reaction(specs[72] + specs[218], specs[80], ks[528], ks[529])
reaction340 = rxd.Reaction(specs[80], specs[74] + specs[218], ks[530])
reaction341 = rxd.Reaction(specs[73] + specs[218], specs[81], ks[531], ks[532])
reaction342 = rxd.Reaction(specs[84] + specs[218], specs[88], ks[533], ks[534])
reaction343 = rxd.Reaction(specs[90] + specs[218], specs[94], ks[535], ks[536])
reaction344 = rxd.Reaction(specs[96] + specs[218], specs[100], ks[537], ks[538])
reaction345 = rxd.Reaction(specs[81], specs[75] + specs[218], ks[539])
reaction346 = rxd.Reaction(specs[88], specs[85] + specs[218], ks[540])
reaction347 = rxd.Reaction(specs[94], specs[91] + specs[218], ks[541])
reaction348 = rxd.Reaction(specs[100], specs[97] + specs[218], ks[542])
reaction349 = rxd.Reaction(specs[72] + specs[219], specs[82], ks[543], ks[544])
reaction350 = rxd.Reaction(specs[82], specs[74] + specs[219], ks[545])
reaction351 = rxd.Reaction(specs[73] + specs[219], specs[83], ks[546], ks[547])
reaction352 = rxd.Reaction(specs[84] + specs[219], specs[89], ks[548], ks[549])
reaction353 = rxd.Reaction(specs[90] + specs[219], specs[95], ks[550], ks[551])
reaction354 = rxd.Reaction(specs[96] + specs[219], specs[101], ks[552], ks[553])
reaction355 = rxd.Reaction(specs[83], specs[75] + specs[219], ks[554])
reaction356 = rxd.Reaction(specs[89], specs[85] + specs[219], ks[555])
reaction357 = rxd.Reaction(specs[95], specs[91] + specs[219], ks[556])
reaction358 = rxd.Reaction(specs[101], specs[97] + specs[219], ks[557])
reaction359 = rxd.Reaction(specs[74] + specs[129], specs[102], ks[558], ks[559])
reaction360 = rxd.Reaction(specs[102], specs[72] + specs[129], ks[560])
reaction361 = rxd.Reaction(specs[74] + specs[244], specs[103], ks[561], ks[562])
reaction362 = rxd.Reaction(specs[103], specs[72] + specs[244], ks[563])
reaction363 = rxd.Reaction(specs[74] + specs[113], specs[104], ks[564], ks[565])
reaction364 = rxd.Reaction(specs[104], specs[72] + specs[113], ks[566])
reaction365 = rxd.Reaction(specs[134], specs[135], ks[567])
reaction366 = rxd.Reaction(specs[136], specs[137], ks[568])
reaction367 = rxd.Reaction(specs[159], specs[160], ks[569])
reaction368 = rxd.Reaction(specs[161], specs[162], ks[570])
reaction369 = rxd.Reaction(specs[134], specs[136], ks[571])
reaction370 = rxd.Reaction(specs[135], specs[137], ks[572])
reaction371 = rxd.Reaction(specs[159], specs[161], ks[573])
reaction372 = rxd.Reaction(specs[160], specs[162], ks[574])
reaction373 = rxd.Reaction(specs[230], specs[235], ks[575])
reaction374 = rxd.Reaction(specs[237], specs[242], ks[576])

reaction_Ca_flux = rxd.Rate(specs[0], Ca_flux_rate) # Ca
reaction_L_flux = rxd.Rate(specs[13], L_flux_rate) # L
reaction_Glu_flux = rxd.Rate(specs[192], Glu_flux_rate) # Glu
reaction_ACh_flux = rxd.Rate(specs[245], ACh_flux_rate) # ACh
vec_t = h.Vector()

vecs = []
vec_t = h.Vector()
vec_t.record(h._ref_t)
for ispec in range(0,len(species)):
  vecs.append(h.Vector())
  vecs[ispec].record(specs[ispec].nodes(dend)(0.5)[0]._ref_concentration)

cvode = h.CVode()
cvode.active(1)
hmax = cvode.maxstep(1000)
hmin = cvode.minstep(1e-10)
cvode.atol(tolerance)

h.finitialize(-65)
def set_param(param, val):
    param.nodes.value = val
    h.cvode.re_init()

### Set on and off the inputs to the spine
T = 1000./Ca_input_freq
tnow = 0
for itrain in range(0,Ntrains):
    for istim in range(0,Ca_input_N):
      tnew = Ca_input_onset + istim*T + trainT*itrain
      h.cvode.event(tnew, lambda: set_param(Ca_flux_rate, Ca_input_flux/6.022e23/my_volume*1e3))
      h.cvode.event(tnew+Ca_input_dur, lambda: set_param(Ca_flux_rate, 0))
      h.cvode.event(tnew, lambda: set_param(L_flux_rate, L_input_flux/6.022e23/my_volume*1e3))
      h.cvode.event(tnew+Ca_input_dur, lambda: set_param(L_flux_rate, 0))
      h.cvode.event(tnew, lambda: set_param(Glu_flux_rate, Glu_input_flux/6.022e23/my_volume*1e3))
      h.cvode.event(tnew+Ca_input_dur, lambda: set_param(Glu_flux_rate, 0))
      h.cvode.event(tnew, lambda: set_param(ACh_flux_rate, ACh_input_flux/6.022e23/my_volume*1e3))
      h.cvode.event(tnew+Ca_input_dur, lambda: set_param(ACh_flux_rate, 0))
      tnow = tnew
timenow = time.time()
h.continuerun(Duration)
print("Simulation done in "+str(time.time()-timenow)+" seconds")
def isFlux(t):
  for itrain in range(0,Ntrains):
    for istim in range(0,Ca_input_N):
      tnew = Ca_input_onset + istim*T + trainT*itrain
      if t >= tnew and t < tnew+Ca_input_dur:
        return 1
  return 0
tvec = array(vec_t)
minDT_nonFlux = 20.0
minDT_Flux = 1.0
lastt = -inf
itvec2 = []
for it in range(0,len(tvec)):
  if tvec[it] - lastt > minDT_nonFlux or (isFlux(tvec[it]) and tvec[it] - lastt > minDT_Flux):
    itvec2.append(it)
    lastt = tvec[it]

headers = [ 'tvec', 'Ca', 'CaOut', 'CaOutLeak', 'Leak', 'Calbin', 'CalbinC', 'LOut', 'Epac1', 'Epac1cAMP', 'PMCA', 'NCX', 'PMCACa', 'NCXCa', 'L', 'R', 'Gs', 'Gi', 'LR', 'LRGs', 'PKAcLR', 'PKAcpLR', 'PKAcppLR', 'PKAcpppLR', 'pLR', 'ppLR', 'pppLR', 'ppppLR', 'ppppLRGi', 'ppppLRGibg', 'PKAcR', 'PKAcpR', 'PKAcppR', 'PKAcpppR', 'pR', 'ppR', 'pppR', 'ppppR', 'ppppRGi', 'ppppRGibg', 'GsR', 'GsaGTP', 'GsaGDP', 'GiaGTP', 'GiaGDP', 'Gibg', 'Gsbg', 'LRGsbg', 'AC1', 'AC1GsaGTP', 'AC1GsaGTPCaMCa4', 'AC1GsaGTPCaMCa4ATP', 'AC1GiaGTP', 'AC1GiaGTPCaMCa4', 'AC1GiaGTPCaMCa4ATP', 'AC1GsaGTPGiaGTP', 'AC1GsaGTPGiaGTPCaMCa4', 'AC1GsGiCaMCa4ATP', 'ATP', 'cAMP', 'AC1CaMCa4', 'AC1CaMCa4ATP', 'AC8', 'AC8CaMCa4', 'AC8CaMCa4ATP', 'PDE1A', 'PDE1ACaMCa4', 'PDE1ACaMCa4cAMP', 'PDE1A_PKAc', 'PDE1Ap', 'PDE1ApCaMCa4', 'PDE1ApCaMCa4cAMP', 'AMP', 'Ng', 'NgCaM', 'Ngp', 'NgpCaM', 'NgPKCtCa', 'NgCaMPKCtCa', 'NgPKCtAACa', 'NgCaMPKCtAACa', 'NgPKCtDAGCa', 'NgCaMPKCtDAGCa', 'NgPKCtAADAGCa', 'NgCaMPKCtAADAGCa', 'NgCaMCa2', 'NgpCaMCa2', 'NgCaMCa2PKCtCa', 'NgCaMCa2PKCtAACa', 'NgCaMCa2PKCtDAGCa', 'NgCaMCa2PKCtAADAGCa', 'NgCaMCa3', 'NgpCaMCa3', 'NgCaMCa3PKCtCa', 'NgCaMCa3PKCtAACa', 'NgCaMCa3PKCtDAGCa', 'NgCaMCa3PKCtAADAGCa', 'NgCaMCa4', 'NgpCaMCa4', 'NgCaMCa4PKCtCa', 'NgCaMCa4PKCtAACa', 'NgCaMCa4PKCtDAGCa', 'NgCaMCa4PKCtAADAGCa', 'NgpPP1', 'NgpPP2A', 'NgpPP2BCaMCa4', 'CaM', 'CaMCa2', 'CaMCa3', 'CaMCa4', 'PP2B', 'PP2BCaM', 'PP2BCaMCa2', 'PP2BCaMCa3', 'PP2BCaMCa4', 'CK', 'CKCaMCa4', 'CKpCaMCa4', 'CKp', 'Complex', 'pComplex', 'CKpPP1', 'CKpCaMCa4PP1', 'PKA', 'PKAcAMP4', 'PKAr', 'PKAc', 'I1', 'I1PKAc', 'Ip35', 'PP1', 'Ip35PP1', 'Ip35PP2BCaMCa4', 'Ip35PP1PP2BCaMCa4', 'PP1PP2BCaMCa4', 'GluR1', 'GluR1_S845', 'GluR1_S831', 'GluR1_S845_S831', 'GluR1_PKAc', 'GluR1_CKCam', 'GluR1_CKpCam', 'GluR1_CKp', 'GluR1_PKCtCa', 'GluR1_PKCtAACa', 'GluR1_PKCtDAGCa', 'GluR1_PKCtAADAGCa', 'GluR1_S845_CKCam', 'GluR1_S845_CKpCam', 'GluR1_S845_CKp', 'GluR1_S845_PKCtCa', 'GluR1_S845_PKCtAACa', 'GluR1_S845_PKCtDAGCa', 'GluR1_S845_PKCtAADAGCa', 'GluR1_S831_PKAc', 'GluR1_S845_PP1', 'GluR1_S845_S831_PP1', 'GluR1_S831_PP1', 'GluR1_S845_PP2B', 'GluR1_S845_S831_PP2B', 'GluR1_memb', 'GluR1_memb_S845', 'GluR1_memb_S831', 'GluR1_memb_S845_S831', 'GluR1_memb_PKAc', 'GluR1_memb_CKCam', 'GluR1_memb_CKpCam', 'GluR1_memb_CKp', 'GluR1_memb_PKCtCa', 'GluR1_memb_PKCtAACa', 'GluR1_memb_PKCtDAGCa', 'GluR1_memb_PKCtAADAGCa', 'GluR1_memb_S845_CKCam', 'GluR1_memb_S845_CKpCam', 'GluR1_memb_S845_CKp', 'GluR1_memb_S845_PKCtCa', 'GluR1_memb_S845_PKCtAACa', 'GluR1_memb_S845_PKCtDAGCa', 'GluR1_memb_S845_PKCtAADAGCa', 'GluR1_memb_S831_PKAc', 'GluR1_memb_S845_PP1', 'GluR1_memb_S845_S831_PP1', 'GluR1_memb_S831_PP1', 'GluR1_memb_S845_PP2B', 'GluR1_memb_S845_S831_PP2B', 'PDE4', 'PDE4cAMP', 'PKAcPDE4', 'PDE4p', 'PDE4pcAMP', 'PKAc_PDE4_cAMP', 'fixedbuffer', 'fixedbufferCa', 'Glu', 'MGluR', 'MGluR_Glu', 'MGluR_Glu_desens', 'MGluR_Gqabg_Glu', 'GluOut', 'Gqabg', 'GqaGTP', 'GqaGDP', 'PLC', 'PLCCa', 'PLCCaGqaGTP', 'PLCGqaGTP', 'Pip2', 'PLCCaPip2', 'PLCCaGqaGTPPip2', 'Ip3', 'PLCCaDAG', 'PLCCaGqaGTPDAG', 'PIkinase', 'Ip3degPIk', 'PKC', 'PKCCa', 'PKCAACa', 'PKCtCa', 'PKCtAACa', 'PKCtDAGCa', 'PKCtAADAGCa', 'DAG', 'DAGK', 'DAGKdag', 'PA', 'DGL', 'CaDGL', 'DAGCaDGL', '2AG', '2AGdegrad', 'Ip3degrad', 'GluR2', 'GluR2_PKCtCa', 'GluR2_PKCtAACa', 'GluR2_PKCtDAGCa', 'GluR2_PKCtAADAGCa', 'GluR2_S880', 'GluR2_S880_PP2A', 'GluR2_memb', 'GluR2_memb_PKCtCa', 'GluR2_memb_PKCtAACa', 'GluR2_memb_PKCtDAGCa', 'GluR2_memb_PKCtAADAGCa', 'GluR2_memb_S880', 'GluR2_memb_S880_PP2A', 'PP2A', 'ACh', 'M1R', 'AChM1R', 'M1RGq', 'AChM1RGq', 'PLA2', 'CaPLA2', 'Ca2PLA2', 'Ca2PLA2act', 'Ca2PLA2actPip2', 'AA' ]

myonset = Ca_input_onset
if myonset > max(tvec):
  myonset = 0
interptimes = [myonset + 10000*i for i in range(-1,int((max(tvec)-myonset)/10000))]
if interptimes[0] < 0:
  interptimes = interptimes[1:]
interpDATA = []
for j in range(0,len(species)):
  interpDATA.append(mytools.interpolate(tvec,vecs[j],interptimes))
tcDATA = array([interptimes]+interpDATA)
maxDATA = c_[tvec,array(vecs).T].max(axis=0)
scipy.io.savemat(filename+'.mat', {'DATA': tcDATA, 'maxDATA': maxDATA, 'headers': headers, 'args': sys.argv})
