/*________________________________________________________________*/
/* BEGIN FILE */
/*----------------------------------------------------------------
%W%  %G%
/usr/local/src/cable/anatomy/ca3cell.txt  translated Tue Jun 30  
13:42:37 1992 by ntscable 2.0
source file syntax: Eutectic
output file syntax: CABLE
soma: diameter = 23.4229 um  length = 46.1079 um  area = 3392.86 um2
      28 three-D points; 30 outline points numbered 1425-1454
      outline diameter = 30.1063 um
10 primary neurites
110 branches totaling 17491.9 um in length, 21723.9 um2 in area
1424 tree points translated to 211 segments (1 requested)
Neurites divided into segments of equal dx between adjacent digitized
branch points.
Segment length constrained to be < 17491.9 um.
The file on this disk is an ASCII dump of a Eutectic datafile of a
rat CA3 cell. The neuron is pictured in Figure 1 of Ishizuka, Weber
and Amaral, J. Comp. Neurol. 1990.

No. points   1454
No. trees      11
Text  File sent from PDP-11                                                                                                   

 

----------------------------------------------------------------*/

					/* create sections */
create    soma,\
          dend1[3],\
          dend2[15],\
          dend3[97],\
          dend4[17],\
          dend5[7],\
          dend6[27],\
          dend7[17],\
          dend8[19],\
          dend9[5],\
          dend10[3]



/*----------------------------------------------------------------*/
proc geometry() { local i, j

						/* soma geometry */
    soma {
        nseg = 1
        pt3dclear()
        for j = 1, fscan() {
            pt3dadd(fscan(),fscan(),fscan(),fscan())
        }
    }

					/* connect primary neurites  
*/
    soma connect dend1[0] (0), 0.5
    soma connect dend2[0] (0), 0.5
    soma connect dend3[0] (0), 0.5
    soma connect dend4[0] (0), 0.5
    soma connect dend5[0] (0), 0.5
    soma connect dend6[0] (0), 0.5
    soma connect dend7[0] (0), 0.5
    soma connect dend8[0] (0), 0.5
    soma connect dend9[0] (0), 0.5
    soma connect dend10[0] (0), 0.5


					/* neurite geometry*/
    for i = 0,2 {
        dend1[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,14 {
        dend2[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,96 {
        dend3[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,16 {
        dend4[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,6 {
        dend5[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,26 {
        dend6[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,16 {
        dend7[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,18 {
        dend8[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,4 {
        dend9[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,2 {
        dend10[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }



					/* branching topology*/
    for i = 1,2 {
        dend1[fscan()] connect dend1[i] (0), fscan()
    }

    for i = 1,14 {
        dend2[fscan()] connect dend2[i] (0), fscan()
    }

    for i = 1,96 {
        dend3[fscan()] connect dend3[i] (0), fscan()
    }

    for i = 1,16 {
        dend4[fscan()] connect dend4[i] (0), fscan()
    }

    for i = 1,6 {
        dend5[fscan()] connect dend5[i] (0), fscan()
    }

    for i = 1,26 {
        dend6[fscan()] connect dend6[i] (0), fscan()
    }

    for i = 1,16 {
        dend7[fscan()] connect dend7[i] (0), fscan()
    }

    for i = 1,18 {
        dend8[fscan()] connect dend8[i] (0), fscan()
    }

    for i = 1,4 {
        dend9[fscan()] connect dend9[i] (0), fscan()
    }

    for i = 1,2 {
        dend10[fscan()] connect dend10[i] (0), fscan()
    }

}

geometry()


SOMA COORDINATES AND DIAMETERS:

    28
     -12       -6        2     1e-6
     -11       -5        2        8
     -10       -3        2       16
    -9.5       -3        2       18
      -9       -4        2       22
      -9       -5     1.75   24.005
      -7  -3.3333     1.75   28.671
    -5.5  -1.8333     1.75    32.67
    -5.5 -0.083333     1.75    36.17
      -5   1.5833     1.75   39.836
      -3     1.25     1.75   40.503
      -3     1.75        1   39.551
      -2     2.25        1   38.552
       0     4.25        1   38.552
     1.5     4.25        1   35.556
       3   3.9688        1   33.123
       3   3.4688        1   32.125
       4   2.2812        1   28.508
     5.5     2.15        1   26.376
     6.5   2.5833        1   23.917
     8.5     4.25        1   20.597
      10   6.1786   1.1071   16.738
      12     9.35     1.25   12.788
    12.5   9.8056   1.3056   12.466
    15.5   11.639   1.6389   8.7521
    16.5    11.75     1.75   6.5192
      17   11.792   1.7917   5.4327
    19.5       12        2   1e-6


NEURITE COORDINATES AND DIAMETERS:

    1 16
       4    -11.5     -3.5      1.8
       5    -16.5       -7      1.8
     4.5      -24     -9.5      1.6
       3      -28      -11      1.2
     0.5      -36    -12.5        1
      -2      -50      -13      0.8
      -3      -66    -15.5      0.8
    -3.5    -82.5    -19.5      0.5
    -5.5    -96.5    -24.5      0.5
    -6.5   -106.5      -28      0.5
      -7     -120    -30.5      0.5
    -8.5   -132.5    -33.5      0.3
      -8     -147      -36      0.3
    -6.5     -159    -38.5      0.3
    -5.5   -173.5    -42.5      0.3
      -8   -182.5    -45.5      0.3

    1 9
      -8   -182.5    -45.5      0.3
     -12   -193.5    -47.5      0.3
   -17.5     -211      -51      0.3
   -22.5     -229    -52.5      0.3
   -24.5     -234    -53.5      0.3
   -23.5     -245    -54.5      0.3
     -28     -254    -57.5      0.3
   -31.5   -263.5      -58      0.3
     -42     -279    -60.5      0.3

    1 6
      -8   -182.5    -45.5      0.3
    -6.5   -186.5    -48.5      0.3
    -3.5   -191.5    -52.5      0.3
    -3.5   -200.5      -56      0.3
      -3   -209.5      -57      0.3
    -2.5     -220      -59      0.3

    1 4
    -8.5    -13.5      2.5      2.9
   -13.5      -22        2      2.9
   -18.5      -32        6      1.8
     -23      -39       11      1.8

    1 8
     -23      -39       11      1.8
   -23.5    -44.5     11.5      0.8
   -26.5      -55     12.5      0.8
   -32.5      -72     13.5      0.6
   -35.5    -90.5     14.5      0.6
   -40.5     -107       15      0.4
     -44     -114       15      0.4
   -44.5     -119       16      0.4

    1 3
   -44.5     -119       16      0.4
     -45     -128       20      0.3
     -45   -134.5       21      0.3

    1 3
     -45   -134.5       21      0.3
   -48.5   -140.5     22.5      0.3
   -49.5     -144     24.5      0.3

    1 7
   -49.5     -144     24.5      0.3
     -42     -155     25.5      0.3
     -26   -175.5       26      0.3
     -18   -187.5       28      0.3
   -16.5   -193.5     28.5      0.3
     -18   -200.5     28.5      0.3
   -15.5   -205.5     28.5      0.3

    1 8
   -49.5     -144     24.5      0.3
   -54.5   -149.5       25      0.3
   -63.5     -159       28      0.3
     -70   -167.5       31      0.3
     -78     -174     32.5      0.3
   -80.5   -177.5       35      0.3
     -83   -182.5     37.5      0.3
   -83.5     -186     38.5      0.3

    1 7
     -45   -134.5       21      0.3
     -40   -141.5       22      0.3
     -33   -150.5     23.5      0.3
   -25.5   -161.5       23      0.3
     -22     -166     21.5      0.3
     -23     -174     22.5      0.3
     -26   -176.5     22.5      0.3

    1 3
   -44.5     -119       16      0.4
   -51.5   -134.5       16      0.3
   -53.5     -143       18      0.3

    1 9
   -53.5     -143       18      0.3
     -52   -154.5     16.5      0.3
     -54   -167.5       18      0.3
   -55.5     -183       18      0.3
   -54.5   -195.5       19      0.3
     -51     -216     22.5      0.3
   -49.5     -227     25.5      0.3
     -46   -244.5     27.5      0.3
   -43.5     -257     27.5      0.3

    1 7
   -53.5     -143       18      0.3
   -56.5     -148     18.5      0.3
     -61     -156     20.5      0.3
   -70.5     -172     19.5      0.3
   -85.5   -187.5       19      0.3
   -94.5     -200     20.5      0.3
   -98.5     -207       20      0.3

    1 11
     -23      -39       11      1.8
     -27    -46.5     14.5      0.6
     -28    -57.5     21.5      0.4
     -30      -64     26.5      0.4
   -29.5    -73.5     30.5      0.4
     -32      -82       33      0.4
     -36    -91.5     37.5      0.4
   -36.5    -99.5     40.5      0.4
     -42     -109     43.5      0.4
     -40     -120       49      0.4
     -41     -126     50.5      0.4

    1 2
     -41     -126     50.5      0.4
   -39.5     -129     50.5      0.3

    1 7
   -39.5     -129     50.5      0.3
   -38.5   -140.5       52      0.3
   -41.5     -154       53      0.3
     -41     -170     54.5      0.3
     -42     -185     55.5      0.3
   -43.5   -191.5     56.5      0.3
   -47.5     -199       58      0.3

    1 12
   -39.5     -129     50.5      0.3
   -37.5     -129     52.5      0.3
   -41.5   -134.5     54.5      0.3
   -43.5   -140.5       59      0.3
   -47.5   -148.5       62      0.3
     -50   -155.5     65.5      0.3
   -53.5     -158     66.5      0.3
   -55.5     -166       69      0.3
     -56   -174.5     70.5      0.3
     -59     -181       72      0.3
     -63   -196.5     75.5      0.3
   -65.5     -211       77      0.3

    1 10
     -41     -126     50.5      0.4
     -46   -133.5     51.5      0.3
   -53.5     -144     53.5      0.3
     -59   -153.5     55.5      0.3
   -65.5     -164       59      0.3
   -71.5     -174     61.5      0.3
     -80   -182.5       64      0.3
   -87.5   -189.5     66.5      0.3
     -94   -194.5       69      0.3
     -97   -196.5       70      0.3

    1 5
      -6    -17.5       -2      5.9
      -8    -27.5     -3.5        5
     -12      -48       -1      3.2
   -17.5    -70.5       -1      2.9
     -21    -89.5        0      2.9

    1 2
     -21    -89.5        0      2.9
     -22     -101        0      3.5

    1 4
     -22     -101        0      3.5
     -20     -107      1.5        3
   -15.5     -113        1      2.2
   -12.5     -119        1      1.8

    1 5
   -12.5     -119        1      1.8
    -8.5     -127     -1.5      1.2
    -5.5     -136     -4.5      1.2
      -3   -142.5     -7.5      0.8
    -1.5   -146.5     -8.5      0.8

    1 7
    -1.5   -146.5     -8.5      0.8
       0   -156.5      -12      0.8
       3     -167      -16      0.6
       8   -178.5    -19.5      0.6
    10.5   -189.5      -23      0.6
      13   -199.5    -25.5      0.6
      17   -210.5    -28.5      0.6

    1 4
      17   -210.5    -28.5      0.6
    27.5   -226.5    -32.5      0.5
      35     -239    -33.5      0.5
    39.5     -251      -36      0.5

    1 8
    39.5     -251      -36      0.5
      43   -266.5    -38.5      0.5
    46.5   -293.5    -38.5      0.5
      51     -311    -41.5      0.5
    57.5   -328.5    -44.5      0.5
      61     -344    -41.5      0.5
      63   -358.5    -38.5      0.5
      63   -366.5      -38      0.5

    1 6
      63   -366.5      -38      0.5
      59   -376.5    -39.5      0.5
      55     -385      -42      0.3
    49.5   -402.5    -44.5      0.3
      43     -418      -49      0.3
      40   -426.5    -51.5      0.3

    1 13
      40   -426.5    -51.5      0.3
      41   -433.5    -51.5      0.3
      52     -453    -53.5      0.3
      57     -463      -57      0.3
    57.5   -468.5    -59.5      0.3
    52.5     -483      -63      0.3
    50.5     -492    -66.5      0.3
    54.5   -501.5    -69.5      0.3
    57.5   -508.5    -71.5      0.3
    57.5     -517    -73.5      0.3
    54.5     -534    -75.5      0.3
    54.5   -543.5    -77.5      0.3
    53.5   -550.5      -80      0.3

    1 5
    53.5   -550.5      -80      0.3
      52   -559.5    -82.5      0.3
    51.5   -565.5      -83      0.3
    50.5     -570      -83      0.3
    51.5   -574.5    -83.5      0.3

    1 8
    53.5   -550.5      -80      0.3
    48.5     -554    -81.5      0.3
    49.5   -557.5    -83.5      0.3
      46   -561.5      -84      0.3
      48     -567    -85.5      0.3
      52     -576    -88.5      0.3
    52.5     -582    -91.5      0.3
    52.5   -587.5      -93      0.3

    1 20
      40   -426.5    -51.5      0.3
    36.5   -437.5    -51.5      0.3
      34   -449.5    -55.5      0.3
      32   -463.5    -59.5      0.3
      31   -471.5      -60      0.3
    27.5   -477.5    -61.5      0.3
    20.5     -484      -64      0.3
      14   -489.5      -67      0.3
       8   -498.5      -70      0.3
    -0.5   -510.5      -72      0.3
     -12   -522.5      -74      0.3
   -19.5     -534    -75.5      0.3
   -31.5   -545.5      -78      0.3
   -37.5     -552    -79.5      0.3
   -43.5   -563.5    -82.5      0.3
   -49.5   -577.5      -86      0.3
   -52.5     -584      -88      0.3
   -54.5   -588.5    -89.5      0.3
   -56.5   -591.5      -91      0.3
     -57   -597.5      -92      0.3

    1 18
      63   -366.5      -38      0.5
    70.5     -377    -36.5      0.3
      85   -399.5    -37.5      0.3
    98.5     -413    -41.5      0.3
   110.5   -426.5    -45.5      0.3
   117.5   -438.5      -46      0.3
     120   -456.5    -46.5      0.3
   123.5   -465.5      -47      0.3
     138     -486    -50.5      0.3
     144   -493.5      -52      0.3
     149   -510.5    -54.5      0.3
   152.5   -521.5      -56      0.3
   155.5     -536    -58.5      0.3
   160.5   -550.5    -61.5      0.3
     163   -565.5    -63.5      0.3
   161.5     -576    -67.5      0.3
   162.5   -582.5      -69      0.3
   163.5   -588.5    -70.5      0.3

    1 5
    39.5     -251      -36      0.5
      57   -260.5    -37.5      0.3
      75   -266.5      -42      0.3
    93.5   -271.5      -45      0.3
   108.5   -277.5      -45      0.3

    1 13
      17   -210.5    -28.5      0.6
      16   -213.5    -33.5      0.3
    16.5     -218    -37.5      0.3
    17.5   -221.5    -39.5      0.3
      19   -226.5    -41.5      0.3
      19     -230      -45      0.3
      21     -235    -48.5      0.3
      25     -240      -53      0.3
    31.5     -246    -58.5      0.3
    32.5   -252.5    -62.5      0.3
    30.5   -260.5    -63.5      0.3
    31.5     -265      -65      0.3
      29     -270    -65.5      0.3

    1 2
    -1.5   -146.5     -8.5      0.8
     4.5   -152.5      -10      0.3

    1 7
     4.5   -152.5      -10      0.3
      16   -161.5       -8      0.3
      28   -173.5       -6      0.3
      35     -182       -5      0.3
    41.5   -197.5     -3.5      0.3
      47   -210.5     -2.5      0.3
      57   -223.5     -1.5      0.3

    1 2
      57   -223.5     -1.5      0.3
    61.5     -228     -2.5      0.3

    1 2
      57   -223.5     -1.5      0.3
      57     -229     -1.5      0.3

    1 2
     4.5   -152.5      -10      0.3
       8     -155    -10.5      0.3

    1 5
       8     -155    -10.5      0.3
    15.5     -153    -11.5      0.3
      39   -156.5    -17.5      0.3
    51.5     -159    -18.5      0.3
    57.5     -162      -18      0.3

    1 9
       8     -155    -10.5      0.3
    11.5   -163.5    -11.5      0.3
    19.5   -176.5      -16      0.3
      34     -186    -20.5      0.3
      50   -198.5      -25      0.3
    65.5     -214    -25.5      0.3
    68.5   -217.5      -26      0.3
      75   -231.5    -26.5      0.3
    82.5     -243    -27.5      0.3

    1 3
   -12.5     -119        1      1.8
    -6.5     -133      8.5      0.8
    -4.5   -142.5     10.5      0.8

    1 4
    -4.5   -142.5     10.5      0.8
    -1.5   -170.5       14      0.6
       2   -190.5       18      0.6
     4.5     -198     19.5      0.6

    1 3
     4.5     -198     19.5      0.6
    12.5     -216       23      0.6
    18.5   -228.5     26.5      0.6

    1 6
    18.5   -228.5     26.5      0.6
      23   -242.5       27      0.3
      29   -260.5     28.5      0.4
    35.5   -285.5     33.5      0.4
    37.5     -297     35.5      0.4
    38.5   -302.5       36      0.4

    1 18
    38.5   -302.5       36      0.4
      49   -320.5       36      0.4
    55.5     -335       36      0.4
      64   -359.5     34.5      0.4
    79.5   -385.5     32.5      0.4
     105   -416.5     27.5      0.4
     118     -435     26.5      0.4
   130.5   -448.5       30      0.4
     140     -475       29      0.4
   140.5     -489     29.5      0.4
   151.5     -522       29      0.3
     157   -535.5       29      0.3
   156.5     -544       30      0.3
     152   -563.5       28      0.3
     153     -579       28      0.3
   158.5     -591       29      0.3
     162     -604       32      0.3
   164.5   -609.5     32.5      0.3

    1 5
   164.5   -609.5     32.5      0.3
   163.5   -619.5     34.5      0.3
   162.5   -631.5       37      0.3
     164   -641.5     38.5      0.3
     168   -651.5       37      0.3

    1 3
   164.5   -609.5     32.5      0.3
     168   -611.5       33      0.3
     174     -614       35      0.3

    1 16
    38.5   -302.5       36      0.4
    39.5     -311       40      0.3
    44.5   -320.5       45      0.3
      51   -332.5       49      0.3
      56     -342       54      0.3
    58.5   -354.5       58      0.3
    64.5     -369       60      0.3
      64   -378.5       63      0.3
    61.5     -395       68      0.3
    60.5   -408.5     72.5      0.3
      58     -420     77.5      0.3
      55   -437.5       82      0.3
    54.5   -456.5       85      0.3
    59.5   -475.5       87      0.3
      66     -494     87.5      0.3
    68.5   -503.5       88      0.3

    1 10
    68.5   -503.5       88      0.3
    69.5     -523     82.5      0.3
      69   -545.5       80      0.3
      71     -567       78      0.3
      81   -590.5       74      0.3
      86   -611.5       70      0.3
    84.5   -623.5       70      0.3
      82   -634.5       66      0.3
      77     -646     61.5      0.3
      77     -654     58.5      0.3

    1 7
    68.5   -503.5       88      0.3
      70   -517.5     91.5      0.3
      69     -533     93.5      0.3
      64   -546.5       96      0.3
      55     -559     99.5      0.3
    52.5     -576      103      0.3
    51.5     -581      105      0.3

    1 5
    51.5     -581      105      0.3
    46.5     -594      107      0.3
      43     -610      109      0.3
    37.5   -624.5      112      0.3
      40   -634.5      111      0.3

    1 5
    51.5     -581      105      0.3
    54.5   -584.5      104      0.3
      56     -593    107.5      0.3
      58   -601.5    110.5      0.3
    64.5     -609      113      0.3

    1 10
    18.5   -228.5     26.5      0.6
      21     -234       30      0.3
    27.5   -243.5       35      0.3
    36.5   -253.5       41      0.3
      44     -264       48      0.3
    50.5     -272       55      0.3
      54     -278     60.5      0.3
      57     -283     64.5      0.3
    58.5     -289       67      0.3
      55   -295.5       70      0.3

    1 8
     4.5     -198     19.5      0.6
      -1     -206     20.5      0.3
      -3   -217.5       22      0.3
     -11     -228       23      0.3
   -23.5     -243       27      0.3
     -34   -253.5       31      0.3
     -42     -263     33.5      0.3
   -49.5   -266.5     34.5      0.3

    1 9
    -4.5   -142.5     10.5      0.8
       2     -147       12      0.3
      19     -156       16      0.3
    40.5     -166       21      0.3
    60.5   -176.5     25.5      0.3
      78     -185     29.5      0.3
   101.5   -190.5       35      0.3
     115   -193.5     37.5      0.3
     127     -199     38.5      0.3

    1 3
     -22     -101        0      3.5
   -25.5   -109.5     -0.5        2
   -27.5   -112.5     -1.5      1.7

    1 3
   -27.5   -112.5     -1.5      1.7
   -31.5     -122       -1      1.2
     -32   -127.5        1      1.2

    1 3
     -32   -127.5        1      1.2
   -33.5   -140.5      1.5        1
     -35     -149        3        1

    1 4
     -35     -149        3        1
     -36   -161.5        2      0.6
   -37.5     -182      3.5      0.6
   -38.5     -196        4      0.6

    1 5
   -38.5     -196        4      0.6
     -32   -209.5      3.5      0.6
   -30.5   -218.5      5.5      0.6
   -30.5   -229.5      5.5      0.6
     -35     -241        6      0.6

    1 4
     -35     -241        6      0.6
   -46.5   -261.5      3.5      0.6
   -52.5   -281.5      0.5      0.5
     -54   -291.5     -0.5      0.5

    1 3
     -54   -291.5     -0.5      0.5
   -49.5   -312.5     -4.5      0.5
     -48     -328     -5.5      0.5

    1 18
     -48     -328     -5.5      0.5
   -45.5     -348     -9.5      0.3
     -44     -361    -12.5      0.3
   -41.5   -375.5    -15.5      0.3
     -47   -393.5    -21.5      0.3
   -49.5     -410      -25      0.3
   -46.5   -424.5    -28.5      0.3
   -38.5     -455      -30      0.3
     -36   -465.5    -30.5      0.3
     -27   -486.5    -31.5      0.3
     -25   -512.5      -31      0.3
     -26   -532.5      -32      0.3
   -34.5     -572    -33.5      0.3
     -40   -588.5      -37      0.3
     -37   -607.5    -39.5      0.3
     -31   -634.5      -42      0.3
   -28.5   -641.5    -43.5      0.3
     -27     -653      -45      0.3

    1 4
     -27     -653      -45      0.3
   -14.5     -661    -46.5      0.3
      -4     -671      -50      0.3
       2     -679      -51      0.3

    1 4
     -27     -653      -45      0.3
   -27.5   -664.5      -45      0.3
     -20   -674.5    -46.5      0.3
     -14     -681      -47      0.3

    1 12
     -48     -328     -5.5      0.5
   -57.5     -340       -6      0.3
     -71   -362.5       -3      0.3
     -81     -377     -0.5      0.3
   -87.5   -386.5     -0.5      0.3
    -104   -401.5     -2.5      0.3
    -107   -411.5     -4.5      0.3
    -110   -427.5       -5      0.3
  -112.5     -458     -2.5      0.3
    -113   -486.5      0.5      0.3
  -109.5   -506.5      1.5      0.3
  -109.5   -517.5      2.5      0.3

    1 10
  -109.5   -517.5      2.5      0.3
    -108   -531.5      4.5      0.3
  -115.5     -548        9      0.3
  -119.5     -564     13.5      0.3
    -123   -578.5     17.5      0.3
  -122.5     -591     19.5      0.3
    -127   -599.5     21.5      0.3
    -133   -625.5     25.5      0.3
  -138.5   -646.5       28      0.3
    -140   -655.5     27.5      0.3

    1 5
    -140   -655.5     27.5      0.3
  -133.5   -667.5       28      0.3
    -129   -676.5     31.5      0.3
  -127.5   -684.5     33.5      0.3
  -127.5   -689.5     34.5      0.3

    1 3
    -140   -655.5     27.5      0.3
  -142.5   -660.5     27.5      0.3
  -138.5     -673       27      0.3

    1 9
  -109.5   -517.5      2.5      0.3
    -116     -532        2      0.3
  -126.5     -562     -1.5      0.3
    -132     -574       -4      0.3
  -132.5   -585.5       -9      0.3
  -139.5   -601.5      -15      0.3
  -144.5   -614.5    -19.5      0.3
    -147   -621.5      -22      0.3
    -148   -625.5      -24      0.3

    1 7
     -54   -291.5     -0.5      0.5
   -58.5   -292.5      0.5      0.3
     -75     -313      1.5      0.3
   -81.5   -322.5      2.5      0.3
     -94     -338      1.5      0.3
   -98.5     -342      0.5      0.3
    -107     -342        2      0.3

    1 12
     -35     -241        6      0.6
   -31.5     -251        7      0.3
   -30.5   -257.5      8.5      0.3
   -32.5     -267     12.5      0.3
     -29     -273       15      0.3
   -28.5     -285       19      0.3
   -31.5     -305       23      0.3
   -30.5   -313.5       24      0.3
   -25.5     -326     25.5      0.3
   -23.5   -342.5     29.5      0.3
   -24.5   -350.5     32.5      0.3
   -28.5     -354     35.5      0.3

    1 2
   -38.5     -196        4      0.6
   -41.5   -197.5        4      0.3

    1 7
   -41.5   -197.5        4      0.3
   -49.5   -208.5        2      0.3
   -54.5   -219.5        0      0.3
   -64.5   -234.5       -1      0.3
     -78     -249       -2      0.3
     -86   -255.5     -2.5      0.3
   -89.5     -259       -3      0.3

    1 8
   -41.5   -197.5        4      0.3
   -52.5     -201      3.5      0.3
   -77.5   -217.5      4.5      0.3
   -98.5   -233.5        4      0.3
    -116   -241.5      1.5      0.3
  -131.5   -257.5     -2.5      0.3
  -145.5     -269     -3.5      0.3
    -156     -276     -1.5      0.3

    1 9
     -35     -149        3        1
     -38     -155      5.5      0.3
   -49.5   -163.5      9.5      0.3
   -68.5   -178.5       10      0.3
     -90   -200.5       12      0.3
   -96.5   -210.5       12      0.3
  -116.5     -220     14.5      0.3
    -135   -226.5       17      0.3
    -143     -231       19      0.3

    1 10
     -32   -127.5        1      1.2
     -33   -131.5      5.5      0.3
     -34   -140.5       11      0.3
   -38.5   -146.5       16      0.3
   -36.5     -148       22      0.3
   -34.5     -154       26      0.3
   -38.5     -168     30.5      0.3
   -39.5   -178.5     32.5      0.3
     -44     -190     36.5      0.3
   -46.5   -195.5     37.5      0.3

    1 2
   -27.5   -112.5     -1.5      1.7
     -29   -119.5     -2.5      1.3

    1 6
     -29   -119.5     -2.5      1.3
     -28   -128.5       -5      1.1
   -26.5     -137       -7      0.8
     -28   -153.5     -9.5      0.8
     -30     -167    -13.5      0.8
   -30.5   -185.5    -16.5      0.8

    1 2
   -30.5   -185.5    -16.5      0.8
     -29     -195    -18.5      0.8

    1 2
     -29     -195    -18.5      0.8
     -27     -204      -21      0.6

    1 3
     -27     -204      -21      0.6
     -27   -216.5    -21.5      0.6
   -24.5   -231.5    -22.5      0.6

    1 2
   -24.5   -231.5    -22.5      0.6
     -20     -251    -21.5      0.6

    1 8
     -20     -251    -21.5      0.6
     -14   -277.5      -20      0.6
      -8     -311      -23      0.6
    -2.5   -331.5    -30.5      0.5
      -1   -355.5    -35.5      0.5
       3   -368.5    -37.5      0.5
     9.5     -388      -41      0.5
    17.5     -413    -43.5      0.5

    1 5
    17.5     -413    -43.5      0.5
      26   -424.5    -47.5      0.3
    38.5   -442.5    -50.5      0.3
    47.5   -453.5    -52.5      0.3
    53.5     -467      -55      0.3

    1 11
    53.5     -467      -55      0.3
    54.5     -479    -54.5      0.3
      52     -496    -55.5      0.3
      54     -514    -56.5      0.3
    61.5     -545      -55      0.3
    65.5     -558      -55      0.3
      69     -577      -56      0.3
      71   -584.5      -57      0.3
    69.5   -601.5      -59      0.3
      68   -612.5      -62      0.3
      72   -631.5      -67      0.3

    1 3
      72   -631.5      -67      0.3
    68.5   -643.5    -71.5      0.3
    61.5   -657.5      -75      0.3

    1 4
    61.5   -657.5      -75      0.3
    56.5     -667    -77.5      0.3
      55   -675.5    -76.5      0.3
      56     -683    -78.5      0.3

    1 3
    61.5   -657.5      -75      0.3
    52.5   -665.5    -72.5      0.3
      45     -670      -74      0.3

    1 5
      72   -631.5      -67      0.3
      77   -642.5      -66      0.3
    80.5     -654      -68      0.3
      78   -663.5    -71.5      0.3
      79   -668.5    -73.5      0.3

    1 7
    53.5     -467      -55      0.3
    58.5     -477    -53.5      0.3
      62     -492      -58      0.3
      69     -514      -59      0.3
    75.5     -527    -62.5      0.3
    83.5   -539.5      -62      0.3
      88     -547    -63.5      0.3

    1 13
    17.5     -413    -43.5      0.5
    12.5   -422.5      -42      0.3
     0.5     -442    -39.5      0.3
      -7     -459      -41      0.3
   -18.5   -477.5      -41      0.3
   -23.5     -492    -38.5      0.3
     -27     -504      -38      0.3
   -30.5     -526    -35.5      0.3
     -33     -553      -34      0.3
   -36.5     -572    -33.5      0.3
   -41.5   -584.5    -33.5      0.3
   -41.5     -591    -32.5      0.3
   -38.5   -600.5      -34      0.3

    1 8
     -20     -251    -21.5      0.6
   -16.5   -258.5    -26.5      0.3
   -10.5     -268    -32.5      0.3
    -0.5   -275.5    -36.5      0.3
     6.5   -287.5    -42.5      0.3
      15     -296    -47.5      0.3
    17.5     -302    -50.5      0.3
    14.5   -306.5      -55      0.3

    1 8
   -24.5   -231.5    -22.5      0.6
   -22.5     -235    -25.5      0.3
     -19     -243    -29.5      0.3
   -16.5   -249.5    -34.5      0.3
     -22   -254.5    -36.5      0.3
   -32.5     -257      -40      0.3
   -39.5     -260    -44.5      0.3
   -44.5     -262    -50.5      0.3

    1 3
     -27     -204      -21      0.6
     -24   -205.5      -24      0.3
     -23   -207.5    -25.5      0.3

    1 9
     -23   -207.5    -25.5      0.3
     -17   -209.5      -27      0.3
    -9.5     -217      -31      0.3
       1     -220      -34      0.3
    10.5   -225.5    -36.5      0.3
      17   -227.5    -39.5      0.3
    24.5     -233      -41      0.3
    33.5   -236.5      -43      0.3
      39     -234      -46      0.3

    1 9
     -23   -207.5    -25.5      0.3
   -26.5   -210.5    -27.5      0.3
     -27     -219    -30.5      0.3
   -27.5   -226.5    -34.5      0.3
     -27   -231.5      -39      0.3
   -26.5     -238    -44.5      0.3
     -27     -241      -48      0.3
   -20.5   -243.5    -52.5      0.3
   -17.5     -245    -56.5      0.3

    1 4
     -29     -195    -18.5      0.8
   -30.5     -206    -18.5      0.5
     -33     -228      -18      0.5
     -34     -241      -19      0.5

    1 4
     -34     -241      -19      0.5
   -37.5   -259.5      -21      0.3
   -43.5     -281      -23      0.3
     -50   -296.5    -24.5      0.3

    1 12
     -50   -296.5    -24.5      0.3
   -47.5   -311.5    -29.5      0.3
     -49     -332      -32      0.3
   -49.5     -350      -32      0.3
     -53     -363      -33      0.3
     -61   -378.5    -33.5      0.3
   -77.5   -398.5    -35.5      0.3
     -91   -415.5      -33      0.3
    -102     -436    -33.5      0.3
    -111   -454.5    -33.5      0.3
    -118     -471      -35      0.3
    -124     -489      -35      0.3

    1 6
    -124     -489      -35      0.3
  -123.5     -505    -35.5      0.3
  -122.5     -533    -35.5      0.3
    -123     -540    -35.5      0.3
    -126   -556.5      -35      0.3
  -126.5   -563.5    -36.5      0.3

    1 15
  -126.5   -563.5    -36.5      0.3
  -127.5   -579.5    -32.5      0.3
    -127   -593.5    -30.5      0.3
    -121   -611.5    -29.5      0.3
  -117.5   -625.5    -28.5      0.3
    -115     -646      -27      0.3
    -110     -662    -25.5      0.3
  -105.5   -675.5      -24      0.3
  -100.5   -681.5      -22      0.3
   -86.5     -687      -24      0.3
   -69.5   -695.5    -24.5      0.3
     -60     -703      -25      0.3
   -46.5   -707.5    -23.5      0.3
   -40.5   -711.5    -25.5      0.3
   -33.5   -721.5      -28      0.3

    1 6
  -126.5   -563.5    -36.5      0.3
    -131     -588    -37.5      0.3
  -133.5     -607    -39.5      0.3
  -137.5     -624    -41.5      0.3
    -138     -628      -42      0.3
    -141     -634    -42.5      0.3

    1 16
    -124     -489      -35      0.3
    -127   -494.5      -35      0.3
  -130.5     -513      -35      0.3
    -139     -533    -35.5      0.3
    -141     -545    -36.5      0.3
  -146.5     -557    -38.5      0.3
    -148     -568      -40      0.3
  -153.5   -582.5      -42      0.3
    -155     -592      -44      0.3
  -152.5   -597.5      -45      0.3
  -145.5     -604    -47.5      0.3
    -134     -615      -52      0.3
  -127.5   -625.5      -55      0.3
    -121     -643    -56.5      0.3
  -116.5   -650.5    -58.5      0.3
    -113   -653.5      -59      0.3

    1 6
    -113   -653.5      -59      0.3
    -103     -661      -58      0.3
     -92     -675      -59      0.3
     -84   -683.5    -57.5      0.3
     -77     -696      -61      0.3
   -67.5   -705.5      -64      0.3

    1 4
    -113   -653.5      -59      0.3
    -110   -663.5    -58.5      0.3
  -109.5     -674      -61      0.3
  -112.5     -680    -62.5      0.3

    1 5
     -50   -296.5    -24.5      0.3
   -63.5     -298    -25.5      0.3
     -83     -299      -29      0.3
   -93.5     -300      -29      0.3
   -97.5     -303      -29      0.3

    1 2
     -34     -241      -19      0.5
     -34   -245.5      -21      0.3

    1 7
     -34   -245.5      -21      0.3
   -32.5     -252    -25.5      0.3
     -31     -259      -30      0.3
     -33   -274.5    -33.5      0.3
   -32.5     -282    -38.5      0.3
   -31.5     -285    -43.5      0.3
   -30.5   -286.5    -45.5      0.3

    1 7
     -34   -245.5      -21      0.3
   -35.5     -249    -24.5      0.3
   -42.5     -258    -29.5      0.3
     -50   -269.5      -33      0.3
     -56   -277.5    -36.5      0.3
     -59     -285    -39.5      0.3
   -66.5   -298.5      -45      0.3

    1 8
   -30.5   -185.5    -16.5      0.8
     -40     -193    -18.5      0.3
   -49.5   -199.5      -24      0.3
   -60.5     -206    -28.5      0.3
   -73.5   -210.5      -33      0.3
   -88.5   -214.5    -37.5      0.3
     -98     -218      -41      0.3
  -105.5     -220    -44.5      0.3

    1 14
     -29   -119.5     -2.5      1.3
     -35   -126.5       -5      0.3
   -39.5     -138      -11      0.3
     -43   -150.5      -15      0.3
     -51   -166.5      -21      0.3
   -56.5     -182    -23.5      0.3
   -61.5     -191    -26.5      0.3
   -66.5     -198    -31.5      0.3
     -72     -206      -36      0.3
   -80.5     -215      -41      0.3
     -92   -228.5    -47.5      0.3
   -93.5   -235.5      -54      0.3
     -91     -242      -58      0.3
   -88.5   -248.5      -59      0.3

    1 6
     -21    -89.5        0      2.9
   -28.5    -99.5       -4      0.3
     -34     -111       -8      0.3
   -42.5     -127    -14.5      0.3
     -50     -142      -19      0.3
     -55   -150.5    -22.5      0.3

    1 17
     -55   -150.5    -22.5      0.3
   -59.5     -165    -26.5      0.3
     -61   -174.5    -28.5      0.3
   -64.5   -185.5    -30.5      0.3
     -65   -196.5      -34      0.3
     -68   -210.5    -37.5      0.3
     -71   -225.5    -40.5      0.3
   -74.5     -237    -45.5      0.3
     -76   -242.5    -47.5      0.3
     -82   -253.5      -51      0.3
     -86   -267.5      -56      0.3
   -87.5     -277    -59.5      0.3
     -88     -286      -65      0.3
   -92.5     -294    -69.5      0.3
   -90.5   -299.5      -70      0.3
     -92     -309    -72.5      0.3
   -96.5     -318      -74      0.3

    1 8
     -55   -150.5    -22.5      0.3
   -65.5     -154    -26.5      0.3
     -83   -161.5      -34      0.3
    -102     -174      -40      0.3
    -117   -185.5      -46      0.3
    -127   -191.5      -51      0.3
    -145     -196      -56      0.3
    -156   -200.5      -58      0.3

    1 2
      16       10        1        2
    20.5     12.5        1        2

    1 5
    20.5     12.5        1        2
    32.5     12.5      2.5      0.5
      55       14        5      0.5
    81.5       19      6.5      0.5
      92     23.5      6.5      0.5

    1 3
      92     23.5      6.5      0.5
      97     26.5        3      0.5
     106     26.5        4      0.5

    1 11
     106     26.5        4      0.5
     109     25.5      1.5      0.5
   113.5     27.5     -1.5      0.5
   119.5       28     -4.5      0.5
   125.5       28       -8      0.5
   138.5     28.5    -11.5      0.5
   147.5       31    -15.5      0.5
     165       35    -19.5      0.5
   170.5       37      -23      0.5
   172.5     35.5    -26.5      0.5
     172       33    -29.5      0.5

    1 12
     106     26.5        4      0.5
   110.5       29      3.5      0.5
   126.5       37        2      0.5
     151     42.5      0.5      0.5
     177       48       -2      0.5
   195.5       55     -3.5      0.5
     211       62     -3.5      0.5
   223.5       69       -2      0.5
     250     72.5       -2      0.5
   257.5     73.5       -4      0.5
   264.5       80     -6.5      0.5
   270.5       84       -8      0.5

    1 4
      92     23.5      6.5      0.5
     101     26.5      9.5      0.5
     116     26.5       12      0.5
   118.5     26.5     11.5      0.5

    1 4
   118.5     26.5     11.5      0.5
     131       25     13.5      0.5
   149.5     30.5       14      0.5
   159.5       33     11.5      0.5

    1 5
   159.5       33     11.5      0.5
     171     33.5      9.5      0.5
   180.5       30       10      0.5
     185     25.5       10      0.5
     194       23       10      0.5

    1 6
   159.5       33     11.5      0.5
   175.5       36     13.5      0.5
     184       37       15      0.5
     197     33.5     16.5      0.5
     204     36.5     16.5      0.5
     212     40.5     16.5      0.5

    1 11
   118.5     26.5     11.5      0.5
   127.5       28       15      0.5
   140.5     31.5     17.5      0.5
     152       33       20      0.5
   158.5     32.5     23.5      0.5
   174.5     31.5       28      0.5
   186.5     32.5     29.5      0.5
     195     35.5     30.5      0.5
     207       40     32.5      0.5
   224.5       46     35.5      0.5
   238.5       51     38.5      0.5

    1 3
    20.5     12.5        1        2
      29       19      2.5      0.5
      41     31.5        5      0.5

    1 3
      41     31.5        5      0.5
      58       43      4.5      0.5
    71.5     50.5        5      0.5

    1 3
    71.5     50.5        5      0.5
      84     58.5      6.5      0.5
   102.5       73      5.5      0.5

    1 9
   102.5       73      5.5      0.5
   111.5       80      2.5      0.5
   128.5       91       -1      0.5
     144       98     -2.5      0.5
   156.5      103     -4.5      0.5
     169      114     -7.5      0.5
     180      126      -11      0.5
     185      138      -13      0.5
     189      145    -16.5      0.5

    1 10
   102.5       73      5.5      0.5
     109     81.5        6      0.5
     126     94.5      6.5      0.5
     137      106      9.5      0.5
   153.5      121     11.5      0.5
     167    132.5        9      0.5
     184    147.5       12      0.5
     199      158       15      0.5
   211.5    168.5     16.5      0.5
   216.5    171.5     17.5      0.5

    1 12
    71.5     50.5        5      0.5
    76.5     59.5      2.5      0.5
      82     67.5        0      0.5
    97.5       80       -1      0.5
     108     90.5     -1.5      0.5
   115.5      106       -2      0.5
     125    115.5     -2.5      0.5
     134    127.5     -4.5      0.5
   144.5      141     -2.5      0.5
   159.5      159     -4.5      0.5
     176    172.5     -4.5      0.5
   192.5      185       -7      0.5

    1 18
      41     31.5        5      0.5
      40       35      4.5      0.5
      47     48.5      6.5      0.5
      59       64        9      0.5
    69.5     80.5      8.5      0.5
    78.5      107        7      0.5
    87.5    133.5        6      0.5
    93.5      141      5.5      0.5
     108      155        7      0.5
   119.5      169        7      0.5
   126.5      183        6      0.5
     132      189        5      0.5
     140    199.5        7      0.5
   151.5      205        7      0.5
     162    216.5      5.5      0.5
     166    219.5        5      0.5
     170    222.5        5      0.5
     172    229.5      5.5      0.5

    1 6
    13.5       12        1      0.6
      18     16.5      1.5      0.6
    22.5     19.5     -0.5      0.6
      30       27     -2.5      0.6
    36.5       33       -3      0.6
      47       43     -3.5      0.6

    1 2
      47       43     -3.5      0.6
      51       45       -4      0.3

    1 16
      51       45       -4      0.3
    60.5       53       -4      0.3
    76.5     67.5     -4.5      0.3
      83       76     -5.5      0.3
    91.5     85.5     -3.5      0.3
     100       94     -4.5      0.3
   108.5      105     -6.5      0.3
     120    120.5       -8      0.3
     134      134       -9      0.3
   142.5    139.5     -9.5      0.3
   149.5      146    -10.5      0.3
   158.5    150.5    -11.5      0.3
   165.5      154      -13      0.3
   169.5      157    -13.5      0.3
   169.5    161.5    -13.5      0.3
   167.5      169      -12      0.3

    1 5
      51       45       -4      0.3
    54.5     49.5     -7.5      0.3
      60       56      -11      0.3
    63.5     60.5      -14      0.3
      69       65      -16      0.3

    1 14
      69       65      -16      0.3
    73.5       70    -17.5      0.3
    83.5       77      -21      0.3
      91       82    -24.5      0.3
   100.5     85.5      -27      0.3
   113.5       94      -31      0.3
     120       99      -32      0.3
     126      105      -34      0.3
     143      111      -38      0.3
     152    116.5    -41.5      0.3
   165.5    121.5    -44.5      0.3
     175      127    -46.5      0.3
     177      132    -47.5      0.3
   182.5      133    -47.5      0.3

    1 10
      69       65      -16      0.3
      73     74.5      -19      0.3
      83     92.5    -24.5      0.3
      86      104      -29      0.3
    90.5      112    -30.5      0.3
    95.5    122.5      -34      0.3
      97      140    -38.5      0.3
    98.5      150      -42      0.3
      97    155.5      -48      0.3
      94    160.5      -49      0.3

    1 16
      47       43     -3.5      0.6
      45     50.5       -5      0.3
    46.5       67       -5      0.3
      50     79.5       -4      0.3
      53       93     -3.5      0.3
    57.5    112.5       -4      0.3
    60.5      121       -4      0.3
    59.5    131.5     -5.5      0.3
    59.5    151.5       -4      0.3
    58.5    168.5       -6      0.3
    58.5    179.5     -7.5      0.3
      56    188.5       -9      0.3
      57    200.5      -10      0.3
    58.5      207    -10.5      0.3
    68.5      221      -11      0.3
    67.5      226      -12      0.3

    1 3
      13     15.5        3      1.3
    14.5     18.5      3.5      1.3
      16     20.5      5.5      1.3

    1 2
      16     20.5      5.5      1.3
      17     23.5      8.5      1.3

    1 5
      17     23.5      8.5      1.3
    19.5       25      8.5      0.6
      27       29       12      0.6
      32     32.5     13.5      0.5
    37.5     36.5     17.5      0.5

    1 5
    37.5     36.5     17.5      0.5
      47       42     22.5      0.3
    55.5     48.5     26.5      0.3
      63       55     31.5      0.3
      65     55.5       33      0.3

    1 16
      65     55.5       33      0.3
      70     58.5       34      0.3
    73.5       63     35.5      0.3
    81.5       69     36.5      0.3
    86.5       74       38      0.3
      89       80     40.5      0.3
      92       86     43.5      0.3
    96.5       94       45      0.3
   101.5    102.5     46.5      0.3
   109.5    112.5     47.5      0.3
     117      124       48      0.3
   123.5    132.5     50.5      0.3
   128.5      140       52      0.3
   132.5      146       52      0.3
     135      155       53      0.3
     142    159.5       52      0.3

    1 11
      65     55.5       33      0.3
    64.5       60     36.5      0.3
    66.5       68     42.5      0.3
      68       73       46      0.3
    72.5       80     48.5      0.3
      82     85.5       52      0.3
      87       89     56.5      0.3
    89.5     93.5       61      0.3
    91.5     98.5       64      0.3
      98    102.5     66.5      0.3
     104    102.5     68.5      0.3

    1 5
    37.5     36.5     17.5      0.5
      47     44.5     18.5      0.3
      61       60       20      0.3
    68.5       69     19.5      0.3
    75.5       80     18.5      0.3

    1 10
    75.5       80     18.5      0.3
      85     86.5       20      0.3
      97      100     19.5      0.3
     105    106.5       20      0.3
     123      116       20      0.3
     140    127.5     19.5      0.3
   157.5    138.5     18.5      0.3
   171.5    148.5     18.5      0.3
     184    159.5     18.5      0.3
   194.5    171.5       18      0.3

    1 10
    75.5       80     18.5      0.3
      77     88.5     19.5      0.3
    86.5    102.5     17.5      0.3
      93      111     16.5      0.3
      99    129.5     16.5      0.3
   107.5    138.5     13.5      0.3
     113    145.5       10      0.3
     116      151        7      0.3
     118    154.5      3.5      0.3
   121.5      159      2.5      0.3

    1 5
      17     23.5      8.5      1.3
    15.5       34       10      0.4
    17.5     52.5       14      0.4
      19     61.5       16      0.4
    18.5       67       16      0.4

    1 2
    18.5       67       16      0.4
    19.5       71       18      0.4

    1 2
    19.5       71       18      0.4
      20     72.5       18      0.4

    1 3
      20     72.5       18      0.4
    24.5     82.5       20      0.4
      27     92.5       21      0.4

    1 11
      27     92.5       21      0.4
      30      101       23      0.4
      32    112.5     24.5      0.4
    34.5      124     24.5      0.4
    39.5    134.5       25      0.4
    41.5    142.5     25.5      0.4
      48      154       26      0.4
    50.5    163.5     28.5      0.4
    54.5    174.5       31      0.4
      58    185.5     33.5      0.4
      62    193.5     35.5      0.4

    1 13
      27     92.5       21      0.4
      26    101.5       21      0.4
      28    113.5       23      0.4
    32.5      124       24      0.4
    34.5      134     24.5      0.4
    41.5    150.5       25      0.4
      46    165.5       26      0.4
    50.5    182.5       29      0.4
      53      197       30      0.4
    56.5      204       31      0.4
      59      217     31.5      0.4
    62.5      227     31.5      0.4
      60    237.5       28      0.4

    1 13
      20     72.5       18      0.4
      18       81     19.5      0.4
    21.5    110.5     21.5      0.4
      28      137       23      0.4
    31.5      166       22      0.4
      34      183     20.5      0.4
    35.5    193.5       21      0.4
    37.5      212     19.5      0.4
    37.5    229.5       18      0.4
    37.5    235.5     19.5      0.4
      33      246     19.5      0.4
    35.5      252     18.5      0.4
    31.5    256.5       20      0.4

    1 12
    19.5       71       18      0.4
      21       84       16      0.4
    23.5       98     14.5      0.4
    24.5      110     11.5      0.4
      27    123.5        9      0.4
    32.5      144      5.5      0.4
      34    165.5        1      0.4
      36      180     -1.5      0.4
      36      195       -2      0.4
      38    204.5       -1      0.4
    35.5    210.5     -1.5      0.4
    35.5    219.5       -2      0.4

    1 13
    18.5       67       16      0.4
      11       72     19.5      0.4
     1.5       87     26.5      0.4
    -3.5     98.5       31      0.4
    -3.5    112.5       33      0.4
      -4      126     35.5      0.4
    -6.5      136       36      0.4
      -8    158.5     37.5      0.4
     -11      170       40      0.4
   -18.5    179.5     41.5      0.4
   -22.5    187.5       42      0.4
   -24.5    194.5     43.5      0.4
   -23.5    203.5     44.5      0.4

    1 4
      16     20.5      5.5      1.3
    22.5     30.5        4      0.5
      34     44.5        5      0.5
      39     50.5        5      0.5

    1 5
      39     50.5        5      0.5
    46.5     56.5        6      0.3
    56.5       67        3      0.3
    62.5       73      0.5      0.3
    72.5       83     -0.5      0.3

    1 10
    72.5       83     -0.5      0.3
    90.5       94      0.5      0.3
     115      109       -1      0.3
   125.5    115.5       -3      0.3
     134      123       -6      0.3
   147.5      138     -7.5      0.3
   168.5    150.5     -7.5      0.3
     185      161       -4      0.3
     193      164     -2.5      0.3
     208      176       -3      0.3

    1 14
    72.5       83     -0.5      0.3
    75.5       92        0      0.3
    85.5      102       -2      0.3
      91      111     -5.5      0.3
      99      121       -8      0.3
   106.5    132.5    -10.5      0.3
   112.5      142      -14      0.3
     123    157.5    -16.5      0.3
   127.5    163.5    -17.5      0.3
     129    170.5    -20.5      0.3
     136      181      -24      0.3
   143.5      190    -26.5      0.3
   150.5      197    -29.5      0.3
     156    203.5      -31      0.3

    1 4
      39     50.5        5      0.5
      42       59      2.5      0.3
      48       69        0      0.3
      50     76.5     -1.5      0.3

    1 4
      50     76.5     -1.5      0.3
    53.5     82.5       -3      0.3
    57.5       90     -4.5      0.3
    64.5    100.5     -6.5      0.3

    1 9
    64.5    100.5     -6.5      0.3
      73    107.5     -9.5      0.3
      82    114.5      -13      0.3
    87.5    122.5    -16.5      0.3
      97    132.5    -20.5      0.3
   109.5      143    -24.5      0.3
     119      151    -28.5      0.3
   126.5    154.5    -32.5      0.3
     133      161    -36.5      0.3

    1 9
    64.5    100.5     -6.5      0.3
      67      112       -8      0.3
      72    125.5      -11      0.3
      76      140      -14      0.3
    78.5    153.5      -19      0.3
    84.5    167.5      -23      0.3
    90.5      183    -25.5      0.3
      96    197.5    -26.5      0.3
   103.5      221    -27.5      0.3

    1 8
      50     76.5     -1.5      0.3
    47.5     87.5     -2.5      0.3
      44      104       -2      0.3
    41.5      125     -3.5      0.3
      38    134.5       -7      0.3
      34    155.5    -10.5      0.3
    29.5    174.5    -12.5      0.3
    22.5      178      -15      0.3

    1 2
     1.5     20.5        4      3.7
       5       30        4      2.9

    1 3
       5       30        4      2.9
       7     39.5     10.5      0.5
       8     45.5     14.5      0.5

    1 3
       8     45.5     14.5      0.5
    12.5       53     15.5      0.5
      14       63       18      0.5

    1 20
      14       63       18      0.5
      18       67     19.5      0.5
      24       75     22.5      0.3
    32.5     83.5       25      0.3
    39.5     92.5     28.5      0.3
      45    100.5       31      0.3
      53      111       33      0.3
    60.5    119.5       34      0.3
      70    131.5     37.5      0.3
    72.5      135     38.5      0.3
      77      148       40      0.3
      81    158.5       40      0.3
    88.5      169       40      0.3
    98.5      183     38.5      0.3
   101.5      190       39      0.3
   108.5      197       40      0.3
   115.5    210.5       39      0.3
     122      222       38      0.3
   128.5      228       37      0.3
   133.5    229.5       36      0.3

    1 10
      14       63       18      0.5
       9       78     18.5      0.3
     4.5     87.5       18      0.3
       0      101       15      0.3
      -2    116.5     13.5      0.3
      -7      137       12      0.3
   -12.5    151.5      9.5      0.3
     -17    164.5      7.5      0.3
   -20.5      183      8.5      0.3
     -23    194.5      8.5      0.3

    1 7
     -23    194.5      8.5      0.3
   -21.5      208      7.5      0.3
   -16.5      217      8.5      0.3
      -9      230      6.5      0.3
    -3.5    238.5      5.5      0.3
      -1    246.5        4      0.3
       1      257        4      0.3

    1 8
     -23    194.5      8.5      0.3
   -26.5      208        8      0.3
   -27.5    217.5      8.5      0.3
     -30    224.5       10      0.3
     -30      231     10.5      0.3
     -32    236.5       12      0.3
   -31.5    249.5       13      0.3
   -29.5    255.5       17      0.3

    1 11
       8     45.5     14.5      0.5
       7     53.5     17.5      0.3
     5.5     64.5       22      0.3
     8.5     75.5       25      0.3
      11     84.5     26.5      0.3
      11       93     27.5      0.3
       7      102     30.5      0.3
       8    115.5       32      0.3
      14      134       33      0.3
      19      150       33      0.3
    22.5      159       35      0.3

    1 10
    22.5      159       35      0.3
    25.5      165       38      0.3
      24      172       40      0.3
      22      179     42.5      0.3
      23      186     45.5      0.3
      21      198       49      0.3
    22.5    204.5       53      0.3
    25.5    215.5       56      0.3
      28    219.5       59      0.3
      30      223       62      0.3

    1 12
    22.5      159       35      0.3
    25.5    171.5     33.5      0.3
      26      183       36      0.3
      27    191.5       39      0.3
    26.5    199.5       42      0.3
    28.5    206.5       44      0.3
      29      212     45.5      0.3
      35    225.5       46      0.3
      37      231       45      0.3
    43.5      237     46.5      0.3
      48      239       47      0.3
    53.5      249       48      0.3

    1 4
       5       30        4      2.9
     4.5     35.5      3.5      0.6
       7     40.5        2      0.6
       9       56        1      0.6

    1 3
       9       56        1      0.6
      14       57       -1      0.3
      17       59     -2.5      0.3

    1 13
      17       59     -2.5      0.3
    23.5       62       -4      0.3
    30.5       70       -5      0.3
      43     87.5     -6.5      0.3
    55.5      104     -7.5      0.3
      66      116       -9      0.3
      76    127.5       -9      0.3
    83.5      140    -10.5      0.3
      91    147.5    -12.5      0.3
      96      154    -14.5      0.3
    98.5    162.5    -15.5      0.3
     100      170    -16.5      0.3
    95.5      177      -19      0.3

    1 14
      17       59     -2.5      0.3
    20.5       64       -5      0.3
      24       67     -6.5      0.3
      29     76.5     -8.5      0.3
    37.5     88.5      -10      0.3
      46    104.5    -12.5      0.3
      51      117      -14      0.3
    57.5    132.5    -15.5      0.3
    65.5    146.5      -19      0.3
      70      161      -21      0.3
      75      175    -23.5      0.3
      77    184.5      -25      0.3
    81.5    193.5    -27.5      0.3
      84    199.5    -29.5      0.3

    1 3
       9       56        1      0.6
     3.5       65     -0.5      0.3
      -1       76      0.5      0.3

    1 14
      -1       76      0.5      0.3
      -3       91       -2      0.3
    -6.5    101.5       -6      0.3
      -8    115.5      -10      0.3
   -11.5    123.5    -14.5      0.3
   -13.5      137    -16.5      0.3
   -15.5    144.5      -18      0.3
   -22.5      153    -21.5      0.3
   -33.5      162    -25.5      0.3
   -37.5    171.5      -27      0.3
     -44      187    -27.5      0.3
   -45.5      201      -28      0.3
   -45.5      209      -30      0.3
   -51.5    217.5    -27.5      0.3

    1 16
      -1       76      0.5      0.3
      -4       81      1.5      0.3
    -7.5     93.5      3.5      0.3
     -12    107.5        3      0.3
     -16    116.5      1.5      0.3
     -21      125      0.5      0.3
   -24.5    143.5      0.5      0.3
     -27      154     -0.5      0.3
   -31.5    167.5       -3      0.3
     -35    183.5     -4.5      0.3
     -36      191       -6      0.3
   -41.5    202.5     -4.5      0.3
   -45.5      219       -3      0.3
     -48      231       -4      0.3
     -50      236     -3.5      0.3
   -57.5      245       -6      0.3

    1 3
    -4.5       18      0.5      3.5
      -8       25     -0.5      1.8
     -12       33       -1      1.8

    1 2
     -12       33       -1      1.8
     -14     35.5       -1      1.8

    1 3
     -14     35.5       -1      1.8
     -20     48.5        1      0.6
   -25.5       59      0.5      0.6

    1 4
   -25.5       59      0.5      0.6
     -29       69     -4.5      0.6
   -33.5     79.5       -5      0.6
     -35       82       -7      0.6

    1 13
     -35       82       -7      0.6
   -35.5     91.5     -6.5      0.6
     -35      104       -6      0.6
   -33.5    114.5       -5      0.6
     -36      125       -6      0.6
   -38.5    129.5     -6.5      0.6
   -40.5    136.5     -6.5      0.6
     -44      147     -7.5      0.6
   -42.5    155.5     -8.5      0.6
   -38.5    170.5       -7      0.6
   -40.5      177     -7.5      0.6
   -43.5      184     -9.5      0.6
     -50      194      -10      0.6

    1 23
     -35       82       -7      0.6
     -38       88     -9.5      0.6
   -41.5     98.5      -13      0.6
     -46      105    -14.5      0.6
     -50    114.5    -15.5      0.3
     -54      120    -17.5      0.3
     -56    126.5    -18.5      0.3
   -61.5      132    -20.5      0.3
     -67      134      -22      0.3
     -72      139    -24.5      0.3
     -76    142.5      -28      0.3
   -78.5    149.5      -31      0.3
     -86      154      -34      0.3
   -96.5      160      -37      0.3
    -102      166    -39.5      0.3
  -105.5    170.5      -41      0.3
    -109      177      -43      0.3
  -114.5      183    -46.5      0.3
    -115    188.5      -49      0.3
    -113    192.5    -50.5      0.3
  -113.5    196.5    -51.5      0.3
  -113.5    200.5      -53      0.3
    -116    206.5    -56.5      0.3

    1 5
   -25.5       59      0.5      0.6
   -30.5       70        0      0.3
   -41.5     92.5     -0.5      0.3
     -49    113.5        0      0.3
   -51.5      118     -0.5      0.3

    1 14
   -51.5      118     -0.5      0.3
   -54.5      130     -0.5      0.3
     -61      140     -1.5      0.3
     -69    147.5       -4      0.3
   -78.5      162       -6      0.3
   -83.5    168.5       -7      0.3
   -85.5    173.5     -8.5      0.3
     -85      180    -10.5      0.3
     -86    190.5    -12.5      0.3
     -90    199.5    -13.5      0.3
   -95.5    213.5      -16      0.3
    -102    223.5      -17      0.3
  -106.5    226.5    -16.5      0.3
    -110      234    -16.5      0.3

    1 8
   -51.5      118     -0.5      0.3
   -55.5    126.5        1      0.3
   -62.5      146        2      0.3
     -70    162.5      3.5      0.3
   -75.5    175.5      6.5      0.3
   -80.5      184       10      0.3
   -86.5      190     10.5      0.3
     -89      191        9      0.3

    1 4
     -14     35.5       -1      1.8
   -20.5       38        1      0.3
   -28.5       45        4      0.3
   -41.5     57.5      1.5      0.3

    1 17
   -41.5     57.5      1.5      0.3
   -44.5     64.5        0      0.3
     -54     81.5     -1.5      0.3
   -59.5       92     -2.5      0.3
     -66    101.5     -4.5      0.3
     -69      109       -5      0.3
     -71      122       -5      0.3
   -80.5      140       -7      0.3
   -87.5      154     -9.5      0.3
   -93.5    171.5    -11.5      0.3
   -99.5    189.5    -12.5      0.3
  -109.5    207.5      -14      0.3
  -118.5    220.5    -13.5      0.3
    -127    233.5    -16.5      0.3
    -133      246      -19      0.3
    -135      251    -20.5      0.3
  -146.5    258.5    -20.5      0.3

    1 6
   -41.5     57.5      1.5      0.3
     -57     61.5        1      0.3
     -77       67        0      0.3
     -91     72.5        1      0.3
  -101.5     74.5        1      0.3
  -116.5     73.5     -1.5      0.3

    1 5
     -12       33       -1      1.8
      -9     39.5     -3.5      0.8
    -7.5       45       -6      0.8
    -6.5       51       -8      0.8
      -7     54.5     -9.5      0.8

    1 3
      -7     54.5     -9.5      0.8
      -5       57    -10.5      0.3
    -2.5       60    -10.5      0.3

    1 17
    -2.5       60    -10.5      0.3
       6     63.5      -10      0.3
      15       70    -11.5      0.3
    26.5       81      -13      0.3
    33.5     91.5    -14.5      0.3
      39    101.5      -17      0.3
    43.5    111.5      -20      0.3
    49.5      122      -24      0.3
      58      128    -27.5      0.3
      65      134      -32      0.3
    69.5      140    -34.5      0.3
      73    152.5      -37      0.3
      80      167      -38      0.3
      87      180      -40      0.3
    91.5      189      -42      0.3
      96      196    -44.5      0.3
      99    199.5    -45.5      0.3

    1 19
    -2.5       60    -10.5      0.3
    -2.5       62    -11.5      0.3
     2.5       69    -13.5      0.3
       9       77      -16      0.3
      12       79      -17      0.3
    16.5       89      -18      0.3
    20.5       98      -20      0.3
      28      111      -21      0.3
      38      122    -23.5      0.3
      44      132      -26      0.3
    50.5      140    -28.5      0.3
      58    148.5    -31.5      0.3
      65    157.5      -33      0.3
      72      169      -36      0.3
    78.5      181    -38.5      0.3
      85    194.5      -42      0.3
    87.5      206      -44      0.3
      91    214.5    -45.5      0.3
    96.5    222.5    -46.5      0.3

    1 6
      -7     54.5     -9.5      0.8
    -9.5     58.5    -11.5      0.3
      -9       72    -13.5      0.3
     -11       84    -14.5      0.3
     -11       89      -17      0.3
     -15       96      -17      0.3

    1 20
     -15       96      -17      0.3
     -14      104      -19      0.3
     -16    116.5      -21      0.3
     -16      124    -23.5      0.3
     -19      135      -26      0.3
   -21.5      147      -29      0.3
     -24    156.5      -31      0.3
     -25    163.5      -34      0.3
     -28      172      -36      0.3
   -32.5      180      -38      0.3
     -35      188      -39      0.3
     -36      197    -42.5      0.3
   -39.5      204      -44      0.3
   -43.5      210      -47      0.3
     -45      213      -49      0.3
   -43.5      223      -50      0.3
   -42.5      228    -51.5      0.3
   -42.5    237.5      -52      0.3
     -46    241.5      -55      0.3
     -52      244      -58      0.3

    1 15
     -15       96      -17      0.3
     -21      101    -16.5      0.3
   -29.5    115.5      -19      0.3
     -36    127.5    -21.5      0.3
   -40.5    137.5    -24.5      0.3
   -43.5    149.5    -28.5      0.3
   -47.5      161      -31      0.3
     -50    169.5    -33.5      0.3
     -58    182.5      -36      0.3
     -61      194    -38.5      0.3
     -62      198      -41      0.3
     -66    205.5      -44      0.3
   -73.5      209      -46      0.3
   -78.5      213      -48      0.3
   -80.5    216.5      -49      0.3

    1 5
      -3     20.5        4        1
   -10.5       28      9.5        1
   -14.5       31       14        1
   -17.5     34.5       18        1
   -17.5       38     22.5        1

    1 19
   -17.5       38     22.5        1
     -16       39     25.5      0.3
     -16       45       29      0.3
   -18.5       54     33.5      0.3
     -19       61       37      0.3
   -19.5       70     38.5      0.3
   -21.5     81.5     41.5      0.3
   -23.5       92     43.5      0.3
     -21      101       48      0.3
   -21.5      106       50      0.3
     -24      118       54      0.3
     -26    131.5       59      0.3
   -27.5    152.5     60.5      0.3
   -28.5      160     63.5      0.3
     -34      177       66      0.3
     -39      189       69      0.3
   -46.5    201.5     71.5      0.3
     -52      208       72      0.3
   -53.5      215       73      0.3

    1 5
   -17.5       38     22.5        1
   -20.5       41       24      0.3
   -26.5       48       29      0.3
   -33.5       56       33      0.3
   -38.5     61.5       37      0.3

    1 9
   -38.5     61.5       37      0.3
   -39.5       66     40.5      0.3
     -38       71       44      0.3
   -41.5     75.5       49      0.3
     -42       77     51.5      0.3
   -43.5     81.5     58.5      0.3
   -41.5       87     65.5      0.3
     -50     91.5     68.5      0.3
     -54     95.5       71      0.3

    1 11
   -38.5     61.5       37      0.3
   -45.5       71     38.5      0.3
     -63       90     38.5      0.3
     -77    104.5     43.5      0.3
   -85.5      116     44.5      0.3
    -100    130.5       47      0.3
  -107.5    142.5       46      0.3
    -112    148.5       47      0.3
    -126      158       46      0.3
    -134    163.5     47.5      0.3
    -140    169.5     47.5      0.3

    1 14
      -8     11.5      4.5      0.6
   -13.5     16.5      9.5      0.6
     -18     24.5     14.5      0.6
     -20       29       17      0.6
     -21       35       22      0.6
     -22       40       25      0.6
     -22     48.5     27.5      0.3
     -23     54.5       31      0.3
   -26.5       63     34.5      0.3
   -29.5     70.5     38.5      0.3
   -31.5     78.5       41      0.3
     -31     82.5       42      0.3
   -27.5     92.5     41.5      0.3
   -25.5      100       42      0.3

    1 8
   -25.5      100       42      0.3
   -21.5    115.5       42      0.3
     -22    128.5       42      0.3
     -26    146.5       41      0.3
   -29.5    160.5     41.5      0.3
     -33    170.5     41.5      0.3
     -38    179.5     39.5      0.3
   -40.5    182.5     39.5      0.3

    1 14
   -25.5      100       42      0.3
     -26      105       45      0.3
     -24      118     48.5      0.3
   -24.5    133.5       50      0.3
   -25.5      142     50.5      0.3
     -28      149       52      0.3
   -28.5    160.5     53.5      0.3
     -30      170       56      0.3
     -31      177     59.5      0.3
   -34.5      185     60.5      0.3
   -35.5    190.5       62      0.3
     -35      201     64.5      0.3
     -36    206.5       67      0.3
   -34.5      208       68      0.3


CONNECTIONS:
        0    1
        0    1

        0    1
        1    1
        2    1
        3    1
        3    1
        2    1
        1    1
        7    1
        7    1
        0    1
       10    1
       11    1
       11    1
       10    1

        0    1
        1    1
        2    1
        3    1
        4    1
        5    1
        6    1
        7    1
        8    1
        8    1
        7    1
        6    1
        5    1
        4    1
        3    1
       15    1
       16    1
       16    1
       15    1
       19    1
       19    1
        2    1
       22    1
       23    1
       24    1
       25    1
       26    1
       26    1
       25    1
       29    1
       29    1
       31    1
       31    1
       24    1
       23    1
       22    1
        1    1
       37    1
       38    1
       39    1
       40    1
       41    1
       42    1
       43    1
       44    1
       44    1
       43    1
       47    1
       48    1
       48    1
       47    1
       42    1
       41    1
       40    1
       54    1
       54    1
       39    1
       38    1
       37    1
       59    1
       60    1
       61    1
       62    1
       63    1
       64    1
       65    1
       66    1
       67    1
       68    1
       68    1
       67    1
       66    1
       65    1
       64    1
       63    1
       62    1
       76    1
       76    1
       61    1
       79    1
       80    1
       81    1
       82    1
       82    1
       81    1
       85    1
       85    1
       80    1
       79    1
       89    1
       89    1
       60    1
       59    1
        0    1
       94    1
       94    1

        0    1
        1    1
        2    1
        2    1
        1    1
        5    1
        6    1
        6    1
        5    1
        0    1
       10    1
       11    1
       12    1
       12    1
       11    1
       10    1

        0    1
        1    1
        1    1
        3    1
        3    1
        0    1

        0    1
        1    1
        2    1
        3    1
        3    1
        2    1
        6    1
        6    1
        1    1
        9    1
       10    1
       11    1
       12    1
       12    1
       11    1
       10    1
        9    1
        0    1
       18    1
       19    1
       19    1
       18    1
       22    1
       23    1
       23    1
       22    1

        0    1
        1    1
        2    1
        2    1
        4    1
        4    1
        1    1
        7    1
        7    1
        0    1
       10    1
       11    1
       11    1
       10    1
       14    1
       14    1

        0    1
        1    1
        2    1
        3    1
        3    1
        2    1
        6    1
        6    1
        1    1
        9    1
        9    1
        0    1
       12    1
       13    1
       13    1
       12    1
       16    1
       16    1

        0    1
        0    1
        2    1
        2    1

        0    1
        0    1


/*----------------------------------------------------------------*/
proc geometry() { 


	/* NULL geometry procedure: keeps the user from
	calling the geometry procedure in isolation. */

    printf("\nYou must re-read the entire geometry\n")
    printf("file to execute geometry().\n\n")
}

/*________________________________________________________________*/
/* END OF FILE */




