/*
 * SnapShotSettingsPanel.java
 *
 * Created on January 1, 2002, 10:03 AM
 */

package pharynx;
import java.io.*;
import java.util.*;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

/**
 *
 * @author  leon
 */
public class SnapShotSettingsPanel extends javax.swing.JPanel {
    public static final File EMPTY_FILE = new File("");
    private double snapStart = 0.0;
    private double snapStop = 0.0;
    private double snapInterval = 100.0;
    private File snapFile = EMPTY_FILE;
    private String snapType = "PNG";
    private String snapExtension = "png";
    private SimOptions.Updater updater;
    private JFileChooser fileDialog = null;

    /** Creates new form SnapShotSettingsPanel */
    public SnapShotSettingsPanel() {
        initComponents();
        readOptions();
    }
    
    public SnapShotSettingsPanel(SimOptions.Updater updater) {
        this.updater = updater;
        initComponents();
        readOptions();
    }
    
    public void defaultSettings(String start, String stop, String interval,
        String file) {
            startTextField.setText(start);
            stopTextField.setText(stop);
            intervalTextField.setText(interval);
            fileTextField.setText(file);            
            readOptions();
    }
    
    public void setFile(String fname) {
        fileTextField.setText(fname);
        snapFile = new File(fname);
    }
    
    public void setFile(File file) {
        setFile(file.getPath());
    }
    
    public SimOptions getOptions() {
        if (!readOptions())
            throw new InvalidSettingsException();
        return getOptions(new SimOptions());
    }
    
    public SimOptions getOptions(SimOptions options) {
        if (!readOptions())
            throw new InvalidSettingsException();
        SimOptions o = new SimOptions(options);
        o.snapStart = snapStart;
        o.snapStop = snapStop;
        o.snapInterval = snapInterval;
        o.snapFile = snapFile;
        o.snapType = snapType;
        o.snapExtension = snapExtension;
        return(o);
    }
    
    private double parseDouble(JTextField tf) {
        String t = tf.getText();
        if (0 == t.length())
            return 0.0;
        else
            return Double.parseDouble(t);
    }

    private boolean readOptions() {
        try {
            snapStart = parseDouble(startTextField);
            snapStop = parseDouble(stopTextField);
            snapInterval = parseDouble(intervalTextField);
            snapFile = new File(fileTextField.getText());
        } catch(NumberFormatException e) {
            errorPopup(e);
            return false;
        }
        return true;
    }
    
    public void update() {
        if (readOptions() && (null != updater))
            updater.update(null);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        startLabel = new javax.swing.JLabel();
        startTextField = new javax.swing.JTextField();
        stopLabel = new javax.swing.JLabel();
        stopTextField = new javax.swing.JTextField();
        intervalLabel = new javax.swing.JLabel();
        intervalTextField = new javax.swing.JTextField();
        fileButton = new javax.swing.JButton();
        fileTextField = new javax.swing.JTextField();
        
        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.X_AXIS));
        
        setPreferredSize(new java.awt.Dimension(226, 12));
        setMinimumSize(new java.awt.Dimension(161, 0));
        startLabel.setText("start");
        add(startLabel);
        
        startTextField.setText("0.0");
        startTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                startTextFieldActionPerformed(evt);
            }
        });
        
        add(startTextField);
        
        stopLabel.setText("stop");
        add(stopLabel);
        
        stopTextField.setText("0.0");
        stopTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                stopTextFieldActionPerformed(evt);
            }
        });
        
        add(stopTextField);
        
        intervalLabel.setText("interval");
        add(intervalLabel);
        
        intervalTextField.setText("100.0");
        intervalTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                intervalTextFieldActionPerformed(evt);
            }
        });
        
        add(intervalTextField);
        
        fileButton.setText("basename");
        fileButton.setPreferredSize(new java.awt.Dimension(70, 27));
        fileButton.setMaximumSize(new java.awt.Dimension(70, 27));
        fileButton.setMargin(new java.awt.Insets(2, 0, 2, 0));
        fileButton.setMinimumSize(new java.awt.Dimension(70, 27));
        fileButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fileButtonActionPerformed(evt);
            }
        });
        
        add(fileButton);
        
        fileTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fileTextFieldActionPerformed(evt);
            }
        });
        
        add(fileTextField);
        
    }//GEN-END:initComponents

    private void fileTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fileTextFieldActionPerformed
        update();
    }//GEN-LAST:event_fileTextFieldActionPerformed

    private void intervalTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_intervalTextFieldActionPerformed
        update();
    }//GEN-LAST:event_intervalTextFieldActionPerformed

    private void stopTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_stopTextFieldActionPerformed
        update();
    }//GEN-LAST:event_stopTextFieldActionPerformed

    private void startTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_startTextFieldActionPerformed
        update();
    }//GEN-LAST:event_startTextFieldActionPerformed

    private void fileButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fileButtonActionPerformed
        if (null == fileDialog) {
            fileDialog = new JFileChooser();
            fileDialog.setDialogTitle("Choose Snapshot File Basename");
            fileDialog.setFileSelectionMode(JFileChooser.FILES_ONLY);
            setFileFilters(fileDialog);
        }
        int result = fileDialog.showDialog(this, "Choose");
        if (JFileChooser.APPROVE_OPTION != result) return;
        setFile(fileDialog.getSelectedFile());
        ssFileFilter ssf = (ssFileFilter) fileDialog.getFileFilter();
        snapType = ssf.getType();
        snapExtension = ssf.getExtension();
        update();
    }//GEN-LAST:event_fileButtonActionPerformed

    private class ssFileFilter extends javax.swing.filechooser.FileFilter {
        private String type;
        private String extension;
        
        public ssFileFilter(String type, String extension) {
            this.type = type;
            this.extension = extension;
        }

        public boolean accept(File f) {
            return f.getName().endsWith("." + extension);
        }
        
        public String getDescription() {
            return type + " Image File";
        }
        
        public String getType() {
            return type;
        }
        
        public String getExtension() {
            return extension;
        }
    }
    
    private final ssFileFilter[] fileFilters = {
        new ssFileFilter("BMP", "bmp"),
        new ssFileFilter("JPEG", "jpg"),
        new ssFileFilter("PNG", "png"),
        new ssFileFilter("PNM", "ppm"),
        new ssFileFilter("TIFF", "tif")
    };
    
    private static final int PNG_CHOICE = 2;
    
    private void setFileFilters(JFileChooser fileDialog) {
        for(int i = 0; i < fileFilters.length; i++) {
            fileDialog.addChoosableFileFilter(fileFilters[i]);
        }
        fileDialog.setFileFilter(fileFilters[PNG_CHOICE]);
    }

    private void errorPopup(Exception e) {
        JOptionPane.showMessageDialog(null, e, "Animation Settings Error",
                                      JOptionPane.ERROR_MESSAGE);
    }

    private void errorPopup(String s) {
        JOptionPane.showMessageDialog(null, s, "Animation Settings Error",
                                      JOptionPane.ERROR_MESSAGE);
    }

    private void infoPopup(String s) {
        JOptionPane.showMessageDialog(null, s, "Animation Settings Message",
                                      JOptionPane.PLAIN_MESSAGE);
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel startLabel;
    private javax.swing.JTextField startTextField;
    private javax.swing.JLabel stopLabel;
    private javax.swing.JTextField stopTextField;
    private javax.swing.JLabel intervalLabel;
    private javax.swing.JTextField intervalTextField;
    private javax.swing.JButton fileButton;
    private javax.swing.JTextField fileTextField;
    // End of variables declaration//GEN-END:variables

    // for debugging
    public static void main(String[] args) {
        SnapShotSettingsPanel sssp = new SnapShotSettingsPanel();
    }
    
}
