/*
 * MotionGraphPanel.java
 *
 * Created on December 25, 2000, 4:42 PM
 */

package pharynx;
import java.awt.*;

/**
 *
 * @author  leon@eatworms.swmed.edu
 * @version 0.1
 */
public class MotionGraphPanel extends javax.swing.JPanel {
    private MotionList motion = new MotionList();
    private double maxT = 1000.0;
    private static final double INDENT = 10.0;

    /** Creates new form MotionGraphPanel */
    public MotionGraphPanel() {
        initComponents ();
    }

    public void display(MotionList motion, double maxT) {
        this.motion = motion;
        this.maxT = maxT;
        repaint();
    }

    protected void paintComponent(Graphics g) {
        if (0.0 >= maxT) return;
        Graphics2D g2 = (Graphics2D) g;
        double pw = (double) getSize().width;
        double ph = (double) getSize().height;
        double hscale = (pw - 2.0 * INDENT) / (2.0 * maxT);
        double vscale = (ph - 2.0 * INDENT);
        g2.setColor(Color.white);
            g2.fillRect(0, 0, (int) Math.round(pw), (int) Math.round(ph));
        g2.translate(INDENT, ph - INDENT);
        g2.scale(1.0, -1.0);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                            RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.black);
        g2.setStroke(new BasicStroke(2.0F));
        for(int j = 0; j < 2; j++) {
            for(int i = 0; i < motion.size() - 1; i++) {
                MotionPoint mp1 = motion.getmp(i);
                MotionPoint mp2 = motion.getmp(i + 1);
                g2.drawLine((int) Math.round(hscale * mp1.t()),
                            (int) Math.round(vscale * mp1.r()),
                            (int) Math.round(hscale * mp2.t()),
                            (int) Math.round(vscale * mp2.r()));
            }
            g2.translate(hscale * maxT, 0.0);
        }
    }
        
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
    }//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables

}
