/*
 * SettingsPanel.java
 *
 * Created on December 25, 2000, 10:18 AM
 */

package pharynx;
import java.util.*;
import java.awt.Color;

/**
 *
 * @author  leon@eatworms.swmed.edu
 * @version 0.1
 */
public class SettingsPanel extends javax.swing.JPanel 
    implements SimOptions.Updater {
    SimOptions options;
    SimOptions.Updater updater;

    /** Creates new form SettingsPanel
     *
     * Apparently we need to have this constructor in order for the forte GUI
     * editor to insert this object, even if it's never used.
     */
    public SettingsPanel() {
        options = new SimOptions();
        initComponents ();
        defaultSettings();
        readOptions();
    }

    /** Creates new form SettingsPanel */
    public SettingsPanel(SimOptions.Updater updater) {
        options = new SimOptions();
        this.updater = updater;
        initComponents();
        defaultSettings();
        readOptions();
    }

    private void defaultSettings() {
        corpusMotionSettingsPanel.defaultSettings("0", "133", "133", "150");
        aIsthmusMotionSettingsPanel.defaultSettings("83", "150", "150", "167");
        pIsthmusMotionSettingsPanel.defaultSettings("150", "183", "183", "200");
        ParticleSeries ps = new ParticleSeries();
        ps.n = 1;
        ps.setDiameter(12.3);
        ps.color = new Color(149, 149, 0);
        particleSeriesSettingsPanel1.defaultSettings(ps);
        ps.n = 0;
        ps.color = new Color(0, 198, 0);
        particleSeriesSettingsPanel2.defaultSettings(ps);
        ps.color = new Color(255, 0, 0);
        particleSeriesSettingsPanel3.defaultSettings(ps);
    }

    public boolean readOptions() {
        try {
            options = animationSettingsPanel.getOptions();
            options = snapShotSettingsPanel.getOptions(options);
            options.corpusMotion = corpusMotionSettingsPanel.getMotion();
            options.aIsthmusMotion = aIsthmusMotionSettingsPanel.getMotion();
            options.pIsthmusMotion = pIsthmusMotionSettingsPanel.getMotion();
            options.maxT = options.defaultMaxT();
            options.connectEnds();
            options.particleSeries = new ArrayList();
            options.particleSeries.add(0, particleSeriesSettingsPanel1.getps());
            options.particleSeries.add(1, particleSeriesSettingsPanel2.getps());
            options.particleSeries.add(2, particleSeriesSettingsPanel3.getps());
            settingsGraphPanel.display(options);
            return true;
        } catch(InvalidSettingsException e) {
            return false;
        }
    }
    
    public void update(SimOptions o) {
        if (readOptions() && (null != updater))
            updater.update(options);
    }
    
    public SimOptions getOptions() {
        if (!readOptions())
            throw new InvalidSettingsException();
        return(new SimOptions(options));
    }
    
    public SimOptions getOptions(SimOptions sto) {
        if (!readOptions())
            throw new InvalidSettingsException();
        SimOptions o = new SimOptions(sto);
        o.dt = options.dt;
        o.start = options.start;
        o.frame = options.frame;
        o.particleSeries = new ArrayList();
        for(int i = 0; i < options.particleSeries.size(); i++) {
            o.particleSeries.add(options.getps(i));
        }
        o.corpusMotion = new MotionList(options.corpusMotion);
        o.aIsthmusMotion = new MotionList(options.aIsthmusMotion);
        o.pIsthmusMotion = new MotionList(options.pIsthmusMotion);
        o.maxT = options.maxT;
        return(o);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        settingsTabbedPane = new javax.swing.JTabbedPane();
        allParticlesPanel = new javax.swing.JPanel();
        particleSeriesSettingsPanel1 = new ParticleSeriesSettingsPanel(this);
        particleSeriesSettingsPanel2 = new ParticleSeriesSettingsPanel(this);
        particleSeriesSettingsPanel3 = new ParticleSeriesSettingsPanel(this);
        allMotionsSettings = new javax.swing.JPanel();
        corpusMotionSettingsPanel = new MotionSettingsPanel(this);
        aIsthmusMotionSettingsPanel = new MotionSettingsPanel(this);
        pIsthmusMotionSettingsPanel = new MotionSettingsPanel(this);
        animationSettingsPanel = new AnimationSettingsPanel(this);
        snapShotSettingsPanel = new pharynx.SnapShotSettingsPanel();
        settingsGraphPanel = new pharynx.SettingsGraphPanel();
        
        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.X_AXIS));
        
        setName("");
        allParticlesPanel.setLayout(new javax.swing.BoxLayout(allParticlesPanel, javax.swing.BoxLayout.Y_AXIS));
        
        particleSeriesSettingsPanel1.setLayout(new java.awt.GridLayout(2, 8));
        
        particleSeriesSettingsPanel1.setBorder(new javax.swing.border.TitledBorder("Particle Series 1"));
        allParticlesPanel.add(particleSeriesSettingsPanel1);
        
        particleSeriesSettingsPanel2.setLayout(new java.awt.GridLayout(2, 8));
        
        particleSeriesSettingsPanel2.setBorder(new javax.swing.border.TitledBorder("Particle Series 2"));
        allParticlesPanel.add(particleSeriesSettingsPanel2);
        
        particleSeriesSettingsPanel3.setLayout(new java.awt.GridLayout(2, 8));
        
        particleSeriesSettingsPanel3.setBorder(new javax.swing.border.TitledBorder("Particle Series 3"));
        allParticlesPanel.add(particleSeriesSettingsPanel3);
        
        settingsTabbedPane.addTab("Particle Settings", allParticlesPanel);
        
        allMotionsSettings.setLayout(new javax.swing.BoxLayout(allMotionsSettings, javax.swing.BoxLayout.Y_AXIS));
        
        corpusMotionSettingsPanel.setLayout(new java.awt.GridLayout(1, 6));
        
        corpusMotionSettingsPanel.setBorder(new javax.swing.border.TitledBorder("Corpus Motions"));
        allMotionsSettings.add(corpusMotionSettingsPanel);
        
        aIsthmusMotionSettingsPanel.setLayout(new java.awt.GridLayout(1, 6));
        
        aIsthmusMotionSettingsPanel.setBorder(new javax.swing.border.TitledBorder("Anterior Isthmus Motions"));
        allMotionsSettings.add(aIsthmusMotionSettingsPanel);
        
        pIsthmusMotionSettingsPanel.setLayout(new java.awt.GridLayout(1, 6));
        
        pIsthmusMotionSettingsPanel.setBorder(new javax.swing.border.TitledBorder("Posterior Isthmus Motions"));
        allMotionsSettings.add(pIsthmusMotionSettingsPanel);
        
        animationSettingsPanel.setLayout(new java.awt.GridLayout(3, 3));
        
        animationSettingsPanel.setBorder(new javax.swing.border.TitledBorder("Animation Settings"));
        allMotionsSettings.add(animationSettingsPanel);
        
        snapShotSettingsPanel.setBorder(new javax.swing.border.TitledBorder("Snapshot Settings"));
        snapShotSettingsPanel.setPreferredSize(new java.awt.Dimension(226, 50));
        snapShotSettingsPanel.setMinimumSize(new java.awt.Dimension(161, 40));
        snapShotSettingsPanel.setFont(new java.awt.Font("Dialog", 0, 11));
        snapShotSettingsPanel.setMaximumSize(new java.awt.Dimension(2147483647, 50));
        allMotionsSettings.add(snapShotSettingsPanel);
        
        settingsTabbedPane.addTab("Motion Settings", allMotionsSettings);
        
        add(settingsTabbedPane);
        
        settingsGraphPanel.setBorder(new javax.swing.border.TitledBorder("Motion and Particle Settings"));
        settingsGraphPanel.setPreferredSize(new java.awt.Dimension(500, 400));
        add(settingsGraphPanel);
        
    }//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTabbedPane settingsTabbedPane;
    private javax.swing.JPanel allParticlesPanel;
    private pharynx.ParticleSeriesSettingsPanel particleSeriesSettingsPanel1;
    private pharynx.ParticleSeriesSettingsPanel particleSeriesSettingsPanel2;
    private pharynx.ParticleSeriesSettingsPanel particleSeriesSettingsPanel3;
    private javax.swing.JPanel allMotionsSettings;
    private pharynx.MotionSettingsPanel corpusMotionSettingsPanel;
    private pharynx.MotionSettingsPanel aIsthmusMotionSettingsPanel;
    private pharynx.MotionSettingsPanel pIsthmusMotionSettingsPanel;
    private pharynx.AnimationSettingsPanel animationSettingsPanel;
    private pharynx.SnapShotSettingsPanel snapShotSettingsPanel;
    private pharynx.SettingsGraphPanel settingsGraphPanel;
    // End of variables declaration//GEN-END:variables

}
