/*
 * MotionSettingsPanel.java
 *
 * Created on December 25, 2000, 10:21 AM
 */

package pharynx;
import javax.swing.*;

/**
 *
 * @author  leon
 * @version 
 */
public class MotionSettingsPanel extends javax.swing.JPanel {
    private double start;
    private double peak;
    private double hold;
    private double end;
    private MotionList motion = new MotionList();
    private SimOptions.Updater updater;

    /** Creates new form MotionSettingsPanel
     *
     * This constructor for the sake of the forte GUI editor
     */
    public MotionSettingsPanel() {
        initComponents();
        readOptions();
    }

    /** Creates new form MotionSettingsPanel */
    public MotionSettingsPanel(SimOptions.Updater updater) {
        this.updater = updater;
        initComponents();
        readOptions();
    }

    public void defaultSettings(String start, String peak,
                                String hold, String end) {
        startTextField.setText(start);
        peakTextField.setText(peak);
        holdTextField.setText(hold);
        endTextField.setText(end);
        readOptions();
    }

    private boolean readOptions() {
        try {
            double v = Double.parseDouble(startTextField.getText());
            if (0.0 > v)
                throw new NumberFormatException(
                    "Start time cannot be negative"
                );
            start = v;
            v = Double.parseDouble(peakTextField.getText());
            if (start >= v)
                throw new NumberFormatException(
                    "Peak time must be greater than start time"
                );
            peak = v;
            v = Double.parseDouble(holdTextField.getText());
            if (peak > v)
                throw new NumberFormatException(
                    "Hold to time must not be less than peak time"
                );
            hold = v;
            v = Double.parseDouble(endTextField.getText());
            if (hold >= v)
                throw new NumberFormatException(
                    "End time must be greater than hold to time"
                );
            end = v;
            motion = new MotionList();
            if (start > 0.0) {
                motion.add(new MotionPoint(0.0, 0.0));
            }
            motion.add(new MotionPoint(start, 0.0));
            motion.add(new MotionPoint(peak, 1.0));
            if (hold > peak)
                motion.add(new MotionPoint(hold, 1.0));
            motion.add(new MotionPoint(end, 0.0));
            return true;
        } catch(NumberFormatException e) {
            errorPopup(e);
            return false;
        }
    }

    private void update() {
        if (readOptions() && (null != updater))
            updater.update(null);
    }

    public MotionList getMotion() {
        if (!readOptions())
            throw new InvalidSettingsException();
        return(new MotionList(motion));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        startLabel = new javax.swing.JLabel();
        startTextField = new javax.swing.JTextField();
        peakLabel = new javax.swing.JLabel();
        peakTextField = new javax.swing.JTextField();
        holdLabel = new javax.swing.JLabel();
        holdTextField = new javax.swing.JTextField();
        endLabel = new javax.swing.JLabel();
        endTextField = new javax.swing.JTextField();
        
        setLayout(new java.awt.GridLayout(1, 6));
        
        setPreferredSize(new java.awt.Dimension(400, 70));
        startLabel.setText("Start");
        startLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        add(startLabel);
        
        startTextField.setText("0");
        startTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                startTextFieldActionPerformed(evt);
            }
        });
        
        add(startTextField);
        
        peakLabel.setText("Peak");
        peakLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        add(peakLabel);
        
        peakTextField.setText("167");
        peakTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                peakTextFieldActionPerformed(evt);
            }
        });
        
        add(peakTextField);
        
        holdLabel.setText("Hold to");
        holdLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        add(holdLabel);
        
        holdTextField.setText("167");
        holdTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                holdTextFieldActionPerformed(evt);
            }
        });
        
        add(holdTextField);
        
        endLabel.setText("End");
        endLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        add(endLabel);
        
        endTextField.setText("172");
        endTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                endTextFieldActionPerformed(evt);
            }
        });
        
        add(endTextField);
        
    }//GEN-END:initComponents

    private void holdTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_holdTextFieldActionPerformed
        update();
    }//GEN-LAST:event_holdTextFieldActionPerformed

  private void endTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_endTextFieldActionPerformed
        update();
  }//GEN-LAST:event_endTextFieldActionPerformed

  private void peakTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_peakTextFieldActionPerformed
        update();
  }//GEN-LAST:event_peakTextFieldActionPerformed

  private void startTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_startTextFieldActionPerformed
        update();
  }//GEN-LAST:event_startTextFieldActionPerformed

    private void errorPopup(Exception e) {
        JOptionPane.showMessageDialog(null, e, "Motion Settings Error",
                                      JOptionPane.ERROR_MESSAGE);
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel startLabel;
    javax.swing.JTextField startTextField;
    private javax.swing.JLabel peakLabel;
    javax.swing.JTextField peakTextField;
    private javax.swing.JLabel holdLabel;
    javax.swing.JTextField holdTextField;
    private javax.swing.JLabel endLabel;
    javax.swing.JTextField endTextField;
    // End of variables declaration//GEN-END:variables

}
