/*
 * ParticleGraphPanel.java
 *
 * Created on December 25, 2000, 4:43 PM
 */

package pharynx;
import java.util.*;
import java.awt.*;
import java.awt.geom.*;

/**
 *
 * @author  leon
 * @version 
 */
public class ParticleGraphPanel extends javax.swing.JPanel {
    private ParticleSeries ps = new ParticleSeries();
    private double maxT = 1000.0;
    private static final double INDENT = 10.0;

    /** Creates new form ParticleGraphPanel */
    public ParticleGraphPanel() {
        initComponents ();
    }

    public void display(ParticleSeries ps, double maxT) {
        this.ps = ps;
        this.maxT = maxT;
        repaint();
    }

    protected void paintComponent(Graphics g) {
        if (0.0 >= maxT) return;
        Graphics2D g2 = (Graphics2D) g;
        double pw = (double) getSize().width;
        double ph = (double) getSize().height;
        double gw = (pw - 2 * INDENT);
        double scale = gw / (2 * maxT);
        g2.setColor(Color.blue);
        g2.fillRect(0, 0, (int) Math.round(pw), (int) Math.round(ph));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                            RenderingHints.VALUE_ANTIALIAS_ON);
        g2.translate(INDENT, ph/2);
        g2.setColor(ps.color);
        AffineTransform tx = g2.getTransform();
        double t = ps.startTime;
        for(int i = 0; i < ps.n; i++) {
            g2.setTransform(tx);
            double x = t * scale;
            if (x > gw) break;
            g2.translate(x, 0);
            g2.fill(ps.shape);
            t += ps.interval;
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        setPreferredSize(new java.awt.Dimension(10, 30));
    }//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables

}
