/*
 * ParticleSeriesSettingsPanel.java
 *
 * Created on December 25, 2000, 10:34 AM
 */

package pharynx;
import java.awt.*;
import javax.swing.*;

/**
 *
 * @author  leon@eatworms.swmed.edu
 * @version 0.1
 */

public class ParticleSeriesSettingsPanel extends javax.swing.JPanel {
    ParticleSeries ps = new ParticleSeries();
    SimOptions.Updater updater;

    /** Creates new form ParticleSeriesSettingsPanel
     *
     * This constructor for the sake of the forte GUI editor
     */
    public ParticleSeriesSettingsPanel() {
        initComponents();
        readOptions();
    }

    /** Creates new form ParticleSeriesSettingsPanel */
    public ParticleSeriesSettingsPanel(SimOptions.Updater updater) {
        this.updater = updater;
        initComponents();
        readOptions();
    }

    public void defaultSettings(ParticleSeries ps) {
        accelerationTextField.setText(Double.toString(ps.acceleration));
        diameterTextField.setText(Double.toString(ps.getDiameter()));
        intervalTextField.setText(Double.toString(ps.interval));
        startTimeTextField.setText(Double.toString(ps.startTime));
        startXTextField.setText(Double.toString(ps.startX));
        typeComboBox.setSelectedIndex(ps.type);
        nTextField.setText(Integer.toString(ps.n));
        setColor(ps.color);
        readOptions();
    }

    private boolean readOptions() {
        try {
            ps.acceleration =
                Double.parseDouble(accelerationTextField.getText());
            ps.setDiameter(Double.parseDouble(diameterTextField.getText()));
            ps.interval = Double.parseDouble(intervalTextField.getText());
            ps.startTime = Double.parseDouble(startTimeTextField.getText());
            ps.startX = Double.parseDouble(startXTextField.getText());
            String s = (String) typeComboBox.getSelectedItem();
            ps.type = ps.parseType(s);
            ps.n = Integer.parseInt(nTextField.getText());
            ps.color = colorButton.getBackground();
            return true;
        } catch(NumberFormatException e) {
            errorPopup(e);
            return false;
        }
    }

    private void update() {
        if (readOptions() && (null != updater))
            updater.update(null);
    }

    public ParticleSeries getps() {
        if (!readOptions())
            throw new InvalidSettingsException();
        return ps;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        colorLabel = new javax.swing.JLabel();
        colorButton = new javax.swing.JButton();
        typeLabel = new javax.swing.JLabel();
        typeComboBox = new javax.swing.JComboBox(ParticleSeries.particleTypeList);

        diameterLabel = new javax.swing.JLabel();
        diameterTextField = new javax.swing.JTextField();
        nLabel = new javax.swing.JLabel();
        nTextField = new javax.swing.JTextField();
        startXLabel = new javax.swing.JLabel();
        startXTextField = new javax.swing.JTextField();
        startTimeLabel = new javax.swing.JLabel();
        startTimeTextField = new javax.swing.JTextField();
        intervalLabel = new javax.swing.JLabel();
        intervalTextField = new javax.swing.JTextField();
        accelerationLabel = new javax.swing.JLabel();
        accelerationTextField = new javax.swing.JTextField();

        setLayout(new java.awt.GridLayout(2, 8));

        setMinimumSize(new java.awt.Dimension(400, 70));
        setPreferredSize(new java.awt.Dimension(400, 70));
        colorLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        colorLabel.setText("Color");
        add(colorLabel);

        setColor(ps.color);
        colorButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chooseColor(evt);
            }
        });

        add(colorButton);

        typeLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        typeLabel.setText("Type");
        add(typeLabel);

        typeComboBox.setName("type");
        typeComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                typeComboBoxActionPerformed(evt);
            }
        });

        add(typeComboBox);

        diameterLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        diameterLabel.setText("Diameter");
        add(diameterLabel);

        diameterTextField.setText("12");
        diameterTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                diameterTextFieldActionPerformed(evt);
            }
        });

        add(diameterTextField);

        nLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        nLabel.setText("Number");
        add(nLabel);

        nTextField.setText("5");
        nTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                nTextFieldActionPerformed(evt);
            }
        });

        add(nTextField);

        startXLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        startXLabel.setText("Place at");
        add(startXLabel);

        startXTextField.setText("0");
        startXTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                startXTextFieldActionPerformed(evt);
            }
        });

        add(startXTextField);

        startTimeLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        startTimeLabel.setText("Start");
        add(startTimeLabel);

        startTimeTextField.setText("0");
        startTimeTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                startTimeTextFieldActionPerformed(evt);
            }
        });

        add(startTimeTextField);

        intervalLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        intervalLabel.setText("Interval");
        add(intervalLabel);

        intervalTextField.setText("50");
        intervalTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                intervalTextFieldActionPerformed(evt);
            }
        });

        add(intervalTextField);

        accelerationLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        accelerationLabel.setText("Acceleration");
        add(accelerationLabel);

        accelerationTextField.setText("1");
        accelerationTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                accelerationTextFieldActionPerformed(evt);
            }
        });

        add(accelerationTextField);

    }//GEN-END:initComponents

  private void accelerationTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_accelerationTextFieldActionPerformed
        update();
  }//GEN-LAST:event_accelerationTextFieldActionPerformed

  private void intervalTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_intervalTextFieldActionPerformed
        update();
  }//GEN-LAST:event_intervalTextFieldActionPerformed

  private void startTimeTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_startTimeTextFieldActionPerformed
        update();
  }//GEN-LAST:event_startTimeTextFieldActionPerformed

  private void startXTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_startXTextFieldActionPerformed
        update();
  }//GEN-LAST:event_startXTextFieldActionPerformed

  private void nTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nTextFieldActionPerformed
        update();
  }//GEN-LAST:event_nTextFieldActionPerformed

  private void diameterTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_diameterTextFieldActionPerformed
        update();
  }//GEN-LAST:event_diameterTextFieldActionPerformed

  private void typeComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_typeComboBoxActionPerformed
        update();
  }//GEN-LAST:event_typeComboBoxActionPerformed

  private void chooseColor(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chooseColor
        Color newColor = JColorChooser.showDialog(this, "Particle Color",
                                                  ps.color);
        if (null == newColor) return;
        setColor(newColor);
        update();
  }//GEN-LAST:event_chooseColor

    private void setColor(Color c) {
        ps.color = c;
        colorButton.setBackground(c);
    }

    private void errorPopup(Exception e) {
        JOptionPane.showMessageDialog(null, e, "Particle Series Error",
                                      JOptionPane.ERROR_MESSAGE);
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel accelerationLabel;
    private javax.swing.JButton colorButton;
    private javax.swing.JLabel startTimeLabel;
    private javax.swing.JTextField startTimeTextField;
    private javax.swing.JLabel colorLabel;
    private javax.swing.JTextField startXTextField;
    private javax.swing.JTextField diameterTextField;
    private javax.swing.JTextField accelerationTextField;
    private javax.swing.JLabel intervalLabel;
    private javax.swing.JTextField intervalTextField;
    private javax.swing.JTextField nTextField;
    private javax.swing.JLabel nLabel;
    private javax.swing.JLabel diameterLabel;
    private javax.swing.JComboBox typeComboBox;
    private javax.swing.JLabel typeLabel;
    private javax.swing.JLabel startXLabel;
    // End of variables declaration//GEN-END:variables

}
