/*----------------------------------------------------------------
$Header$
hugrea.asc  translated Mon Jan 18 11:58:56 1993 by ntscable 2.0
source file syntax: Eutectic
output file syntax: NEURON
soma: diameter = 14.0754 um  length = 34.5468 um  area = 1527.62 um2
      33 three-D points; 38 outline points numbered 634-671
      outline diameter = 22.323 um
4 primary neurites
42 branches totaling 3785.29 um in length, 13302.9 um2 in area
1416 tree points translated to 81 segments (1 requested)
Neurites divided into segments of equal dx between adjacent digitized
branch points.
Segment length constrained to be < 3785.29 um.
No. points   1454
No. trees       5

Thalamic reticular cell, from the reticular sector of rat ventrobasal nucleus.

This cell was recorded intracellularly in slices and stained with biocytin. 
The physiology of that cell is described in:

 Huguenard, JR and Prince, DA. A novel T-type current undelies prolonged
 calcium-dependent burst firing in GABAergic neurons of rat thalamic reticular
 nucleus.  J. Neurosci. 12: 3804-3817, 1992.

 http://www.cnl.salk.edu/~alain
 http://cns.fmed.ulaval.ca

The cell was traced in December 1992 by A. Destexhe using a computer-guided
neuronal tracing system (Eutectic), kindly provided by D. Amaral (Salk
Institute).  The tracing was done using a x100 oil immersion objective and the
geometry was corrected for tissue shrinkage. The morphological characteristics
of the cellular reconstruction, the passive properties of the cell and the
modeling of that cell were described in:

 Destexhe, A., Contreras, D., Steriade, M., Sejnowski, T.J. and Huguenard, J.R.
 In vivo, in vitro and computational analysis of dendritic calcium currents in
 thalamic reticular neurons.  J. Neurosci. 16: 169-185, 1996.

This geometry can be used by anyone interested, under the only condition that
the two above papers are cited.  Please also send us a copy of publications
that use that cell as courtesy.

A. Destexhe, Salk Institute, 1994

----------------------------------------------------------------*/

					/* make geometry explicit */
primary_branches_cell = 4
branches_cell = 42
max_dx_cell = 3785.29
points_cell = 1416
nseg_cell = 81
double sections_cell[4]
sections_cell[0] = 43
sections_cell[1] = 15
sections_cell[2] = 19
sections_cell[3] = 3
nsec_cell = 81

strdef name_soma, name_section
name_soma = "soma"
name_section = "dend"
use_axon = 0					/* create sections */
create    soma,\
          dend1[43],\
          dend2[15],\
          dend3[19],\
          dend4[3]



/*----------------------------------------------------------------*/
proc geometry() { local i, j

						/* soma geometry */
    soma {
        nseg = 1
        pt3dclear()
        for j = 1, fscan() {
            pt3dadd(fscan(),fscan(),fscan(),fscan())
        }
    }

					/* connect primary neurites */
    soma connect dend1[0] (0), 0.5
    soma connect dend2[0] (0), 0.5
    soma connect dend3[0] (0), 0.5
    soma connect dend4[0] (0), 0.5


					/* neurite geometry*/
    for i = 0,42 {
        dend1[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,14 {
        dend2[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,18 {
        dend3[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,2 {
        dend4[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }



					/* branching topology*/
    for i = 1,42 {
        dend1[fscan()] connect dend1[i] (0), fscan()
    }

    for i = 1,14 {
        dend2[fscan()] connect dend2[i] (0), fscan()
    }

    for i = 1,18 {
        dend3[fscan()] connect dend3[i] (0), fscan()
    }

    for i = 1,2 {
        dend4[fscan()] connect dend4[i] (0), fscan()
    }

}

geometry()


SOMA COORDINATES AND DIAMETERS:

    33
     -26      1.5     16.5        0
     -26     0.75     17.5      2.5
   -25.5        1       18        5
     -25    0.625       19   8.0039
   -24.5     0.25       19   9.8615
   -23.5    -0.25       19    11.63
   -22.5     -0.5   18.833   12.875
     -22   -0.625    18.75   13.521
   -20.5    -1.25    18.75    16.14
   -18.5    -1.35    18.75   18.263
     -18  -1.4375    18.75   18.675
   -16.5     -1.5   18.625    19.47
     -15    -1.75     18.5   19.906
   -14.5  -1.7917     18.5   19.988
     -13  -1.9167     20.5   19.833
     -12       -2       21   20.025
   -11.5    -1.75    21.75   20.555
     -10     -1.5    20.75    21.29
    -8.5  -1.4375       21   20.519
      -8  -1.4167       21   20.233
      -7     -1.5       21   19.416
      -6    -1.25     20.5   17.755
    -5.5    -1.25   20.167   16.714
    -4.5  -1.4167       20   15.134
      -4     -1.5   19.917   14.354
      -3  -1.3333    19.75    12.18
    -2.5   -1.375    19.75   10.831
      -2    -1.25       20   9.3941
      -2    -1.25       21   8.7321
    -1.5       -2    22.25   5.0249
    -1.5       -1       23   3.6056
    -1.5    -0.25     22.5   1.8028
    -1.5      0.5       22        0


NEURITE COORDINATES AND DIAMETERS:

    1 2
      -3        7       -6        7
    -5.5        6       -6        7

    1 13
    -5.5        6       -6        7
    -5.5      3.5       -6      6.4
      -6      1.5       -6      5.5
      -7     -0.5     -6.5      5.3
      -8       -2       -7      4.5
      -9     -3.5     -7.5      4.3
     -10     -5.5       -7      4.3
     -11     -7.5     -6.5      4.3
     -12       -9       -6      4.3
     -13      -11     -6.5      4.3
   -14.5    -12.5       -7      4.3
   -16.5      -14       -8        4
   -18.5    -15.5     -8.5      4.6

    1 9
   -18.5    -15.5     -8.5      4.6
   -20.5    -15.5      -11      3.5
     -23      -16      -13      3.5
     -24      -17      -16      3.5
     -24      -18    -20.5      3.5
   -22.5      -19    -25.5      3.5
   -22.5    -20.5    -29.5      3.5
   -23.5      -21    -32.5      3.5
     -25      -22    -35.5      3.5

    1 38
     -25      -22    -35.5      3.5
     -25    -23.5    -33.5      2.9
   -25.5      -25    -32.5      2.9
     -26      -27      -33      2.9
   -27.5    -28.5      -33      2.9
   -28.5      -30    -34.5      2.9
     -30    -31.5      -35      2.9
   -30.5      -33      -36        2
     -31      -34    -36.5        2
   -31.5    -35.5    -37.5      1.6
     -32      -37      -37      1.6
   -32.5    -38.5      -37        2
   -32.5      -40      -37      2.2
   -32.5    -41.5    -37.5      2.2
   -32.5      -43    -37.5      2.2
   -32.5    -44.5    -36.5      2.2
   -32.5      -46      -36        2
     -33    -47.5    -35.5      1.6
     -33      -49      -35      2.2
     -33    -50.5      -35      2.2
   -33.5      -52    -35.5      2.2
   -33.5      -54      -36      2.2
   -33.5    -55.5      -35      2.2
   -33.5    -57.5    -34.5      2.2
   -33.5      -59      -34      1.7
     -33    -60.5      -34        2
   -32.5    -62.5      -34      2.2
     -31    -64.5      -34      2.2
   -29.5      -66      -34      2.2
     -28      -68      -34      2.2
     -27      -69      -34      2.2
     -26    -70.5      -34      2.2
     -25      -72      -34      2.2
     -24    -73.5    -34.5      1.7
     -23      -75      -35      1.7
     -22    -76.5    -35.5      1.7
   -21.5    -78.5    -35.5      2.4
   -21.5      -80    -35.5      3.7

    1 4
   -21.5      -80    -35.5      3.7
   -19.5      -81    -35.5      2.2
     -18    -82.5    -35.5      2.2
   -16.5    -84.5    -36.5      2.2

    1 33
   -16.5    -84.5    -36.5      2.2
     -15    -84.5      -33      1.2
     -14    -84.5    -29.5        1
   -12.5      -85    -27.5        1
   -11.5    -86.5      -26        1
   -10.5    -88.5      -26        1
     -10      -91      -24        1
    -9.5    -93.5    -22.5        1
    -8.5      -96    -21.5        1
      -8      -98      -20        1
    -6.5      -99      -19      0.8
    -5.5      -99      -18      0.8
    -4.5    -98.5      -18      0.8
    -3.5      -98    -17.5      0.8
    -2.5      -97      -17        1
      -1    -96.5    -16.5        1
     0.5      -96    -16.5        1
     2.5    -95.5    -16.5      0.6
       4    -94.5    -15.5      0.6
       6      -94    -14.5      0.6
     7.5    -93.5    -13.5      1.1
     9.5    -93.5      -12        1
      11      -94      -11        1
      13      -94     -9.5        1
      15      -94     -8.5        1
    16.5      -94     -8.5      1.6
      18      -94     -7.5      0.8
      20      -94     -6.5      0.8
      22      -94       -6      0.8
    24.5    -93.5       -6      0.8
    26.5    -93.5       -6      0.8
    28.5      -93       -6      0.8
      30    -92.5       -6      0.8

    1 8
   -16.5    -84.5    -36.5      2.2
   -16.5      -86    -32.5      1.2
     -16    -87.5    -30.5      1.2
     -15      -89    -30.5      1.2
     -14    -90.5    -30.5      1.2
     -13      -92    -30.5      1.2
   -12.5      -93    -30.5      1.7
   -11.5    -94.5    -30.5      1.7

    1 43
   -11.5    -94.5    -30.5      1.7
   -10.5    -93.5      -28        1
    -9.5      -92      -26        1
      -9      -91    -25.5        1
    -7.5    -89.5      -25        1
      -6    -88.5    -25.5        1
    -4.5    -87.5      -25        1
    -2.5      -86    -24.5        1
      -1    -84.5      -22        1
     0.5      -84    -19.5        1
       1    -83.5    -15.5        1
       3    -82.5      -11        1
     4.5      -81     -7.5        1
       7      -80       -6      0.6
     8.5      -79       -6      0.6
      10      -78       -6      0.6
      11      -77       -6      0.6
    11.5    -75.5       -6      0.6
      13      -74     -5.5      1.2
    14.5    -72.5       -5      0.8
    16.5      -71       -4      0.8
      19      -69       -4      0.8
    21.5    -67.5       -5      0.8
      24    -66.5       -5      0.8
    26.5    -66.5     -3.5        1
      29    -66.5     -1.5        1
      31      -66        0        1
      33      -65      0.5        1
    34.5    -64.5        1        1
    36.5    -63.5      1.5        1
    38.5      -62      1.5        1
      40    -60.5        2        1
      41    -59.5        3      1.2
      41    -58.5        5      0.8
      41      -58      7.5      0.8
    40.5      -57       11      0.8
      40    -55.5       14      0.8
      40    -54.5       16      0.8
      41    -54.5     17.5      0.8
      42      -55       19      0.8
      43    -55.5     20.5      0.8
      45      -55     22.5      0.8
      47      -54     23.5      0.5

    1 34
   -11.5    -94.5    -30.5      1.7
     -12      -95    -31.5      1.7
   -12.5      -96      -32      1.5
     -12    -97.5    -31.5      0.8
     -12      -99      -30      0.8
     -11     -101    -28.5      0.8
   -10.5     -103    -28.5      0.8
   -10.5     -104    -28.5      0.8
     -11   -105.5    -27.5      0.8
     -12     -107    -26.5      0.8
   -12.5   -108.5      -25      0.8
   -12.5     -110      -24      0.8
   -12.5   -111.5      -23      0.8
   -12.5   -113.5      -23      0.8
   -12.5     -115    -24.5      0.8
   -11.5     -117    -23.5      0.8
   -10.5     -119    -22.5      0.8
     -10     -121      -21      0.8
    -8.5   -123.5    -21.5      0.8
      -7     -126      -22      0.8
    -5.5     -128      -24      1.5
    -4.5     -129    -24.5      1.5
    -3.5   -130.5      -25      0.6
      -2   -132.5      -25      0.6
      -1     -135      -25      0.6
       0   -137.5      -26      0.6
     0.5   -139.5      -26      0.6
       2   -142.5      -26      0.6
       3     -146    -25.5      0.6
     4.5   -149.5      -25      0.6
     5.5     -152      -23      0.6
       7     -154    -22.5      0.6
     8.5   -155.5    -21.5        2
     9.5     -157    -22.5      1.7

    1 23
     9.5     -157    -22.5      1.7
     5.5     -158      -21        1
       3     -161      -20        1
       1     -164    -20.5        1
     0.5     -168      -22        1
       0   -172.5      -25        1
       0     -177      -28        1
       0   -181.5    -30.5        1
       0   -185.5    -33.5        1
      -2   -190.5    -33.5        1
      -6   -195.5      -34        1
   -11.5     -201    -34.5        1
     -16     -208      -37        1
     -19   -214.5    -40.5        1
     -20   -221.5      -43        1
   -20.5     -227    -44.5        1
     -22   -232.5      -47        1
     -24     -237      -51        1
   -27.5     -242      -56        1
   -31.5     -248    -60.5        1
     -35   -253.5    -63.5        1
     -39     -258    -65.5        1
     -43   -260.5      -67        1

    1 5
     9.5     -157    -22.5      1.7
     9.5     -160      -21        1
       9   -162.5    -21.5        1
       9     -165    -22.5        1
     9.5     -168    -23.5        1

    1 6
     9.5     -168    -23.5        1
      12   -169.5    -22.5      0.6
    14.5   -171.5    -22.5      0.6
    15.5   -174.5    -23.5      0.6
    16.5   -176.5    -23.5      0.6
    17.5     -179    -23.5      0.6

    1 38
     9.5     -168    -23.5        1
       9     -171    -24.5      0.8
     8.5   -174.5    -26.5      0.8
       9     -178    -27.5      0.8
     8.5     -180    -28.5      0.8
       8   -181.5    -28.5      0.8
       7   -183.5      -29      0.8
       6   -186.5    -29.5      0.8
       5     -189      -30      0.8
       3     -192    -31.5      0.8
       2     -195    -34.5      0.8
       2   -198.5      -36      0.8
       2     -203    -37.5      0.8
     2.5     -207    -37.5      0.8
     1.5     -211    -37.5      0.8
       0   -214.5    -37.5      0.8
      -1   -217.5    -37.5      0.8
    -3.5     -220    -36.5      0.8
    -6.5     -223      -36      0.8
    -9.5   -225.5    -33.5      0.8
   -10.5     -227    -31.5      0.8
    -8.5     -227    -29.5      0.8
      -6     -228      -28      0.8
      -3   -229.5      -26      0.8
    -0.5     -232    -23.5      0.8
     0.5   -234.5    -23.5      0.8
       1     -237    -25.5      0.8
       1     -240    -28.5      0.8
     0.5   -243.5    -29.5      0.8
       0     -247    -30.5      0.8
       0     -250      -33      0.8
    -0.5     -253    -36.5      0.8
    -0.5   -255.5    -38.5      0.8
    -0.5   -258.5      -39      0.8
       0     -261      -39      0.8
     0.5     -264    -38.5      0.8
     1.5     -267    -38.5      0.8
       2     -270      -40      0.8

    1 7
   -21.5      -80    -35.5      3.7
   -22.5      -81    -35.5        2
     -23      -83    -36.5      1.5
     -23      -85      -38      0.8
   -22.5    -87.5    -39.5      0.8
   -22.5      -90      -40      0.8
   -22.5    -92.5      -40        2

    1 20
   -22.5    -92.5      -40        2
     -21    -93.5    -39.5        1
     -20    -94.5      -40        1
   -18.5    -96.5    -42.5        1
     -17      -99    -45.5        1
     -16   -101.5    -48.5        1
   -15.5   -104.5    -48.5        1
     -16   -107.5    -48.5        1
   -16.5   -110.5      -48        1
   -17.5     -114    -48.5        1
     -18   -117.5      -49        1
   -18.5     -121      -50        1
   -19.5     -124    -52.5        1
   -20.5     -127    -55.5      0.8
   -21.5     -130      -58      0.8
     -22   -133.5    -58.5      0.8
   -22.5     -137      -59      0.8
   -22.5     -140      -60      0.8
   -22.5     -143    -60.5      0.8
     -23   -146.5      -60      0.8

    1 24
   -22.5    -92.5      -40        2
   -23.5      -93    -40.5      0.8
     -24      -94    -42.5      0.8
   -24.5    -95.5      -46      0.8
   -24.5    -97.5      -48      0.8
   -24.5     -100    -49.5      0.8
   -25.5   -102.5    -49.5      0.8
   -26.5     -105    -49.5      0.8
   -27.5   -107.5    -49.5      0.8
   -28.5     -110      -51      0.8
     -30   -112.5      -53      0.8
   -31.5     -115      -56      0.8
     -34     -118      -59      0.8
     -37     -121    -62.5      0.8
   -39.5   -124.5    -66.5      0.8
     -42     -127    -69.5      0.8
   -43.5   -129.5      -70      0.8
   -45.5     -132    -70.5      0.8
   -46.5   -135.5    -70.5      0.8
   -47.5   -138.5    -71.5      0.8
   -48.5     -142      -72      0.8
     -49     -145      -73      0.8
     -50     -148      -74      0.8
     -51   -151.5      -74      0.8

    1 11
     -25      -22    -35.5      3.5
     -27      -22    -35.5      1.7
   -29.5    -22.5    -35.5      1.7
   -31.5    -23.5      -37      1.7
     -33    -23.5      -39      1.7
     -34    -21.5      -42      1.7
     -35    -19.5    -43.5      1.7
   -36.5    -17.5    -44.5      1.7
   -38.5      -16    -46.5      1.7
     -40      -15    -48.5      1.7
     -41      -14    -50.5      1.7

    1 9
     -41      -14    -50.5      1.7
     -39    -12.5    -50.5      1.1
   -37.5      -11      -50      1.1
   -35.5       -9    -49.5      1.1
   -34.5       -7    -49.5      1.1
   -33.5     -4.5    -49.5      1.1
     -33       -2    -49.5      1.1
   -32.5      0.5      -49      1.1
     -33        4      -47      1.1

    1 12
     -41      -14    -50.5      1.7
     -42      -16    -51.5      1.1
     -43      -17      -53        1
   -44.5      -16    -54.5      1.1
     -46      -15      -57      1.1
   -47.5      -14      -58      1.1
     -48    -12.5      -60      1.1
   -47.5    -10.5    -61.5      1.1
     -47    -10.5      -65      1.1
     -47      -12      -68      1.1
   -49.5    -15.5      -71      1.1
   -52.5      -19    -72.5      1.1

    1 18
   -18.5    -15.5     -8.5      4.6
   -18.5      -17     -8.5      3.5
   -18.5    -18.5     -8.5        2
   -18.5      -20       -7      1.7
   -18.5      -22     -7.5      1.7
   -17.5      -24     -7.5      1.7
   -16.5      -26       -9      1.7
     -15      -28      -10      1.7
     -13      -30      -11      1.7
   -10.5    -31.5    -11.5      1.7
    -7.5    -32.5      -12      1.7
      -5      -34      -12      1.7
    -2.5    -35.5      -13      1.7
    -0.5    -37.5      -14      1.7
       1    -39.5    -15.5      1.2
       2    -41.5    -15.5      1.2
       3      -44    -15.5      1.2
       4      -47    -15.5      1.7

    1 37
       4      -47    -15.5      1.7
     2.5    -47.5      -16      1.2
       1    -48.5    -17.5      1.2
       0      -50      -18      1.2
       0      -51    -19.5      1.2
       0    -52.5    -19.5      1.2
       0      -53      -20      0.8
       0      -54      -20      0.8
      -1      -55      -21      0.8
      -3    -55.5      -21      0.8
      -5    -56.5    -23.5      0.8
    -5.5    -57.5      -26      0.8
      -6    -59.5      -29      0.8
      -7      -62    -29.5      0.8
    -8.5    -64.5    -29.5      0.8
    -9.5    -67.5    -31.5      0.8
   -10.5    -69.5    -34.5      0.8
     -11      -72      -37      0.8
     -12      -74      -39      0.8
     -13    -76.5      -39      0.8
     -14    -78.5    -40.5      0.8
     -14      -81      -41        1
   -13.5    -83.5      -42        1
   -13.5      -86    -41.5      1.5
     -14      -88      -42      0.8
   -14.5    -90.5      -43      0.8
     -15      -93    -46.5      0.8
   -15.5    -95.5    -48.5      0.8
   -16.5    -98.5      -52      0.8
     -18     -103      -56      0.8
   -19.5   -108.5    -59.5      0.8
     -21   -113.5    -64.5      0.8
     -23     -117    -66.5      0.8
     -25   -120.5    -67.5      0.8
   -26.5   -124.5    -67.5      0.8
     -27     -128      -66      0.8
   -27.5     -131    -64.5      0.8

    1 42
       4      -47    -15.5      1.7
       5    -47.5      -14      1.1
       6      -49      -13      1.1
       7      -51      -12      1.1
     6.5      -54      -12      1.1
       6    -56.5    -10.5      1.1
       7    -59.5       -9      1.1
       7      -61       -9      0.8
       6    -62.5    -10.5        1
       4    -63.5      -13        1
       2      -65      -14        1
     0.5      -67      -15        1
       0    -69.5    -15.5        1
    -0.5    -71.5    -17.5        1
      -1    -72.5    -18.5        1
      -2    -73.5    -20.5        1
    -2.5      -74    -20.5      0.6
    -2.5      -75    -20.5      0.6
    -2.5    -76.5    -20.5      0.6
      -4      -78    -21.5        1
      -4      -80      -23        1
      -4      -82      -24        1
      -4      -84      -25        1
      -4    -86.5      -24        1
      -4    -88.5    -24.5        1
      -4    -91.5    -24.5        1
      -5      -94      -26        1
    -6.5    -96.5      -26        1
      -8      -99    -23.5        1
    -9.5   -101.5      -22        1
   -11.5     -104      -21        1
   -14.5   -106.5      -23        1
   -17.5     -109    -24.5        1
   -20.5   -111.5      -26        1
     -23   -114.5    -27.5        1
   -25.5   -118.5    -30.5        1
     -28   -122.5      -35        1
   -30.5     -128      -38        1
     -31     -133      -40        1
   -31.5   -138.5    -40.5        1
     -32     -143    -41.5        1
   -33.5   -146.5    -42.5        1

    1 12
    -5.5        6       -6        7
      -8        6       -6        5
   -10.5      6.5       -6      2.7
     -13        8       -6      3.5
   -15.5       10     -6.5      3.5
     -18     12.5     -7.5      3.2
   -20.5       16     -8.5      3.2
     -23     19.5     -8.5      3.2
   -25.5     23.5     -8.5      2.2
     -28     26.5     -8.5      2.2
   -30.5     29.5       -9      2.7
     -33       32     -9.5      2.7

    1 32
     -33       32     -9.5      2.7
     -34     31.5    -12.5      2.5
   -35.5     30.5    -14.5        2
     -37       30    -14.5        2
     -39       29    -14.5        2
   -40.5     27.5      -15        2
     -42     26.5      -16        2
   -43.5     24.5    -17.5        2
   -45.5       23    -19.5        2
   -47.5       21    -19.5        2
   -49.5     19.5      -20        2
     -51       18    -21.5        2
     -52       17      -25      1.2
     -53     15.5      -27      1.2
   -53.5       14      -28      1.2
   -54.5     12.5    -28.5      1.2
     -56       11    -29.5      1.2
   -57.5      9.5      -30      1.2
     -59        8      -31      1.2
     -60      6.5      -32      1.2
   -61.5      5.5      -33      1.2
   -62.5      4.5    -34.5      1.2
     -64        4    -35.5      1.2
   -65.5        3    -36.5      1.2
   -66.5        2    -36.5      1.2
   -67.5        1    -38.5      1.6
   -69.5      0.5    -40.5      1.6
   -71.5        0      -42      1.6
   -73.5     -0.5    -41.5      1.6
     -75     -0.5    -41.5      1.6
     -76       -1      -42      1.6
     -77     -2.5    -42.5        2

    1 21
     -77     -2.5    -42.5        2
     -76       -3    -44.5      1.5
     -75     -3.5      -46      1.5
     -74       -5      -47      1.5
   -74.5       -6    -47.5      1.5
     -75     -7.5    -49.5      0.5
     -75       -8    -52.5      1.1
   -74.5       -8      -55      0.4
     -74       -7      -58      0.8
     -74     -5.5      -60      0.8
     -75     -3.5      -63      0.8
     -75     -1.5      -65      0.8
   -75.5        0      -66      0.8
     -76      1.5    -66.5      0.8
   -76.5        3    -66.5      0.8
     -77      3.5    -69.5      0.8
     -78        4      -72      0.8
   -79.5      4.5      -74      0.6
     -81      5.5      -74      0.6
     -82        7      -74      0.6
   -82.5      8.5      -75      0.8

    1 8
     -77     -2.5    -42.5        2
     -78       -3    -44.5      0.6
   -79.5     -3.5      -46      0.6
     -81     -3.5      -46      0.6
     -82     -2.5    -47.5      1.2
   -83.5     -2.5    -49.5      1.2
   -84.5     -2.5      -52      1.2
     -86     -2.5      -53      1.6

    1 5
     -86     -2.5      -53      1.6
     -88       -4    -53.5      0.6
     -90     -5.5      -54      1.7
     -92       -7    -55.5      0.8
     -94     -8.5    -56.5      0.8

    1 4
     -94     -8.5    -56.5      0.8
   -94.5      -10    -56.5      0.8
     -95    -11.5    -55.5      0.8
   -95.5      -13      -54      1.2

    1 7
     -94     -8.5    -56.5      0.8
   -95.5       -8    -56.5      0.6
   -97.5     -7.5    -56.5      0.6
   -99.5     -7.5    -57.5      0.6
    -101     -6.5      -58      0.6
    -102       -6      -59      0.6
    -103       -5    -58.5      1.2

    1 6
     -86     -2.5      -53      1.6
     -88     -2.5      -53      0.8
   -90.5       -3      -53      0.8
   -93.5     -2.5      -54      0.8
   -96.5     -2.5    -55.5      0.5
   -99.5       -2    -57.5      1.2

    1 3
   -99.5       -2    -57.5      1.2
     -99     -3.5    -55.5      0.5
   -98.5       -5      -55        1

    1 11
   -99.5       -2    -57.5      1.2
    -101       -2    -57.5      0.6
    -103     -2.5    -57.5      1.2
  -104.5       -3    -57.5      0.5
  -106.5     -3.5      -57        1
  -108.5       -5      -58        1
    -111       -7      -61        1
  -113.5       -9    -64.5        1
    -116    -10.5      -68        1
  -118.5      -11    -69.5        1
    -122    -12.5    -70.5      1.7

    1 7
    -122    -12.5    -70.5      1.7
  -124.5    -13.5      -71      0.8
    -127    -15.5    -73.5      0.8
    -130    -16.5    -75.5      0.8
  -131.5    -16.5    -78.5      0.8
    -132    -14.5      -79      0.8
    -133      -12    -78.5      0.8

    1 7
    -122    -12.5    -70.5      1.7
  -119.5      -10    -71.5      0.8
    -117     -7.5      -72      0.8
    -114       -5    -71.5      0.8
    -110     -2.5    -71.5      0.8
  -106.5       -1      -70      0.8
  -103.5     -0.5      -67        2

    1 14
     -33       32     -9.5      2.7
   -32.5       34      -11      2.5
     -33       36    -12.5      1.6
   -33.5       38    -14.5      1.6
   -34.5     40.5    -14.5      2.2
     -36       43      -14      2.2
     -37       46      -13      1.1
     -38     48.5      -12      1.1
     -40       52    -11.5      1.1
   -42.5       55      -11      1.1
     -45       58      -11      1.1
   -46.5     60.5      -11      1.1
     -48       62    -11.5        2
     -49     63.5      -13        2

    1 19
     -49     63.5      -13        2
   -48.5       65      -13      1.1
     -49     67.5    -13.5      1.1
   -48.5       70    -12.5      1.1
     -48     72.5      -12      1.1
   -47.5     74.5     -9.5      1.1
   -46.5     76.5     -8.5      0.5
   -46.5     78.5     -7.5      0.5
   -46.5     80.5     -7.5      1.1
     -46     82.5     -7.5      1.1
   -45.5     84.5       -7      0.5
   -44.5     86.5     -6.5      0.6
   -43.5       89     -6.5      0.6
   -42.5       91       -7      1.5
     -42       93       -8      0.5
   -40.5     94.5     -8.5      0.5
     -39     96.5     -8.5      1.2
     -37       98     -7.5      1.2
   -34.5      100       -6        2

    1 5
     -49     63.5      -13        2
   -50.5       64      -13        2
     -52     65.5      -12      1.6
   -53.5       67      -12      1.6
   -54.5       69      -12      1.6

    1 4
   -54.5       69      -12      1.6
   -57.5       69     -8.5      0.6
     -60     69.5     -6.5      0.6
   -62.5       70       -6      0.6

    1 15
   -62.5       70       -6      0.6
     -61     71.5       -6        1
   -59.5       72       -6        1
     -59     72.5     -5.5      1.6
   -59.5     73.5       -5      0.8
   -61.5     75.5       -4      0.8
   -62.5       77     -2.5      0.8
   -63.5       79     -0.5      0.8
     -64       81      1.5      0.8
   -65.5     82.5        4      0.8
   -66.5     84.5      6.5      0.8
   -66.5     85.5        8      0.8
     -65     86.5       10      0.8
     -63     86.5       13      0.8
   -60.5       87     16.5      1.2

    1 18
   -62.5       70       -6      0.6
     -65     69.5       -6      0.8
   -67.5     68.5     -6.5      0.8
   -70.5     66.5     -6.5      0.8
     -72     64.5     -7.5      1.7
   -73.5     62.5       -8      0.6
     -75     60.5     -9.5      0.6
     -77     58.5    -10.5      0.6
     -79       57    -12.5      0.6
   -80.5     54.5      -14      0.6
   -82.5       52    -15.5      0.6
   -84.5     49.5    -17.5      0.6
   -87.5       48      -22      0.6
     -90     47.5    -26.5      0.6
   -91.5       47    -29.5      0.6
     -93       46    -33.5      0.6
   -93.5     42.5    -36.5      0.6
     -94     37.5      -40      0.4

    1 5
   -54.5       69      -12      1.6
     -55       72      -10      0.4
     -56       75     -8.5      0.4
     -56     77.5     -8.5      0.8
     -56       80     -8.5        2

    1 15
     -56       80     -8.5        2
     -55     82.5     -8.5      0.6
   -53.5     85.5       -8      0.6
     -53     88.5     -7.5      0.8
     -52       91     -7.5      0.8
   -51.5     93.5     -7.5      0.8
   -50.5       96     -7.5      0.8
   -49.5     99.5     -7.5      0.8
     -48      103     -7.5      0.8
   -45.5    106.5     -7.5      0.8
   -43.5    109.5     -7.5      0.8
   -41.5      112     -7.5      0.8
   -39.5    114.5       -7      0.8
   -36.5      117       -6      0.8
     -34    119.5       -5      0.8

    1 21
     -56       80     -8.5        2
     -57     82.5      -10      0.8
     -58     84.5    -11.5      0.8
   -58.5       87    -12.5      0.8
     -60     89.5      -12      0.8
     -62     92.5      -13      0.8
   -64.5       95    -15.5      0.8
     -66       98    -17.5      0.8
   -68.5      100      -19      0.8
     -71    102.5      -19      0.8
     -74    105.5    -19.5      0.8
     -76      109      -22      0.8
     -78      113    -24.5      0.8
     -80    117.5      -26      0.8
     -82      122      -28      0.8
   -84.5    125.5      -32      0.8
   -88.5      128      -37      0.8
     -92      130      -40      0.8
     -96    132.5    -44.5      0.8
  -101.5      135    -48.5      0.8
  -108.5      137    -51.5      0.8

    1 13
      -7      -11       23        6
    -6.5    -12.5       24      5.1
    -6.5      -14       25      4.5
      -7      -16       25      4.1
    -7.5    -17.5       26      3.9
      -8    -18.5       27      3.5
    -8.5      -20       29      2.9
      -9      -21     29.5      2.9
     -10    -22.5       30      3.7
   -10.5      -24     30.5      3.7
   -11.5    -25.5       32      3.5
     -12      -27     33.5      3.2
   -12.5    -28.5     34.5      3.2

    1 20
   -12.5    -28.5     34.5      3.2
   -11.5    -29.5     32.5      1.7
     -11    -30.5       31      1.6
     -10    -31.5     30.5      1.6
    -9.5    -32.5     30.5      1.6
    -8.5    -33.5       31      1.6
    -7.5    -34.5       31      1.6
    -6.5      -36     32.5      1.6
    -6.5      -37       34      1.6
      -7    -37.5       36      1.6
    -7.5    -38.5       38      1.6
      -8      -39       41      1.6
    -7.5      -40       43      1.2
      -7      -41     43.5      1.2
      -6    -42.5     43.5      1.2
      -5      -44     43.5      1.2
      -4    -45.5     45.5      1.2
      -3    -47.5       48      1.2
      -2    -49.5     50.5      1.2
    -1.5      -51       52      1.6

    1 16
    -1.5      -51       52      1.6
      -1    -52.5       54      0.8
      -1      -54     55.5      0.8
    -1.5    -55.5       57      0.8
    -2.5    -56.5     58.5      0.8
      -3      -58       60      0.8
      -4    -59.5       60      0.8
    -4.5      -61       60      0.8
      -5    -62.5     58.5      0.8
      -5    -64.5     57.5      0.8
    -5.5      -66     56.5      0.6
    -6.5      -67       57      0.6
      -7      -68     58.5      0.6
    -7.5    -69.5     59.5      0.6
      -8      -71       60      0.6
      -9      -73       60      0.3

    1 18
    -1.5      -51       52      1.6
    -0.5      -52     56.5      0.8
       1      -53       59      0.8
     1.5      -54     61.5      0.8
     1.5      -54       64      0.8
       0    -53.5       67      0.8
    -1.5      -53       67      0.8
      -3    -52.5     67.5      0.8
      -4    -52.5     68.5      0.8
    -3.5    -53.5     71.5      0.8
    -2.5    -54.5     72.5      0.8
      -1    -55.5     73.5      0.8
       0    -56.5       73      0.8
     0.5    -57.5       73      0.8
     0.5    -58.5       73      0.8
       1    -59.5       74      0.8
       0    -59.5       75      0.8
      -2      -60     75.5      0.8

    1 48
   -12.5    -28.5     34.5      3.2
   -13.5      -29       32      2.9
     -15    -29.5     30.5      2.4
   -16.5    -30.5       30        2
     -18    -31.5       30        2
     -19    -32.5       30        2
     -20    -33.5     30.5        2
     -21      -35       31      2.2
     -22      -36     30.5        2
     -23    -37.5       30        2
   -24.5      -39       30        2
     -26    -40.5       30        2
     -28    -41.5       30        2
     -30      -43       30      1.7
     -32      -44       31      1.6
   -33.5    -45.5       32      1.6
     -35    -47.5     33.5      1.6
     -36      -49     33.5      1.6
     -37    -50.5       33      1.6
     -38    -51.5     32.5      1.6
   -39.5    -52.5     32.5      1.6
     -41    -53.5       33      1.6
   -42.5    -54.5     33.5      1.7
     -44    -55.5     33.5      1.7
     -45      -56       33      1.7
   -46.5      -57     32.5      1.7
   -47.5      -58       32      1.7
   -48.5      -59       32      1.7
   -49.5    -59.5       32      1.6
   -50.5    -60.5       32      1.7
   -51.5    -61.5       32      1.7
   -52.5    -62.5       30      1.7
     -54    -63.5     29.5      1.7
   -54.5    -64.5     26.5      1.7
   -55.5    -65.5       25        2
   -55.5    -66.5       23        2
   -55.5      -68     21.5      1.7
   -55.5      -69     20.5      1.7
     -56    -70.5       19      1.7
   -56.5    -71.5     19.5      1.7
     -57    -72.5     19.5      1.7
   -57.5    -73.5     19.5      1.7
   -57.5      -75       20      1.7
     -58    -76.5     20.5      1.7
     -58      -78     20.5      1.7
   -57.5    -79.5     20.5      1.7
   -57.5    -80.5       21        2
   -57.5      -82     21.5      2.7

    1 9
   -57.5      -82     21.5      2.7
   -58.5    -82.5     20.5        2
   -59.5    -83.5       20      1.6
   -60.5    -84.5     19.5      1.6
     -62      -86       19      1.2
     -63      -87     17.5      1.2
   -64.5      -88     15.5      2.2
     -66    -88.5       12      2.5
     -68      -89      7.5      3.5

    1 76
     -68      -89      7.5      3.5
     -69    -89.5      7.5      2.5
   -70.5      -90        6      2.2
   -71.5      -91      4.5        2
     -73    -91.5        3      1.7
     -74      -92      2.5      1.7
   -75.5    -92.5      1.5      1.6
   -76.5    -92.5      1.5      1.6
   -77.5      -93      1.5      1.6
     -79    -93.5        2      1.6
   -80.5      -94      1.5      1.6
     -82    -94.5      1.5      1.5
     -84      -95      1.5      1.2
     -86    -95.5      1.5      1.2
     -88      -97        0        1
   -89.5    -98.5       -2      1.2
   -90.5    -99.5     -2.5      1.2
     -92     -101     -2.5      1.7
   -93.5     -102     -2.5      1.7
     -95     -103     -2.5      1.5
     -97     -104       -3      1.5
     -99     -105     -3.5      1.5
  -100.5   -106.5     -3.5      1.7
    -102   -107.5     -3.5      1.5
  -103.5   -108.5     -3.5      1.5
    -105     -110     -3.5      1.5
  -106.5   -111.5     -3.5      1.5
  -107.5   -112.5     -3.5      1.5
    -109   -113.5       -4        1
    -110     -114       -5      0.6
  -111.5     -115       -6      0.6
  -112.5     -116       -6      1.2
  -113.5   -116.5       -6      1.7
  -114.5   -117.5       -6      1.5
  -115.5     -118       -6      0.8
    -117     -119       -6      0.6
    -118     -121       -6      0.6
  -119.5     -125     -5.5      1.6
    -121     -130       -5      1.6
  -122.5     -134     -4.5      1.6
  -123.5   -137.5       -4      1.6
    -124     -141       -5      1.6
  -124.5   -144.5     -5.5      0.8
    -126     -148       -6      0.8
  -127.5     -151       -6      0.8
  -128.5     -155       -6      0.8
  -129.5     -159       -6      0.8
  -129.5   -162.5       -6      0.8
    -129     -165     -4.5      1.7
    -128     -168     -3.5      0.6
    -128   -171.5     -2.5      0.6
  -128.5     -176       -3      0.6
  -129.5     -181       -3      0.6
    -130     -186     -3.5      0.6
  -130.5   -190.5     -3.5      0.6
    -130   -195.5     -3.5      0.6
  -129.5     -200     -3.5      0.6
  -129.5   -203.5     -3.5      0.6
    -131   -206.5     -2.5      0.6
    -133   -209.5       -1      0.8
    -135   -212.5      0.5      0.8
  -136.5     -215      1.5      0.8
    -137   -216.5        2      0.8
  -137.5     -218        4      0.8
  -138.5   -220.5        5      0.8
  -139.5   -222.5      6.5      0.8
  -141.5   -223.5        8      0.8
    -143     -225      9.5      0.8
    -144   -226.5       10      0.8
    -144   -227.5     11.5      0.8
  -143.5     -229     11.5      1.2
    -144   -230.5     13.5      1.2
    -145   -231.5       14      0.8
  -146.5   -232.5       16      0.8
  -148.5   -233.5       16      0.8
  -150.5   -234.5       16        1

    1 2
  -150.5   -234.5       16        1
    -153     -234       16      0.6

    1 4
  -150.5   -234.5       16        1
    -151     -236       16      0.6
  -151.5   -237.5       16      0.6
  -152.5     -239       17      0.6

    1 28
     -68      -89      7.5      3.5
   -67.5      -88      6.5        3
     -68      -87        6      1.2
     -69      -86      5.5      1.2
   -70.5      -86      4.5      1.2
     -72    -86.5      3.5        1
     -74    -87.5        2        1
   -75.5      -88        1      1.2
     -77    -88.5     -0.5      0.8
   -78.5    -88.5     -1.5      0.8
     -80    -88.5     -2.5      0.8
   -81.5      -89     -3.5      1.7
     -84      -89     -3.5      1.2
   -86.5    -89.5       -5      1.2
     -89    -88.5     -6.5      1.2
   -92.5      -88     -8.5      1.2
     -96      -89      -12      1.2
  -100.5    -90.5    -17.5      1.2
    -104    -91.5      -22      1.2
  -107.5    -91.5      -26      1.2
    -112    -91.5    -30.5      1.2
    -116      -92    -36.5      1.2
  -119.5    -93.5    -41.5      1.2
    -123      -96      -45      1.2
    -127    -99.5      -48      1.2
  -130.5   -101.5      -50      1.2
    -135   -102.5      -51      0.8
    -140     -103      -50      0.8

    1 14
   -57.5      -82     21.5      2.7
   -56.5      -83     21.5      2.2
   -56.5      -84     21.5      1.7
     -56      -85     21.5      1.7
   -56.5    -86.5     21.5      1.7
   -56.5      -88     21.5      1.7
   -56.5    -89.5       22      1.7
     -56    -91.5       23      1.2
   -55.5    -93.5       24      1.2
   -55.5    -95.5       24      1.6
   -56.5      -97       24      1.6
   -57.5      -98       24      1.2
   -58.5    -99.5       26        1
   -59.5   -100.5       30        1

    1 69
   -59.5   -100.5       30        1
   -60.5   -101.5     27.5      0.8
   -61.5     -103     26.5      0.8
   -62.5   -104.5     26.5      0.8
   -63.5   -105.5       26      0.8
   -64.5   -106.5     25.5      0.5
     -66   -107.5       25      0.5
     -67     -108       25      0.8
   -68.5     -109     24.5      1.1
     -70     -110       24      0.6
   -71.5     -111       24      0.6
   -72.5   -112.5       24      0.6
     -74   -113.5       24      0.6
     -75     -115       24        1
     -76   -116.5       24        1
     -77     -118       24        1
   -77.5     -119       24      0.8
   -78.5   -120.5       24      0.8
   -79.5     -122       24      0.8
     -80   -123.5       24      0.8
   -80.5     -125       24      1.2
     -81     -127       25      0.6
     -81     -129       26      0.6
     -82   -130.5       27      0.6
     -83     -132     26.5      0.6
     -84     -133     27.5      0.6
     -85     -135     27.5      0.6
     -86     -138     27.5      0.5
   -87.5     -141     27.5      0.5
     -89   -143.5     27.5      0.5
     -91     -146     27.5      0.5
     -93     -148     27.5      0.5
   -94.5   -150.5     27.5      0.5
     -96   -152.5       27      0.5
     -98     -155     26.5      0.5
   -99.5   -157.5     26.5      0.5
    -101     -160       27      0.5
    -102     -162     27.5      0.5
  -103.5     -164     28.5      0.5
  -104.5   -165.5       29      0.5
  -105.5   -166.5     29.5      0.6
  -106.5   -167.5     29.5      0.5
  -107.5   -168.5       29      0.5
  -108.5     -170     28.5      1.1
  -109.5     -171     28.5      0.5
    -111     -172     28.5      0.5
  -112.5     -173     28.5      0.5
    -115     -174     28.5      0.5
  -117.5     -175     28.5      0.5
  -119.5   -175.5     28.5      0.5
  -121.5     -176       28      0.5
  -123.5     -176     27.5      0.5
  -125.5   -176.5     27.5      0.5
  -127.5   -177.5     27.5      0.5
  -129.5   -178.5     27.5      0.5
  -130.5     -179     27.5      1.2
    -132     -180     27.5      1.2
    -133   -180.5       27      0.5
    -134     -181     26.5      0.5
  -135.5     -182     26.5      0.5
    -138     -183     24.5      0.5
    -141   -184.5       23      0.5
    -144     -186     21.5      0.5
    -147   -186.5     21.5      0.5
  -149.5   -187.5       22      0.5
    -153   -188.5       22      0.5
  -155.5   -189.5     20.5      0.5
  -157.5     -190       18      0.5
  -159.5   -190.5     14.5        2

    1 26
   -59.5   -100.5       30        1
     -59   -101.5     28.5      0.8
   -59.5   -102.5     27.5      0.6
     -60   -103.5     27.5      0.6
     -61   -104.5     26.5      0.6
     -62   -105.5     26.5      0.6
   -62.5   -106.5     26.5      0.6
   -63.5   -107.5     26.5      0.6
     -65     -108     27.5      0.6
     -66     -109     27.5      0.6
   -67.5   -110.5     27.5      0.6
     -69     -112     26.5      0.6
     -71   -113.5     26.5      0.6
     -72   -115.5     26.5      0.6
     -73     -117       28      0.6
   -73.5     -119     29.5      0.6
     -74   -120.5       31      0.6
   -74.5   -122.5       31      0.6
     -75   -124.5       31      0.6
     -76     -126       30      0.6
   -77.5   -127.5       30      0.8
   -78.5   -129.5       30      0.8
     -80   -131.5       31      0.8
   -81.5   -133.5       31      0.8
     -83     -135     32.5      0.8
     -85     -137     35.5      1.2

    1 38
     -85     -137     35.5      1.2
   -85.5   -138.5     34.5      0.8
     -86     -140     33.5      0.8
   -86.5   -142.5     33.5      0.8
   -86.5   -144.5     33.5      0.8
   -86.5     -146       34      0.8
     -86     -148       35      0.8
     -86     -150       36      0.8
     -87     -152       38      0.6
   -88.5   -154.5       39      0.6
   -89.5     -157     40.5      0.8
     -91     -159     41.5      0.8
   -92.5   -160.5       42      0.8
     -94     -162     42.5      0.8
   -95.5   -163.5       43      0.8
   -96.5   -165.5     43.5      0.8
     -98     -167       44      0.8
     -99     -168     44.5      0.8
    -100     -169     45.5      0.8
    -101     -170       47      0.8
    -102     -171     47.5      0.8
  -103.5     -173       48      0.8
    -105   -175.5     48.5      0.8
    -106   -178.5     49.5      0.8
  -106.5   -181.5     50.5      0.8
    -108   -184.5     52.5      0.8
    -110     -188       54      0.8
    -113   -191.5     57.5      0.8
  -116.5     -195     60.5      0.8
    -120     -198     64.5      0.8
  -123.5     -201     68.5      0.8
  -126.5   -203.5       72      0.8
  -130.5   -205.5       73      0.8
    -135     -207     73.5      0.8
  -138.5   -207.5     73.5      0.8
  -141.5   -207.5     74.5      0.8
  -143.5     -208     74.5      0.8
  -145.5   -209.5       74      0.8

    1 34
     -85     -137     35.5      1.2
     -86     -139     37.5      0.8
     -87   -141.5       38      0.8
     -87     -144     36.5      0.6
   -87.5     -146       37      1.1
     -88   -148.5     37.5      0.4
     -89   -150.5     39.5      0.4
   -90.5     -153       40      0.4
     -92     -155     40.5      0.4
     -94   -156.5       40      0.4
   -95.5     -158       39      0.4
     -97     -159     38.5        1
   -98.5   -160.5     38.5      0.5
   -99.5     -162       39      0.5
    -101     -164     38.5      0.6
    -103     -166       38      0.6
  -105.5   -168.5       38      0.6
  -107.5     -171       38      0.6
  -109.5     -173       38      0.6
    -111     -175       38      0.6
  -112.5     -178       40      0.6
  -115.5   -180.5     41.5      0.6
  -118.5     -183     42.5      0.6
  -121.5     -185     41.5      0.6
    -125     -188       40      0.6
  -127.5   -189.5     38.5      0.6
  -130.5     -192       38      0.6
    -133     -195     36.5      0.6
    -136   -198.5     34.5      0.6
    -138     -202     32.5      0.6
  -139.5   -203.5       31      0.6
    -140     -205       31      1.1
  -140.5     -207       31      1.1
    -141     -210       31      1.6

    1 19
   -25.5       -1     19.5      4.5
   -27.5       -1     19.5      3.2
     -30       -1     19.5      3.2
     -32       -1     19.5      2.7
   -34.5     -0.5     19.5      2.7
   -36.5     -0.5     19.5      2.7
   -38.5     -0.5     18.5      2.4
     -40     -0.5     17.5      2.4
     -42       -1     16.5      2.4
   -43.5       -1       16      3.2
     -45       -1     15.5        3
   -46.5     -1.5       15      2.5
     -48     -1.5       14      2.5
   -49.5     -1.5     13.5      2.5
   -51.5     -1.5       13      2.5
     -53     -1.5     12.5      2.2
   -54.5     -1.5       13      2.2
   -55.5       -2       15      2.2
     -57     -2.5     17.5      2.2

    1 35
     -57     -2.5     17.5      2.2
   -58.5     -2.5       14      1.7
     -60       -3     12.5      1.7
   -61.5     -3.5       13      1.7
     -63       -4     13.5      1.7
   -64.5       -4       14      1.7
     -66     -4.5       14      1.7
     -68     -4.5       14      1.7
   -69.5     -4.5       14      1.7
     -71     -4.5       14      1.7
     -72       -5     13.5      1.7
   -73.5       -5       13      1.7
   -74.5     -5.5     12.5      1.7
     -76       -6       12      1.7
     -77     -6.5     11.5      1.7
   -78.5     -6.5     10.5      1.7
     -80       -7     10.5      1.7
   -81.5       -7     10.5      1.7
     -83       -7       10      1.7
     -85       -7        9      1.7
   -86.5       -7        8      1.7
   -88.5       -7        8      1.7
   -90.5       -7      8.5      2.2
     -92       -7      9.5      1.7
     -94       -7      9.5      1.7
     -96       -7        9      1.7
     -98     -6.5        8      1.7
    -100     -6.5        8      1.7
  -101.5       -6        8      1.7
  -103.5     -6.5        9      1.7
    -105       -7        9      1.6
  -106.5       -8      9.5      1.6
    -108     -8.5     11.5      1.6
  -109.5     -9.5     15.5      1.6
    -111    -10.5       21      1.6

    1 87
    -111    -10.5       21      1.6
    -112    -11.5     19.5      1.6
    -114    -12.5     18.5      1.6
    -116    -13.5     18.5      1.2
  -117.5    -15.5       19      1.2
  -119.5      -17       20        1
  -121.5    -19.5       21        1
    -124    -21.5       23      1.2
    -126      -23       24      1.2
  -128.5    -24.5       25      1.2
  -130.5      -25     24.5      0.8
    -133    -25.5     24.5      1.6
    -135    -25.5     25.5      1.6
    -137    -26.5       27      0.8
    -139    -27.5       29      1.2
    -141      -29     30.5      1.2
  -142.5    -30.5     31.5      0.6
  -143.5    -31.5       32      0.6
    -145      -33     32.5      0.6
    -146    -34.5     32.5      0.6
    -147    -36.5       32      1.2
  -147.5      -38     31.5      1.2
  -148.5    -39.5     31.5      0.8
  -149.5      -41     31.5      0.8
  -150.5      -42     31.5      1.7
    -152    -43.5       32      0.8
    -154      -45       33      0.8
  -155.5    -46.5     34.5      0.8
  -157.5    -48.5     36.5      1.2
    -159      -50       37      0.6
    -161      -52       38        1
    -162    -54.5       39        1
    -163      -57       40        1
  -163.5      -60     40.5        1
    -165      -62     40.5        1
    -167      -64     40.5        1
    -169    -66.5     40.5        1
    -171      -69     40.5        1
  -173.5    -71.5     40.5        1
    -176    -73.5     40.5        1
  -178.5    -75.5       41        1
    -180    -78.5       44        1
  -180.5    -81.5       47        1
    -180      -84     49.5      0.8
    -179    -86.5       50      0.8
  -178.5      -89       50      0.8
    -179      -92       51      0.8
    -180    -94.5       53      0.8
    -181    -97.5       55      0.8
  -181.5   -100.5       56      0.8
  -181.5   -103.5       56      0.8
  -182.5     -106       56      0.8
  -183.5   -107.5       56      0.8
  -185.5     -109       56      1.2
  -187.5     -110       56      1.2
  -189.5   -111.5     55.5      0.6
    -192   -112.5       55      0.6
  -194.5     -114     54.5      0.6
    -196     -115     54.5      0.6
    -198     -116     53.5      0.6
    -200     -118       53      0.6
    -202   -120.5     53.5      0.6
    -204   -123.5     53.5      0.6
    -205   -126.5     53.5      0.6
  -206.5   -128.5     52.5      0.6
    -207   -130.5     52.5      0.6
    -208   -132.5     52.5      0.6
    -209   -134.5     52.5      0.6
  -210.5   -136.5     52.5      0.6
  -211.5   -138.5     52.5      0.6
    -213     -140     52.5      0.6
  -214.5     -142     52.5      0.6
  -215.5     -144       53      0.6
  -216.5     -146       52      0.6
  -217.5     -148     51.5      0.6
  -217.5   -150.5       50      0.6
    -219     -153     49.5      0.6
    -221     -156     48.5      0.6
  -223.5   -158.5     47.5      0.6
    -225   -160.5     46.5      0.6
  -226.5   -163.5     46.5      0.6
    -228     -166       46      0.6
  -229.5   -168.5     45.5      1.1
  -230.5   -170.5     45.5      1.1
    -231     -172       45      0.6
  -231.5   -173.5       45      0.5
  -232.5   -175.5     45.5      1.2

    1 4
  -232.5   -175.5     45.5      1.2
    -234   -175.5     40.5      0.5
  -235.5     -176     37.5      0.5
    -238   -176.5       37      0.5

    1 7
    -238   -176.5       37      0.5
  -238.5     -177       37      0.5
    -240   -177.5       36      0.5
    -242     -178       34      0.5
  -244.5     -179     33.5      0.5
  -246.5   -180.5     33.5      0.5
    -249   -181.5     33.5      1.2

    1 3
    -238   -176.5       37      0.5
    -239   -176.5       37      0.5
    -241   -176.5       37      0.5

    1 14
  -232.5   -175.5     45.5      1.2
  -232.5   -174.5       40      0.8
    -232   -174.5     36.5      0.8
  -230.5   -174.5       35      0.8
  -228.5     -175       35      0.8
  -226.5   -175.5       35      0.8
  -223.5   -176.5       35      0.8
  -221.5     -177     33.5      0.8
    -219   -177.5     32.5      0.8
  -217.5   -177.5       31      0.8
    -216     -177       31      0.8
  -214.5   -177.5     31.5      0.8
    -213     -179       32      0.8
    -212   -180.5     31.5        2

    1 17
    -111    -10.5       21      1.6
    -110    -11.5     23.5      1.6
  -108.5    -12.5     26.5      1.1
  -107.5    -13.5       28      1.1
    -107      -15       31      1.1
  -107.5      -16       35      1.1
    -108    -16.5     38.5      1.1
  -107.5    -17.5     41.5      1.1
    -106      -19       42      1.1
  -104.5      -20     43.5      1.1
  -103.5    -20.5     44.5      1.1
    -103    -20.5     47.5      1.1
    -102    -20.5     51.5      1.1
  -101.5      -22       54      1.1
    -101    -23.5     54.5      0.6
    -101      -25       55      0.6
    -101      -26       57      0.6

    1 16
    -101      -26       57      0.6
    -100    -26.5       55      0.6
    -100    -27.5     54.5      0.4
    -100    -29.5       57      0.4
  -100.5    -31.5       59      0.4
    -101    -33.5     60.5      0.4
    -101      -35     60.5      0.4
    -101    -36.5     61.5        1
  -101.5    -37.5     62.5      0.3
    -102    -38.5       64      0.3
    -102    -39.5       64      0.3
  -102.5      -41       65      0.3
    -103      -42       66      0.6
    -104    -43.5     67.5      0.6
    -105    -44.5       67      0.6
    -106    -46.5     66.5      0.6

    1 15
    -101      -26       57      0.6
    -101    -26.5       57      0.8
  -101.5      -28     58.5      0.4
    -102    -29.5     60.5      0.4
    -103    -31.5     62.5      0.4
  -104.5    -33.5       65      0.4
    -105      -35       69      0.4
    -105    -35.5     72.5      0.4
    -104      -36     74.5      0.4
  -104.5    -36.5     74.5      0.5
    -106      -37       75      0.5
    -107      -38     76.5      0.5
    -108    -39.5       79      0.5
    -109    -40.5       80      0.5
    -110      -40       79      0.5

    1 15
     -57     -2.5     17.5      2.2
   -57.5     -3.5     19.5      1.2
     -58     -4.5       21      1.2
   -59.5       -5     21.5      1.1
   -61.5     -6.5       22      1.1
   -63.5       -8     23.5      1.1
   -65.5       -9     26.5      1.1
     -67     -9.5     30.5      1.1
     -69     -8.5     33.5      1.1
   -70.5     -7.5       36      1.1
   -72.5       -7       37      1.1
     -75     -6.5       40      1.1
     -77     -5.5     42.5      1.1
   -79.5       -5       45      1.1
   -82.5     -4.5     45.5      2.7

    1 18
   -82.5     -4.5     45.5      2.7
     -84       -5     46.5        1
   -86.5       -6     47.5        1
   -88.5     -7.5     47.5        1
     -90       -9     47.5      1.1
     -91    -10.5       48      1.1
     -93      -12       48        1
   -94.5    -13.5     48.5        1
     -96      -16       49      1.2
     -96    -18.5       50      1.2
     -96    -21.5     51.5      1.2
   -96.5      -24     53.5      1.2
   -98.5    -26.5       57      1.2
    -101      -29     61.5      1.2
    -103      -32       64      1.2
  -104.5      -35     69.5      1.2
  -104.5      -37       73      1.2
    -104      -38       77      1.2

    1 12
    -104      -38       77      1.2
    -103      -37       77      1.2
  -102.5      -37     77.5      1.2
  -102.5      -38       78      1.2
  -102.5      -39     79.5      1.2
    -102      -40       80      1.2
  -100.5      -41     80.5      1.2
   -99.5      -42     80.5      1.2
     -98    -42.5     80.5      1.2
     -97      -43     80.5      1.2
     -96      -44     80.5      1.2
     -95    -45.5     80.5      1.2

    1 11
    -104      -38       77      1.2
    -105    -38.5     74.5      0.8
    -106    -39.5     73.5      0.8
    -107    -40.5       74      0.8
  -107.5    -42.5     74.5      0.8
  -108.5    -45.5     75.5      0.8
  -109.5      -48     76.5      0.8
  -111.5    -50.5       77      0.8
    -113      -53       77      0.8
  -114.5      -55       77      0.8
    -116      -57       77      0.8

    1 9
   -82.5     -4.5     45.5      2.7
   -81.5     -2.5     46.5      0.8
     -80       -1       49      0.8
   -78.5        0     52.5      0.8
     -76      1.5     53.5      0.8
     -75        4       54      0.8
   -74.5        6     54.5      0.8
     -75        8       58      0.8
     -76       10     61.5      0.8

    1 6
     -76       10     61.5      0.8
     -78      9.5       60      0.8
   -79.5       10     58.5      0.8
   -81.5       11       58      0.8
   -82.5       13     57.5      0.8
   -83.5       16       57      0.8

    1 14
     -76       10     61.5      0.8
     -75     11.5     61.5      0.8
     -75       13     61.5      0.8
   -75.5     15.5       61      0.8
     -76     17.5     61.5      0.8
   -76.5     20.5     63.5      0.8
     -77     23.5       65      0.8
     -77       27     65.5      0.8
   -76.5     29.5       65      0.8
   -76.5       32     64.5      0.8
   -76.5       34       66      0.8
   -75.5       35       68      0.8
   -73.5     35.5       70      0.8
   -71.5     36.5       71      1.2

    1 8
   -71.5     36.5       71      1.2
     -73       38     71.5      0.6
     -75       39     71.5      0.6
     -76       41       70      0.6
     -77     42.5       68      0.6
     -78     44.5     66.5      0.6
     -79     46.5     65.5      0.6
     -80       49       64      1.7

    1 8
   -71.5     36.5       71      1.2
     -69     36.5     71.5      0.6
     -67       36       72      0.6
   -64.5       36       72      0.6
     -62     35.5       72      0.6
   -59.5     34.5       73      0.6
   -56.5     34.5     74.5      0.6
   -53.5       35       77      0.6

    1 13
     -12      6.5       15      1.7
   -11.5        8       15      1.7
   -10.5        9       15      1.7
    -9.5       10     15.5        2
    -8.5       11     15.5        2
    -7.5       12     15.5      1.7
    -6.5       13     16.5      1.7
      -5     14.5     16.5      1.7
    -4.5       16       18      0.8
    -2.5     16.5       18      0.8
    -0.5     16.5       18      1.7
       0       18     18.5      1.7
     1.5       19       19      1.5

    1 48
     1.5       19       19      1.5
       3     19.5     17.5        1
       5     20.5     17.5        1
     6.5       21     17.5        1
     8.5       23     16.5        1
       9     24.5     16.5        1
      10       25     16.5      1.5
    12.5     26.5     16.5      1.5
      14     27.5       16        1
    16.5       28       16        1
      19     29.5       16      1.5
      20     30.5       16      0.8
    21.5       32       16      0.8
      23     32.5       17      0.5
    23.5       33     17.5      1.2
      26     34.5     17.5      1.2
    27.5       35     18.5      0.8
      30       36     18.5      0.8
    31.5       36     18.5      0.8
    30.5     36.5     18.5      0.8
      31     37.5     18.5      0.8
      33       38     18.5      0.8
    34.5       39     18.5      0.8
      36     39.5     18.5      0.8
    36.5       41     18.5      0.8
    37.5     42.5       19      0.8
    38.5     43.5       19      1.2
    40.5     44.5       19        1
      41     45.5     18.5      0.6
      41       48       18      0.6
    41.5       49       18      1.1
      42     50.5       17      0.4
    40.5     52.5       17      0.4
      39       54     16.5      0.4
    38.5       55       16      0.4
    39.5       55     16.5      0.4
    40.5     54.5       17      0.4
    40.5       56     16.5      0.4
    39.5     57.5       16      0.4
    38.5       59       16      0.4
      39     60.5     15.5      0.4
      38     61.5       15      0.4
    37.5       60     15.5      0.4
      36       61     15.5      0.4
    36.5       62     15.5      0.4
    35.5     63.5     16.5      0.4
      35       65       16      0.4
      34     67.5     16.5      0.4

    1 23
     1.5       19       19      1.5
     1.5       20       20      0.8
     2.5     21.5       20      0.8
       1     23.5       20      0.8
     1.5     26.5     22.5      0.8
       3       29       23      0.8
     4.5       30     23.5      0.8
       7     30.5       23      0.8
       9       33     23.5      0.8
    11.5     36.5     24.5      0.8
      14       40       25      0.8
    17.5       44       26      0.8
      20       45     26.5      0.8
      21     48.5     27.5      0.8
    20.5       50     26.5      0.8
    21.5       52     28.5      0.8
    24.5     53.5     28.5      0.8
      27       55     28.5      0.8
    27.5     57.5     28.5      0.8
    29.5     57.5     29.5      0.8
      32       58       32      0.8
    32.5       60     31.5      0.8
      30       62     31.5      0.8


CONNECTIONS:

        0    1
        1    1
        2    1
        3    1
        4    1
        4    1
        6    1
        6    1
        8    1
        8    1
       10    1
       10    1
        3    1
       13    1
       13    1
        2    1
       16    1
       16    1
        1    1
       19    1
       19    1
        0    1
       22    1
       23    1
       23    1
       25    1
       26    1
       26    1
       25    1
       29    1
       29    1
       31    1
       31    1
       22    1
       34    1
       34    1
       36    1
       37    1
       37    1
       36    1
       40    1
       40    1

        0    1
        1    1
        1    1
        0    1
        4    1
        5    1
        6    1
        6    1
        5    1
        4    1
       10    1
       10    1
       12    1
       12    1

        0    1
        1    1
        2    1
        3    1
        3    1
        2    1
        1    1
        7    1
        7    1
        0    1
       10    1
       11    1
       11    1
       10    1
       14    1
       14    1
       16    1
       16    1

        0    1
        0    1


/*----------------------------------------------------------------*/
proc geometry() { 

	/* NULL geometry procedure: keeps the user from
	calling the geometry procedure in isolation. */

    printf("\nYou must re-read the entire geometry\n")
    printf("file to execute geometry().\n\n")
}

