/* ColScale.java

Create a colour scale for data representation

BPG 24-11-99
*/

import java.awt.Color;
import java.awt.Graphics;


public final class ColScale extends Object {

  // 8-bit "hot" scale (taken from "hot" in GENESIS)
  private static final int maxCS = 127;  // max colour index
  private static final int CSrgb[][] = {
{0, 0, 10},
{0, 0, 20},
{0, 0, 30},
{0, 0, 40},
{0, 0, 50},
{0, 0, 60},
{0, 0, 70},
{0, 0, 80},
{0, 0, 90},
{0, 0, 100},
{0, 0, 110},
{0, 0, 120},
{0, 0, 130},
{0, 0, 140},
{0, 0, 150},
{0, 0, 160},
{0, 0, 170},
{0, 0, 180},
{0, 0, 190},
{0, 0, 200},
{0, 0, 210},
{0, 0, 220},
{0, 0, 230},
{0, 0, 240},
{0, 0, 250},
{0, 0, 255},
{0, 10, 246},
{0, 20, 236},
{0, 30, 226},
{0, 40, 216},
{0, 50, 206},
{0, 60, 196},
{0, 70, 186},
{0, 80, 176},
{0, 90, 166},
{0, 100, 156},
{0, 110, 146},
{0, 120, 136},
{0, 130, 126},
{0, 140, 116},
{0, 150, 106},
{0, 160, 96},
{0, 170, 86},
{0, 180, 76},
{0, 190, 66},
{0, 200, 56},
{0, 210, 46},
{0, 220, 36},
{0, 230, 26},
{0, 240, 16},
{0, 250, 6},
{0, 255, 0},
{10, 246, 0},
{20, 236, 0},
{30, 226, 0},
{40, 216, 0},
{50, 206, 0},
{60, 196, 0},
{70, 186, 0},
{80, 176, 0},
{90, 166, 0},
{100, 156, 0},
{110, 146, 0},
{120, 136, 0},
{130, 126, 0},
{140, 116, 0},
{150, 106, 0},
{160, 96, 0},
{170, 86, 0},
{180, 76, 0},
{190, 66, 0},
{200, 56, 0},
{210, 46, 0},
{220, 36, 0},
{230, 26, 0},
{240, 16, 0},
{250, 6, 0},
{255, 0, 0},
{255, 10, 0},
{255, 20, 0},
{255, 30, 0},
{255, 40, 0},
{255, 50, 0},
{255, 60, 0},
{255, 70, 0},
{255, 80, 0},
{255, 90, 0},
{255, 100, 0},
{255, 110, 0},
{255, 120, 0},
{255, 130, 0},
{255, 140, 0},
{255, 150, 0},
{255, 160, 0},
{255, 170, 0},
{255, 180, 0},
{255, 190, 0},
{255, 200, 0},
{255, 210, 0},
{255, 220, 0},
{255, 230, 0},
{255, 240, 0},
{255, 250, 0},
{255, 255, 0},
{255, 255, 10},
{255, 255, 20},
{255, 255, 30},
{255, 255, 40},
{255, 255, 50},
{255, 255, 60},
{255, 255, 70},
{255, 255, 80},
{255, 255, 90},
{255, 255, 100},
{255, 255, 110},
{255, 255, 120},
{255, 255, 130},
{255, 255, 140},
{255, 255, 150},
{255, 255, 160},
{255, 255, 170},
{255, 255, 180},
{255, 255, 190},
{255, 255, 200},
{255, 255, 210},
{255, 255, 220},
{255, 255, 230},
{255, 255, 240}
};


  // Generate required colour
  public static Color ColVal(float pval, float pmval) {
    int i;

    if (pval < pmval)
      i = (int)(maxCS * (pval / pmval));
    else if (pval < 0)
      i = 0;
    else
      i = maxCS;
    return(new Color(CSrgb[i][0],CSrgb[i][1],CSrgb[i][2]));

  }


  // Draw colour scale
  public static void drawCS(Graphics g, int x0, int y0, int dw) {
    int i, dx;

    dx = dw / maxCS;
    for (i = 0; i <= maxCS; i++) {
      g.setColor(new Color(CSrgb[i][0],CSrgb[i][1],CSrgb[i][2]));
      g.drawLine(x0+(i*dx), y0, x0+((i+1)*dx), y0);
//      g.drawLine(x0+(i*dx), y0+1, x0+((i+1)*dx), y0+1);
    };

  }


}
