
10 REM "SA-NODE ACTION POTENTIAL" BY FREDRIK ELINDER, LINKPINGS UNIVERSITET
11 REM  REFERENCES: MNNIKK, PANDEY, LARSSON & ELINDER. 2005. J GEN PHYSIOL 125:305-326
12 REM              ELINDER, MNNIKK, PANDEY & LARSSON. 2006. J PHYSIOL 575:417-431
13 REM  UPDATED SEPTEMBER 13, 2006
14 REM  BASED ON THE MODEL BY ZHANG ET AL., 2000, AM J PHYSIOL 279:H397-H421
15 REM  DIFFERENCES FROM ZHANG ET AL: NEW DESCRIPTION OF HCN + CORRECTION OF EQ 42
20 SCREEN 9
30 CLS

40 OPEN "C:\DATA\X.PRN" FOR OUTPUT AS #1
45 OPEN "C:\DATA\Y1.PRN" FOR OUTPUT AS #2
50 OPEN "C:\DATA\Y2.PRN" FOR OUTPUT AS #3
55 OPEN "C:\DATA\Y3.PRN" FOR OUTPUT AS #4
60 OPEN "C:\DATA\Y4.PRN" FOR OUTPUT AS #5
65 OPEN "C:\DATA\Y5.PRN" FOR OUTPUT AS #6

80 FOR WW=0 TO 1		:REM HYSTERESIS (1) OR NOT (0)

100 REM CONSTANTS FOR PROGRAM CONTROL AND SAMPLING CARACTERISTICS
110 	DT=0.000005		:REM STEP LENGTH TIME (s) = 5 us
120 	MAXCOUNT=400000		:REM TOTAL TIME = 2 s
130 	R = 8.31		:REM GENERAL GAS CONSTANT
140 	T = 293			:REM TEMPERATURE (K)
150 	F = 96480/1000		:REM FARADAYS CONSTANT (C/MOL) CORRECTED FOR mV

190 GOTO 400                    :REM GOTO 200 TO GET CENTRAL NODAL CELLS, OTHERWISE PERIPHERAL

200 REM CENTRAL NODAL CELL CONDUCTANCES (S, A, F)
210 	GNA  = 0
220 	GCAL = 0.58   * 10^-2 * 10^-6
230 	GCAT = 0.43   * 10^-2 * 10^-6
240 	GTO  = 4.91   * 10^-3 * 10^-6
250 	GSUS = 6.65   * 10^-5 * 10^-6
260 	GKR  = 7.97   * 10^-4 * 10^-6
270 	GKS  = 5.18   * 10^-4 * 10^-6
280 	GHNA = 0.0548 * 10^-2 * 10^-6
290 	GHK  = 0.0548 * 10^-2 * 10^-6
300 	GBNA = 5.8    * 10^-5 * 10^-6
310 	GBCA = 1.32   * 10^-5 * 10^-6
320 	GBK  = 2.52   * 10^-5 * 10^-6
330 	IPMAX= 4.78   * 10^-2 * 10^-9	:REM (A)
340 	KNACA= 0.27   * 10^-5 * 10^-9	:REM (A)
350 	CM   = 20             * 10^-12	:REM (F)

390 GOTO 600

400 REM PERIPHERAL NODAL CELL CONDUCTANCES (S, A, F)
410	GNA  = 1.2    * 10^-6 * 10^-6
420	GCAL = 6.59   * 10^-2 * 10^-6
430	GCAT = 1.39   * 10^-2 * 10^-6
440	GTO  =36.49   * 10^-3 * 10^-6
450	GSUS = 1.14   * 10^-2 * 10^-6
460	GKR  = 1.60   * 10^-2 * 10^-6
470	GKS  = 1.04   * 10^-2 * 10^-6
480	GHNA = 0.69   * 10^-2 * 10^-6
490	GHK  = 0.69   * 10^-2 * 10^-6
500	GBNA = 1.89   * 10^-4 * 10^-6
510	GBCA = 4.3    * 10^-5 * 10^-6
520	GBK  = 8.19   * 10^-5 * 10^-6
530	IPMAX= 0.16           * 10^-9	:REM (A)
540	KNACA= 0.88   * 10^-5 * 10^-9	:REM (A)
550	CM   = 65             * 10^-12	:REM (F)

600 REM CONCENTRATIONS (mM = mol/m^3)
610 	NAO = 140
620 	NAI =   8
630 	CAO =   2
640 	CAI =   0.0001
650 	KO  =   5.4
660 	KI  = 140

700 REM REVERSEL POTENTIALS (mV)
710 	ENA = R*T/   F  * LOG(NAO/NAI)
720 	ECA = R*T/(2*F) * LOG(CAO/CAI)
730 	EK  = R*T/   F  * LOG(KO/KI)
740 	ECAL= 46.4
750 	ECAT= 45
760 	EKS = R*T/   F  * LOG((KO+0.12*NAO)/(KI+0.12*NAI))

800 REM OTHER CONSTANTS
810 	DNACA    = 0.0001
820 	KMK      = 0.621
830 	KMNA     = 5.64
840 	GNACA    = 0.5		

900 REM INITIAL VALUES (MEAN OF CENTRAL AND PERIPHERAL CELLS)
905 	V  = -60		:REM (mV)

910 	DL = 0.07
915 	FL = 0.90
920 	DTT= 0.06
925 	FT = 0.25

930 	RR = 0.03
935 	Q  = 0.50
940 	XS = 0.07

945 	PAF= 0.44
950 	PAS= 0.48
955 	PI = 0.98

960 	M  = 0.12
965 	H1 = 0.59
970 	H2 = 0.05

975 	HO1 = 0.025
980 	HO2 = 0.025
985 	HC1 = 0.475
990 	HC2 = 0.475

995 GOSUB 1000

998 GOTO 2000

1000 REM L-TYPE CA CURRENT
1010 	IF V=-35 THEN V=-35.001
1012 	IF V= 5  THEN V=5.001
1014 	IF V= 0  THEN V=0.001
1016 	IF V=-28 THEN V=-28.001
1018 	ADL   = -14.19*(V+35)/(EXP(-(V+35)/2.5)-1) - 42.45*V/(EXP(-0.208*V)-1)
1020 	BDL   =   5.71* (V-5) /(EXP(0.4*(V-5))-1)
1022 	TDL   = 1/(ADL+BDL)
1024 	DLINF = 1/(1+EXP(-(V+23.1)/6))
1026 	DDL   = ((DLINF-DL)/TDL) * DT
1028 	DL    = DL + DDL
1030 	AFL   = 3.12*(V+28)/(  EXP( (V+28)/4)-1)
1032 	BFL   = 25         /(1+EXP(-(V+28)/4))
1034 	TFL   = 1/(AFL+BFL)
1036 	FLINF = 1          /(1+EXP( (V+45)/5))
1038 	DFL   = ((FLINF-FL)/TFL) * DT
1040 	FL    = FL + DFL

1100 REM T-TYPE CA CURRENT
1110 	ADT   = 1068*EXP( (V+26.3)/30)
1115 	BDT   = 1068*EXP(-(V+26.3)/30)
1120 	TDT   = 1/(ADT+BDT)
1125 	DTINF = 1/(1+EXP(-(V+37)/6.8))
1130 	DDTT  = ((DTINF-DTT)/TDT) * DT
1135 	DTT   = DTT + DDTT
1140 	AFT   = 15.3*EXP(-(V+71.7)/83.3)
1145 	BFT   = 15.3*EXP( (V+71.7)/15.38)
1150 	TFT   = 1/(AFT+BFT)
1155 	FTINF = 1/(1+EXP((V+71)/9))
1160 	DFT   = ((FTINF-FT)/TFT) * DT
1165 	FT    = FT + DFT

1200 REM 4-AP-SENSITIVE CURRENTS
1210 	QINF  = 1 / (1+EXP((V+59.37)/13.1))
1220 	TQ    = 10.1*10^-3 + (65.17*10^-3)/(0.57*EXP(-0.08*(V+49)) + 0.24*EXP(0.1*(V+50.93))) :REM CORRECTED FROM ZHANG ET AL., 2000
1230 	DQ    = ((QINF-Q)/TQ) * DT
1240 	Q     = Q + DQ
1250 	RINF  = 1 / (1+EXP(-(V-10.93)/19.7))
1260 	TRR   = 2.98*10^-3 + (15.59*10^-3)/(1.037*EXP(0.09*(V+30.61))+0.369*EXP(-0.12*(V+23.84)))
1270 	DRR   = ((RINF-RR)/TRR) * DT
1280 	RR    = RR + DRR

1300 REM RAPID DELAYED RECTIFYING K CURRENT
1310 	PAFINF= 1 / (1+EXP(-(V+14.2)/10.6))
1315 	PASINF= PAFINF
1320 	TPAF  = 1 / (37.2*EXP((V-9)/15.9) + 0.96*EXP(-(V-9)/22.5))
1325 	TPAS  = 1 / ( 4.2*EXP((V-9)/17)   + 0.15*EXP(-(V-9)/21.6))
1330 	DPAF  = ((PAFINF-PAF)/TPAF) * DT
1335 	PAF   = PAF + DPAF
1340 	DPAS  = ((PASINF-PAS)/TPAS) * DT
1345 	PAS   = PAS + DPAS
1350 	PIINF = 1 / (1+EXP((V+18.6)/10.1))
1355 	TPI   = 0.002
1360 	DPI   = ((PIINF-PI)/TPI) * DT
1365 	PI    = PI + DPI
1370 	FKR   = 0.4
1375 	PA    = (1-FKR)*PAF + FKR*PAS

1400 REM SLOW DELAYED RECTIFYING K CURRENT
1410 	AXS   = 14 / (1+EXP(-(V-40)/9))
1420 	BXS   = EXP(-V/45)
1430 	XSINF = AXS/(AXS+BXS)
1440 	TXS   = 1  /(AXS+BXS)
1450 	DXS   = ((XSINF-XS)/TXS) * DT
1460 	XS    = XS + DXS

1500 REM HYPERPOLARIZATION-ACTIVATED CURRENT - DIFFERENT FROM ZHANG ET AL., 2000
1505 	HCNSHIFT = WW*60
1506    MIDPOINT = -75		:REM MIDPOINT OF G(V) CURVE WITHOUT MODE SHIFT
1507    KACT  = 18		:REM ACTIVATION RATE AT MIDPOINT (/s)
1508    KMODE = 10		:REM MODE SHIFT RATE (/s)
1524 	KCO1  = KACT*EXP(-(V-(MIDPOINT-HCNSHIFT/2))*F/R/T)
1525 	KOC1  = KACT*EXP( (V-(MIDPOINT-HCNSHIFT/2))*F/R/T)
1526 	KCO2  = KACT*EXP(-(V-(MIDPOINT+HCNSHIFT/2))*F/R/T)
1528 	KOC2  = KACT*EXP( (V-(MIDPOINT+HCNSHIFT/2))*F/R/T)
1530 	KO12  = KMODE
1532 	KO21  = KO12*(KOC2*KCO1/(KOC1*KCO2))^0.5
1534 	KC21  = KO12
1536 	KC12  = KO21
1538 	HO1   = HO1 + ((-KOC1-KO12)*HO1 + KCO1*HC1 + KO21*HO2)*DT
1540 	HO2   = HO2 + ((-KOC2-KO21)*HO2 + KCO2*HC2 + KO12*HO1)*DT
1542 	HC1   = HC1 + ((-KCO1-KC12)*HC1 + KOC1*HO1 + KC21*HC2)*DT
1544 	HC2   = 1-HO1-HO2-HC1
1545 	W     = HO2+HO1

1600 REM TTX-SENSITIVE NA CURRENT
1610 	MINF  = (1/(1+EXP(-V/5.46)))^(1/3)
1612 	TM    = 4*10^-5 + 0.6247*10^-3 / (0.832*EXP(-0.335*(V+56.7))+0.627*EXP(0.082*(V+65.01)))
1614 	DM    = ((MINF-M)/TM) * DT
1616 	M     = M+DM
1618 	H1INF = 1/(1+EXP((V+66.1)/6.4))
1620 	H2INF = H1INF
1622 	TH1   = 5.977*10^-4 + 3.717*10^-6*EXP(-0.2815*(V+17.11))/(1+3.732*10^-3*EXP(-0.3426*(V+37.76)))
1624 	TH2   = 3.556*10^-3 + 3.186*10^-8*EXP(-0.6219*(V+18.8)) /(1+7.189*10^-5*EXP(-0.6683*(V+34.07)))
1626 	DH1   = ((H1INF-H1)/TH1) * DT
1628 	H1    = H1+DH1
1630 	DH2   = ((H2INF-H2)/TH2) * DT
1632 	H2    = H2+DH2
1634 	XNA   = 8.69*10^-2 + 9.52*10^-2*EXP(-6.3*10^-2*(V+34.4))/(1+1.66*EXP(-0.225*(V+63.7)))
1636 	H     = (1-XNA)*H1 + XNA*H2

1900 RETURN

2000 REM MAIN ALGORITHM
2010 FOR COUNT=0 TO MAXCOUNT-1
2020   GOSUB 1000

2100 REM CURRENTS (A)
2110   INA  = 0.001 * GNA   * M^3 * H  * NAO * F^2 * V/(R*T) * (EXP((V-ENA)*F/(R*T))-1)/(EXP(V*F/(R*T))-1)
2120   ICAL = 0.001 * GCAL  *(FL  * DL + 0.006/(1+EXP(-(V+14.1)/6))) * (V-ECAL)
2130   ICAT = 0.001 * GCAT  * DTT * FT * (V-ECAT)
2140   ITO  = 0.001 * GTO   * Q   * RR * (V-EK)
2150   ISUS = 0.001 * GSUS  *       RR * (V-EK)
2160   IKR  = 0.001 * GKR   * PA  * PI * (V-EK)
2170   IKS  = 0.001 * GKS   * (XS)^2   * (V-EKS)
2180   IH   = 0.001 *(GHNA  * W        * (V-ENA) + GHK * W * (V-EK))
2190   IBNA = 0.001 * GBNA  * (V-ENA)
2200   IBK  = 0.001 * GBK   * (V-EK)
2210   IBCA = 0.001 * GBCA  * (V-ECA)
2220   INACA=         KNACA * (NAI^3*CAO*EXP(0.03743*V*GNACA) - NAO^3*CAI*EXP(0.0374*V*(GNACA-1))) / (1+DNACA*(CAI*NAO^3+CAO*NAI^3))
2230   IP   =         IPMAX * (NAI/(KMNA+NAI))^3 * (KO/(KMK+KO))^2 * 1.6/(1.5+EXP(-(V+60)/40))

2300   IC  = 0 - (IS+INA+ICAL+ICAT+ITO+ISUS+IKR+IKS+IH+IBNA+IBCA+IBK+INACA+IP)
2310   DV  = 1000 * (IC/CM) * DT
2320   V   = V + DV

2500 REM PRINT ROUTINE
2510	X = COUNT/MAXCOUNT*500		
2520	Y = 50 - V + WW*150
2530	PSET(X,Y)
2540    Y = 50 + WW*150
2550    PSET(X,Y)

2600 IF INT(COUNT/1000)=COUNT/1000 THEN GOTO 2610 ELSE GOTO 2700
2610 IF WW=0 THEN PRINT #1, COUNT*DT
2620 IF ww=0 THEN PRINT #2, V
2630 IF ww=1 THEN PRINT #3, V
2640 IF ww=2 THEN PRINT #4, V
2650 IF ww=3 THEN PRINT #5, V
2660 IF ww=4 THEN PRINT #6, V

2700 NEXT COUNT

2800 NEXT WW

3000 END



