: Fast Ca2+ & V-dependent K+ channel
: from Durstewitz & Gabriel (2006), Cerebral Cortex

NEURON {
	SUFFIX Kc
	USEION k READ ki, ko WRITE ik
	USEION ca READ cai
        RANGE gk, gKcbar
}

UNITS {
        (mM) = (milli/liter)
	(mA) = (milliamp)
	(mV) = (millivolt)
}

PARAMETER {
	cai		(mM)
	gKcbar= 0.0022	(mho/cm2)
}

ASSIGNED {
	v  (mV)
	ik (mA/cm2)
	cinf 
	ctau (ms)
	gk (mho/cm2)
	ek (mV)
	ki (mM)
	ko (mM)
}

STATE {
	c 
}

INITIAL {
	rate(v)
	c = cinf
}

BREAKPOINT {
	SOLVE states METHOD derivimplicit
	gk = gKcbar*c*c        
	ek = 25*log(ko/ki)
	ik = gk*(v-ek)
}

DERIVATIVE states {
        rate(v)
	c' = (cinf-c)/ctau
}

UNITSOFF

FUNCTION calf(v (mV), cai (mM)) (/ms) { 
	   LOCAL vs, va
           vs=v+40*log10(1000*cai)
	   va=vs+18
	   if (fabs(va)<1e-04){
	   	calf = -0.0064*(-12-va*0.5)
	   }
	   else {	   
		calf = (-0.0064*vs-0.1152)/(-1+exp(-va/12))
	   }
}

FUNCTION cbet(v (mV), cai (mM))(/ms) { 
	   LOCAL vs
	   vs=v+40*log10(cai*1000)+152
	   cbet = 1.7*exp(-vs/30)
}	

PROCEDURE rate(v) {
	   LOCAL  csum, ca, cb
	   ca=calf(v,cai) 
	   cb=cbet(v, cai)
	   csum = ca+cb
	   cinf = ca/csum
	   ctau = 1/csum
	   if (ctau<1.1) { ctau = 1.1 }
}
	
UNITSON
