// LDS_active.p Cell parameter file.       
// This file was developed by      
// Akira Takashima, Ryou Hikosaka and Masakazu Takahata.      
// Department of Biological Sciences       
// Faculry of Science        
// Hokkaido University         
// Sapporo Japan         
//           
// Last update on 22 Jan. 2007     


// Morphology file for crayfish nonspiking interneuron, LDS cell.   
// Original data provided by Takashima, A., Hikosaka, R., and Takahata,M.
// -2006 Functional significance of passive and active dendritic properties  
// in the synaptic integration by an identified nonspiking interneuron of 
// crayfish. J. Neurophysiol., 96:3157-3169.       
// The model cell of this file includes three voltage-dependent conductances,   
// Ks(Kd-like), Kt1(transient), Kt2(D-like). Excitatory and (inhibitory)       
// synaptic conductances are also included.        

// Format of file :         
// "x,y,z,dia" are in "10e-6centimeter," all other unit are physiological units   
// (centiMeter milliSec microAmp)          
// In polar mode 'r' is in 10^-2 "microns," theta and phi in degrees
// Control line options start with a '*'      
// The format for each compartment parameter line is :    
// name parent x y z d ch dens ...    
// in polar "mode," and in cartesian mode :     
// name parent x y z d ch dens ...    
// For "channels," 'dens' = maximum conductance per unit area    
// (per square centimeter) of compartment        
// For spike "elements," 'dens' is the spike threshold     
// Coordinate mode           
*relative             
*cartesian             
*asymmetric             

// Specifying constants           
*set_compt_param RM 25.8 // kiloOhm*cm2         
*set_compt_param RA 0.06 // kiloOhm*cm         
*set_compt_param CM 1 // microFarad/cm2         
*set_compt_param EREST_ACT -60 // milliVolts         
*set_compt_param ELEAK -60           
//             
soma none -2600 2400 -3000 3000 Ex_chan 0      
dend[1] soma -400 400 -400 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[2] dend[1] -800 800 -800 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[3] dend[2] 200 2000 -200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[4] dend[3] 400 400 -400 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[5] dend[4] 800 800 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[6] dend[5] 1200 600 -600 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[7] dend[6] 1200 600 -400 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[8] dend[7] 1800 1000 -600 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[9] dend[8] 1600 1000 -400 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[10] dend[9] 1600 1600 -1400 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[11] dend[10] 1200 2000 -1400 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[12] dend[11] 0 1600 -1200 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[13] dend[12] -200 800 -600 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[14] dend[13] 0 1400 -600 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[15] dend[14] 800 -1400 200 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[16] dend[15] 400 -1200 -200 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[17] dend[16] 200 -200 0 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[18] dend[17] 400 -800 0 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[19] dend[18] 0 -1000 200 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[20] dend[19] 200 -1800 -400 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[21] dend[20] 200 -1000 400 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[22] dend[21] 0 -1400 200 1400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[23] dend[22] -600 -1200 -600 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[24] dend[23] -400 -800 -200 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[25] dend[24] -400 -800 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[26] dend[25] -600 -800 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[27] dend[26] -600 -1000 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[28] dend[27] -400 -1000 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[29] dend[28] -600 -400 -400 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[30] dend[29] -200 -2000 -200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[31] dend[30] -200 -1200 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[32] dend[31] -200 -1200 400 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[33] dend[32] -400 -1000 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[34] dend[24] 0 -1200 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[35] dend[34] 200 -1400 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[36] dend[35] -400 -1200 -200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[37] dend[36] -600 -1200 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[38] dend[37] 200 -1200 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[39] dend[38] 0 -1000 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[40] dend[39] -200 -1000 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[41] dend[40] 200 -1000 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[42] dend[41] 200 -600 600 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[43] dend[42] -400 -600 1000 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[44] dend[22] 800 -1200 200 1400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[45] dend[44] 600 -1200 600 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[46] dend[45] 1400 -600 400 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[47] dend[46] 1200 -400 1000 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[48] dend[47] 1000 -400 600 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[49] dend[48] 200 -600 1400 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[50] dend[49] -400 -400 -400 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[51] dend[50] -400 1000 600 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[52] dend[51] -800 0 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[53] dend[52] -400 800 600 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[54] dend[53] -600 0 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[55] dend[48] 1000 200 600 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[56] dend[55] 800 -400 400 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[57] dend[56] 800 -400 400 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[58] dend[57] 1000 -600 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[59] dend[58] 1400 -800 -200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[60] dend[59] 400 -400 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[61] dend[45] 0 -1400 200 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[62] dend[61] 200 -1000 -200 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[63] dend[62] 400 -1000 200 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[64] dend[63] -600 -1200 -200 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[65] dend[64] -200 -600 -200 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[66] dend[65] 0 -1000 -200 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[67] dend[66] 400 -1200 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[68] dend[67] 400 -600 -200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[69] dend[68] -200 -600 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[70] dend[69] -400 -1400 400 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[71] dend[70] 0 -1600 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[72] dend[63] 400 -600 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[73] dend[72] 600 -800 600 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[74] dend[73] 600 -800 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[75] dend[74] 600 -1200 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[76] dend[75] 1000 -600 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[77] dend[76] 0 -400 600 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[78] dend[14] -600 1200 0 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[79] dend[78] -1000 1200 -400 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[80] dend[79] 1400 600 1800 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[81] dend[80] 0 1000 400 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[82] dend[81] 800 600 400 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[83] dend[82] 800 400 400 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[84] dend[83] 1400 200 600 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[85] dend[84] 1200 200 600 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[86] dend[85] 400 200 600 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[87] dend[86] 0 1400 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[88] dend[87] -200 800 400 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[89] dend[88] 400 1000 1800 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[90] dend[89] -600 1000 1000 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[91] dend[90] -600 1400 600 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[92] dend[91] -600 800 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[93] dend[92] -600 -200 -600 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[94] dend[93] -400 400 400 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[95] dend[94] 0 400 400 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[96] dend[95] 600 0 800 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[97] dend[96] 200 0 400 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[98] dend[97] -2000 0 600 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[99] dend[98] -1200 200 200 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[100] dend[99] -1000 400 1000 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[101] dend[86] 600 200 400 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[102] dend[101] 400 -600 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[103] dend[102] -400 -800 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[104] dend[103] -400 -400 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[105] dend[104] -600 -1000 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[106] dend[105] -1000 -1000 600 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[107] dend[106] -600 -400 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[108] dend[107] -1000 0 1000 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[109] dend[106] -200 -800 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[110] dend[109] -200 -600 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[111] dend[110] 400 -800 400 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[112] dend[111] 400 -600 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[113] dend[112] 1000 -800 800 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[114] dend[113] 1600 0 600 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[115] dend[101] 600 600 600 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[116] dend[115] 400 600 1200 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[117] dend[116] 400 -400 400 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[118] dend[117] 200 -800 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[119] dend[118] 600 -800 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[120] dend[116] -800 400 1600 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[121] dend[120] 400 400 600 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[122] dend[121] 600 800 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[123] dend[122] 1400 200 200 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[124] dend[123] 400 400 200 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[125] dend[124] 400 -1000 400 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[126] dend[125] 600 200 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[127] dend[126] -200 1000 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[128] dend[80] 600 -800 0 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[129] dend[128] 600 -200 200 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[130] dend[129] 1800 0 400 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[131] dend[130] 1600 -400 800 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[132] dend[131] 800 -200 200 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[133] dend[132] 2000 0 800 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[134] dend[133] 1200 200 400 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[135] dend[134] 1200 -200 400 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[136] dend[135] 600 0 200 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[137] dend[136] 1000 200 1200 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[138] dend[137] 0 1000 800 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[139] dend[138] 600 400 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[140] dend[137] 600 0 0 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[141] dend[140] 400 -200 800 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[142] dend[141] 600 1000 1000 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[143] dend[142] 400 -1000 400 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[144] dend[143] 400 -600 400 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[145] dend[141] 400 -1000 800 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[146] dend[145] 0 -800 600 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[147] dend[146] -200 -1600 600 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[148] dend[147] -400 -1000 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[149] dend[148] -200 -800 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[150] dend[149] -400 -1600 -200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[151] dend[150] 400 -1600 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[152] dend[151] 200 -1000 -400 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[153] dend[152] 200 -400 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[154] dend[153] 1000 -1200 -200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[155] dend[150] -600 -800 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[156] dend[155] -400 -800 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[157] dend[156] -400 -600 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[158] dend[157] -800 -600 400 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[159] dend[136] 1000 -1000 200 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[160] dend[159] 600 -800 -200 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[161] dend[160] 600 -600 -400 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[162] dend[161] 2200 200 600 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[163] dend[162] 1000 400 600 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[164] dend[163] 600 600 400 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[165] dend[164] 800 -200 800 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[166] dend[165] 1000 -600 1000 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[167] dend[166] 600 -800 1400 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[168] dend[167] 200 -200 800 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[169] dend[168] 0 -800 1400 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[170] dend[169] 0 -1200 1000 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[171] dend[170] 200 -1200 800 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[172] dend[171] 0 -1200 200 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[173] dend[172] -200 -1000 400 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[174] dend[173] -400 -1200 200 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[175] dend[174] -400 -800 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[176] dend[175] -200 -1000 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[177] dend[176] -400 -800 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[178] dend[79] -1000 1000 -400 1400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[179] dend[178] -1200 1400 -600 1400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[180] dend[179] -1200 1000 -400 1400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[181] dend[180] -1800 1200 -200 1600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[182] dend[181] -2000 1000 -400 1600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[183] dend[182] -1200 400 200 1600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[184] dend[183] -1200 400 0 1600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[185] dend[184] -200 -1000 2200 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[186] dend[185] 0 1200 800 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[187] dend[186] -200 600 200 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[188] dend[187] -200 600 0 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[189] dend[188] -200 1400 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[190] dend[189] 400 200 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[191] dend[190] 400 600 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[192] dend[191] 200 400 400 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[193] dend[192] -200 400 400 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[194] dend[193] -800 0 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[195] dend[194] -1000 400 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[196] dend[195] -800 200 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[197] dend[196] -400 400 600 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[198] dend[185] 800 -1400 600 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[199] dend[198] 400 -200 0 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[200] dend[199] 600 -200 400 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[201] dend[200] 1000 -200 200 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[202] dend[201] 1200 200 200 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[203] dend[202] 1200 200 0 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[204] dend[203] 800 1000 200 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[205] dend[204] -600 1200 800 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[206] dend[205] -600 1000 800 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[207] dend[206] 0 1000 400 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[208] dend[207] -400 400 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[209] dend[204] 1000 200 400 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[210] dend[209] 800 1000 200 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[211] dend[210] 800 800 400 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[212] dend[211] 0 1000 400 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[213] dend[212] 400 1400 600 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[214] dend[213] 200 2000 800 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[215] dend[214] 200 800 600 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[216] dend[215] -600 0 1000 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[217] dend[216] -1200 400 200 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[218] dend[217] -800 400 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[219] dend[218] -1200 1000 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[220] dend[219] -1000 1600 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[221] dend[220] -600 800 -1000 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[222] dend[221] 200 1400 -1000 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[223] dend[222] -400 600 -200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[224] dend[223] -200 1000 -400 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[225] dend[224] -400 1000 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[226] dend[225] -400 400 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[227] dend[201] 800 -1000 600 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[228] dend[227] 1000 -800 400 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[229] dend[228] 1200 -1000 600 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[230] dend[229] 800 -600 800 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[231] dend[230] 1000 -600 400 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[232] dend[231] 1000 -200 600 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[233] dend[232] 400 -600 200 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[234] dend[233] 800 -1000 800 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[235] dend[234] 400 -1000 200 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[236] dend[235] 1400 -200 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[237] dend[235] 400 -1200 200 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[238] dend[237] 200 -800 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[239] dend[238] 0 -1000 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[240] dend[239] -600 -800 -400 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[241] dend[240] -600 -600 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[242] dend[241] -400 0 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[243] dend[242] -600 200 -800 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[244] dend[243] -400 200 -600 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[245] dend[244] 400 600 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[246] dend[240] 0 -800 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[247] dend[246] -400 -1800 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[248] dend[247] -400 -1200 -200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[249] dend[248] -200 -1400 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[250] dend[249] 1000 -1000 -200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[251] dend[250] 600 -400 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[252] dend[251] -200 -400 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[253] dend[252] 0 -2200 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[254] dend[184] -1600 600 -600 1800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[255] dend[254] -1200 400 0 1800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[256] dend[255] -1200 200 0 2000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[257] dend[256] 800 -2000 -600 1400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[258] dend[257] 400 -1400 -400 1400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[259] dend[258] 600 -1400 -200 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[260] dend[259] 400 -800 0 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[261] dend[260] -400 -1000 200 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[262] dend[261] 200 -1200 400 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[263] dend[262] 200 -800 600 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[264] dend[263] 600 -800 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[265] dend[264] 200 -800 400 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[266] dend[265] -400 -800 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[267] dend[266] 0 -600 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[268] dend[267] 800 -1000 200 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[269] dend[268] 400 -600 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[270] dend[269] 800 -200 200 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[271] dend[270] 1000 -400 400 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[272] dend[271] 400 -400 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[273] dend[272] 1000 -400 200 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[274] dend[273] 800 -200 200 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[275] dend[274] 600 -800 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[276] dend[260] 1000 -1000 -200 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[277] dend[276] 1000 -1800 -200 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[278] dend[277] 1000 -1800 -400 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[279] dend[278] 400 -1000 200 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[280] dend[279] 400 -1800 -200 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[281] dend[280] 200 -1200 200 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[282] dend[281] 200 -1400 0 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[283] dend[282] 200 -1200 400 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[284] dend[283] -1200 -1200 0 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[285] dend[284] -600 -600 -200 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[286] dend[285] -400 -200 0 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[287] dend[286] -200 -1200 -400 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[288] dend[287] 0 -1000 -400 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[289] dend[288] 200 -800 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[290] dend[289] -600 -400 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[291] dend[290] -600 -200 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[292] dend[291] -1400 -200 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[293] dend[286] -1200 600 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[294] dend[293] -600 200 200 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[295] dend[294] -800 0 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[296] dend[295] -1200 -400 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[297] dend[296] -1200 -200 -200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[298] dend[283] 400 -1000 -200 1400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[299] dend[298] 200 -1200 0 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[300] dend[299] -200 -1000 -200 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[301] dend[300] -200 -1600 -200 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[302] dend[301] 200 -1200 -200 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[303] dend[302] -200 -600 -400 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[304] dend[303] 800 -1000 200 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[305] dend[304] 600 -2000 400 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[306] dend[305] 0 -1800 600 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[307] dend[306] 400 -600 800 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[308] dend[307] 800 -600 600 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[309] dend[308] 400 -200 600 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[310] dend[309] 0 -800 600 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[311] dend[303] -800 -1600 -800 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[312] dend[311] -200 -1000 -600 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[313] dend[312] 0 -1400 200 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[314] dend[313] 400 -800 0 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[315] dend[314] 400 -1000 0 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[316] dend[315] 400 -600 0 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[317] dend[316] -600 -600 -200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[318] dend[317] -800 -600 600 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[319] dend[318] -800 800 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[320] dend[319] -600 600 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[321] dend[316] 600 -400 200 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[322] dend[321] 200 -1000 -200 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[323] dend[322] 400 -1000 600 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[324] dend[323] 0 -1200 400 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[325] dend[324] 200 -1000 1200 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[326] dend[325] 1200 -1000 1800 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[327] dend[326] 600 -600 400 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[328] dend[327] 200 -1400 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[329] dend[325] -600 -1200 -400 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[330] dend[329] -400 -1400 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[331] dend[330] -800 -1000 -200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[332] dend[331] -400 -400 -200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[333] dend[332] -400 -400 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[334] dend[333] -200 -800 -600 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[335] dend[256] -1400 400 200 2000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[336] dend[335] -1000 400 0 2200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[337] dend[336] -1000 0 0 2400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[338] dend[337] 200 1800 800 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[339] dend[338] -200 1200 200 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[340] dend[339] 0 1000 200 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[341] dend[340] -200 800 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[342] dend[337] -1200 200 200 2000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[343] dend[342] 800 -1600 2000 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[344] dend[343] 1200 -1200 400 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[345] dend[342] -1400 -200 0 2400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[346] dend[345] -1000 -600 -400 2400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[347] dend[346] -1200 -400 -200 2000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[348] dend[347] -1400 -1000 -200 1800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[349] dend[348] -1400 -400 -200 2400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[350] dend[349] -1600 -200 0 2000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[351] dend[350] -1200 0 -200 2000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[352] dend[351] -800 0 0 1800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[353] dend[352] -1400 0 -200 2200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[354] dend[353] -1200 -200 0 1800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[355] dend[354] -1200 -200 0 1800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[356] dend[355] -1200 -200 0 1800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[357] dend[356] -400 1800 800 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[358] dend[357] -200 1800 400 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[359] dend[358] 800 800 3000 1800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[360] dend[359] -600 -200 400 1600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[361] dend[360] -1400 -200 800 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[362] dend[361] -1200 200 1000 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[363] dend[362] -800 200 1200 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[364] dend[363] -400 1000 1200 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[365] dend[364] 200 600 400 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[366] dend[365] 200 200 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[367] dend[363] -1200 0 0 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[368] dend[367] -1000 400 600 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[369] dend[368] -1200 -600 200 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[370] dend[369] -800 -200 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[371] dend[370] -600 -400 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[372] dend[361] -800 -1200 0 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[373] dend[372] -800 -800 400 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[374] dend[373] -400 -1000 400 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[375] dend[374] -400 -600 0 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[376] dend[375] 0 -400 0 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[377] dend[376] 600 -400 200 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[378] dend[377] 1800 -400 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[379] dend[378] 1000 -800 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[380] dend[373] -1400 200 0 1400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[381] dend[380] -800 0 0 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[382] dend[381] -1200 -200 0 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[383] dend[382] -1400 -200 0 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[384] dend[383] -1200 -600 400 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[385] dend[384] -1800 0 800 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[386] dend[385] -800 -200 200 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[387] dend[386] -1200 -400 200 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[388] dend[387] -400 0 600 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[389] dend[388] -400 -200 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[390] dend[384] -2800 -1400 400 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[391] dend[390] -800 -400 800 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[392] dend[391] -800 -400 400 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[393] dend[392] -1000 -400 400 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[394] dend[393] -800 -200 200 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[395] dend[394] -600 -200 -200 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[396] dend[395] -200 -600 0 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[397] dend[396] -400 -400 200 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[398] dend[397] -200 -800 600 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[399] dend[393] -600 -1200 400 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[400] dend[399] -800 -200 400 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[401] dend[400] 400 -400 600 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[402] dend[393] 200 -1400 600 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[403] dend[402] 800 -400 600 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[404] dend[403] 1000 -400 200 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[405] dend[404] 600 0 200 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[406] dend[356] -800 -800 1800 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[407] dend[406] -1000 -600 800 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[408] dend[407] -400 -600 800 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[409] dend[408] 0 -600 1000 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[410] dend[409] 600 200 0 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[411] dend[410] 600 200 400 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[412] dend[411] 800 0 0 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[413] dend[412] 800 200 200 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[414] dend[413] 600 -800 200 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[415] dend[414] 1000 -600 400 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[416] dend[356] -1000 -1000 0 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[417] dend[416] 0 -1600 -200 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[418] dend[417] 0 -1400 -200 1400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[419] dend[418] 0 -1000 0 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[420] dend[419] 600 -1000 0 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[421] dend[420] 200 -1600 200 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[422] dend[421] 800 -1600 -400 1400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[423] dend[422] 400 -800 0 1400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[424] dend[423] 200 -1400 -200 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[425] dend[424] 0 -400 200 1400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[426] dend[425] -1600 200 1800 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[427] dend[426] -200 600 1200 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[428] dend[427] 800 800 600 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[429] dend[428] 800 800 600 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[430] dend[429] 600 600 1000 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[431] dend[427] -600 -400 -800 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[432] dend[431] -1000 -600 1200 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[433] dend[432] -600 -600 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[434] dend[431] -1200 400 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[435] dend[434] -800 400 400 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[436] dend[435] -200 800 400 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[437] dend[436] -400 0 600 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[438] dend[425] -200 -1400 -200 1400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[439] dend[438] -400 -2000 0 1200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[440] dend[439] -1200 -1600 400 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[441] dend[440] -600 -1000 -200 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[442] dend[441] -800 -800 0 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[443] dend[442] -1000 -1200 200 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[444] dend[443] -1600 -1200 400 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[445] dend[444] -2200 -1000 1600 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[446] dend[445] -1800 -600 1400 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[447] dend[446] -400 200 2000 1400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[448] dend[447] -800 400 0 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[449] dend[448] -1000 -1000 600 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[450] dend[449] 0 -1200 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[451] dend[448] -600 200 600 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[452] dend[451] -400 1200 600 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[453] dend[452] 0 800 600 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[454] dend[453] 200 1200 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[455] dend[454] -200 400 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[456] dend[455] 600 1200 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[457] dend[456] 200 -400 400 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[458] dend[457] 200 400 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[459] dend[451] -800 -200 400 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[460] dend[459] -1000 -200 600 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[461] dend[460] -1400 400 800 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[462] dend[461] -1000 -600 200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[463] dend[462] -400 -800 400 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[464] dend[463] -1400 -800 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[465] dend[464] -2000 -600 -200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[466] dend[465] -600 200 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[467] dend[466] -1000 400 -200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[468] dend[467] -400 400 -200 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[469] dend[439] 200 -1000 400 1000 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[470] dend[469] 600 -400 1400 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[471] dend[470] 1200 -1000 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[472] dend[471] -200 -400 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[473] dend[469] -200 -2400 -2200 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[474] dend[473] -200 -2000 0 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[475] dend[474] -800 -1000 200 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[476] dend[475] -800 -1800 0 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[477] dend[476] -200 -800 0 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[478] dend[477] -1200 -1000 800 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[479] dend[478] -800 -1200 400 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[480] dend[479] -800 -1200 1000 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[481] dend[480] 200 -800 1000 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[482] dend[481] 200 200 1800 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[483] dend[482] 0 600 1000 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[484] dend[477] 200 -1000 0 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[485] dend[484] -1200 -1800 0 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[486] dend[485] -400 -1000 -400 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[487] dend[486] -600 -1000 400 800 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[488] dend[487] 200 -1400 400 400 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[489] dend[488] 0 -1200 200 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[490] dend[489] -200 -800 -200 600 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[491] dend[490] -200 -1400 0 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
dend[492] dend[491] 0 -600 400 200 K_tab_chan 0.237 Kfast_tab_chan 6.53 D_tab_chan 0.343 Ex_chan 0
