// genesis
//
// Cell morphology file for GENESIS.
// Written by cvapp (http://www.neuro.soton.ac.uk/cells/#software).

*absolute
*asymmetric
*cartesian

// End of cvapp-generated header file.

*set_compt_param RM 4.0
*set_compt_param RA 0.9
*set_compt_param CM 0.007
*set_compt_param ELEAK -0.08
*set_compt_param EREST_ACT -0.071

*add_spines 10.0 1 0.83

*spherical
*compt /library/soma
soma none 0 0 0 20.00

*cylindrical

*compt /library/Dend_Ap_shaft
p0[1]  soma  -4.815  13.412  -0.782  6.444 
p0[2]  p0[1]  -6.52  25.783  -0.437  4.75 

*compt /library/Dend_Ap_Obl
p0b1[0]  p0[2]  -6.475  27.37  -0.437  4.75 
p0b1b1[1]  p0b1[0]  0.797  28.149  -0.437  1.663 
p0b1b1[2]  p0b1b1[1]  8.084  27.094  -0.437  1.65 
p0b1b1b1[0]  p0b1b1[2]  18.408  27.894  0.553  1.035 
p0b1b1b1[1]  p0b1b1b1[0]  25.32  30.658  3.786  0.991 
p0b1b1b1[2]  p0b1b1b1[1]  26.17  37.999  6.885  1.004 
p0b1b1b1[3]  p0b1b1b1[2]  30.228  38.648  11.753  1.263 
p0b1b1b1[4]  p0b1b1b1[3]  33.12  33.522  10.453  0.62 
p0b1b1b2[0]  p0b1b1[2]  17.15  29.627  -3.095  1.257 
p0b1b1b2[1]  p0b1b1b2[0]  21.567  29.646  -10.306  1.352 
p0b1b1b2[2]  p0b1b1b2[1]  18.193  33.612  -17.509  1.287 
p0b1b1b2[3]  p0b1b1b2[2]  25.803  32.199  -23.823  1.145 
p0b1b1b2[4]  p0b1b1b2[3]  34.275  31.988  -29.732  1.107 
p0b1b1b2[5]  p0b1b1b2[4]  36.403  29.089  -39.181  1.131 
p0b1b1b2[6]  p0b1b1b2[5]  37.636  32.588  -49.076  1.082 
p0b1b1b2[7]  p0b1b1b2[6]  43.06  36.714  -56.849  1.106 
p0b1b1b2[8]  p0b1b1b2[7]  53.127  37.228  -60.11  1.079 
p0b1b1b2[9]  p0b1b1b2[8]  60.256  31.4  -63.89  1.149 
p0b1b1b2[10]  p0b1b1b2[9]  62.703  29.241  -67.403  2.385 
p0b1b1b2[11]  p0b1b1b2[10]  64.664  28.368  -74.016  1.452 
p0b1b1b2[12]  p0b1b1b2[11]  69.441  24.354  -79.364  1.006 
p0b1b1b2[13]  p0b1b1b2[12]  72.395  20.906  -85.489  1.085 
p0b1b1b2[14]  p0b1b1b2[13]  79.276  21.376  -91.819  0.884 
p0b1b1b2[15]  p0b1b1b2[14]  84.576  16.845  -96.435  0.989 
p0b1b1b2[16]  p0b1b1b2[15]  90.504  18.012  -103.776  0.87 
p0b1b1b2[17]  p0b1b1b2[16]  94.857  17.554  -111.548  0.927 
p0b1b1b2[18]  p0b1b1b2[17]  96.852  19.134  -121.104  0.836 
p0b1b1b2[19]  p0b1b1b2[18]  99.557  19.48  -128.501  0.969 
p0b1b1b2[20]  p0b1b1b2[19]  100.551  17.708  -136.216  0.669 
p0b1b1b2[21]  p0b1b1b2[20]  100.936  16.888  -140.704  1.166 
p0b1b1b2[22]  p0b1b1b2[21]  103.551  14.904  -147.404  0.716 
p0b1b1b2[23]  p0b1b1b2[22]  104.077  13.93  -155.812  0.63 
p0b1b1b2[24]  p0b1b1b2[23]  104.153  13.338  -161.161  0.992 
p0b1b1b2[25]  p0b1b1b2[24]  102.867  6.532  -160.724  0.62 

*compt /library/Dend_Ap
p0b1b2[0]  p0b1[0]  -10.062  35.662  1.299  4.75 

*compt /library/Dend_Ap_Obl
p0b1b2b1[0]  p0b1b2[0]  -10.787  40.572  2.61  4.75 

*compt /library/Dend_Ap
p0b1b2b1b1[0]  p0b1b2b1[0]  -9.856  43.631  2.61  4.75 

*compt /library/Dend_Ap_Obl
p0b1b2b1b1b1[0]  p0b1b2b1b1[0]  -10.062  44.068  -6.532  4.75 
p0b1b2b1b1b1b1[1]  p0b1b2b1b1b1[0]  -6.123  42.989  -13.434  1.752 
p0b1b2b1b1b1b1[2]  p0b1b2b1b1b1b1[1]  -6.815  43.535  -24.729  1.24 
p0b1b2b1b1b1b1[3]  p0b1b2b1b1b1b1[2]  -14.253  47.422  -28.691  1.514 
p0b1b2b1b1b1b1[4]  p0b1b2b1b1b1b1[3]  -19.31  51.708  -34.795  1.559 
p0b1b2b1b1b1b1[5]  p0b1b2b1b1b1b1[4]  -19.86  51.899  -46.172  1.24 
p0b1b2b1b1b1b1b1[0]  p0b1b2b1b1b1b1[5]  -21.068  51.931  -36.906  1.24 
p0b1b2b1b1b1b1b1[1]  p0b1b2b1b1b1b1b1[0]  -22.732  53.466  -37.384  5.009 
p0b1b2b1b1b1b1b1[2]  p0b1b2b1b1b1b1b1[1]  -23.955  53.923  -46.61  1.24 
p0b1b2b1b1b1b1b1b1[0]  p0b1b2b1b1b1b1b1[2]  -25.265  54.844  -46.583  9.129 
p0b1b2b1b1b1b1b1b1[1]  p0b1b2b1b1b1b1b1b1[0]  -29.175  60.781  -53.589  1.465 
p0b1b2b1b1b1b1b1b1[2]  p0b1b2b1b1b1b1b1b1[1]  -36.13  58.642  -58.201  1.697 
p0b1b2b1b1b1b1b1b1[3]  p0b1b2b1b1b1b1b1b1[2]  -38.404  64.644  -63.986  1.692 
p0b1b2b1b1b1b1b1b1[4]  p0b1b2b1b1b1b1b1b1[3]  -40.164  69.474  -73.611  1.34 
p0b1b2b1b1b1b1b1b1[5]  p0b1b2b1b1b1b1b1b1[4]  -41.399  67.392  -80.517  1.998 
p0b1b2b1b1b1b1b1b1[6]  p0b1b2b1b1b1b1b1b1[5]  -48.627  71.963  -85.414  1.31 
p0b1b2b1b1b1b1b1b1[7]  p0b1b2b1b1b1b1b1b1[6]  -48.778  78.079  -91.839  1.248 
p0b1b2b1b1b1b1b1b1[8]  p0b1b2b1b1b1b1b1b1[7]  -54.682  76.14  -97.131  1.356 
p0b1b2b1b1b1b1b1b1[9]  p0b1b2b1b1b1b1b1b1[8]  -63.705  79.384  -98.877  1.136 
p0b1b2b1b1b1b1b1b1[10]  p0b1b2b1b1b1b1b1b1[9]  -71.81  84.477  -100.625  1.053 
p0b1b2b1b1b1b1b1b1[11]  p0b1b2b1b1b1b1b1b1[10]  -76.897  86.013  -106.232  1.037 
p0b1b2b1b1b1b1b1b1[12]  p0b1b2b1b1b1b1b1b1[11]  -82.8  89.741  -111.471  0.917 
p0b1b2b1b1b1b1b1b1[13]  p0b1b2b1b1b1b1b1b1[12]  -87.416  87.738  -116.736  1.1 
p0b1b2b1b1b1b1b1b1[14]  p0b1b2b1b1b1b1b1b1[13]  -90.436  89.332  -124.579  0.83 
p0b1b2b1b1b1b1b1b2[0]  p0b1b2b1b1b1b1b1[2]  -24.406  52.015  -55.435  1.196 
p0b1b2b1b1b1b1b1b2[1]  p0b1b2b1b1b1b1b1b2[0]  -27.461  49.356  -63.248  1.074 
p0b1b2b1b1b1b1b1b2[2]  p0b1b2b1b1b1b1b1b2[1]  -21.621  47.106  -70.035  0.847 
p0b1b2b1b1b1b1b1b2[3]  p0b1b2b1b1b1b1b1b2[2]  -23.308  46.792  -76.327  1.2 
p0b1b2b1b1b1b1b1b2[4]  p0b1b2b1b1b1b1b1b2[3]  -27.6  45.694  -82.379  1.043 
p0b1b2b1b1b1b1b1b2[5]  p0b1b2b1b1b1b1b1b2[4]  -26.048  37.419  -84.094  0.91 
p0b1b2b1b1b1b1b1b2[6]  p0b1b2b1b1b1b1b1b2[5]  -33.042  33.491  -87.333  0.904 
p0b1b2b1b1b1b1b1b2[7]  p0b1b2b1b1b1b1b1b2[6]  -37.787  30.824  -93.077  0.989 
p0b1b2b1b1b1b1b1b2[8]  p0b1b2b1b1b1b1b1b2[7]  -38.599  26.106  -98.003  1.139 
p0b1b2b1b1b1b1b1b2[9]  p0b1b2b1b1b1b1b1b2[8]  -42.206  25.488  -103.293  1.216 
p0b1b2b1b1b1b1b1b2[10]  p0b1b2b1b1b1b1b1b2[9]  -46.92  24.007  -109.33  1.003 
p0b1b2b1b1b1b1b1b2[11]  p0b1b2b1b1b1b1b1b2[10]  -53.074  23.505  -111.941  1.167 
p0b1b2b1b1b1b1b1b2[12]  p0b1b2b1b1b1b1b1b2[11]  -55.522  27.152  -115.862  0.83 
p0b1b2b1b1b1b1b2[0]  p0b1b2b1b1b1b1[5]  -19.245  54.108  -52.065  1.896 
p0b1b2b1b1b1b1b2[1]  p0b1b2b1b1b1b1b2[0]  -18.278  61.055  -57.926  0.964 
p0b1b2b1b1b1b1b2[2]  p0b1b2b1b1b1b1b2[1]  -19.681  65.527  -62  1.311 
p0b1b2b1b1b1b1b2[3]  p0b1b2b1b1b1b1b2[2]  -22.874  71.902  -64.469  1.079 
p0b1b2b1b1b1b1b2[4]  p0b1b2b1b1b1b1b2[3]  -21.719  80.29  -64.35  0.962 
p0b1b2b1b1b1b1b2[5]  p0b1b2b1b1b1b1b2[4]  -20.686  83.956  -69.897  1.21 
p0b1b2b1b1b1b1b2[6]  p0b1b2b1b1b1b1b2[5]  -22.381  91.023  -73.857  0.984 
p0b1b2b1b1b1b1b2[7]  p0b1b2b1b1b1b1b2[6]  -21.497  93.611  -80.151  1.187 
p0b1b2b1b1b1b1b2[8]  p0b1b2b1b1b1b1b2[7]  -16.019  91.344  -84.617  1.097 
p0b1b2b1b1b1b1b2[9]  p0b1b2b1b1b1b1b2[8]  -18.255  91.58  -91.908  1.067 
p0b1b2b1b1b1b1b2[10]  p0b1b2b1b1b1b1b2[9]  -22.218  90.654  -97.566  0.83 

*compt /library/Dend_Ap
p0b1b2b1b1b1b2[0]  p0b1b2b1b1b1[0]  -8.044  53.194  0.944  4.47 
p0b1b2b1b1b1b2[1]  p0b1b2b1b1b1b2[0]  -4.68  57.845  -9.591  3.93 

*compt /library/Dend_Ap_Obl
p0b1b2b1b1b1b2b1[0]  p0b1b2b1b1b1b2[1]  -4.566  58.155  -9.591  3.93 
p0b1b2b1b1b1b2b1b1[1]  p0b1b2b1b1b1b2b1[0]  -6.332  62.171  -17.465  1.673 
p0b1b2b1b1b1b2b1b1[2]  p0b1b2b1b1b1b2b1b1[1]  -14.92  63.603  -23.529  1.422 
p0b1b2b1b1b1b2b1b1[3]  p0b1b2b1b1b1b2b1b1[2]  -24.197  66.419  -24.828  1.452 
p0b1b2b1b1b1b2b1b1[4]  p0b1b2b1b1b1b2b1b1[3]  -32.678  68.03  -27.876  1.247 
p0b1b2b1b1b1b2b1b1[5]  p0b1b2b1b1b1b2b1b1[4]  -39.613  65.753  -33.298  1.256 
p0b1b2b1b1b1b2b1b1[6]  p0b1b2b1b1b1b2b1b1[5]  -44.998  69.124  -37.68  1.479 
p0b1b2b1b1b1b2b1b1[7]  p0b1b2b1b1b1b2b1b1[6]  -48.748  65.195  -43.562  1.327 
p0b1b2b1b1b1b2b1b1[8]  p0b1b2b1b1b1b2b1b1[7]  -52.118  71.514  -47.484  1.012 
p0b1b2b1b1b1b2b1b1[9]  p0b1b2b1b1b1b2b1b1[8]  -54.536  79.544  -49.657  0.954 
p0b1b2b1b1b1b2b1b1[10]  p0b1b2b1b1b1b2b1b1[9]  -57.393  79.322  -58.328  0.905 
p0b1b2b1b1b1b2b1b1[11]  p0b1b2b1b1b1b2b1b1[10]  -62.987  75.594  -63.019  1.008 
p0b1b2b1b1b1b2b1b1[12]  p0b1b2b1b1b1b2b1b1[11]  -69.12  69.782  -66.917  0.888 
p0b1b2b1b1b1b2b1b1[13]  p0b1b2b1b1b1b2b1b1[12]  -75.252  64.962  -67.08  0.834 
p0b1b2b1b1b1b2b1b1[14]  p0b1b2b1b1b1b2b1b1[13]  -81.102  62.199  -67.08  0.824 
p0b1b2b1b1b1b2b1b1[15]  p0b1b2b1b1b1b2b1b1[14]  -83.929  54.377  -67.746  0.639 
p0b1b2b1b1b1b2b1b1[16]  p0b1b2b1b1b1b2b1b1[15]  -89.072  49.729  -69.142  0.754 
p0b1b2b1b1b1b2b1b1[17]  p0b1b2b1b1b1b2b1b1[16]  -93.644  44.045  -72.738  0.62 

*compt /library/Dend_Ap
p0b1b2b1b1b1b2b1b2[0]  p0b1b2b1b1b1b2b1[0]  0.678  63.756  -3.059  3.93 

*compt /library/Dend_Ap_Obl
p0b1b2b1b1b1b2b1b2b1[0]  p0b1b2b1b1b1b2b1b2[0]  4.082  67.172  -3.059  3.93 
p0b1b2b1b1b1b2b1b2b1b1[1]  p0b1b2b1b1b1b2b1b2b1[0]  10.978  66.729  -2.372  1.34 
p0b1b2b1b1b1b2b1b2b1b1[2]  p0b1b2b1b1b1b2b1b2b1b1[1]  14.708  61.168  -2.185  1.24 
p0b1b2b1b1b1b2b1b2b1b1b1[0]  p0b1b2b1b1b1b2b1b2b1b1[2]  17.134  53.317  -0.651  0.974 
p0b1b2b1b1b1b2b1b2b1b1b1[1]  p0b1b2b1b1b1b2b1b2b1b1b1[0]  25.741  51.07  0.862  0.902 
p0b1b2b1b1b1b2b1b2b1b1b1[2]  p0b1b2b1b1b1b2b1b2b1b1b1[1]  31.02  45.757  3.571  1.022 
p0b1b2b1b1b1b2b1b2b1b1b1[3]  p0b1b2b1b1b1b2b1b2b1b1b1[2]  34.649  51.6  8.268  0.83 
p0b1b2b1b1b1b2b1b2b1b1b2[0]  p0b1b2b1b1b1b2b1b2b1b1[2]  19.957  54.182  -1.311  1.288 
p0b1b2b1b1b1b2b1b2b1b1b2[1]  p0b1b2b1b1b1b2b1b2b1b1b2[0]  26.774  51.249  -5.205  1.064 
p0b1b2b1b1b1b2b1b2b1b1b2[2]  p0b1b2b1b1b1b2b1b2b1b1b2[1]  30.023  50.649  -10.453  1.319 
p0b1b2b1b1b1b2b1b2b1b1b2[3]  p0b1b2b1b1b1b2b1b2b1b1b2[2]  38.173  45.943  -10.453  0.87 
p0b1b2b1b1b1b2b1b2b1b1b2[4]  p0b1b2b1b1b1b2b1b2b1b1b2[3]  47.36  47.152  -10.27  0.883 
p0b1b2b1b1b1b2b1b2b1b1b2[5]  p0b1b2b1b1b1b2b1b2b1b1b2[4]  56.805  45.941  -10.453  0.859 
p0b1b2b1b1b1b2b1b2b1b1b2[6]  p0b1b2b1b1b1b2b1b2b1b1b2[5]  61.397  46.379  -10.453  1.774 
p0b1b2b1b1b1b2b1b2b1b1b2[7]  p0b1b2b1b1b1b2b1b2b1b1b2[6]  67.278  39.545  -10.453  0.908 
p0b1b2b1b1b1b2b1b2b1b1b2[8]  p0b1b2b1b1b1b2b1b2b1b1b2[7]  73.393  35.372  -11.328  1.098 
p0b1b2b1b1b1b2b1b2b1b1b2[9]  p0b1b2b1b1b1b2b1b2b1b1b2[8]  80.454  30.411  -11.328  0.948 
p0b1b2b1b1b1b2b1b2b1b1b2[10]  p0b1b2b1b1b1b2b1b2b1b1b2[9]  88.974  30.379  -11.328  0.96 
p0b1b2b1b1b1b2b1b2b1b1b2[11]  p0b1b2b1b1b1b2b1b2b1b1b2[10]  98.401  30.936  -11.599  0.866 
p0b1b2b1b1b1b2b1b2b1b1b2[12]  p0b1b2b1b1b1b2b1b2b1b1b2[11]  105.84  26.191  -11.764  0.927 
p0b1b2b1b1b1b2b1b2b1b1b2[13]  p0b1b2b1b1b1b2b1b2b1b1b2[12]  114.378  25.241  -12.434  0.95 
p0b1b2b1b1b1b2b1b2b1b1b2[14]  p0b1b2b1b1b1b2b1b2b1b1b2[13]  122.961  24.391  -14.812  0.915 
p0b1b2b1b1b1b2b1b2b1b1b2[15]  p0b1b2b1b1b1b2b1b2b1b1b2[14]  131.306  26.585  -14.812  0.948 
p0b1b2b1b1b1b2b1b2b1b1b2[16]  p0b1b2b1b1b1b2b1b2b1b1b2[15]  139.27  30.493  -14.812  0.923 
p0b1b2b1b1b1b2b1b2b1b1b2[17]  p0b1b2b1b1b1b2b1b2b1b1b2[16]  147.996  27.078  -14.812  0.873 
p0b1b2b1b1b1b2b1b2b1b1b2[18]  p0b1b2b1b1b1b2b1b2b1b1b2[17]  153.559  23.149  -18.296  0.83 

*compt /library/Dend_Ap
p0b1b2b1b1b1b2b1b2b1b2[0]  p0b1b2b1b1b1b2b1b2b1[0]  13.466  73.956  -9.591  3.93 

*compt /library/Dend_Ap_Obl
p0b1b2b1b1b1b2b1b2b1b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2[0]  15.882  76.67  -11.328  3.93 
p0b1b2b1b1b1b2b1b2b1b2b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1[0]  8.71  79.214  -7.843  1.361 
p0b1b2b1b1b1b2b1b2b1b2b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b1[1]  5.576  86.509  -3.484  0.914 
p0b1b2b1b1b1b2b1b2b1b2b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b1[2]  0.572  92.739  -0.489  0.966 
p0b1b2b1b1b1b2b1b2b1b2b1b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b1[3]  -1.507  93.713  6.532  0.83 

*compt /library/Dend_Ap
p0b1b2b1b1b1b2b1b2b1b2b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1[0]  18.333  92.557  -19.554  4.172 
p0b1b2b1b1b1b2b1b2b1b2b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2[0]  9.212  108.94  -22.655  3.72 

*compt /library/Dend_Ap_Obl
p0b1b2b1b1b1b2b1b2b1b2b1b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2[1]  5.911  112.125  -22.218  3.72 

*compt /library/Dend_Ap
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1[0]  3.232  115.598  -21.781  3.72 

*compt /library/Dend_Ap_Obl
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1[0]  3.174  115.77  -10.89  3.72 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[0]  7.665  123.917  -9.154  1.342 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1[1]  11.662  131.668  -6.894  1.41 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1[2]  10.476  138.31  -0.874  1.24 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1[3]  2.963  142.419  -0.874  1.147 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b1[0]  -4.356  145.079  3.484  1.1 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b1[1]  -5.474  150.76  7.831  1.356 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b1[2]  -6.325  157.492  11.316  1.03 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1[3]  7.63  147.603  -0.437  1.141 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b2[0]  8.304  158.043  -0.437  1.061 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b2[1]  8.95  167.95  0.862  1.108 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b2[2]  11.321  175.042  0.862  1.484 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b2[3]  9.955  185.228  1.287  1.079 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b2[4]  10.447  192.505  1.736  1.518 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b2[5]  11.98  199.116  3.047  1.605 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b2[6]  9.781  208.418  3.047  1.06 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b2[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b2[7]  8.91  216.782  3.91  0.95 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b2[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b2[8]  7.733  224.981  3.91  0.969 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b2[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b1b2[9]  2.07  227.205  3.484  0.83 

*compt /library/Dend_Ap
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[0]  -2.219  122.222  -21.781  3.72 

*compt /library/Dend_Ap_Obl
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2[0]  -4.382  125.154  -21.781  3.72 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1[0]  -16.465  124.475  -21.781  1.581 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[1]  -19.822  135.997  -24.702  1.55 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[2]  -24.412  133.772  -34.105  1.789 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[3]  -28.231  132.614  -45.829  1.545 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[4]  -39.121  129.821  -50.668  1.564 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[5]  -48.591  131.624  -47.592  1.509 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[6]  -55.529  135.946  -50.354  1.754 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[7]  -66.725  137.541  -47.921  1.308 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[8]  -78.259  137.92  -47.249  1.309 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[9]  -88.809  135.923  -46.61  1.119 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[10]  -95.929  134.204  -46.61  1.304 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[11]  -105.719  133.04  -46.807  0.841 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[12]  -113.379  133.515  -51.405  0.926 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[13]  -121.5  131.643  -53.716  0.958 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[15]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[14]  -129.573  131.258  -57.5  0.929 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[16]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[15]  -135.951  133.736  -61.421  1.051 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[17]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[16]  -141.263  139.572  -63.078  1.028 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[18]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[17]  -148.391  140.775  -67.033  1.006 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[19]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b1[18]  -152.306  138.437  -71.875  0.83 

*compt /library/Dend_Ap
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1[0]  -6.995  138.743  -18.933  3.823 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2[0]  -4.485  152.375  -19.17  3.72 

*compt /library/Dend_Ap_Obl
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2[1]  -3.715  153.525  -19.607  3.72 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1[0]  1.023  151.996  -20.907  1.65 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1[1]  -0.532  147.563  -28.414  1.365 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1[0]  -9.207  146.915  -31.252  1.321 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1[1]  -12.915  141.248  -36.511  1.409 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1[2]  -13.996  138.713  -43.125  1.24 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1[3]  -20.583  135.631  -43.235  1.136 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1[0]  -27.031  132.613  -44.862  0.882 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1[1]  -32.544  127.734  -45.298  0.873 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1[2]  -38.651  128.777  -47.046  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1[3]  -44.713  125.436  -51.405  0.968 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1[0]  -48.506  125.884  -56.675  1.217 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1[1]  -48.484  126.123  -66.215  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1[2]  -48.461  126.362  -75.796  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1[3]  -50.122  120.528  -79.395  1.077 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b1[0]  -53.495  115.885  -84.93  0.953 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b1[1]  -59.187  114.587  -90.394  0.95 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b1[2]  -62.204  112.745  -96.861  1.031 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b1[3]  -63.687  109.549  -103.235  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1[3]  -49.695  126.188  -66.197  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[0]  -50.929  126.015  -56.597  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[1]  -55.261  122.321  -52.268  1.123 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[2]  -60.592  116.172  -54.89  0.94 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[3]  -68.968  112.505  -54.89  0.879 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[4]  -73.156  107.836  -58.8  1.087 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[5]  -81.61  107.075  -61.433  0.904 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[6]  -87.118  104.015  -67.589  0.912 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[7]  -93.551  102.297  -71.001  1.074 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[8]  -102.342  99.395  -71.001  0.868 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[9]  -107.989  99.122  -71.16  1.421 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[10]  -116.664  99.822  -72.312  0.915 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[11]  -124.552  95.534  -72.992  0.892 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[12]  -127.836  93.229  -81.454  0.858 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[13]  -132.343  95.718  -86.676  0.839 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[15]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b1b2[14]  -139.392  98.578  -86.676  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1[3]  -43.073  133.526  -44.436  1.077 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b2[0]  -45.787  136.025  -47.046  1.667 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b2[1]  -51.745  140.036  -49.555  0.99 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b2[2]  -50.714  141.894  -58.044  0.861 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b2[3]  -55.811  141.51  -59.284  1.432 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b2[4]  -53.739  144.816  -66.642  0.904 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b2[5]  -48.058  143.567  -72.126  0.942 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b2[6]  -46.893  146.446  -78.848  1.017 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b2[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b1b2[7]  -48.507  153.284  -81.891  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1[3]  -22.137  141.072  -44.436  1.579 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b2[0]  -32.367  138.874  -44.579  1.294 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b2[1]  -36.154  134.022  -51.405  1.473 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b2[2]  -42.559  134.095  -57.937  1.232 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b1b2[3]  -41.549  127.684  -60.548  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1[1]  6.648  146.705  -26.98  1.444 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2[0]  14.295  144.099  -33.108  1.399 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2[1]  23.993  142.79  -35.033  1.423 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2[2]  29.907  143.194  -44.308  1.289 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2[3]  38.598  139.942  -48.918  1.369 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2[4]  47.151  140.122  -51.891  1.567 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2[5]  52.799  136.547  -57.057  1.679 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2[6]  58.51  140.058  -64.021  1.468 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2[7]  66.8  142.773  -66.642  1.558 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2[8]  75.46  141.788  -69.69  1.537 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2[9]  80.236  144.635  -76.233  1.24 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2[10]  84.356  142.257  -76.659  1.116 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b1[0]  84.169  140.691  -79.281  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b1[1]  81.947  138.159  -86.202  0.69 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b1b1[0]  81.023  138.016  -94.715  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b1b1[1]  81.178  140.334  -101.05  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b1[1]  80.731  139.34  -85.83  0.622 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b1b2[0]  80.407  137.53  -91.98  0.728 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b1b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b1b2[1]  83.245  138.301  -97.007  0.803 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b1b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b1b2[2]  79.929  135.922  -103.089  0.638 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b1b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b1b2[3]  77.148  134.661  -109.188  0.686 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b1b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b1b2[4]  76.854  133.883  -116.736  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2[10]  88.745  148.33  -75.796  0.835 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b2[0]  95.065  146.287  -76.233  1.165 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b2[1]  102.16  151.218  -76.233  0.898 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b2[2]  110.901  148.589  -76.233  0.85 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b2[3]  118.802  153.403  -76.233  0.839 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b1b2b2[4]  123.13  158.332  -81.454  0.83 

*compt /library/Dend_Ap
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1[0]  -0.21  164.84  -20.279  3.799 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2[0]  4.301  174.029  -24.828  3.31 

*compt /library/Dend_Ap_Obl
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2[1]  5.186  175.501  -33.546  3.31 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1[0]  7.966  169.727  -38.329  1.026 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[1]  7.674  169.192  -46.752  0.972 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[2]  6.705  167.676  -56.092  0.863 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[3]  15.671  165.997  -57.717  0.886 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[4]  20.093  170.164  -60.548  1.224 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[5]  22.689  166.556  -66.434  1.112 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[6]  26.081  164.026  -70.52  1.395 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[7]  28.106  169.117  -76.859  0.979 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[8]  35.387  168.271  -83.202  0.846 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[9]  40.519  162.709  -86.367  1 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[10]  39.959  160.765  -89.147  2.386 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[11]  43.729  160.788  -97.856  0.865 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[12]  45.244  163.221  -105.266  1.033 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[13]  48.526  161.384  -113.796  0.88 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[15]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[14]  51.006  162.723  -115.711  2.408 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[16]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[15]  56.949  160.251  -121.515  0.947 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[17]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[16]  57.828  155.816  -123.705  1.633 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[18]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[17]  63.556  156.681  -129.287  1.02 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[19]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[18]  68.021  157.031  -132.848  1.434 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[20]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[19]  72.671  156.49  -138.797  1.084 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[21]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[20]  72.534  159.816  -144.549  1.235 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[22]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[21]  72.687  155.954  -150.238  1.193 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[23]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[22]  76.755  158.876  -157.676  0.915 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[24]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[23]  79.435  157.646  -163.823  1.204 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[25]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[24]  80.754  155.651  -171.163  1.063 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[26]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[25]  87.293  157.758  -177.272  0.892 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[27]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[26]  95.336  158.675  -180.305  0.949 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[28]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[27]  103.106  159.152  -183.379  0.98 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[29]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b1[28]  103.086  164.876  -189.037  0.83 

*compt /library/Dend_Ap
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1[0]  4.876  180.067  -38.766  3.31 

*compt /library/Dend_Ap_Obl
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2[0]  6.014  180.964  -46.172  3.31 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1[0]  9.03  174.418  -50.094  1.1 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1[1]  16.943  175.068  -52.237  1.098 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1[2]  24.685  174.419  -54.593  1.112 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1[3]  28.911  167.256  -54.015  1.03 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1[4]  33.826  169.197  -58.059  1.688 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[0]  39.258  173.712  -64.906  1.142 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[1]  48.892  175.162  -64.032  1.148 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[2]  57.652  177.202  -64.906  1.243 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[3]  61.197  185.564  -67.718  1.181 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[4]  69.753  189.69  -67.953  1.182 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[5]  79.857  191.047  -67.953  1.102 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[6]  87.363  197.925  -67.953  1.103 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[7]  95.345  200.643  -67.953  1.332 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[8]  98.367  207.797  -71.001  1.346 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[9]  104.135  213.246  -72.738  1.383 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[10]  111.895  217.137  -76.233  1.2 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[11]  117.775  224.701  -76.233  1.172 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[12]  126.538  229.414  -76.233  1.129 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[13]  131.427  233.956  -78.228  1.5 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[15]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1[14]  132.963  237.498  -84.939  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1[4]  32.476  159.758  -58.208  1.204 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[0]  31.945  155.172  -66.921  1.136 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[1]  26.869  151.196  -73.701  1.197 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[2]  26.939  155.296  -81.404  1.283 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[3]  32.345  147.991  -86.71  1.064 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[4]  30.448  141.079  -90.178  1.406 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[5]  32.647  135.914  -93.936  1.658 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[6]  30.618  129.808  -95.392  1.698 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[7]  31.055  121.124  -99.727  1.032 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[8]  33.988  113.5  -99.751  0.992 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[9]  28.643  114.881  -106.147  0.959 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[10]  32.02  109.244  -111.648  0.945 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[11]  33.797  103.801  -118.917  0.875 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[12]  40.222  98.247  -121.095  0.924 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[13]  43.122  90.693  -122.862  0.978 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[15]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[14]  47.151  88.691  -129.364  1.025 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[16]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[15]  46.946  94.105  -135.769  0.966 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[17]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[16]  50.729  94.472  -140.691  1.303 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[18]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[17]  52.229  93.559  -145.909  1.471 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[19]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[18]  50.624  93.664  -155.536  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[20]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b1b2[19]  49.277  92.552  -163.772  0.83 

*compt /library/Dend_Ap
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1[0]  6.293  191.544  -50.209  4.617 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2[0]  5.219  201.748  -58.374  3.988 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2[1]  4.899  203.665  -44.436  3.31 

*compt /library/Dend_Ap_Obl
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2[2]  4.853  206  -44.436  3.31 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[0]  -2.023  207.166  -43.056  1.756 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1[1]  -6.931  213.421  -37.35  1.276 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1[2]  -9.815  219.093  -32.04  1.506 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1[3]  -17.17  221.179  -28.313  1.24 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1[4]  -20.739  225.801  -23.583  1.035 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b1[0]  -15.223  230.348  -19.558  0.948 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b1[1]  -21.221  232.945  -14.547  0.944 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b1[2]  -26.076  237.929  -12.041  1.051 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b1[3]  -26.963  245.885  -9.154  0.914 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b1[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b1[4]  -26.848  253.884  -6.766  0.931 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b1[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b1[5]  -26.588  258.507  -0.915  1.042 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b1[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b1[6]  -28.77  266.275  0.862  0.941 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b1[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b1[7]  -28.675  274.283  2.471  0.952 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b1[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b1[8]  -23.84  278.783  0.437  1.125 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b1[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b1[9]  -30.364  283.869  -0.437  0.935 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b1[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b1[10]  -35.581  286.522  -0.437  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1[4]  -25.735  216.864  -25.544  1.129 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[0]  -29.4  222.471  -17.392  1.068 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[1]  -34.365  227.242  -11.764  1.268 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[2]  -42.59  228.788  -7.285  1.188 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[3]  -48.652  225.958  -5.232  1.611 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[4]  -56.271  232.369  -3.922  1.123 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[5]  -65.684  229.653  -3.922  1.039 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[6]  -72.769  224.748  -3.059  0.942 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[7]  -82.266  225.106  -3.895  0.855 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[8]  -90.141  222.076  -3.484  0.965 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[9]  -96.021  221.129  -3.922  1.366 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[10]  -104.085  222.476  -3.922  0.998 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[11]  -110.417  226.253  -3.922  1.106 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[12]  -116.651  231.418  -3.922  1.007 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[13]  -121.801  233.357  -3.178  1.469 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[15]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[14]  -129.548  233.292  -0.929  1.011 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[16]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[15]  -137.49  235.112  0.437  0.987 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[17]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[16]  -144.531  236.033  1.736  1.13 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[18]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[17]  -147.457  244.535  3.484  0.89 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[19]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b1b2[18]  -155.894  248.25  3.91  0.83 

*compt /library/Dend_Ap
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[0]  7.324  218.87  -35.719  3.578 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2[0]  8.303  235.152  -32.235  3.31 

*compt /library/Dend_Ap_Obl
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2[1]  8.246  240.89  -32.235  3.31 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1[0]  18.825  242.477  -33.982  1.797 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[1]  21.755  252.941  -34.516  1.79 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[2]  33.357  256.416  -31.797  1.569 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[3]  38.304  266.894  -32.235  1.68 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[4]  50.839  264.945  -31.36  1.532 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[5]  57.676  272.336  -25.702  1.686 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[6]  69.94  268.424  -24.975  1.511 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[7]  82.684  270.448  -26.139  1.503 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[8]  88.098  279.322  -27.876  1.848 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[9]  96.495  287.75  -27.876  1.637 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[10]  107.639  292.287  -27.728  1.619 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[11]  119.389  296.319  -26.139  1.555 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[12]  131.201  299.488  -26.139  1.593 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[13]  142.442  303.988  -24.392  1.592 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[15]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b1[14]  152.697  306.486  -18.733  1.24 

*compt /library/Dend_Ap
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1[0]  1.911  257.352  -36.674  3.332 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2[0]  -4.879  273.23  -41.679  3.37 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2[1]  1.866  284.356  -48.386  4.14 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2[2]  16.607  293.018  -53.283  3.407 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2[3]  20.276  309.71  -50.836  3.51 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2[4]  13.577  325.909  -48.66  3.43 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2[5]  9.884  341.611  -50.402  3.735 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2[6]  7.028  355.706  -60.11  3.492 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2[7]  9.188  372.669  -64.032  3.31 

*compt /library/Dend_Ap_Med
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2[8]  11.144  381.972  -62.721  3.31 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[0]  27.941  383.1  -54.89  2.939 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[0]  25.368  400.002  -53.142  3.175 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[1]  18.322  415.25  -49.657  2.858 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[2]  23.998  430.116  -46.101  3.005 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[3]  19.129  445.488  -46.61  3.038 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[4]  13.477  461.938  -47.634  2.806 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[5]  9.325  476.128  -50.547  2.879 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[6]  10.078  488.374  -53.513  3.437 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[7]  7.809  498.608  -51.405  4.057 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[8]  11.211  514.653  -54.429  2.601 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[9]  18.027  529.414  -58.374  2.593 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[10]  19.272  545.996  -59.674  2.601 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[11]  11.162  557.884  -61.862  2.98 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[12]  15.957  572.264  -64.906  2.805 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[13]  18.819  588.921  -63.595  2.559 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[15]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[14]  13.721  603.661  -65.343  2.764 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[16]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[15]  24.35  616.834  -65.343  2.563 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[17]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[16]  25  632.602  -66.205  2.608 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[18]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[17]  22.317  646.335  -65.768  2.713 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[19]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[18]  28.613  655.044  -68.827  3.4 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[20]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[19]  23.022  669.001  -66.205  2.489 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[21]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[20]  27.858  683.053  -65.768  2.555 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[22]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[21]  30.563  696.205  -65.79  2.829 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[23]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[22]  21.693  708.416  -68.39  2.48 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[24]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[23]  23.401  723.791  -69.253  2.452 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[25]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[24]  26.464  738.25  -65.343  2.485 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[26]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[25]  24.619  751.984  -67.516  2.708 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[27]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[26]  14.779  764.324  -66.036  2.396 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[28]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[27]  12.139  778.581  -62.112  2.529 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[29]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[28]  18.832  791.152  -65.615  2.59 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[30]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[29]  22.507  806.118  -62.736  2.423 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[31]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[30]  17.521  821.455  -62.721  2.355 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[32]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[31]  15.453  834.861  -61.858  2.795 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[33]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[32]  18.544  848.689  -57.262  2.55 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[34]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[33]  23.504  861.797  -53.142  2.6 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[35]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[34]  22.367  878.427  -52.268  2.27 

*compt /library/Dend_Ap_Dis
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[35]  21.873  879.508  -52.268  2.27 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1[0]  17.023  885.218  -48.649  0.943 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[0]  16.808  889.68  -44.362  1.267 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[1]  11.29  896.966  -43.125  0.851 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[2]  3.009  901.157  -43.125  0.846 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[3]  -1.719  907.585  -43.125  0.984 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[4]  -0.847  916.168  -43.684  0.908 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[5]  -7.246  919.272  -43.125  1.1 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[6]  -11.93  925.271  -40.62  0.979 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[7]  -14.27  933.689  -41.388  0.895 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[8]  -15.129  942.415  -40.514  0.891 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[9]  -19.98  948.822  -38.96  0.959 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[10]  -26.76  953.936  -38.329  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[11]  -33.403  960.65  -39.453  0.874 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[0]  -40.585  967.028  -39.64  0.865 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[1]  -45.124  973.56  -38.766  1.039 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[2]  -51.52  980.794  -39.64  0.858 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[3]  -57.74  986.318  -39.64  0.999 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[4]  -66.274  990.18  -40.952  0.879 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[5]  -70.541  998.972  -40.952  0.851 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[6]  -74.659  1006.922  -39.204  0.911 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[7]  -80.077  1014.876  -38.849  0.863 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[8]  -85.661  1022.857  -38.766  0.854 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[9]  -86.89  1032.557  -39.755  0.846 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[10]  -95.164  1037.657  -40.515  0.853 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[11]  -99.401  1044.49  -44.519  0.926 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[12]  -101.147  1051.413  -47.757  1.061 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[13]  -108.928  1054.337  -51.842  0.898 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[15]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[14]  -118.318  1053.927  -51.842  0.885 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[16]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[15]  -125.727  1058.275  -53.142  0.957 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[17]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[16]  -133.288  1060.082  -54.452  1.055 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[18]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[17]  -136.704  1069.375  -54.89  0.839 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[19]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[18]  -143.267  1072.053  -56.626  1.139 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[20]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[19]  -149.404  1079.48  -57.063  0.862 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[21]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[20]  -151.801  1082.083  -63.158  0.821 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[22]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[21]  -158.902  1083.127  -67.08  0.656 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[23]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[22]  -161.135  1087.416  -70.237  0.929 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[24]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[23]  -163.73  1088.735  -75.796  0.855 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[25]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[24]  -169.89  1092.212  -79.718  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[25]  -174.634  1093.43  -85.714  0.69 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[0]  -178.687  1093.086  -92.782  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[25]  -171.642  1091.632  -86.472  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2[0]  -177.711  1093.266  -88.423  0.66 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2[1]  -180.215  1097.587  -91.811  0.719 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2[2]  -178.664  1101.482  -96.703  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[11]  -29.175  961.006  -35.282  0.896 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2[0]  -34.954  966.757  -34.845  0.885 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2[1]  -34.949  971.558  -34.266  1.495 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2[2]  -41.813  974.441  -32.046  0.931 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2[3]  -47.564  978.305  -27.876  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2[4]  -51.037  978.827  -23.823  0.937 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1[0]  -54.922  982.772  -23.092  0.9 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1[1]  -56.721  986.282  -20.731  1.094 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1[2]  -63.727  987.515  -17.353  0.638 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1[3]  -66.952  991.891  -14.188  0.799 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1[4]  -70.743  994.953  -9.2  0.721 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1[5]  -73.932  996.619  -8.261  1.352 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1[6]  -77.505  1000.264  -11.764  0.812 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1[7]  -80.033  1005.521  -11.764  0.862 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1[8]  -80.81  1013.092  -11.764  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1[9]  -79.835  1015.639  -9.154  0.427 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1b1[0]  -77.176  1018.198  -8.717  0.41 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1[9]  -84.256  1014.559  -12.851  0.571 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1b2[0]  -86.917  1011.574  -12.638  0.41 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2[4]  -48.569  984.986  -27.18  0.758 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[0]  -51.803  990.245  -27.013  0.833 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[1]  -49.296  995.242  -27.013  0.92 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[2]  -49.945  1002.92  -25.702  0.658 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[3]  -52.408  1010.384  -25.702  0.655 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[4]  -53.165  1018.427  -26.576  0.633 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[5]  -54.293  1025.857  -27.725  0.677 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[6]  -52.811  1033.593  -27.013  0.651 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[7]  -51.663  1040.757  -28.313  0.698 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[8]  -51.319  1047.973  -26.139  0.682 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[9]  -53.429  1050.502  -18.733  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1[0]  29.292  889.798  -49.778  2.258 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[0]  33.954  900.293  -48.262  2.157 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[1]  31.656  910.484  -43.999  1.884 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[2]  33.741  921.912  -43.562  1.555 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[3]  37.465  932.921  -43.562  1.473 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[4]  37.748  943.118  -42.287  1.665 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[5]  40.053  949.967  -34.233  1.582 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[6]  42.734  958.973  -28.75  1.45 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[7]  45.167  965.848  -28.75  0.889 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1[0]  42.376  972.45  -30.061  0.89 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1[1]  36.317  976.695  -30.061  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1[2]  31.828  984.809  -30.498  0.846 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[0]  32.053  993.008  -28.75  0.937 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[1]  30.018  1000.89  -30.27  0.949 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[2]  30.589  1008.313  -29.187  1.044 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[3]  29.294  1015.766  -29.187  1.038 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[4]  31.56  1023.863  -29.664  0.933 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[5]  33.506  1030.752  -27.181  1.037 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[6]  35.137  1037.48  -24.698  1.068 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[7]  35.972  1045.476  -21.781  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[8]  38.216  1048.459  -21.781  1.24 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b1[0]  36.397  1049.616  -21.781  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[8]  42.869  1045.312  -21.344  0.747 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b2[0]  45.639  1050.773  -21.344  0.843 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b2[1]  49.07  1053.94  -26.139  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1[2]  37.921  984.872  -30.061  0.983 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[0]  38.681  992.383  -35.041  0.905 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[1]  37.872  998.112  -41.797  0.921 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[2]  44.24  1003.863  -43.125  0.943 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[3]  47.769  1011.164  -45.298  0.976 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[4]  51.879  1016.64  -49.38  1.027 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[5]  56.14  1023.264  -52.268  0.976 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[6]  56.119  1027.788  -55.122  1.531 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[7]  62.867  1031.749  -60.019  0.887 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[8]  64.272  1039.842  -62.102  0.966 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[9]  70.931  1042.921  -66.16  0.977 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[10]  71.976  1042.16  -75.024  0.742 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[11]  73.518  1041.224  -82.011  0.733 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[12]  74.621  1042.19  -89.546  0.689 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[13]  74.043  1045.35  -94.955  0.84 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[15]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[14]  76.988  1049.092  -97.448  0.984 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[16]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[15]  82.142  1044  -99.207  0.709 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[17]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[16]  87.441  1044.244  -103.611  0.767 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[18]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[17]  90.456  1046.684  -109.912  0.715 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[19]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[18]  93.665  1053.27  -113.318  0.654 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[20]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[19]  96.504  1053.171  -116.872  1.162 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[21]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[20]  101.861  1053.918  -121.957  0.712 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[22]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[21]  104.841  1059.86  -123.268  0.78 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[23]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[22]  106.712  1065.941  -126.85  0.724 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[24]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[23]  108.605  1066.993  -133.285  0.779 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[25]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[24]  108.33  1071.88  -139.38  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[7]  49.979  967.07  -26.576  1.24 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[0]  47.056  972.638  -22.516  1.11 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b1[0]  51.735  977.854  -18.247  1.013 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b1[1]  53.794  984.048  -13.938  1.044 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b1[2]  58.036  989.069  -11.328  0.759 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b1[3]  60.524  995.06  -9.154  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[0]  54.149  976.561  -27.013  1.109 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[0]  63.437  979.922  -27.394  1.165 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[1]  72.845  983.584  -28.108  0.909 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[2]  77.938  991.606  -28.75  0.874 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[3]  84.739  992.981  -28.75  1.2 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[4]  91.078  995.993  -28.05  1.181 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[5]  94.543  1004.142  -26.139  0.919 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[6]  99.483  1011.83  -26.576  0.91 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[7]  105.76  1019.131  -26.457  0.865 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[8]  110.854  1022.843  -26.576  1.321 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[9]  115.189  1030.812  -27.49  0.913 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[10]  120.388  1036.763  -29.624  1.017 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[11]  123.692  1044.803  -30.498  0.953 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[12]  123.326  1053.776  -32.893  0.896 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[13]  123.313  1056.87  -39.598  1.128 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[15]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[14]  120.978  1062.091  -44.442  1.111 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[16]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[15]  116.586  1069.389  -45.564  0.969 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[17]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[16]  119.739  1073.234  -48.859  1.396 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[18]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[17]  118.985  1080.828  -52.298  0.959 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[19]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[18]  119.917  1087.129  -56.626  0.698 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[20]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[19]  123.073  1094.225  -57.5  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[20]  123.924  1099.582  -60.262  0.669 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2b1[0]  124.357  1104.449  -63.595  0.689 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2b1[1]  129.168  1107.024  -64.469  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2b1[2]  132.736  1107.39  -67.356  0.812 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2b1b1[0]  136.022  1108.646  -71.001  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2b1[2]  131.368  1109.883  -70.564  0.683 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2b1b2[0]  135.439  1115.304  -72.219  0.693 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2b1b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2b1b2[1]  139.89  1117.857  -74.036  0.889 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2b1b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2b1b2[2]  144.912  1119.352  -79.718  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[20]  126.262  1095.275  -60.367  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2b2[0]  129.824  1096.065  -62.296  0.62 

*compt /library/Dend_Ap_Med
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[0]  13.736  394.265  -59.175  4.05 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2[0]  12.052  403.638  -58.8  3.1 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2[1]  -0.726  411.481  -60.984  2.139 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[0]  -6.635  423.179  -65.768  2.324 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[1]  -15.815  433.111  -68.827  2.338 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[2]  -11.927  444.179  -72.345  2.647 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[3]  -10.494  455.203  -75.796  2.785 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[4]  -20.477  466.29  -75.36  2.172 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[5]  -24.748  477.127  -79.052  2.653 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[6]  -19.113  489.123  -79.618  2.444 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[7]  -22.839  501.836  -78.407  2.437 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[8]  -31.882  513.543  -79.281  2.187 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[9]  -32.407  527.194  -81.273  2.348 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[10]  -27.918  535.813  -83.628  3.242 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[11]  -38.308  546.631  -84.502  2.157 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[12]  -35.488  559.399  -83.476  2.471 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[13]  -32.663  571.687  -87.112  2.47 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[15]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[14]  -40.01  582.457  -85.813  2.474 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[16]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[15]  -40.363  596.131  -85.813  2.37 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[17]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[16]  -37.401  609.647  -89.269  2.273 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[18]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[17]  -28.923  621.221  -92.336  2.21 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[19]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[18]  -36.714  632.428  -96.266  2.282 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[20]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[19]  -39.993  645.694  -97.566  2.361 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[21]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[20]  -37.323  660.696  -97.566  2.127 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[22]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[21]  -42.619  675.136  -96.703  2.104 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[23]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[22]  -42.364  687.75  -98.038  2.555 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[24]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[23]  -37.503  693.866  -99.314  4.095 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[25]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[24]  -46.686  706.154  -98.003  2.105 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[26]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[25]  -47.584  721.244  -98.877  2.141 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[27]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[26]  -45.208  736.056  -95.829  2.118 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[28]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[27]  -43.12  750.671  -95.947  2.196 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[29]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[28]  -52.316  762.376  -97.566  2.165 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[30]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[29]  -47.194  774.477  -99.314  2.18 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[31]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[30]  -40.739  786.364  -99.314  2.041 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[32]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[31]  -44.204  798.661  -96.703  2.117 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[33]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[32]  -46.114  811.21  -96.703  2.175 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[34]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[33]  -45.874  819.343  -100.818  3.028 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[35]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[34]  -49.319  832.507  -99.751  2.023 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[36]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[35]  -49.108  845.797  -95.486  1.978 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[37]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[36]  -48.64  859.76  -93.219  1.951 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[38]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[37]  -56.856  869.618  -93.219  1.86 

*compt /library/Dend_Ap_Dis
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1[38]  -55.35  870.32  -93.219  1.86 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[0]  -56.241  882.675  -93.334  2.077 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1[0]  -56.529  895.259  -93.244  1.722 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1[1]  -51.21  905.28  -97.566  1.65 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1[2]  -59.179  910.25  -99.751  1.604 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[0]  -65.615  917.091  -98.877  1.64 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[1]  -68.59  927.08  -99.178  1.484 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[2]  -72.024  936.479  -95.829  1.45 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[3]  -75.424  943.498  -95.829  0.853 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[0]  -79.707  943.652  -96.703  1.521 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[1]  -81.137  948.007  -93.613  1.203 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[2]  -80.189  955.477  -92.345  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[3]  -87.78  960.784  -91.908  0.9 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[0]  -88.611  969.232  -96.266  0.875 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[1]  -95.68  975.955  -96.266  0.856 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[2]  -105.212  978.913  -96.515  0.836 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[3]  -108.841  982.764  -96.337  1.577 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[4]  -113.584  983.564  -102.22  1.099 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[5]  -116.763  988.214  -107.574  1.074 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[6]  -121.797  995.681  -108.456  0.923 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[7]  -126.01  1003.207  -106.72  0.949 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[8]  -127.431  1012.28  -106.479  0.909 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[9]  -131.574  1018.498  -106.657  1.117 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[10]  -132.9  1026.436  -109.35  0.984 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[11]  -126.365  1033.336  -109.851  0.877 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[12]  -129.948  1040.815  -112.81  0.948 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[13]  -132.148  1048.872  -113.989  0.99 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[15]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[14]  -135.811  1056.222  -117.361  0.941 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[16]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[15]  -136.652  1062.742  -121.957  1.041 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[17]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[16]  -137.826  1071.689  -119.993  0.904 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[18]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[17]  -143.305  1078.732  -121.095  0.929 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[19]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[18]  -146.342  1083.275  -124.142  1.334 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[20]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[19]  -150.31  1089.526  -128.064  0.997 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[21]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[20]  -153.122  1095.559  -129.364  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[21]  -152.572  1099.949  -134.596  0.659 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b1[0]  -148.817  1102.506  -135.033  0.99 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b1[1]  -145.107  1101.401  -133.285  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b1[2]  -141.727  1102.395  -132.848  0.453 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b1b1[0]  -141.944  1100.24  -132.848  0.41 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b1[2]  -145.061  1099.526  -130.674  0.631 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b1b2[0]  -145.004  1097.25  -130.674  0.41 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1[21]  -158.493  1097.502  -131.548  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2[0]  -162.245  1098.075  -135.033  0.519 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2b1[0]  -165.346  1096.935  -139.366  0.491 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2b1[1]  -166.791  1095.578  -145.576  0.411 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2b1[2]  -168.116  1094.095  -151.793  0.41 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2b1[3]  -169.038  1092.592  -158.114  0.41 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2[0]  -159.485  1097.203  -137.765  0.41 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2b2[0]  -161.969  1098.034  -141.954  0.523 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2b2[1]  -163.472  1098.066  -148.097  0.41 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2b2[2]  -165.638  1095.802  -150.048  0.454 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2b2b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2b2b1[0]  -169.004  1093.662  -150.27  0.41 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2b2[2]  -161.214  1094.045  -148.097  0.45 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2b2b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b1b2b2b2[0]  -158.918  1093.374  -152.456  0.41 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1[3]  -85.181  962.246  -91.471  0.879 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2[0]  -81.203  967.923  -92.397  1.062 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2[1]  -80.505  971.721  -88.363  1.33 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2[2]  -80.063  974.889  -80.143  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2[3]  -80.144  980.026  -79.718  1.613 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[0]  -80.552  985.309  -86.25  0.989 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[1]  -77.393  991.807  -82.328  1.012 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[2]  -82.212  999.448  -80.58  0.904 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[3]  -84.935  1007.315  -77.97  0.953 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[4]  -86.314  1014.615  -76.912  1.108 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[5]  -92.909  1020.766  -77.096  0.922 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[6]  -97.541  1027.171  -74.442  0.997 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[7]  -99.508  1033.448  -73.345  1.247 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[8]  -101.778  1040.936  -70.263  0.989 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[9]  -107.006  1046.002  -67.516  1.069 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[10]  -109.883  1054.919  -67.516  0.888 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[11]  -113.319  1062.414  -70.564  0.946 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[12]  -120.016  1067.475  -70.564  0.991 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[13]  -122.073  1074.07  -73.611  1.101 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[15]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[14]  -126.353  1080.941  -75.167  1.009 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[16]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[15]  -134.292  1080.972  -77.936  0.989 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[17]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[16]  -142.83  1081.362  -81.784  0.887 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[18]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[17]  -149.169  1084.065  -87.818  0.908 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[19]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[18]  -154.453  1087.804  -90.934  1.119 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[20]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b1[19]  -152.582  1091.028  -95.829  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2[3]  -77.328  978.647  -79.008  1.44 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2[0]  -78.222  982.7  -71.99  0.845 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2[1]  -77.452  990.044  -73.611  0.911 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2[2]  -76.774  997.66  -74.048  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2[3]  -74.202  998.797  -70.564  0.913 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b1[0]  -71.047  997.176  -68.39  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2[3]  -79.104  1003.958  -70.271  1.055 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[0]  -81.66  1007.696  -64.032  1.054 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[1]  -89.337  1012.431  -62.788  0.893 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[2]  -92.71  1016.233  -57.398  1.097 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[3]  -97.805  1018.604  -53.191  1.158 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[4]  -98.215  1024.701  -49.345  1.125 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[5]  -103.13  1026.556  -47.276  1.44 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[6]  -105.181  1027.543  -37.781  0.832 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[7]  -110.344  1032.12  -31.296  0.858 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[8]  -115.418  1035.063  -23.966  0.866 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[9]  -118.927  1040.252  -20.907  1.166 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[10]  -125.925  1043.441  -18.733  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[11]  -127.534  1039.348  -17.422  1.018 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2b1[0]  -126.527  1033.15  -18.296  0.466 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2b1[1]  -125.913  1028.238  -15.686  0.41 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2[11]  -129.664  1044.752  -19.17  0.614 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b1b2b2b2b2[0]  -133.112  1040.865  -20.044  0.41 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1[3]  -78.59  940.421  -98.74  0.961 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2[0]  -75.491  943.961  -105.451  0.96 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2[1]  -78.28  947.176  -111.085  1.115 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2[2]  -79.437  954.264  -115.862  0.912 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2[3]  -83.576  961.661  -118.036  0.899 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2[4]  -88.515  968.852  -118.91  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2[5]  -92.782  968.608  -115.356  0.836 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b1[0]  -96.887  969.933  -112.815  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2[5]  -92.968  976.353  -120.658  0.946 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[0]  -98.521  981.591  -120.658  1.103 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[1]  -102.666  985.612  -124.579  1.206 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[2]  -109.786  990.941  -125.016  0.945 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[3]  -117.502  996.145  -124.68  0.904 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[4]  -115.751  1004.053  -121.532  0.969 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[5]  -119.99  1009.127  -125.016  1.126 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[6]  -127.095  1015.164  -124.16  0.899 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[7]  -132.366  1021.98  -122.617  0.962 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[8]  -132.699  1025.336  -121.532  2.376 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[9]  -126.649  1028.858  -122.831  1.182 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[10]  -132.289  1032.347  -126.107  1.138 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[11]  -140.312  1036.208  -130.674  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[12]  -145.973  1038.998  -131.894  1.074 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b1[0]  -153.297  1041.465  -131.112  0.672 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b1[1]  -159.702  1040.545  -131.112  0.806 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b1[2]  -166.802  1039.129  -129.364  0.701 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b1[3]  -171.517  1038.988  -127.19  1.005 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b1[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b1[4]  -175.875  1040.956  -126.807  1.088 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b1[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b1[5]  -178.358  1042.854  -119.784  0.679 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b1[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b1[6]  -183.742  1043.172  -119.347  0.964 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b1[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b1[7]  -185.495  1043.706  -111.504  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2[12]  -146.218  1041.29  -133.663  0.935 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2[0]  -146.971  1047.448  -138.518  0.991 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2[1]  -144.945  1055.691  -140.254  0.901 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2[2]  -146.476  1063.474  -142.002  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2[3]  -145.529  1069.373  -138.08  0.744 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b1[0]  -145.049  1074.037  -142.864  0.794 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b1[1]  -143.787  1081.08  -143.963  0.735 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b1[2]  -140.399  1086.72  -147.074  0.731 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b1[3]  -138.08  1093.868  -145.486  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2[3]  -146.343  1068.923  -146.227  0.74 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b2[0]  -146.532  1070.53  -154.294  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b2[1]  -146.981  1076.238  -157.171  0.796 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b2[2]  -148.299  1080.437  -162.787  0.715 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b2[3]  -147.197  1087.499  -163.346  0.711 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b2[4]  -147.778  1094.448  -163.772  0.73 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b2[5]  -148.119  1097.557  -157.926  0.769 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b2[6]  -147.754  1098.764  -157.714  3.989 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b2[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b2[7]  -147.311  1099.984  -165.839  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b2[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b1b2b2b2b2[8]  -144.842  1103.828  -170.741  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1[2]  -55.613  910.784  -103.235  1.618 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[0]  -61.259  919.549  -104.535  1.393 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[1]  -62.976  928.514  -109.152  1.431 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[2]  -61.301  936.233  -113.874  1.59 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[3]  -54.918  944.705  -115.426  1.365 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[4]  -63.224  950.78  -117.173  1.402 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[5]  -62.68  959.101  -122.394  1.487 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[6]  -67.305  967.346  -125.879  1.159 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[7]  -71.88  976.422  -125.879  1.09 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[8]  -75.826  982.257  -130.41  1.115 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[9]  -73.808  989.623  -132.848  1 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[10]  -75.338  996.973  -136.842  0.942 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[11]  -80.173  1004.105  -139.817  0.879 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[12]  -80.85  1010.951  -143.605  1.02 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[13]  -75.866  1017.784  -145.05  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[14]  -72.096  1023.738  -148.534  1.002 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1[0]  -75.021  1028.725  -144.47  1.115 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1[1]  -80.22  1033.319  -141.53  1.046 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1[2]  -78.494  1039.642  -144.375  1.042 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1[3]  -79.52  1045.381  -145.912  0.844 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1[4]  -77.109  1050.5  -147.66  0.859 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1[5]  -78.571  1056.008  -146.786  0.882 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1[6]  -79.35  1061.254  -142.864  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1[7]  -80.147  1067.43  -142.864  0.657 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[0]  -80.896  1072.446  -142.427  0.804 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[1]  -81.399  1078.165  -142.427  0.713 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[2]  -81.811  1083.967  -143.738  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[3]  -82.716  1088.131  -143.99  1.27 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b1[0]  -84.982  1093.812  -141.128  0.803 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b1[1]  -82.099  1097.971  -141.565  0.684 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b1[2]  -85.482  1102.005  -141.599  0.554 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b1[3]  -85.583  1106.082  -145.05  0.41 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1[3]  -81.732  1088.957  -143.738  0.432 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b2[0]  -82.178  1093.513  -143.738  0.471 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b2[1]  -80.155  1097.848  -143.738  0.41 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b2[2]  -78.395  1096.307  -143.738  0.41 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b1b2[2]  -78.706  1100.884  -143.738  0.41 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1[7]  -82.816  1058.149  -142.864  0.562 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b1b2[0]  -83.294  1057.322  -137.644  0.41 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2[14]  -76.938  1022.911  -151.162  0.662 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[0]  -77.266  1029  -156.328  0.667 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[1]  -83.369  1032.641  -158.55  0.716 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[2]  -87.936  1036.407  -163.872  0.67 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[3]  -91.9  1041.154  -168.864  0.671 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[4]  -98.993  1044.295  -171.178  0.659 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[5]  -101.289  1052.141  -170.741  0.651 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[6]  -104.617  1059.721  -170.741  0.644 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[7]  -110.667  1063.998  -171.614  0.715 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[8]  -111.603  1071.936  -171.614  0.667 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[9]  -115.46  1078.504  -173.362  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[10]  -116.498  1086.236  -174.225  0.658 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b1[0]  -120.254  1089.355  -179.411  0.725 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b1[1]  -120.996  1094.078  -183.816  0.794 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b1[2]  -124.085  1100.149  -184.678  0.752 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b1[3]  -118.657  1105.058  -184.678  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2[10]  -119.536  1084.549  -174.662  0.641 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[0]  -122.456  1089.575  -176.41  0.782 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[1]  -124.386  1095.68  -176.847  0.74 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[2]  -127.533  1099.924  -180.331  0.75 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b1b2b2b2[3]  -130.87  1105.392  -180.331  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1[0]  -45.953  875.325  -92.345  1.044 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[0]  -48.233  884.214  -91.471  1.21 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[1]  -44.717  892.798  -91.471  1.203 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[2]  -45.685  902.761  -94.081  1.078 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[3]  -44.097  911.428  -94.518  1.264 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[4]  -50.061  920.18  -94.518  1.053 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[5]  -49.389  930.605  -94.357  1.068 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[6]  -47.656  940.329  -94.081  1.129 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[7]  -45.969  946.734  -93.312  1.673 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[8]  -45.805  955.23  -92.345  1.304 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[9]  -44.292  965.593  -92.345  1.065 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[10]  -40.636  975.477  -92.345  1.059 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[11]  -35.306  984.426  -93.219  1.067 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[12]  -28.906  991.296  -92.345  1.183 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[13]  -26.575  998.262  -89.722  1.43 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[15]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[14]  -20.044  1004.127  -92.345  1.218 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[16]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[15]  -15.687  1013.184  -92.345  1.11 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[17]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[16]  -7.486  1019.015  -91.034  1.03 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[17]  -5.714  1026.774  -91.034  1.01 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[0]  -0.497  1033.484  -92.761  0.927 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[1]  -1.057  1042.88  -93.219  0.853 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[2]  1.34  1048.02  -93.644  1.413 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[3]  5.964  1054.649  -95.392  0.972 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[4]  4.39  1061.404  -95.392  1.159 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[5]  6.264  1068.902  -95.392  1.04 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[6]  10.059  1076.964  -96.384  0.897 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[7]  11.217  1079.804  -97.566  2.446 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[8]  14.669  1085.911  -96.266  1.047 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[9]  17.817  1090.438  -94.518  0.897 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[10]  15.818  1096.303  -91.908  0.772 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[11]  15.136  1100.073  -89.298  1.119 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[12]  14.364  1106.53  -92.345  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[13]  18.623  1110.453  -92.345  0.474 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1b1[0]  16.928  1114.534  -92.345  0.41 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1[13]  12.926  1108.485  -92.345  0.41 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1b2[0]  11.228  1112.438  -92.345  0.51 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1b2b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1b2b1[0]  9.188  1115.926  -94.955  0.41 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1b2b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1b2b1[1]  9.476  1118.145  -94.955  0.41 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1b2b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1b2b1[1]  7.417  1116.926  -94.955  0.41 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b1b2[0]  10.028  1111.326  -92.345  0.41 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2[17]  -0.032  1024.557  -90.16  0.885 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[0]  2.041  1031.899  -90.16  1.083 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[1]  9.257  1037.285  -88.423  0.901 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[2]  16.225  1043.602  -89.298  0.875 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[3]  22.503  1050.243  -89.298  0.904 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[4]  27.662  1051.695  -89.298  1.541 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[5]  35.35  1056.347  -91.034  0.903 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[6]  38.426  1064.161  -91.034  0.984 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[7]  45.368  1066.009  -91.034  1.15 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[8]  51.54  1071.336  -92.782  0.991 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[9]  60.506  1071.514  -94.142  0.911 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[10]  67.275  1070.402  -96.703  1.128 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[11]  72.081  1076.547  -100.161  0.968 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[12]  80.809  1079.268  -101.05  0.899 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[13]  86.421  1084.381  -101.05  1.088 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[15]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[14]  93.106  1088.731  -97.858  0.962 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[16]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[15]  97.129  1095.115  -97.129  1.09 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[17]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[16]  103.814  1101.941  -96.703  0.864 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[18]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[17]  111.513  1105.898  -98.987  0.923 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[19]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[18]  117.189  1107.586  -105.481  0.76 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[20]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[19]  120.677  1107.333  -113.268  0.624 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[21]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[20]  124.874  1107.089  -117.61  0.475 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[22]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[21]  129.404  1107.725  -122.387  0.434 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[23]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[22]  136.076  1108.44  -122.394  0.427 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[24]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[23]  142.835  1108.56  -122.394  0.424 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[25]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[24]  149.654  1109.492  -122.831  0.416 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[26]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[25]  156.508  1109.729  -122.831  0.418 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[27]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[26]  163.448  1109.097  -122.831  0.412 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[28]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[27]  170.179  1108.545  -123.268  0.424 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[29]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b1b2b2[28]  177.158  1108.232  -123.268  0.41 

*compt /library/Dend_Ap_Med
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2[1]  10.384  416.489  -66.712  2.794 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[0]  7.661  426.524  -69.64  3.926 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[1]  2.102  433.823  -61.421  3.443 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[2]  5.709  447.692  -66.413  2.795 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[3]  5.965  461.487  -70.267  2.961 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[4]  2.696  472.797  -77.096  3.117 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[5]  3.2  485.544  -82.624  3.051 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[6]  -2.939  499.897  -81.018  2.615 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[7]  4.707  511.161  -80.143  2.723 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[8]  6.664  523.727  -83.628  2.817 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[9]  0.331  534.937  -90.745  2.525 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[10]  -4.369  540.218  -95.956  4.229 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[11]  5.585  552.086  -93.644  2.372 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[12]  5.934  566.301  -92.693  2.606 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[13]  2.645  578.611  -92.782  2.915 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[15]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[14]  2.079  594.271  -94.518  2.356 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[16]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[15]  0.599  610.169  -94.567  2.326 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[17]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[16]  -1.708  624.457  -96.173  2.551 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[18]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[17]  -14.33  631.048  -97.566  2.596 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[19]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[18]  -4.958  639.982  -98.877  2.649 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[20]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[19]  -0.134  653.213  -98.877  2.297 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[21]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[20]  0.817  664.189  -100.168  2.916 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[22]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[21]  -4.591  676.219  -102.997  2.398 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[23]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[22]  -7.988  690.36  -104.109  2.218 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[24]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[23]  -1.65  702.651  -104.109  2.339 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[25]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[24]  0.789  712.428  -105.042  3.196 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[26]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[25]  -6.725  720.679  -110.204  2.63 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[27]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[26]  -2.735  734.698  -111.941  2.204 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[28]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[27]  -2.805  746.316  -110.306  2.757 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[29]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[28]  1.303  760.15  -111.524  2.233 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[30]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[29]  4.48  774.057  -109.33  2.241 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[31]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[30]  0.037  786.083  -111.067  2.5 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[32]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[31]  5.134  791.492  -110.204  4.322 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[33]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[32]  4.393  806.909  -111.067  2.07 

*compt /library/Dend_Ap_Dis
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2[33]  3.841  810.324  -112.815  2.07 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1[0]  5.31  820.376  -107.157  1.634 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[0]  2.024  831.667  -105.846  1.605 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[1]  5.732  840.971  -110.12  1.744 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[2]  3.958  850.376  -106.526  1.858 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[3]  5.163  859.267  -105.846  1.841 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[4]  11.24  863.554  -108.893  1.869 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[5]  14.238  873.137  -107.167  1.474 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[6]  9.241  881.831  -107.582  1.497 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[7]  14.526  891.252  -107.582  1.391 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[8]  11.705  899.965  -105.846  1.612 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[9]  13.855  909.994  -106.72  1.459 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[10]  21.98  917.463  -106.72  1.361 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[11]  29.356  922.122  -113.527  1.358 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[12]  38.203  928.994  -115.426  1.322 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[13]  42.988  939.296  -115.426  1.322 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[15]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[14]  41.374  949.713  -117.173  1.406 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[16]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[15]  48.106  956.506  -118.566  1.554 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[17]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[16]  55.922  963.966  -121.58  1.339 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[18]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[17]  63.606  972.658  -124.142  1.24 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[18]  67.172  980.779  -125.972  0.895 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[0]  72.117  988.104  -126.856  0.913 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[1]  74.332  995.606  -129.364  0.987 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[2]  73.415  1004.281  -130.238  0.925 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[3]  72.746  1011.617  -134.159  0.972 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[4]  75.457  1016.057  -139.925  1.044 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[5]  76.742  1021.521  -142.864  1.28 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[6]  77.846  1026.996  -147.022  1.165 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[7]  73.745  1031.571  -152.606  0.977 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[8]  74.729  1038.61  -157.605  0.933 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[9]  75.785  1046.26  -161.598  0.933 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[10]  79.223  1054.585  -161.161  0.899 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[11]  79.53  1059.468  -167.073  1.056 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[12]  77.91  1062.696  -175.099  0.921 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[13]  80.569  1069.372  -179.83  0.942 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[15]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[14]  83.546  1075.582  -184.402  0.981 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[16]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[15]  85.908  1083.408  -186.928  0.948 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[17]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[16]  84.774  1090.452  -191.053  0.984 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[18]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[17]  84.789  1099.645  -192.175  0.875 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[19]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[18]  90.101  1107.597  -192.522  0.847 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[20]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b1[19]  95.266  1115.615  -192.522  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1[18]  73.122  974.078  -126.753  1.083 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2[0]  82.169  974.904  -125.723  1.181 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2[1]  89.217  978.193  -122.831  1.301 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2[2]  93.537  985.797  -119.784  1.166 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2[3]  102.099  990.953  -119.449  1.08 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2[4]  107.077  999.223  -118.036  1.03 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2[5]  108.337  1004.06  -110.204  0.87 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[0]  108.629  1009.932  -104.92  1.022 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[1]  110.706  1014.179  -98.877  1.053 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[2]  105.328  1019.607  -94.718  0.929 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[3]  99.446  1021.588  -88.423  0.914 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[4]  97.946  1029.19  -85.376  0.971 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[5]  95.162  1036.304  -83.628  1.031 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[6]  96.227  1042.177  -78.341  1.014 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[7]  96.288  1049.758  -75.626  1.003 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[8]  99.93  1058.419  -74.922  0.858 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[9]  98.018  1067.214  -74.922  0.898 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[10]  97.933  1076.02  -75.36  0.916 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[11]  95.349  1084.537  -75.36  0.908 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[12]  100.569  1092.115  -76.614  0.87 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[13]  101.44  1100.653  -78.838  0.911 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[15]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[14]  106.484  1107.655  -81.891  0.883 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[16]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[15]  113.843  1111.441  -85.376  0.9 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[17]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[16]  121.473  1110.158  -85.659  1.044 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[18]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[17]  129.791  1110.827  -88.673  0.911 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[19]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b1[18]  131.916  1111.222  -83.202  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2[5]  114.238  1004.465  -119.685  0.922 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[0]  121.322  1009.789  -118.036  0.923 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[1]  125.226  1014.771  -124.546  0.917 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[2]  133.447  1016.8  -126.316  0.962 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[3]  136.522  1024.105  -131.396  0.884 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[4]  142.994  1029.658  -131.548  0.976 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[5]  150.285  1035.152  -131.717  0.912 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[6]  157.457  1040.68  -133.057  0.909 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[7]  163.876  1044.098  -136.332  1.043 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[8]  170.752  1048.177  -136.77  1.039 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[9]  177.669  1052.034  -139.38  0.998 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[10]  181.011  1059.012  -140.161  1.07 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[11]  183.643  1065.149  -140.691  1.242 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[12]  189.607  1071.082  -140.691  0.989 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[13]  195.594  1076.054  -140.691  1.069 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[15]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[14]  201.733  1083.124  -140.691  0.889 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[16]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[15]  209.092  1088.012  -141.94  0.933 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[17]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[16]  217.539  1089.536  -142.427  0.968 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[18]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b1b2b2[17]  222.525  1096.836  -142.864  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1[0]  -2.18  816.211  -111.941  1.294 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2[0]  0.015  825.679  -110.711  1.637 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2[1]  -4.905  836.929  -110.641  1.57 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2[2]  -12.689  845.238  -109.767  1.459 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2[3]  -5.969  852.11  -107.27  1.457 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2[4]  -2.636  859.224  -103.672  1.674 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2[5]  -5.483  867.59  -101.924  1.606 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2[6]  -3.25  877.835  -101.05  1.375 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2[7]  -5.693  889.26  -101.05  1.24 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2[8]  -9.615  895.241  -97.14  0.97 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1[0]  -12.66  900.944  -94.081  1.106 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1[1]  -9.598  906.993  -93.219  1.157 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1[2]  -9.635  916.151  -93.219  0.864 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1[3]  -9.039  922.288  -86.676  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1[4]  -4.945  924.198  -85.376  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1[4]  -8.943  926.098  -80.475  0.642 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2[0]  -6.935  929.579  -75.36  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2[1]  -2.801  930.294  -70.924  0.796 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b1[0]  2.277  931.776  -66.642  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2[1]  -6.762  934.542  -71.181  0.808 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2[0]  -9.869  938.57  -66.383  0.75 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2[1]  -8.839  946.04  -64.382  0.672 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2[2]  -14.016  948.553  -60.608  0.762 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2[3]  -18.772  952.909  -57.658  0.739 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2[4]  -23.088  958.707  -54.379  0.661 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2[5]  -25.656  966.398  -54.015  0.646 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2[6]  -23.844  973.739  -50.745  0.637 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2[7]  -23.908  981.168  -50.531  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2[8]  -27.034  985.177  -49.205  1.021 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[0]  -25.874  990.185  -51.405  0.959 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[1]  -24.815  996.239  -52.647  0.855 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[2]  -25.838  1002.165  -56.998  0.723 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[3]  -24.377  1009.441  -57.522  0.721 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[4]  -21.88  1016.226  -59.114  0.724 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[5]  -25.414  1023.37  -59.674  0.671 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[6]  -31.36  1029.113  -60.548  0.645 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[7]  -36.313  1034.845  -62.94  0.675 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[8]  -41.635  1039.996  -64.889  0.7 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[9]  -43.694  1046.289  -64.906  0.81 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[10]  -50.403  1050.748  -64.906  0.666 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[11]  -54.636  1056.875  -64.906  0.72 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[12]  -58.359  1061.624  -69.144  0.727 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[13]  -63.64  1060.459  -73.658  0.761 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[15]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[14]  -63.944  1065.267  -78.844  0.758 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[16]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[15]  -64.802  1069.988  -81.454  0.982 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[17]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[16]  -70.914  1068.433  -85.813  0.7 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[18]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[17]  -75.091  1071.458  -90.736  0.752 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[19]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[18]  -75.324  1076.51  -94.518  0.849 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[20]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[19]  -79.139  1076.019  -94.518  1.394 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[21]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[20]  -82.936  1081.912  -98.44  0.668 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[22]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[21]  -88.918  1085.132  -101.487  0.72 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[23]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b1[22]  -90.551  1090.878  -104.535  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2[8]  -25.267  987.225  -47.524  1.201 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b2[0]  -23.7  995.643  -45.298  0.937 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b2[1]  -20.88  1000.985  -38.783  0.933 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b2[2]  -21.843  1009.293  -37.467  0.979 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b2[3]  -20.493  1016.06  -34.046  1.076 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b2[4]  -21.02  1021.436  -30.935  1.329 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b2[5]  -22.723  1028.663  -27.439  1.01 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b2[6]  -22.289  1036.21  -22.218  0.902 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b2[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b2[7]  -26.119  1042.734  -24.058  0.941 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b2[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b2[8]  -28.28  1048.032  -23.37  0.928 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b2[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b1b2b2b2[9]  -25.196  1054.757  -25.265  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2[8]  -2.038  896.265  -96.666  0.917 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[0]  -0.761  905.704  -95.392  0.862 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[1]  3.537  913.486  -93.656  0.915 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[2]  6.096  920.073  -95.829  1.121 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[3]  12.821  925.002  -95.392  0.993 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[4]  14.772  934.581  -94.081  0.84 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[5]  20.983  940.049  -92.345  0.98 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[6]  26.131  947.636  -91.908  0.903 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[7]  34.388  951.248  -91.034  0.915 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[8]  39.821  958.801  -91.034  0.891 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[9]  45.078  964.209  -88.86  1.056 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[10]  48.046  972.633  -87.962  0.923 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[11]  55.926  973.972  -86.381  1.017 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[12]  61.755  979.89  -84.323  0.968 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[13]  67.51  985.985  -83.628  0.985 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[15]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[14]  73.138  992.697  -81.891  0.928 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[16]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[15]  80.063  998.475  -81.891  0.919 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[17]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[16]  87.024  1002.248  -79.281  0.994 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[18]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[17]  94.461  1006.733  -74.922  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[18]  98.268  1005.894  -73.174  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2[18]  97.419  1012.403  -72.451  1.107 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2[0]  105.159  1013.775  -70.127  0.926 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2[1]  108.01  1018.909  -66.205  1.075 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2[2]  114.301  1024.411  -64.469  0.89 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2[3]  119.136  1029.668  -63.463  1.053 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2[4]  121.762  1037.036  -60.984  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2[5]  121.931  1041.56  -61.421  1.001 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2b1[0]  125.189  1045.971  -61.421  0.62 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2[5]  125.417  1041.508  -60.548  0.856 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2b2[0]  129.841  1045.356  -62.668  0.796 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2b2[1]  132.278  1052.584  -62.296  0.65 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2b2[2]  136.861  1058.238  -61.858  0.68 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1b2b1b2b1b2b2b1b2b2b2b2[3]  140.714  1061.6  -66.642  0.62 

*compt /library/Dend_Ap_Obl
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1[0]  -3.209  109.192  -20.044  1.45 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2[1]  -6.893  115.523  -13.748  0.832 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[0]  -7.456  121.004  -9.154  1.12 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[1]  -10.185  126.387  -3.359  0.96 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[2]  -15.369  128.199  -0.637  1.311 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[3]  -20.649  135.696  0.437  0.87 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[4]  -23.679  143.612  1.792  0.936 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[5]  -21.962  152.222  2.173  0.914 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[6]  -27.237  159.685  2.173  0.879 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[7]  -32.283  165.587  2.173  1.035 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[8]  -39.72  170.593  0.437  0.88 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[9]  -46.615  173.819  0  1.054 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[10]  -46.394  182.08  0  0.972 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[11]  -50.519  190.482  0.437  0.858 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[12]  -56.543  192.003  0.437  1.293 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[13]  -63.435  197.84  1.736  0.881 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[15]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[14]  -67.77  202.041  3.047  1.301 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[16]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b1[15]  -74.14  201.676  9.58  0.83 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[0]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2[1]  -13.784  109.549  -15.357  1.681 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[1]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[0]  -19.093  111.602  -22.366  2.154 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[2]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[1]  -29.758  117.687  -25.163  1.544 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[3]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[2]  -40.945  112.481  -24.828  1.576 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[4]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[3]  -49.569  110.353  -30.261  1.868 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[5]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[4]  -58.797  111.417  -32.672  1.708 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[6]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[5]  -67.727  105.533  -32.235  1.088 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[7]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[6]  -77.063  102.798  -32.235  1.197 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[8]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[7]  -85.337  95.924  -32.235  1.082 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[9]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[8]  -92.845  88.478  -31.797  1.1 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[10]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[9]  -97.776  81.944  -33.108  1.405 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[11]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[10]  -106.992  77.319  -33.108  1.129 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[12]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[11]  -111.065  68.912  -33.546  1.245 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[13]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[12]  -110.849  60.216  -33.546  1.192 
p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[14]  p0b1b2b1b1b1b2b1b2b1b2b1b2b1b2b2[13]  -117.058  55.315  -35.719  0.83 
p0b1b2b1b2[1]  p0b1b2b1[0]  -22.029  42.041  2.173  1.406 
p0b1b2b1b2[2]  p0b1b2b1b2[1]  -25.72  43.722  -3.642  2.05 
p0b1b2b1b2[3]  p0b1b2b1b2[2]  -29.584  37.401  -9.591  1.53 
p0b1b2b1b2[4]  p0b1b2b1b2[3]  -35.534  46.817  -11.328  1.289 
p0b1b2b1b2[5]  p0b1b2b1b2[4]  -46.483  43.005  -10.453  1.25 
p0b1b2b1b2[6]  p0b1b2b1b2[5]  -56.634  38.744  -11.764  1.311 
p0b1b2b1b2[7]  p0b1b2b1b2[6]  -67.337  39.923  -10.016  1.333 
p0b1b2b1b2[8]  p0b1b2b1b2[7]  -78.166  37.927  -8.28  1.24 
p0b1b2b1b2b1[0]  p0b1b2b1b2[8]  -84.811  39.311  -9.797  1.136 
p0b1b2b1b2b1[1]  p0b1b2b1b2b1[0]  -87.231  42.354  -14.673  1.267 
p0b1b2b1b2b1[2]  p0b1b2b1b2b1[1]  -95.642  44.417  -17.794  0.859 
p0b1b2b1b2b1[3]  p0b1b2b1b2b1[2]  -101.784  49.999  -19.607  0.93 
p0b1b2b1b2b1[4]  p0b1b2b1b2b1[3]  -109.869  46.001  -21.344  0.861 
p0b1b2b1b2b1[5]  p0b1b2b1b2b1[4]  -117.556  49.585  -23.094  0.913 
p0b1b2b1b2b1[6]  p0b1b2b1b2b1[5]  -120.477  57.147  -25.229  0.943 
p0b1b2b1b2b1[7]  p0b1b2b1b2b1[6]  -128.171  59.483  -27.876  0.934 
p0b1b2b1b2b1[8]  p0b1b2b1b2b1[7]  -133.72  59.025  -33.872  0.966 
p0b1b2b1b2b1[9]  p0b1b2b1b2b1[8]  -138.21  61.343  -39.673  1.027 
p0b1b2b1b2b1[10]  p0b1b2b1b2b1[9]  -139.07  68.195  -39.64  0.83 
p0b1b2b1b2b2[0]  p0b1b2b1b2[8]  -82.106  29.5  -7.406  1.229 
p0b1b2b1b2b2[1]  p0b1b2b1b2b2[0]  -88.595  30.423  -6.106  1.252 
p0b1b2b1b2b2[2]  p0b1b2b1b2b2[1]  -95.215  29.447  -1.289  1.015 
p0b1b2b1b2b2[3]  p0b1b2b1b2b2[2]  -104.429  28.034  0.326  0.885 
p0b1b2b1b2b2[4]  p0b1b2b1b2b2[3]  -112.872  30.194  2.664  0.927 
p0b1b2b1b2b2[5]  p0b1b2b1b2b2[4]  -117.005  34.233  6.095  1.245 
p0b1b2b1b2b2[6]  p0b1b2b1b2b2[5]  -125.144  33.441  6.497  1.022 
p0b1b2b1b2b2[7]  p0b1b2b1b2b2[6]  -134.039  36.266  6.095  0.896 
p0b1b2b1b2b2[8]  p0b1b2b1b2b2[7]  -138.631  30.388  5.221  1.114 
p0b1b2b1b2b2[9]  p0b1b2b1b2b2[8]  -142.79  23.315  4.687  1.018 
p0b1b2b1b2b2[10]  p0b1b2b1b2b2[9]  -152.064  22.828  3.845  0.897 
p0b1b2b1b2b2[11]  p0b1b2b1b2b2[10]  -161.347  25.276  3.047  0.869 
p0b1b2b1b2b2[12]  p0b1b2b1b2b2[11]  -167.534  20.631  3.484  1.08 
p0b1b2b1b2b2[13]  p0b1b2b1b2b2[12]  -175.117  25.744  5.274  0.898 
p0b1b2b1b2b2[14]  p0b1b2b1b2b2[13]  -183.591  22.672  8.11  0.886 
p0b1b2b1b2b2[15]  p0b1b2b1b2b2[14]  -190.916  21.463  12.589  0.905 
p0b1b2b1b2b2[16]  p0b1b2b1b2b2[15]  -190.912  16.031  16.548  0.62 


*compt /library/Dend_Bas
p1[1]  soma  3.958  0.845  -4.851  2.176 
p1[2]  p1[1]  4.301  5.945  -10.016  1.65 
p1b1[0]  p1[2]  12.053  9.584  -15.249  1.507 
p1b1[1]  p1b1[0]  16.553  14.177  -20.907  1.295 
p1b1[2]  p1b1[1]  14.403  18.157  -26.711  1.126 
p1b1[3]  p1b1[2]  19.242  19.247  -31.069  1.255 
p1b1[4]  p1b1[3]  20.536  15.189  -38.423  0.975 
p1b1[5]  p1b1[4]  22.835  11.564  -43.999  1.177 
p1b1[6]  p1b1[5]  26.944  15.619  -50.618  0.943 
p1b1[7]  p1b1[6]  23.709  12.613  -57.02  1.065 
p1b1[8]  p1b1[7]  27.367  12.769  -65.951  0.858 
p1b1[9]  p1b1[8]  36.108  13.436  -68.089  0.794 
p1b1[10]  p1b1[9]  37.139  12.029  -68.379  3.025 
p1b1[11]  p1b1[10]  40.293  12.522  -75.233  0.707 
p1b1[12]  p1b1[11]  43.365  11.97  -80.496  0.874 
p1b1[13]  p1b1[12]  47.564  11.432  -86.397  0.736 
p1b1[14]  p1b1[13]  52.51  7.98  -92.22  0.638 
p1b1[15]  p1b1[14]  56.747  10.024  -94.392  1.032 
p1b1[16]  p1b1[15]  58.853  8.702  -98.877  1.043 
p1b1[17]  p1b1[16]  63.586  6.755  -104.333  0.715 
p1b1[18]  p1b1[17]  63.264  8.811  -112.386  0.643 
p1b1[19]  p1b1[18]  62.205  7.495  -117.528  0.988 
p1b1[20]  p1b1[19]  60.019  4.557  -124.479  0.602 
p1b1[21]  p1b1[20]  56.618  4.783  -130.411  0.42 
p1b1[22]  p1b1[21]  51.796  5.29  -135.458  0.41 
p1b2[0]  p1[2]  11.592  4.732  -16.332  1.401 
p1b2[1]  p1b2[0]  12.912  -4.245  -20.847  1.344 
p1b2[2]  p1b2[1]  18.102  -5.883  -27.525  1.581 
p1b2[3]  p1b2[2]  13.88  -7.148  -36.576  1.353 
p1b2[4]  p1b2[3]  22.425  -11.028  -40.503  1.24 
p1b2b1[0]  p1b2[4]  24.66  -14.51  -43.636  1.547 
p1b2b1[1]  p1b2b1[0]  17.927  -13.406  -49.134  0.916 
p1b2b1[2]  p1b2b1[1]  21.26  -19.61  -52.704  1.017 
p1b2b1[3]  p1b2b1[2]  22.063  -18.4  -59.794  1.109 
p1b2b1[4]  p1b2b1[3]  21.857  -23.43  -67.26  0.892 
p1b2b1[5]  p1b2b1[4]  22.942  -30.464  -72.3  0.83 
p1b2b1b1[0]  p1b2b1[5]  26.031  -34.317  -70.527  1.015 
p1b2b1b1[1]  p1b2b1b1[0]  24.424  -39.98  -73.379  0.814 
p1b2b1b1[2]  p1b2b1b1[1]  28.877  -45.317  -77.009  0.679 
p1b2b1b1[3]  p1b2b1b1[2]  25.926  -52.367  -77.096  0.697 
p1b2b1b1[4]  p1b2b1b1[3]  28.576  -58.175  -81.499  0.687 
p1b2b1b1[5]  p1b2b1b1[4]  24.468  -64.334  -83.585  0.693 
p1b2b1b1[6]  p1b2b1b1[5]  24.222  -71.22  -86.676  0.705 
p1b2b1b1[7]  p1b2b1b1[6]  25.278  -77.224  -87.083  0.872 
p1b2b1b1[8]  p1b2b1b1[7]  25.633  -83.478  -89.723  0.62 
p1b2b1b2[0]  p1b2b1[5]  28.364  -32.471  -77.778  1.005 
p1b2b1b2[1]  p1b2b1b2[0]  34.109  -35.661  -81.819  0.802 
p1b2b1b2[2]  p1b2b1b2[1]  40.739  -36.008  -82.754  0.77 
p1b2b1b2[3]  p1b2b1b2[2]  43.678  -34.08  -86.805  0.963 
p1b2b1b2[4]  p1b2b1b2[3]  44.976  -32.775  -94.956  0.62 
p1b2b2[0]  p1b2[4]  24.944  -8.525  -43.999  1.577 
p1b2b2[1]  p1b2b2[0]  27.366  -5.271  -48.783  1.253 
p1b2b2[2]  p1b2b2[1]  23.883  0.188  -52.704  1.038 
p1b2b2[3]  p1b2b2[2]  31.283  1.861  -57.149  0.894 
p1b2b2[4]  p1b2b2[3]  38.044  -2.39  -58.8  0.964 
p1b2b2[5]  p1b2b2[4]  42.654  -1.67  -63.358  1.205 
p1b2b2[6]  p1b2b2[5]  42.834  -6.481  -70.947  0.875 
p1b2b2[7]  p1b2b2[6]  45.876  -8.976  -78.377  0.935 
p1b2b2[8]  p1b2b2[7]  47.115  -12.902  -80.87  1.633 
p1b2b2[9]  p1b2b2[8]  53.817  -14.852  -83.628  1.047 
p1b2b2[10]  p1b2b2[9]  59.84  -19.634  -83.628  1.022 
p1b2b2[11]  p1b2b2[10]  63.637  -25.518  -83.628  1.122 
p1b2b2[12]  p1b2b2[11]  68.855  -33.164  -83.628  0.849 
p1b2b2[13]  p1b2b2[12]  75.82  -36.49  -83.628  0.62 

p2[1]  soma  1.392  -0.149  0  4.55 
p2b1[0]  p2[1]  9.661  2.505  2.308  1.775 
p2b1[1]  p2b1[0]  17.576  6.073  2.978  1.832 
p2b1[2]  p2b1[1]  24.069  13.052  3.484  1.65 
p2b1b1[0]  p2b1[2]  29.304  16.505  3.048  1.135 
p2b1b1[1]  p2b1b1[0]  36.221  17.82  3.922  1.005 
p2b1b1[2]  p2b1b1[1]  43.572  20.055  1.761  0.893 
p2b1b1[3]  p2b1b1[2]  51.002  22.195  -1.299  0.83 
p2b1b1b1[0]  p2b1b1[3]  55.989  22.804  0.437  0.465 
p2b1b1b1[1]  p2b1b1b1[0]  58.942  24.327  3.61  0.538 
p2b1b1b1[2]  p2b1b1b1[1]  63.1  25.484  7.406  0.41 
p2b1b1b2[0]  p2b1b1[3]  56.78  22.255  -2.604  0.824 
p2b1b1b2[1]  p2b1b1b2[0]  61.28  25.25  1.388  0.726 
p2b1b1b2[2]  p2b1b1b2[1]  66.043  30.765  1.748  0.669 
p2b1b1b2[3]  p2b1b1b2[2]  73.52  31.832  1.748  0.646 
p2b1b1b2[4]  p2b1b1b2[3]  81.03  30.919  2.61  0.641 
p2b1b1b2[5]  p2b1b1b2[4]  87.16  34.71  3.796  0.668 
p2b1b1b2[6]  p2b1b1b2[5]  92.897  38.594  6.969  0.62 
p2b1b1b2b1[0]  p2b1b1b2[6]  97.452  40.127  6.969  0.441 
p2b1b1b2b1[1]  p2b1b1b2b1[0]  101.499  38.145  8.717  0.41 
p2b1b1b2b2[0]  p2b1b1b2[6]  93.459  40.174  9.142  1.008 
p2b1b1b2b2[1]  p2b1b1b2b2[0]  97.232  37.732  9.58  0.41 
p2b1b2[0]  p2b1[2]  29.487  10.108  4.358  1.469 
p2b1b2[1]  p2b1b2[0]  29.877  3.427  4.358  1.24 
p2b1b2b1[0]  p2b1b2[1]  35.092  -2.015  6.196  0.893 
p2b1b2b1[1]  p2b1b2b1[0]  41.158  -3.358  9.58  0.83 
p2b1b2b1b1[0]  p2b1b2b1[1]  43.769  -5.014  9.58  0.41 
p2b1b2b1b2[0]  p2b1b2b1[1]  42.4  -0.414  10.016  0.41 
p2b1b2b2[0]  p2b1b2[1]  38.279  0.824  3.922  0.958 
p2b1b2b2[1]  p2b1b2b2[0]  44.246  7.139  1.748  0.942 
p2b1b2b2[2]  p2b1b2b2[1]  53.721  4.196  1.748  0.851 
p2b1b2b2[3]  p2b1b2b2[2]  58.884  -3.029  1.713  0.951 
p2b1b2b2[4]  p2b1b2b2[3]  66.773  -1.815  -1.428  0.984 
p2b1b2b2[5]  p2b1b2b2[4]  72.656  2.679  -5.638  0.991 
p2b1b2b2[6]  p2b1b2b2[5]  80.126  0.876  -11.327  0.883 
p2b1b2b2[7]  p2b1b2b2[6]  84.721  5.424  -17.336  0.956 
p2b1b2b2[8]  p2b1b2b2[7]  94.531  5.962  -18.296  0.855 
p2b1b2b2[9]  p2b1b2b2[8]  103.028  8.795  -20.033  0.925 
p2b1b2b2[10]  p2b1b2b2[9]  110.743  4.847  -17.422  0.932 
p2b1b2b2[11]  p2b1b2b2[10]  119.789  4.301  -15.34  0.908 
p2b1b2b2[12]  p2b1b2b2[11]  129.617  3.863  -14.244  0.853 
p2b1b2b2[13]  p2b1b2b2[12]  138.546  6.063  -13.501  0.915 
p2b1b2b2[14]  p2b1b2b2[13]  144.893  3.656  -17.959  0.945 
p2b1b2b2[15]  p2b1b2b2[14]  149.263  0.648  -21.998  0.817 
p2b1b2b2[16]  p2b1b2b2[15]  153.525  1.322  -28.313  0.62 
p2b2[0]  p2[1]  12.604  -1.725  -1.737  2.27 
p2b2b1[0]  p2b2[0]  18.308  0.657  -4.436  1.238 
p2b2b1[1]  p2b2b1[0]  19.014  5.572  -12.397  0.89 
p2b2b1[2]  p2b2b1[1]  23.506  12.125  -11.628  1.046 
p2b2b1[3]  p2b2b1[2]  33.041  14.05  -11.327  0.858 
p2b2b1[4]  p2b2b1[3]  42.712  15.818  -10.89  0.849 
p2b2b1[5]  p2b2b1[4]  51.785  16.042  -7.843  0.872 
p2b2b1[6]  p2b2b1[5]  54.2  23.279  -7.843  1.095 
p2b2b1[7]  p2b2b1[6]  62.257  27.34  -8.034  0.925 
p2b2b1[8]  p2b2b1[7]  71.285  26.587  -9.944  0.902 
p2b2b1[9]  p2b2b1[8]  78.745  30.258  -5.658  0.893 
p2b2b1[10]  p2b2b1[9]  87.925  32.297  -6.532  0.884 
p2b2b1[11]  p2b2b1[10]  95.011  38.005  -4.786  0.901 
p2b2b1[12]  p2b2b1[11]  98.195  43.865  1.552  0.881 
p2b2b1[13]  p2b2b1[12]  101.223  47.196  6.969  0.62 
p2b2b2[0]  p2b2[0]  16.011  -3.548  -8.02  2.671 
p2b2b2[1]  p2b2b2[0]  14.755  -4.658  -17.422  2.07 
p2b2b2b1[0]  p2b2b2[1]  17.613  -8.061  -10.153  2.861 
p2b2b2b1[1]  p2b2b2b1[0]  17.618  -16.951  -16.112  1.65 
p2b2b2b1b1[0]  p2b2b2b1[1]  25.988  -18.863  -17.624  0.962 
p2b2b2b1b1[1]  p2b2b2b1b1[0]  33.615  -16.017  -13.55  0.922 
p2b2b2b1b1[2]  p2b2b2b1b1[1]  41.456  -16.169  -10.016  0.975 
p2b2b2b1b1[3]  p2b2b2b1b1[2]  45.835  -21.957  -6.532  0.894 
p2b2b2b1b1[4]  p2b2b2b1b1[3]  48.688  -26.284  -5.473  1.024 
p2b2b2b1b1[5]  p2b2b2b1b1[4]  46.577  -32.472  -1.653  0.715 
p2b2b2b1b1[6]  p2b2b2b1b1[5]  52.965  -33.459  0.793  0.784 
p2b2b2b1b1[7]  p2b2b2b1b1[6]  60.049  -31.511  4.647  0.653 
p2b2b2b1b1[8]  p2b2b2b1b1[7]  62.713  -26.578  6.532  0.916 
p2b2b2b1b1[9]  p2b2b2b1b1[8]  58.868  -20.539  7.406  0.41 
p2b2b2b1b2[0]  p2b2b2b1[1]  21.663  -23.067  -17.099  1.574 
p2b2b2b1b2[1]  p2b2b2b1b2[0]  28.536  -24.575  -11.813  1.323 
p2b2b2b1b2[2]  p2b2b2b1b2[1]  28.014  -33.085  -10.016  1.24 
p2b2b2b1b2b1[0]  p2b2b2b1b2[2]  26.637  -40.45  -7.406  1.064 
p2b2b2b1b2b1[1]  p2b2b2b1b2b1[0]  35.921  -37.607  -7.406  0.841 
p2b2b2b1b2b1[2]  p2b2b2b1b2b1[1]  33.703  -45.522  -6.969  0.662 
p2b2b2b1b2b1[3]  p2b2b2b1b2b1[2]  36.571  -50.449  -2.921  0.779 
p2b2b2b1b2b1[4]  p2b2b2b1b2b1[3]  39.171  -56.118  1.576  0.709 
p2b2b2b1b2b1[5]  p2b2b2b1b2b1[4]  45.426  -58.271  3.294  0.797 
p2b2b2b1b2b1[6]  p2b2b2b1b2b1[5]  51.931  -58.598  7.865  0.685 
p2b2b2b1b2b1[7]  p2b2b2b1b2b1[6]  59.19  -59.444  10.89  0.62 
p2b2b2b1b2b2[0]  p2b2b2b1b2[2]  22.054  -39.928  -12.735  1.295 
p2b2b2b1b2b2[1]  p2b2b2b1b2b2[0]  21.133  -45.457  -20.218  1.312 
p2b2b2b1b2b2[2]  p2b2b2b1b2b2[1]  23.506  -53.049  -25.691  1.24 
p2b2b2b1b2b2b1[0]  p2b2b2b1b2b2[2]  32.188  -55.115  -28.75  0.865 
p2b2b2b1b2b2b1[1]  p2b2b2b1b2b2b1[0]  38.778  -59.979  -28.75  0.996 
p2b2b2b1b2b2b1[2]  p2b2b2b1b2b2b1[1]  40.933  -65.622  -34.835  0.951 
p2b2b2b1b2b2b1[3]  p2b2b2b1b2b2b1[2]  38.262  -68.44  -40.066  1.252 
p2b2b2b1b2b2b1[4]  p2b2b2b1b2b2b1[3]  47.058  -67.313  -43.125  0.87 
p2b2b2b1b2b2b1[5]  p2b2b2b1b2b2b1[4]  53.159  -71.698  -47.34  0.947 
p2b2b2b1b2b2b1[6]  p2b2b2b1b2b2b1[5]  56.829  -75.843  -51.607  1.167 
p2b2b2b1b2b2b1[7]  p2b2b2b1b2b2b1[6]  61.701  -78.11  -54.441  1.343 
p2b2b2b1b2b2b1[8]  p2b2b2b1b2b2b1[7]  68.356  -80.649  -55.752  0.83 
p2b2b2b1b2b2b1b1[0]  p2b2b2b1b2b2b1[8]  69.607  -82.499  -55.752  1.098 
p2b2b2b1b2b2b1b1[1]  p2b2b2b1b2b2b1b1[0]  69.882  -85.737  -57.063  0.7 
p2b2b2b1b2b2b1b1[2]  p2b2b2b1b2b2b1b1[1]  72.879  -88.236  -57.063  0.628 
p2b2b2b1b2b2b1b1[3]  p2b2b2b1b2b2b1b1[2]  67.551  -86.79  -57.063  0.41 
p2b2b2b1b2b2b1b2[0]  p2b2b2b1b2b2b1[8]  71.559  -88.19  -57.488  0.847 
p2b2b2b1b2b2b1b2[1]  p2b2b2b1b2b2b1b2[0]  78.557  -87.737  -58.328  0.762 
p2b2b2b1b2b2b1b2[2]  p2b2b2b1b2b2b1b2[1]  81.921  -93.662  -61.41  0.719 
p2b2b2b1b2b2b1b2[3]  p2b2b2b1b2b2b1b2[2]  83.204  -97.222  -65.799  0.928 
p2b2b2b1b2b2b1b2[4]  p2b2b2b1b2b2b1b2[3]  83.35  -99.922  -72.345  0.76 
p2b2b2b1b2b2b1b2[5]  p2b2b2b1b2b2b1b2[4]  83.318  -100.924  -81.017  0.62 
p2b2b2b1b2b2b2[0]  p2b2b2b1b2b2[2]  29.791  -59.819  -28.382  1.484 
p2b2b2b1b2b2b2[1]  p2b2b2b1b2b2b2[0]  33.287  -65.807  -23.397  1.672 
p2b2b2b1b2b2b2[2]  p2b2b2b1b2b2b2[1]  31.49  -74.07  -28.034  1.48 
p2b2b2b1b2b2b2[3]  p2b2b2b1b2b2b2[2]  35.572  -82.117  -28.75  1.386 
p2b2b2b1b2b2b2[4]  p2b2b2b1b2b2b2[3]  37.994  -90.472  -28.702  1.242 
p2b2b2b1b2b2b2[5]  p2b2b2b1b2b2b2[4]  42.556  -94.483  -34.828  1.253 
p2b2b2b1b2b2b2[6]  p2b2b2b1b2b2b2[5]  43.832  -103.512  -35.719  1.08 
p2b2b2b1b2b2b2[7]  p2b2b2b1b2b2b2[6]  44.744  -109.974  -37.455  1.158 
p2b2b2b1b2b2b2[8]  p2b2b2b1b2b2b2[7]  48.794  -113.209  -35.282  1.391 
p2b2b2b1b2b2b2[9]  p2b2b2b1b2b2b2[8]  48.676  -116.074  -31.322  1.599 
p2b2b2b1b2b2b2[10]  p2b2b2b1b2b2b2[9]  45.052  -122.272  -27.439  0.958 
p2b2b2b1b2b2b2[11]  p2b2b2b1b2b2b2[10]  44.926  -131.606  -27.439  0.838 
p2b2b2b1b2b2b2[12]  p2b2b2b1b2b2b2[11]  46.012  -139.575  -30.05  0.83 
p2b2b2b2[0]  p2b2b2[1]  19.273  0.01  -23.467  1.626 
p2b2b2b2[1]  p2b2b2b2[0]  25.116  4.623  -28.313  1.45 
p2b2b2b2b1[0]  p2b2b2b2[1]  32.334  5.421  -32.401  1.177 
p2b2b2b2b1[1]  p2b2b2b2b1[0]  37.938  1.886  -33.097  0.83 
p2b2b2b2b1b1[0]  p2b2b2b2b1[1]  39.923  -3.99  -34.408  0.783 
p2b2b2b2b1b1[1]  p2b2b2b2b1b1[0]  38.259  -3.719  -39.295  0.854 
p2b2b2b2b1b1[2]  p2b2b2b2b1b1[1]  41.706  -4.834  -44.532  0.694 
p2b2b2b2b1b1[3]  p2b2b2b2b1b1[2]  42.956  -7.691  -49.172  0.79 
p2b2b2b2b1b1[4]  p2b2b2b2b1b1[3]  48.081  -8.061  -50.519  0.62 
p2b2b2b2b1b1b1[0]  p2b2b2b2b1b1[4]  50.274  -7.495  -57.063  0.642 
p2b2b2b2b1b1b1[1]  p2b2b2b2b1b1b1[0]  48.76  -6.522  -61.611  0.908 
p2b2b2b2b1b1b1[2]  p2b2b2b2b1b1b1[1]  52.396  -7.071  -61.617  1.208 
p2b2b2b2b1b1b1[3]  p2b2b2b2b1b1b1[2]  52.636  -6.753  -68.771  0.62 
p2b2b2b2b1b1b1[4]  p2b2b2b2b1b1b1[3]  53.107  -3.105  -69.253  0.62 
p2b2b2b2b1b1b2[0]  p2b2b2b2b1b1[4]  51.932  -7.134  -55.951  0.717 
p2b2b2b2b1b1b2[1]  p2b2b2b2b1b1b2[0]  54.443  -4.949  -61.031  0.794 
p2b2b2b2b1b1b2[2]  p2b2b2b2b1b1b2[1]  52.502  -3.048  -67.599  0.678 
p2b2b2b2b1b1b2[3]  p2b2b2b2b1b1b2[2]  50.555  -5.781  -74.447  0.632 
p2b2b2b2b1b1b2[4]  p2b2b2b2b1b1b2[3]  50.76  -9.519  -81.017  0.637 
p2b2b2b2b1b1b2[5]  p2b2b2b2b1b1b2[4]  46.374  -9.466  -83.345  0.971 
p2b2b2b2b1b1b2[6]  p2b2b2b2b1b1b2[5]  46.545  -5.625  -89.949  0.631 
p2b2b2b2b1b1b2[7]  p2b2b2b2b1b1b2[6]  46.402  -3.346  -96.692  0.62 
p2b2b2b2b1b2[0]  p2b2b2b2b1[1]  41.136  1.738  -37.018  1.219 
p2b2b2b2b1b2[1]  p2b2b2b2b1b2[0]  40.77  4.266  -43.55  0.749 
p2b2b2b2b1b2[2]  p2b2b2b2b1b2[1]  47.274  8.924  -43.125  0.656 
p2b2b2b2b1b2[3]  p2b2b2b2b1b2[2]  54.534  13.029  -43.125  0.63 
p2b2b2b2b1b2[4]  p2b2b2b2b1b2[3]  60.125  18.024  -43.125  0.701 
p2b2b2b2b1b2[5]  p2b2b2b2b1b2[4]  64.51  24.958  -43.125  0.641 
p2b2b2b2b1b2[6]  p2b2b2b2b1b2[5]  69.591  29.428  -45.735  0.725 
p2b2b2b2b1b2[7]  p2b2b2b2b1b2[6]  69.265  35.903  -49.22  0.62 
p2b2b2b2b2[0]  p2b2b2b2[1]  32.112  7.618  -29.187  0.855 
p2b2b2b2b2[1]  p2b2b2b2b2[0]  38.838  4.554  -30.753  0.867 
p2b2b2b2b2[2]  p2b2b2b2b2[1]  45.183  7.693  -32.672  0.83 
p2b2b2b2b2b1[0]  p2b2b2b2b2[2]  49.099  14.255  -34.633  0.829 
p2b2b2b2b2b1[1]  p2b2b2b2b2b1[0]  51.995  11.797  -37.398  1.073 
p2b2b2b2b2b1[2]  p2b2b2b2b2b1[1]  55.55  13.194  -43.255  0.721 
p2b2b2b2b2b1[3]  p2b2b2b2b2b1[2]  60.225  18.37  -43.988  0.718 
p2b2b2b2b2b1[4]  p2b2b2b2b2b1[3]  64.572  24.87  -44.141  0.644 
p2b2b2b2b2b1[5]  p2b2b2b2b2b1[4]  69.36  28.934  -47.472  0.709 
p2b2b2b2b2b1[6]  p2b2b2b2b2b1[5]  69.242  36.478  -47.472  0.62 
p2b2b2b2b2b2[0]  p2b2b2b2b2[2]  47.226  8.225  -30.05  1.503 
p2b2b2b2b2b2[1]  p2b2b2b2b2b2[0]  53.26  8.487  -30.05  0.838 
p2b2b2b2b2b2[2]  p2b2b2b2b2b2[1]  61.16  8.777  -29.187  0.636 
p2b2b2b2b2b2[3]  p2b2b2b2b2b2[2]  67.422  8.898  -27.119  0.767 
p2b2b2b2b2b2[4]  p2b2b2b2b2b2[3]  73.236  10.128  -25.691  0.828 
p2b2b2b2b2b2[5]  p2b2b2b2b2b2[4]  79.809  13.177  -25.691  0.698 
p2b2b2b2b2b2[6]  p2b2b2b2b2b2[5]  85.18  15.894  -22.015  0.717 
p2b2b2b2b2b2[7]  p2b2b2b2b2b2[6]  92.421  18.294  -20.907  0.656 
p2b2b2b2b2b2[8]  p2b2b2b2b2b2[7]  97.654  21.473  -22.935  0.785 
p2b2b2b2b2b2[9]  p2b2b2b2b2b2[8]  100.298  20.874  -17.408  0.822 
p2b2b2b2b2b2[10]  p2b2b2b2b2b2[9]  102.928  19.813  -12.485  0.891 
p2b2b2b2b2b2[11]  p2b2b2b2b2b2[10]  104.167  22.873  -9.143  0.62 

p3[1]  soma  -7.337  -7.697  -1.266  1.847 
p3[2]  p3[1]  -16.512  -11.454  -2.61  1.697 
p3[3]  p3[2]  -26.37  -8.613  -2.185  1.65 
p3b1[0]  p3[3]  -32.713  -3.928  -2.668  0.901 
p3b1[1]  p3b1[0]  -38.177  1.219  -3.808  0.938 
p3b1[2]  p3b1[1]  -41.329  8.401  -5.331  0.891 
p3b1[3]  p3b1[2]  -48.645  11.19  -4.796  0.83 
p3b1b1[0]  p3b1[3]  -55.1  11.327  -1.79  0.713 
p3b1b1[1]  p3b1b1[0]  -59.689  10.242  1.715  0.865 
p3b1b1[2]  p3b1b1[1]  -58.674  15.123  3.944  0.93 
p3b1b1[3]  p3b1b1[2]  -63.192  20.432  3.922  0.729 
p3b1b1[4]  p3b1b1[3]  -68.746  26.081  3.922  0.641 
p3b1b1[5]  p3b1b1[4]  -72.139  28.468  4.784  1.199 
p3b1b1[6]  p3b1b1[5]  -78.011  32.894  4.784  0.691 
p3b1b1[7]  p3b1b1[6]  -84.371  37.013  4.358  0.669 
p3b1b1[8]  p3b1b1[7]  -91.376  37.608  3.922  0.721 
p3b1b1[9]  p3b1b1[8]  -93.883  45.163  3.922  0.638 
p3b1b1[10]  p3b1b1[9]  -100.079  48.575  4.749  0.713 
p3b1b1[11]  p3b1b1[10]  -102.661  49.897  1.294  0.737 
p3b1b1[12]  p3b1b1[11]  -104.524  50.664  3.958  0.818 
p3b1b1[13]  p3b1b1[12]  -106.548  51.578  8.705  0.41 
p3b1b1b1[0]  p3b1b1[13]  -104.914  53.13  8.705  0.41 
p3b1b1b2[0]  p3b1b1[13]  -106.478  54.222  8.705  0.41 
p3b1b2[0]  p3b1[3]  -55.822  7.592  -4.796  0.62 
p3b1b2[1]  p3b1b2[0]  -59.892  1.672  -4.796  0.693 
p3b1b2[2]  p3b1b2[1]  -63.006  -3.637  -1.591  0.718 
p3b1b2[3]  p3b1b2[2]  -66.541  -7.59  2.251  0.76 
p3b1b2[4]  p3b1b2[3]  -71.168  -3.348  5.221  0.717 
p3b1b2[5]  p3b1b2[4]  -75.881  -4.999  6.969  0.941 
p3b1b2[6]  p3b1b2[5]  -80.143  -9.51  9.579  0.41 
p3b2[0]  p3[3]  -35.236  -11.385  -1.748  1.24 
p3b2b1[0]  p3b2[0]  -33.341  -13.516  -9.387  1.01 
p3b2b1[1]  p3b2b1[0]  -32.14  -20.39  -13.481  1.018 
p3b2b1[2]  p3b2b1[1]  -25.35  -20.564  -17.859  1.019 
p3b2b1[3]  p3b2b1[2]  -33.392  -24.35  -20.47  0.889 
p3b2b1[4]  p3b2b1[3]  -37.355  -32.104  -21.82  0.934 
p3b2b1[5]  p3b2b1[4]  -31.536  -37.104  -27.589  0.858 
p3b2b1[6]  p3b2b1[5]  -35.31  -45.337  -27.876  0.842 
p3b2b1[7]  p3b2b1[6]  -28.762  -48.618  -28.708  0.721 
p3b2b1[8]  p3b2b1[7]  -26.459  -53.925  -33.232  0.724 
p3b2b1[9]  p3b2b1[8]  -25.082  -59.616  -36.593  0.62 
p3b2b1b1[0]  p3b2b1[9]  -28.129  -62.065  -36.593  0.41 
p3b2b1b2[0]  p3b2b1[9]  -22.051  -63.253  -37.892  0.888 
p3b2b1b2[1]  p3b2b1b2[0]  -21.422  -64.304  -41.885  1.044 
p3b2b1b2[2]  p3b2b1b2[1]  -24.483  -65.379  -45.467  0.902 
p3b2b1b2[3]  p3b2b1b2[2]  -29.405  -62.146  -45.299  0.41 
p3b2b2[0]  p3b2[0]  -41.802  -14.179  -7.843  1.24 
p3b2b2b1[0]  p3b2b2[0]  -45.316  -18.143  -4.358  0.753 
p3b2b2b1[1]  p3b2b2b1[0]  -42.928  -23.432  -1.687  0.747 
p3b2b2b1[2]  p3b2b2b1[1]  -39.092  -24.253  3.76  0.711 
p3b2b2b1[3]  p3b2b2b1[2]  -37.87  -29.923  7.406  0.62 
p3b2b2b1b1[0]  p3b2b2b1[3]  -35.891  -35.293  9.579  0.62 
p3b2b2b1b1b1[0]  p3b2b2b1b1[0]  -38.318  -34.592  10.016  0.41 
p3b2b2b1b1b2[0]  p3b2b2b1b1[0]  -33.936  -37.789  10.453  0.41 
p3b2b2b1b2[0]  p3b2b2b1[3]  -33.312  -34.524  9.125  0.78 
p3b2b2b1b2[1]  p3b2b2b1b2[0]  -28.221  -37.66  10.016  0.865 
p3b2b2b1b2[2]  p3b2b2b1b2[1]  -24.012  -43.907  8.268  0.62 
p3b2b2b1b2b1[0]  p3b2b2b1b2[2]  -24.399  -45.254  5.658  0.22 
p3b2b2b1b2b1[1]  p3b2b2b1b2b1[0]  -26.76  -47.012  5.658  0.21 
p3b2b2b1b2b2[0]  p3b2b2b1b2[2]  -23.403  -46.437  5.707  0.922 
p3b2b2b1b2b2[1]  p3b2b2b1b2b2[0]  -26.921  -49.462  3.922  0.62 
p3b2b2b1b2b2b1[0]  p3b2b2b1b2b2[1]  -26.901  -55.134  5.63  0.668 
p3b2b2b1b2b2b1[1]  p3b2b2b1b2b2b1[0]  -29.779  -60.772  5.641  0.625 
p3b2b2b1b2b2b1[2]  p3b2b2b1b2b2b1[1]  -27.439  -64.112  0.862  0.62 
p3b2b2b1b2b2b1b1[0]  p3b2b2b1b2b2b1[2]  -27.324  -68.264  0.437  0.41 
p3b2b2b1b2b2b1b2[0]  p3b2b2b1b2b2b1[2]  -31.673  -66.343  -1.817  0.825 
p3b2b2b1b2b2b1b2[1]  p3b2b2b1b2b2b1b2[0]  -27.577  -61.571  -3.484  0.62 
p3b2b2b1b2b2b2[0]  p3b2b2b1b2b2[1]  -29.152  -53.118  3.922  0.62 
p3b2b2b2[0]  p3b2b2[0]  -47.965  -19.154  -2.188  1.243 
p3b2b2b2[1]  p3b2b2b2[0]  -49.126  -18.863  5.143  1.074 
p3b2b2b2[2]  p3b2b2b2[1]  -52.02  -26.512  2.368  0.924 
p3b2b2b2[3]  p3b2b2b2[2]  -58.326  -33.413  2.154  0.853 
p3b2b2b2[4]  p3b2b2b2[3]  -66.105  -35.142  5.098  0.939 
p3b2b2b2[5]  p3b2b2b2[4]  -69.101  -40.761  0.862  1.043 
p3b2b2b2[6]  p3b2b2b2[5]  -75.452  -47.173  3.484  0.83 
p3b2b2b2b1[0]  p3b2b2b2[6]  -79.166  -46.957  3.484  0.814 
p3b2b2b2b1[1]  p3b2b2b2b1[0]  -79.43  -45.356  7.831  0.62 
p3b2b2b2b2[0]  p3b2b2b2[6]  -80.161  -47.684  9.27  0.712 
p3b2b2b2b2[1]  p3b2b2b2b2[0]  -82.676  -54.01  9.934  0.778 
p3b2b2b2b2[2]  p3b2b2b2b2[1]  -89.237  -59.356  9.579  0.628 
p3b2b2b2b2[3]  p3b2b2b2b2[2]  -97.4  -61.875  10.016  0.622 
p3b2b2b2b2[4]  p3b2b2b2b2[3]  -101.944  -62.298  11.959  1.057 
p3b2b2b2b2[5]  p3b2b2b2b2[4]  -101.878  -57.937  15.674  0.41 

p4[1]  soma  -3.188  -7.853  -5.232  2.314 
p4[2]  p4[1]  -6.647  -5.992  -14.812  2.07 
p4b1[0]  p4[2]  -7.291  -2.875  -16.548  2.07 
p4b1b1[0]  p4b1[0]  -15.121  -1.654  -20.877  1.301 
p4b1b1[1]  p4b1b1[0]  -23.909  0.464  -21.285  1.298 
p4b1b1[2]  p4b1b1[1]  -30.05  -3.013  -27.439  1.24 
p4b1b1b1[0]  p4b1b1[2]  -29.164  -4.991  -27.439  0.83 
p4b1b1b1b1[0]  p4b1b1b1[0]  -31.334  -11.302  -30.923  0.776 
p4b1b1b1b1[1]  p4b1b1b1b1[0]  -38.768  -11.01  -30.923  0.702 
p4b1b1b1b1[2]  p4b1b1b1b1[1]  -40.09  -18.819  -32.368  0.648 
p4b1b1b1b1[3]  p4b1b1b1b1[2]  -38.903  -22.151  -38.827  0.709 
p4b1b1b1b1[4]  p4b1b1b1b1[3]  -43.159  -20.405  -42.046  0.93 
p4b1b1b1b1[5]  p4b1b1b1b1[4]  -45.919  -22.093  -48.783  0.698 
p4b1b1b1b1[6]  p4b1b1b1b1[5]  -47.885  -29.523  -49.657  0.675 
p4b1b1b1b1[7]  p4b1b1b1b1[6]  -44.011  -34.661  -50.672  0.801 
p4b1b1b1b1[8]  p4b1b1b1b1[7]  -47.959  -37.175  -56.189  0.721 
p4b1b1b1b1[9]  p4b1b1b1b1[8]  -53.028  -40.084  -61.41  0.666 
p4b1b1b1b1[10]  p4b1b1b1b1[9]  -50.721  -43.276  -63.774  1.136 
p4b1b1b1b1[11]  p4b1b1b1b1[10]  -56.728  -48.536  -64.829  0.648 
p4b1b1b1b1[12]  p4b1b1b1b1[11]  -64.519  -51.042  -64.469  0.637 
p4b1b1b1b1[13]  p4b1b1b1b1[12]  -69.85  -52.97  -66.402  0.872 
p4b1b1b1b1[14]  p4b1b1b1b1[13]  -74.895  -54.276  -72.146  0.673 
p4b1b1b1b1[15]  p4b1b1b1b1[14]  -77.963  -58.431  -76.839  0.748 
p4b1b1b1b1[16]  p4b1b1b1b1[15]  -76.158  -63.253  -81.017  0.787 
p4b1b1b1b1[17]  p4b1b1b1b1[16]  -78.688  -68.134  -82.754  0.905 
p4b1b1b1b1[18]  p4b1b1b1b1[17]  -81.408  -71.16  -87.103  0.876 
p4b1b1b1b1[19]  p4b1b1b1b1[18]  -81.403  -74.882  -94.434  0.635 
p4b1b1b1b1[20]  p4b1b1b1b1[19]  -82.041  -76.567  -102.798  0.62 
p4b1b1b1b2[0]  p4b1b1b1[0]  -29.443  -10.429  -30.17  0.893 
p4b1b1b1b2[1]  p4b1b1b1b2[0]  -36.049  -11.559  -31.797  0.789 
p4b1b1b1b2[2]  p4b1b1b1b2[1]  -41.256  -16.079  -31.797  0.789 
p4b1b1b1b2[3]  p4b1b1b1b2[2]  -44.236  -23.938  -33.608  0.633 
p4b1b1b1b2[4]  p4b1b1b1b2[3]  -50.102  -26.807  -37.602  0.711 
p4b1b1b1b2[5]  p4b1b1b1b2[4]  -51.12  -33.547  -39.203  0.777 
p4b1b1b1b2[6]  p4b1b1b1b2[5]  -52.644  -41.331  -37.455  0.67 
p4b1b1b1b2[7]  p4b1b1b1b2[6]  -57.135  -46.07  -40.439  0.758 
p4b1b1b1b2[8]  p4b1b1b1b2[7]  -61.41  -52.787  -41.814  0.673 
p4b1b1b1b2[9]  p4b1b1b1b2[8]  -63.332  -55.957  -44.424  1.2 
p4b1b1b1b2[10]  p4b1b1b1b2[9]  -63.507  -60.496  -48.83  0.86 
p4b1b1b1b2[11]  p4b1b1b1b2[10]  -64.831  -67.284  -49.959  0.777 
p4b1b1b1b2[12]  p4b1b1b1b2[11]  -69.521  -73.469  -50.956  0.695 
p4b1b1b1b2[13]  p4b1b1b1b2[12]  -71.798  -75.459  -57.88  0.72 
p4b1b1b1b2[14]  p4b1b1b1b2[13]  -78.137  -80.733  -58.8  0.656 
p4b1b1b1b2[15]  p4b1b1b1b2[14]  -85.91  -82.083  -61.577  0.651 
p4b1b1b1b2[16]  p4b1b1b1b2[15]  -89.771  -87.762  -64.032  0.746 
p4b1b1b1b2[17]  p4b1b1b1b2[16]  -93.98  -89.047  -68.816  0.837 
p4b1b1b1b2[18]  p4b1b1b1b2[17]  -98.696  -95.625  -68.816  0.672 
p4b1b1b1b2[19]  p4b1b1b1b2[18]  -105.047  -95.953  -73.283  0.7 
p4b1b1b1b2[20]  p4b1b1b1b2[19]  -107.651  -99.786  -77.97  0.62 
p4b1b1b2[0]  p4b1b1[2]  -36.055  -4.973  -30.762  1.041 
p4b1b1b2[1]  p4b1b1b2[0]  -39.302  -3.543  -36.856  1.054 
p4b1b1b2[2]  p4b1b1b2[1]  -40.641  2.288  -42.688  0.83 
p4b1b1b2b1[0]  p4b1b1b2[2]  -46.905  6.219  -43.125  0.733 
p4b1b1b2b1[1]  p4b1b1b2b1[0]  -50.92  8.341  -48.012  0.813 
p4b1b1b2b1[2]  p4b1b1b2b1[1]  -46.333  10.73  -54.016  0.685 
p4b1b1b2b1[3]  p4b1b1b2b1[2]  -52.513  11.457  -57.5  0.761 
p4b1b1b2b1[4]  p4b1b1b2b1[3]  -51.48  16.099  -58.791  1.101 
p4b1b1b2b1[5]  p4b1b1b2b1[4]  -51.122  20.325  -63.873  0.82 
p4b1b1b2b1[6]  p4b1b1b2b1[5]  -56.344  19.038  -67.842  0.812 
p4b1b1b2b1[7]  p4b1b1b2b1[6]  -61.843  16.771  -73.996  0.634 
p4b1b1b2b1[8]  p4b1b1b2b1[7]  -66.095  19.122  -79.762  0.72 
p4b1b1b2b1[9]  p4b1b1b2b1[8]  -71.92  21.131  -82.473  0.806 
p4b1b1b2b1[10]  p4b1b1b2b1[9]  -76.114  26.305  -86.742  0.686 
p4b1b1b2b1[11]  p4b1b1b2b1[10]  -78.501  25.158  -92.494  0.857 
p4b1b1b2b1[12]  p4b1b1b2b1[11]  -73.381  21.344  -98.003  0.62 
p4b1b1b2b2[0]  p4b1b1b2[2]  -48.78  4.879  -42.688  0.623 
p4b1b1b2b2[1]  p4b1b1b2b2[0]  -55.662  6.35  -43.361  0.753 
p4b1b1b2b2[2]  p4b1b1b2b2[1]  -63.156  6.726  -44.861  0.695 
p4b1b1b2b2[3]  p4b1b1b2b2[2]  -70.526  9.751  -45.924  0.662 
p4b1b1b2b2[4]  p4b1b1b2b2[3]  -77.655  11.241  -47.909  0.705 
p4b1b1b2b2[5]  p4b1b1b2b2[4]  -80.886  6.653  -53.311  0.683 
p4b1b1b2b2[6]  p4b1b1b2b2[5]  -84.733  8.114  -57.925  0.861 
p4b1b1b2b2[7]  p4b1b1b2b2[6]  -89.786  9.849  -60.855  0.873 
p4b1b1b2b2[8]  p4b1b1b2b2[7]  -92.947  5.56  -63.158  0.917 
p4b1b1b2b2[9]  p4b1b1b2b2[8]  -100.822  3.264  -63.595  0.648 
p4b1b1b2b2[10]  p4b1b1b2b2[9]  -107.686  4.282  -63.595  0.767 
p4b1b1b2b2[11]  p4b1b1b2b2[10]  -115.408  4.705  -62.284  0.678 
p4b1b1b2b2[12]  p4b1b1b2b2[11]  -121.717  0.729  -62.284  0.714 
p4b1b1b2b2[13]  p4b1b1b2b2[12]  -126.914  0.069  -67.517  0.62 
p4b1b2[0]  p4b1[0]  -6.825  4.517  -22.084  1.299 
p4b1b2[1]  p4b1b2[0]  -6.492  11.026  -27.181  1.452 
p4b1b2[2]  p4b1b2[1]  -2.875  7.302  -35.282  1.24 
p4b1b2b1[0]  p4b1b2[2]  -3.701  0.885  -40.541  0.949 
p4b1b2b1[1]  p4b1b2b1[0]  -4.479  4.012  -45.286  1.38 
p4b1b2b1[2]  p4b1b2b1[1]  -3.894  -3.439  -50.747  0.855 
p4b1b2b1[3]  p4b1b2b1[2]  1.28  -7.434  -55.099  1.008 
p4b1b2b1[4]  p4b1b2b1[3]  1.336  -6.938  -62.214  1.11 
p4b1b2b1[5]  p4b1b2b1[4]  -2.465  -9.477  -67.843  1.092 
p4b1b2b1[6]  p4b1b2b1[5]  -0.138  -10.135  -75.178  0.973 
p4b1b2b1[7]  p4b1b2b1[6]  -1.349  -13.569  -79.706  0.88 
p4b1b2b1[8]  p4b1b2b1[7]  -4.799  -14.738  -83.533  0.967 
p4b1b2b1[9]  p4b1b2b1[8]  -6.192  -19.439  -88.141  0.76 
p4b1b2b1[10]  p4b1b2b1[9]  -9.593  -18.734  -89.495  1.371 
p4b1b2b1[11]  p4b1b2b1[10]  -12.822  -18.044  -94.518  0.62 
p4b1b2b2[0]  p4b1b2[2]  -2.736  10.126  -37.713  3.378 
p4b1b2b2[1]  p4b1b2b2[0]  -8.489  15.894  -40.304  1.072 
p4b1b2b2[2]  p4b1b2b2[1]  -1.58  15.994  -47.513  0.844 
p4b1b2b2[3]  p4b1b2b2[2]  -2.305  22.097  -53.202  1.006 
p4b1b2b2[4]  p4b1b2b2[3]  0.338  26.357  -58.247  1.185 
p4b1b2b2[5]  p4b1b2b2[4]  -6.658  24.548  -61.847  1.044 
p4b1b2b2[6]  p4b1b2b2[5]  -5.687  29.435  -69.037  0.963 
p4b1b2b2[7]  p4b1b2b2[6]  -10.391  31.066  -76.836  0.911 
p4b1b2b2[8]  p4b1b2b2[7]  -14.107  34.564  -81.011  1.278 
p4b1b2b2[9]  p4b1b2b2[8]  -14.968  40.054  -88.32  0.918 
p4b1b2b2[10]  p4b1b2b2[9]  -18.721  40.741  -95.392  1.049 
p4b1b2b2[11]  p4b1b2b2[10]  -22.724  35.799  -100.613  0.83 
p4b2[0]  p4[2]  -9.694  -9.272  -20.279  1.615 
p4b2[1]  p4b2[0]  -16.825  -12.834  -18.296  1.24 
p4b2b1[0]  p4b2[1]  -20.27  -20.577  -18.733  1.148 
p4b2b1[1]  p4b2b1[0]  -14.223  -20.613  -24.588  0.989 
p4b2b1[2]  p4b2b1[1]  -10.663  -26.328  -26.576  1.185 
p4b2b1[3]  p4b2b1[2]  -8.847  -34.636  -26.965  0.978 
p4b2b1[4]  p4b2b1[3]  -2.753  -35.258  -33.035  0.965 
p4b2b1[5]  p4b2b1[4]  -3.258  -42.036  -37.892  0.996 
p4b2b1[6]  p4b2b1[5]  2.171  -49.236  -38.329  0.922 
p4b2b1[7]  p4b2b1[6]  5.158  -53.139  -41.766  1.388 
p4b2b1[8]  p4b2b1[7]  1.074  -60.468  -45.519  0.905 
p4b2b1[9]  p4b2b1[8]  6.733  -62.365  -50.016  1.114 
p4b2b1[10]  p4b2b1[9]  10.861  -63.463  -54.843  1.291 
p4b2b1[11]  p4b2b1[10]  6.394  -67.246  -62.177  0.887 
p4b2b1[12]  p4b2b1[11]  9.094  -64.656  -69.323  1.032 
p4b2b1[13]  p4b2b1[12]  15.217  -67.742  -71.438  1.16 
p4b2b1[14]  p4b2b1[13]  12.883  -73.34  -73.081  0.956 
p4b2b1[15]  p4b2b1[14]  10.682  -78.447  -76.749  0.807 
p4b2b1[16]  p4b2b1[15]  13.006  -84.652  -79.27  0.62 
p4b2b2[0]  p4b2[1]  -23.87  -12.806  -14.812  1.091 
p4b2b2[1]  p4b2b2[0]  -30.395  -15.032  -16.986  1.186 
p4b2b2[2]  p4b2b2[1]  -33.879  -22.356  -18.733  1.03 
p4b2b2b1[0]  p4b2b2[2]  -35.282  -29.149  -20.897  0.96 
p4b2b2b1[1]  p4b2b2b1[0]  -36.65  -34.396  -24.828  0.83 
p4b2b2b2[0]  p4b2b2[2]  -32.068  -30.225  -16.59  0.944 
p4b2b2b2[1]  p4b2b2b2[0]  -37.142  -37.611  -16.986  0.879 
p4b2b2b2[2]  p4b2b2b2[1]  -42.559  -43.102  -16.986  1.022 
p4b2b2b2[3]  p4b2b2b2[2]  -47.427  -44.878  -13.501  1.263 
p4b2b2b2[4]  p4b2b2b2[3]  -52.109  -49.898  -8.554  0.932 
p4b2b2b2[5]  p4b2b2b2[4]  -53.783  -58.409  -9.588  0.903 
p4b2b2b2[6]  p4b2b2b2[5]  -56.495  -66.199  -8.941  0.953 
p4b2b2b2[7]  p4b2b2b2[6]  -64.609  -69.36  -7.288  0.89 
p4b2b2b2[8]  p4b2b2b2[7]  -68.172  -75.314  -4.358  0.83 
p4b2b2b2b1[0]  p4b2b2b2[8]  -64.25  -75.842  -4.358  0.62 
p4b2b2b2b2[0]  p4b2b2b2[8]  -64.662  -81.615  -4.734  1.063 
p4b2b2b2b2[1]  p4b2b2b2b2[0]  -67.535  -84.716  -3.921  1.782 
p4b2b2b2b2[2]  p4b2b2b2b2[1]  -70.676  -92.022  -1.748  0.931 
p4b2b2b2b2[3]  p4b2b2b2b2[2]  -69.254  -98.866  -0.874  0.714 
p4b2b2b2b2[4]  p4b2b2b2b2[3]  -64.724  -100.469  3.795  0.74 
p4b2b2b2b2[5]  p4b2b2b2b2[4]  -60.015  -104.59  7.496  0.681 
p4b2b2b2b2[6]  p4b2b2b2b2[5]  -52.923  -105.167  9.58  0.62 

p5[1]  soma  -14.766  -3.197  -3.485  2.27 
p5b1[0]  p5[1]  -25.744  2.668  -3.988  1.487 
p5b1[1]  p5b1[0]  -34.925  9.683  0.874  1.45 
p5b1b1[0]  p5b1[1]  -40.753  8.916  -1.532  1.345 
p5b1b1[1]  p5b1b1[0]  -44.298  8.981  -7.406  1.24 
p5b1b1b1[0]  p5b1b1[1]  -48.269  10.816  -5.305  1.233 
p5b1b1b1[1]  p5b1b1b1[0]  -52.774  9.752  -3.485  0.83 
p5b1b1b1b1[0]  p5b1b1b1[1]  -54.567  9.683  -3.485  0.62 
p5b1b1b1b1b1[0]  p5b1b1b1b1[0]  -52.601  12.167  -0.437  0.41 
p5b1b1b1b1b2[0]  p5b1b1b1b1[0]  -56.17  6.113  1.625  0.837 
p5b1b1b1b1b2[1]  p5b1b1b1b1b2[0]  -59.018  6.29  7.843  0.62 
p5b1b1b1b1b2b1[0]  p5b1b1b1b1b2[1]  -62.408  5.666  10.067  0.534 
p5b1b1b1b1b2b1[1]  p5b1b1b1b1b2b1[0]  -62.949  6.845  14.006  0.21 
p5b1b1b1b1b2b1[2]  p5b1b1b1b1b2b1[1]  -64.561  6.336  16.112  0.21 
p5b1b1b1b1b2b2[0]  p5b1b1b1b1b2[1]  -63.386  7.986  10.109  0.485 
p5b1b1b1b1b2b2[1]  p5b1b1b1b1b2b2[0]  -67.341  5.06  11.832  0.484 
p5b1b1b1b1b2b2[2]  p5b1b1b1b1b2b2[1]  -70.944  5.98  15.249  0.41 
p5b1b1b1b2[0]  p5b1b1b1[1]  -54.322  6.179  1.042  0.632 
p5b1b1b1b2[1]  p5b1b1b1b2[0]  -55.2  0.609  1.748  0.664 
p5b1b1b1b2[2]  p5b1b1b1b2[1]  -57.42  -5.025  1.748  0.62 
p5b1b1b1b2b1[0]  p5b1b1b1b2[2]  -61.687  -10.42  1.83  0.687 
p5b1b1b1b2b1[1]  p5b1b1b1b2b1[0]  -63.047  -15.983  5.875  0.674 
p5b1b1b1b2b1[2]  p5b1b1b1b2b1[1]  -62.064  -22.939  6.969  0.665 
p5b1b1b1b2b1[3]  p5b1b1b1b2b1[2]  -57.06  -27.712  7.843  0.678 
p5b1b1b1b2b1[4]  p5b1b1b1b2b1[3]  -51.876  -31.544  9.579  0.62 
p5b1b1b1b2b2[0]  p5b1b1b1b2[2]  -56.258  -9.188  1.311  0.62 
p5b1b1b2[0]  p5b1b1[1]  -50.305  4.719  -10.297  0.941 
p5b1b1b2[1]  p5b1b1b2[0]  -58.447  1.756  -11.765  0.848 
p5b1b1b2[2]  p5b1b1b2[1]  -64.711  -0.785  -7.936  0.959 
p5b1b1b2[3]  p5b1b1b2[2]  -71.523  -2.389  -3.083  0.874 
p5b1b1b2[4]  p5b1b1b2[3]  -79.086  -4.634  -0.437  0.83 
p5b1b1b2b1[0]  p5b1b1b2[4]  -87.653  -5.356  0.437  0.892 
p5b1b1b2b1[1]  p5b1b1b2b1[0]  -94.379  -7.076  0.437  0.86 
p5b1b1b2b1[2]  p5b1b1b2b1[1]  -101.729  -8.207  1.311  0.665 
p5b1b1b2b1[3]  p5b1b1b2b1[2]  -108.247  -11.689  3.047  0.656 
p5b1b1b2b1[4]  p5b1b1b2b1[3]  -115.629  -9.889  3.921  0.651 
p5b1b1b2b1[5]  p5b1b1b2b1[4]  -120.042  -10.989  8.325  0.786 
p5b1b1b2b1[6]  p5b1b1b2b1[5]  -126.056  -15.031  9.142  0.683 
p5b1b1b2b1[7]  p5b1b1b2b1[6]  -132.652  -18.125  9.142  0.683 
p5b1b1b2b1[8]  p5b1b1b2b1[7]  -139.425  -20.091  9.142  0.706 
p5b1b1b2b1[9]  p5b1b1b2b1[8]  -145.992  -19.547  12.129  0.688 
p5b1b1b2b1[10]  p5b1b1b2b1[9]  -147.326  -19.676  15.686  0.41 
p5b1b1b2b2[0]  p5b1b1b2[4]  -83.526  -2.943  -6.543  1.016 
p5b1b1b2b2[1]  p5b1b1b2b2[0]  -85.787  -3.336  -13.761  1.038 
p5b1b1b2b2[2]  p5b1b1b2b2[1]  -89.367  -10.174  -15.686  0.988 
p5b1b1b2b2[3]  p5b1b1b2b2[2]  -95.978  -14.443  -18.026  0.958 
p5b1b1b2b2[4]  p5b1b1b2b2[3]  -102.243  -13.583  -23.995  0.904 
p5b1b1b2b2[5]  p5b1b1b2b2[4]  -111.136  -14.412  -25.829  0.862 
p5b1b1b2b2[6]  p5b1b1b2b2[5]  -113.89  -18.221  -30.443  1.194 
p5b1b1b2b2[7]  p5b1b1b2b2[6]  -119.498  -20.529  -35.957  0.959 
p5b1b1b2b2[8]  p5b1b1b2b2[7]  -125.942  -16.621  -39.495  0.944 
p5b1b1b2b2[9]  p5b1b1b2b2[8]  -131.655  -19.322  -42.251  1.14 
p5b1b1b2b2[10]  p5b1b1b2b2[9]  -139.254  -22.699  -44.476  0.913 
p5b1b1b2b2[11]  p5b1b1b2b2[10]  -144.672  -23.759  -47.407  1.103 
p5b1b1b2b2[12]  p5b1b1b2b2[11]  -146.268  -24.173  -54.015  0.62 
p5b1b2[0]  p5b1[1]  -38.558  16.379  -3.166  0.93 
p5b1b2[1]  p5b1b2[0]  -45.92  20.254  -6.969  0.877 
p5b1b2[2]  p5b1b2[1]  -50.822  25.958  -4.359  1.007 
p5b1b2[3]  p5b1b2[2]  -59.951  26.037  -4.359  0.878 
p5b1b2[4]  p5b1b2[3]  -67.747  28.78  -4.095  0.97 
p5b1b2[5]  p5b1b2[4]  -73.786  35.409  -2.174  0.874 
p5b1b2[6]  p5b1b2[5]  -77.822  36.606  -1.737  1.895 
p5b1b2[7]  p5b1b2[6]  -84.849  40.289  -1.311  1.009 
p5b1b2[8]  p5b1b2[7]  -90.985  46.083  -0.874  0.903 
p5b1b2[9]  p5b1b2[8]  -98.717  43.908  -0.064  0.641 
p5b1b2[10]  p5b1b2[9]  -102.987  44.848  4.745  0.797 
p5b1b2[11]  p5b1b2[10]  -109.277  48.126  6.532  0.708 
p5b1b2[12]  p5b1b2[11]  -112.948  54.815  7.406  0.674 
p5b1b2[13]  p5b1b2[12]  -116.16  62.171  7.406  0.645 
p5b1b2[14]  p5b1b2[13]  -120.924  67.542  7.843  0.72 
p5b1b2[15]  p5b1b2[14]  -127.792  68.127  6.969  0.745 
p5b1b2[16]  p5b1b2[15]  -134.182  71.337  5.221  0.703 
p5b1b2[17]  p5b1b2[16]  -140.358  76.118  5.221  0.62 
p5b1b2b1[0]  p5b1b2[17]  -139.15  78.016  5.221  0.21 
p5b1b2b2[0]  p5b1b2[17]  -142.749  78.43  5.221  0.21 
p5b2[0]  p5[1]  -19.444  -3.658  -11.041  1.086 
p5b2[1]  p5b2[0]  -21.585  -7.693  -16.986  1.03 
p5b2b1[0]  p5b2[1]  -21.444  -8.908  -21.974  0.83 
p5b2b1[1]  p5b2b1[0]  -18.308  -8.004  -23.08  0.83 
p5b2b1b1[0]  p5b2b1[1]  -13.035  -2.037  -23.518  0.668 
p5b2b1b1[1]  p5b2b1b1[0]  -19.518  -1.998  -27.43  0.704 
p5b2b1b1[2]  p5b2b1b1[1]  -24.76  1.612  -32.414  0.659 
p5b2b1b1[3]  p5b2b1b1[2]  -29.941  3.716  -37.536  0.703 
p5b2b1b1[4]  p5b2b1b1[3]  -36.445  4.227  -41.25  0.71 
p5b2b1b1[5]  p5b2b1b1[4]  -41.548  4.556  -45.298  0.817 
p5b2b1b1[6]  p5b2b1b1[5]  -49.101  7.793  -45.735  0.648 
p5b2b1b1[7]  p5b2b1b1[6]  -54.352  11.457  -45.735  0.832 
p5b2b1b1[8]  p5b2b1b1[7]  -58.689  7.338  -46.968  0.873 
p5b2b1b1[9]  p5b2b1b1[8]  -65.683  6.757  -46.658  0.759 
p5b2b1b1[10]  p5b2b1b1[9]  -69.365  6.936  -52.36  0.785 
p5b2b1b1[11]  p5b2b1b1[10]  -74.269  1.496  -54.273  0.704 
p5b2b1b1[12]  p5b2b1b1[11]  -79.054  -3.513  -56.221  0.741 
p5b2b1b1[13]  p5b2b1b1[12]  -82.994  -1.48  -62.344  0.705 
p5b2b1b1[14]  p5b2b1b1[13]  -81.604  2.61  -66.206  0.62 
p5b2b1b2[0]  p5b2b1[1]  -14.063  -6.4  -24.94  0.897 
p5b2b1b2[1]  p5b2b1b2[0]  -15.663  -3.335  -24.392  0.62 
p5b2b2[0]  p5b2[1]  -24.018  -8.317  -26.058  0.86 
p5b2b2[1]  p5b2b2[0]  -23.949  -12.919  -32.322  1.041 
p5b2b2[2]  p5b2b2[1]  -25.045  -16.539  -40.322  0.801 
p5b2b2[3]  p5b2b2[2]  -32.789  -16.307  -39.64  0.672 
p5b2b2[4]  p5b2b2[3]  -35.914  -23.374  -40.733  0.669 
p5b2b2[5]  p5b2b2[4]  -39.338  -30.63  -42.46  0.637 
p5b2b2[6]  p5b2b2[5]  -45.168  -33.074  -46.164  0.713 
p5b2b2[7]  p5b2b2[6]  -45.583  -40.931  -45.912  0.664 
p5b2b2[8]  p5b2b2[7]  -48.215  -48.575  -45.917  0.646 
p5b2b2[9]  p5b2b2[8]  -52.76  -53.232  -49.22  0.716 
p5b2b2[10]  p5b2b2[9]  -55.777  -59.331  -52.268  0.701 
p5b2b2[11]  p5b2b2[10]  -57.671  -62.145  -54.878  1.221 
p5b2b2[12]  p5b2b2[11]  -58.782  -69.984  -55.315  0.659 
p5b2b2[13]  p5b2b2[12]  -62.786  -75.094  -58.363  0.729 
p5b2b2[14]  p5b2b2[13]  -66.492  -80.647  -62.895  0.647 
p5b2b2[15]  p5b2b2[14]  -72.696  -85.499  -65.332  0.634 
p5b2b2[16]  p5b2b2[15]  -80.23  -86.514  -67.98  0.649 
p5b2b2[17]  p5b2b2[16]  -83.242  -90.446  -73.198  0.726 
p5b2b2[18]  p5b2b2[17]  -87.768  -93.851  -78.396  0.62 
p5b2b2b1[0]  p5b2b2[18]  -91.721  -99.585  -78.396  0.646 
p5b2b2b1[1]  p5b2b2b1[0]  -98.423  -100.06  -80.139  0.648 
p5b2b2b1[2]  p5b2b2b1[1]  -101.533  -103.672  -85.364  0.62 
p5b2b2b2[0]  p5b2b2[18]  -90.487  -92.261  -74.751  0.21 
p5b2b2b2[1]  p5b2b2b2[0]  -93.907  -92.69  -71.924  0.227 
p5b2b2b2[2]  p5b2b2b2[1]  -95.208  -94.185  -67.516  0.21 

p6[1]  soma  6.881  4.928  -0.874  2.105 
p6[2]  p6[1]  12.949  11.005  -0.874  2.07 
p6b1[0]  p6[2]  21.128  13.324  -4.687  1.088 
p6b1[1]  p6b1[0]  24.727  5.91  -8.28  1.128 
p6b1[2]  p6b1[1]  27.561  0.137  -12.164  1.055 
p6b1[3]  p6b1[2]  33.158  4.228  -15.051  0.977 
p6b1[4]  p6b1[3]  37.226  5.934  -20.47  0.83 
p6b1b1[0]  p6b1[4]  41.451  0.799  -20.648  0.758 
p6b1b1[1]  p6b1b1[0]  46.051  -2.985  -16.187  0.678 
p6b1b1[2]  p6b1b1[1]  50.511  -4.962  -12.044  0.788 
p6b1b1[3]  p6b1b1[2]  58.278  -4.604  -10.89  0.642 
p6b1b1[4]  p6b1b1[3]  63.859  -9.232  -10.908  0.696 
p6b1b1[5]  p6b1b1[4]  70.112  -12.045  -10.016  0.73 
p6b1b1[6]  p6b1b1[5]  75.266  -8.582  -9.142  0.804 
p6b1b1[7]  p6b1b1[6]  81.585  -6.168  -9.142  0.746 
p6b1b1[8]  p6b1b1[7]  88.75  -6.145  -7.108  0.677 
p6b1b1[9]  p6b1b1[8]  93.604  0.163  -6.903  0.634 
p6b1b1[10]  p6b1b1[9]  98.459  5.245  -4.795  0.687 
p6b1b1[11]  p6b1b1[10]  105.708  6.394  -4.795  0.62 
p6b1b1b1[0]  p6b1b1[11]  106.674  7.118  -4.795  0.62 
p6b1b1b2[0]  p6b1b1[11]  108.655  10.437  -4.795  0.635 
p6b1b1b2[1]  p6b1b1b2[0]  108.675  14.076  -3.047  0.62 
p6b1b1b2b1[0]  p6b1b1b2[1]  105.478  14.156  -3.047  0.41 
p6b1b1b2b2[0]  p6b1b1b2[1]  107.62  20.112  -2.61  0.654 
p6b1b1b2b2[1]  p6b1b1b2b2[0]  103.713  20.006  -0.186  0.682 
p6b1b1b2b2[2]  p6b1b1b2b2[1]  101.476  23.31  1.737  0.41 
p6b1b1b2b2b1[0]  p6b1b1b2b2[2]  96.979  22.252  2.174  0.41 
p6b1b1b2b2b2[0]  p6b1b1b2b2[2]  97.807  24.989  1.737  0.41 
p6b1b2[0]  p6b1[4]  39.254  -2.658  -21.533  0.922 
p6b1b2[1]  p6b1b2[0]  42.493  -11.534  -21.344  0.867 
p6b1b2[2]  p6b1b2[1]  45.636  -20.303  -21.344  0.88 
p6b1b2[3]  p6b1b2[2]  52.331  -18.711  -25.41  1.025 
p6b1b2[4]  p6b1b2[3]  56.697  -25.598  -27.255  0.98 
p6b1b2[5]  p6b1b2[4]  61.547  -30.529  -33.428  0.884 
p6b1b2[6]  p6b1b2[5]  64.81  -39.564  -34.408  0.849 
p6b1b2[7]  p6b1b2[6]  70.387  -42.416  -37.396  1.181 
p6b1b2[8]  p6b1b2[7]  71.964  -45.735  -41.207  1.548 
p6b1b2[9]  p6b1b2[8]  76.746  -49.888  -43.999  1.184 
p6b1b2[10]  p6b1b2[9]  83.846  -53.419  -44.785  1.029 
p6b1b2[11]  p6b1b2[10]  92.301  -53.38  -44.861  0.969 
p6b1b2[12]  p6b1b2[11]  98.595  -58.446  -47.602  0.961 
p6b1b2[13]  p6b1b2[12]  98.482  -63.334  -53.514  1.068 
p6b1b2[14]  p6b1b2[13]  100.65  -68.967  -55.167  1.31 
p6b1b2[15]  p6b1b2[14]  105.937  -72.882  -56.919  1.204 
p6b1b2[16]  p6b1b2[15]  105.751  -78.035  -61.739  1.161 
p6b1b2[17]  p6b1b2[16]  111.051  -75.908  -67.953  0.76 
p6b1b2[18]  p6b1b2[17]  111.411  -81.749  -70.127  0.848 
p6b1b2[19]  p6b1b2[18]  112.39  -85.94  -75.317  0.785 
p6b1b2[20]  p6b1b2[19]  117.646  -89.026  -78.407  0.774 
p6b1b2[21]  p6b1b2[20]  120.845  -93.79  -80.753  0.854 
p6b1b2[22]  p6b1b2[21]  120.722  -99.21  -85.222  0.686 
p6b1b2[23]  p6b1b2[22]  123.058  -103.932  -88.032  0.477 
p6b1b2[24]  p6b1b2[23]  123.958  -105.282  -94.956  0.41 
p6b2[0]  p6[2]  17.129  17.566  -4.371  1.191 
p6b2[1]  p6b2[0]  12.523  24.827  -7.843  1.095 
p6b2[2]  p6b2[1]  5.704  31.337  -10.453  1.03 
p6b2b1[0]  p6b2[2]  2.273  37.26  -16.906  1.177 
p6b2b1[1]  p6b2b1[0]  8.242  43.658  -20.47  1.172 
p6b2b1[2]  p6b2b1[1]  13.933  49.034  -21.021  1.411 
p6b2b1[3]  p6b2b1[2]  11.259  57.937  -21.781  1.03 
p6b2b1b1[0]  p6b2b1[3]  10.664  66.28  -23.518  0.956 
p6b2b1b1[1]  p6b2b1b1[0]  9.632  71.266  -23.08  1.598 
p6b2b1b1[2]  p6b2b1b1[1]  6.215  77.772  -23.08  1.111 
p6b2b1b1[3]  p6b2b1b1[2]  4.793  85.516  -24.392  1.023 
p6b2b1b1[4]  p6b2b1b1[3]  -2.39  89.47  -23.954  0.995 
p6b2b1b1[5]  p6b2b1b1[4]  -2.748  97.543  -26.139  0.83 
p6b2b1b2[0]  p6b2b1[3]  19.321  61.604  -23.012  0.902 
p6b2b1b2[1]  p6b2b1b2[0]  23.557  64.936  -29.931  0.92 
p6b2b1b2[2]  p6b2b1b2[1]  27.671  71.621  -34.294  0.899 
p6b2b1b2[3]  p6b2b1b2[2]  32.559  78.097  -37.173  0.937 
p6b2b1b2[4]  p6b2b1b2[3]  28.263  85.155  -41.876  0.849 
p6b2b1b2[5]  p6b2b1b2[4]  30.232  90.751  -47.291  1.005 
p6b2b1b2[6]  p6b2b1b2[5]  35.197  94.116  -52.492  1.017 
p6b2b1b2[7]  p6b2b1b2[6]  31.206  101.815  -55.315  0.885 
p6b2b1b2[8]  p6b2b1b2[7]  33.037  105.888  -61.273  1.084 
p6b2b1b2[9]  p6b2b1b2[8]  40.102  105.364  -65.331  0.988 
p6b2b1b2[10]  p6b2b1b2[9]  42.778  112.131  -68.233  1.03 
p6b2b1b2[11]  p6b2b1b2[10]  45.632  114.091  -71.863  0.83 
p6b2b2[0]  p6b2[2]  10.66  32.268  -17.872  0.923 
p6b2b2[1]  p6b2b2[0]  16.587  32.446  -24.874  0.903 
p6b2b2[2]  p6b2b2[1]  23.847  34.363  -27.891  1.023 
p6b2b2[3]  p6b2b2[2]  29.408  32.638  -34.686  0.925 
p6b2b2[4]  p6b2b2[3]  36.346  33.361  -39.64  0.968 
p6b2b2[5]  p6b2b2[4]  42.689  39.673  -41.377  0.908 
p6b2b2[6]  p6b2b2[5]  45.764  44.522  -43.832  1.326 
p6b2b2[7]  p6b2b2[6]  54.31  45.613  -47.331  0.89 
p6b2b2[8]  p6b2b2[7]  57.895  52.691  -50.091  0.986 
p6b2b2[9]  p6b2b2[8]  57.775  59.464  -52.704  1.141 
p6b2b2[10]  p6b2b2[9]  64.43  59.848  -58.362  0.947 
p6b2b2[11]  p6b2b2[10]  61.908  63.36  -61.41  1.566 
p6b2b2[12]  p6b2b2[11]  67.093  67.315  -65.783  1.055 
p6b2b2[13]  p6b2b2[12]  75.308  70.344  -67.08  0.936 
p6b2b2[14]  p6b2b2[13]  79.716  78.654  -67.08  0.88 
p6b2b2[15]  p6b2b2[14]  84.81  82.646  -71.109  1.086 
p6b2b2[16]  p6b2b2[15]  89.98  88.928  -73.611  0.973 
p6b2b2[17]  p6b2b2[16]  95.175  94.817  -74.486  1.048 
p6b2b2[18]  p6b2b2[17]  101.021  96.03  -74.486  1.387 
p6b2b2[19]  p6b2b2[18]  107.249  98.095  -78.407  0.83 

p7[1]  soma  6.138  4.552  -2.61  1.206 
p7[2]  p7[1]  4.157  -4.178  -4.358  1.068 
p7[3]  p7[2]  6.438  -5.677  -12.904  1.086 
p7[4]  p7[3]  12.316  -4.485  -17.86  1.03 
p7b1[0]  p7[4]  15.099  -3.703  -17.86  1.03 
p7b1b1[0]  p7b1[0]  21.715  -2.724  -22.863  0.625 
p7b1b1[1]  p7b1b1[0]  21.354  -1.558  -28.43  0.916 
p7b1b1[2]  p7b1b1[1]  25.633  -3.778  -34.642  0.664 
p7b1b1[3]  p7b1b1[2]  28.478  -5.525  -41.186  0.711 
p7b1b1[4]  p7b1b1[3]  32.284  -6.16  -47.268  0.725 
p7b1b1[5]  p7b1b1[4]  36.553  -4.624  -47.472  1.15 
p7b1b1[6]  p7b1b1[5]  39.951  -8.354  -49.657  0.95 
p7b1b1[7]  p7b1b1[6]  42.924  -6.542  -56.386  0.689 
p7b1b1[8]  p7b1b1[7]  44.842  -7.892  -62.653  0.781 
p7b1b1[9]  p7b1b1[8]  50.298  -6.852  -66.463  0.775 
p7b1b1[10]  p7b1b1[9]  54.542  -11.98  -69.625  0.709 
p7b1b1[11]  p7b1b1[10]  59.422  -12.031  -74.048  0.793 
p7b1b1[12]  p7b1b1[11]  62.731  -11.088  -79.736  0.786 
p7b1b1[13]  p7b1b1[12]  64.723  -13.319  -84.548  0.922 
p7b1b1[14]  p7b1b1[13]  70.757  -14.987  -86.729  0.788 
p7b1b1[15]  p7b1b1[14]  76.797  -14.007  -90.16  0.62 
p7b1b1b1[0]  p7b1b1[15]  77.049  -11.644  -94.142  0.811 
p7b1b1b1[1]  p7b1b1b1[0]  76.188  -9.303  -97.129  0.62 
p7b1b1b2[0]  p7b1b1[15]  80.415  -15.69  -94.928  0.738 
p7b1b1b2[1]  p7b1b1b2[0]  85.777  -18.926  -95.284  0.732 
p7b1b1b2[2]  p7b1b1b2[1]  92.096  -18.902  -98.865  0.632 
p7b1b1b2[3]  p7b1b1b2[2]  96.082  -19.952  -102.35  0.62 
p7b1b2[0]  p7b1[0]  17.33  3.15  -21.649  0.982 
p7b1b2[1]  p7b1b2[0]  13.293  3.561  -29.135  0.939 
p7b1b2[2]  p7b1b2[1]  12.087  6.166  -35.489  1.147 
p7b1b2[3]  p7b1b2[2]  7.765  7.345  -40.066  1.248 
p7b1b2[4]  p7b1b2[3]  3.033  8.935  -45.803  1.051 
p7b1b2[5]  p7b1b2[4]  5.179  16.352  -47.354  1.015 
p7b1b2[6]  p7b1b2[5]  2.556  16.746  -52.858  1.308 
p7b1b2[7]  p7b1b2[6]  -0.637  19.459  -56.626  0.932 
p7b1b2[8]  p7b1b2[7]  2.595  21.361  -60.947  0.902 
p7b1b2[9]  p7b1b2[8]  -0.345  22.126  -63.595  0.62 
p7b2[0]  p7[4]  15.52  -1.601  -23.08  0.78 
p7b2[1]  p7b2[0]  17.036  0.6  -28.474  0.877 
p7b2[2]  p7b2[1]  15.582  2.012  -32.234  0.62 
p7b2b1[0]  p7b2[2]  13.47  0.04  -41.878  0.83 
p7b2b1[1]  p7b2b1[0]  14.345  -3.979  -49.002  1.016 
p7b2b1[2]  p7b2b1[1]  11.96  -0.633  -56.993  0.93 
p7b2b1[3]  p7b2b1[2]  4.267  -1.029  -61.638  0.929 
p7b2b1[4]  p7b2b1[3]  6.881  -6.801  -64.052  1.232 
p7b2b1[5]  p7b2b1[4]  11.494  -8.911  -70.564  1.012 
p7b2b1[6]  p7b2b1[5]  10.23  -12.728  -72.81  1.775 
p7b2b1[7]  p7b2b1[6]  10.295  -15.333  -78.333  0.883 
p7b2b1[8]  p7b2b1[7]  6.069  -15.259  -83.191  0.838 
p7b2b1[9]  p7b2b1[8]  7.576  -20.152  -85.801  0.939 
p7b2b1[10]  p7b2b1[9]  11.555  -24.868  -88.633  0.795 
p7b2b1[11]  p7b2b1[10]  11.922  -28.354  -96.574  0.622 
p7b2b1[12]  p7b2b1[11]  12.9  -29.673  -105.084  0.623 
p7b2b1[13]  p7b2b1[12]  13.37  -29.578  -113.773  0.62 
p7b2b1[14]  p7b2b1[13]  14.582  -30.693  -121.52  0.62 
p7b2b2[0]  p7b2[2]  13.041  0.174  -29.613  1.312 
p7b2b2[1]  p7b2b2[0]  6.611  -3.953  -29.552  0.702 
p7b2b2[2]  p7b2b2[1]  3.841  -10.57  -27.743  0.725 
p7b2b2[3]  p7b2b2[2]  2.93  -11.093  -35.648  0.673 
p7b2b2[4]  p7b2b2[3]  1.494  -11.801  -43.92  0.637 
p7b2b2[5]  p7b2b2[4]  -3.336  -13.353  -50.483  0.647 
p7b2b2[6]  p7b2b2[5]  -9.624  -15.699  -53.869  0.714 
p7b2b2[7]  p7b2b2[6]  -13.625  -18.532  -59.236  0.738 
p7b2b2[8]  p7b2b2[7]  -17.189  -25.132  -60.973  0.616 
p7b2b2[9]  p7b2b2[8]  -18.943  -31.486  -59.673  0.429 
p7b2b2[10]  p7b2b2[9]  -20.51  -37.621  -59.673  0.456 
p7b2b2[11]  p7b2b2[10]  -22.912  -43.339  -60.11  0.464 
p7b2b2[12]  p7b2b2[11]  -21.827  -48.196  -59.236  0.41 

p8[1]  soma  0.954  0.196  0  2.07 
p8b1[0]  p8[1]  1.431  11.153  -0.437  1.368 
p8b1[1]  p8b1[0]  -4.208  15.414  -8.105  1.44 
p8b1[2]  p8b1[1]  -7.086  22.295  -16.455  1.341 
p8b1[3]  p8b1[2]  -10.462  23.359  -25.008  1.622 
p8b1[4]  p8b1[3]  -16.976  26.996  -29.612  1.55 
p8b1[5]  p8b1[4]  -14.762  30.289  -38.094  1.214 
p8b1[6]  p8b1[5]  -22.3  33.592  -44.753  1.074 
p8b1[7]  p8b1[6]  -22.281  39.659  -50.091  1.036 
p8b1[8]  p8b1[7]  -23.178  37.491  -57.402  1.071 
p8b1[9]  p8b1[8]  -30.478  37.776  -62.735  0.909 
p8b1[10]  p8b1[9]  -36.516  42.04  -65.433  1.045 
p8b1[11]  p8b1[10]  -41.746  41.722  -73.174  0.879 
p8b1[12]  p8b1[11]  -43.637  41.839  -76.668  2.069 
p8b1[13]  p8b1[12]  -49.173  39.039  -83.628  0.882 
p8b1[14]  p8b1[13]  -54.126  43.461  -89.745  0.911 
p8b1[15]  p8b1[14]  -59.048  42.349  -92.333  1.45 
p8b1[16]  p8b1[15]  -65.345  42.316  -98.846  0.908 
p8b1[17]  p8b1[16]  -68.49  41.334  -104.701  0.904 
p8b1[18]  p8b1[17]  -74.773  39.343  -106.8  0.767 
p8b1[19]  p8b1[18]  -77.213  35.993  -112.945  0.667 
p8b1[20]  p8b1[19]  -77.691  35.122  -119.836  0.41 
p8b1[21]  p8b1[20]  -80.589  30.694  -121.52  0.514 
p8b1[22]  p8b1[21]  -77.038  24.644  -121.52  0.41 
p8b2[0]  p8[1]  6.171  -5.236  1.748  2.167 
p8b2[1]  p8b2[0]  1.087  -13.997  2.622  1.648 
p8b2[2]  p8b2[1]  -0.69  -21.022  -2.611  1.45 
p8b2b1[0]  p8b2[2]  6.237  -18.931  -6.254  1.038 
p8b2b1[1]  p8b2b1[0]  7.562  -22.261  -13.064  1.093 
p8b2b1[2]  p8b2b1[1]  15.163  -25.371  -13.757  1.02 
p8b2b1[3]  p8b2b1[2]  20.62  -30.756  -13.938  1.097 
p8b2b1[4]  p8b2b1[3]  18.831  -39.935  -15.237  0.891 
p8b2b1[5]  p8b2b1[4]  27.588  -42.481  -16.111  0.918 
p8b2b1[6]  p8b2b1[5]  37.337  -42.502  -16.111  0.863 
p8b2b1[7]  p8b2b1[6]  41.45  -50.885  -17.848  0.885 
p8b2b1[8]  p8b2b1[7]  39.129  -59.013  -17.848  0.995 
p8b2b1[9]  p8b2b1[8]  42.352  -62.209  -22.332  1.318 
p8b2b1[10]  p8b2b1[9]  46.276  -67.654  -27.478  0.994 
p8b2b1[11]  p8b2b1[10]  51.499  -73.226  -30.049  1.044 
p8b2b1[12]  p8b2b1[11]  56.995  -75.737  -31.515  1.352 
p8b2b1[13]  p8b2b1[12]  64.536  -78.074  -32.223  1.061 
p8b2b1[14]  p8b2b1[13]  67.309  -87.191  -32.294  0.882 
p8b2b1[15]  p8b2b1[14]  65.412  -95.946  -33.097  0.935 
p8b2b1[16]  p8b2b1[15]  71.054  -103.53  -33.097  0.89 
p8b2b1[17]  p8b2b1[16]  72.953  -108.252  -35.636  1.479 
p8b2b1[18]  p8b2b1[17]  77.49  -113.587  -39.967  1.021 
p8b2b1[19]  p8b2b1[18]  85.048  -117.052  -43.388  0.935 
p8b2b1[20]  p8b2b1[19]  92.154  -117.986  -49.796  0.875 
p8b2b1[21]  p8b2b1[20]  100.326  -121.267  -50.956  0.62 
p8b2b2[0]  p8b2[2]  2.016  -27.068  -6.532  1.368 
p8b2b2[1]  p8b2b2[0]  -6.152  -26.726  -8.268  1.03 
p8b2b2b1[0]  p8b2b2[1]  -14.197  -23.72  -9.6  0.93 
p8b2b2b1[1]  p8b2b2b1[0]  -22.413  -23.327  -10.331  0.979 
p8b2b2b1[2]  p8b2b2b1[1]  -29.162  -22.083  -15.631  0.932 
p8b2b2b1[3]  p8b2b2b1[2]  -37.391  -26.777  -16.986  0.845 
p8b2b2b1[4]  p8b2b2b1[3]  -46.94  -26.839  -16.986  0.847 
p8b2b2b1[5]  p8b2b2b1[4]  -55.243  -22.481  -16.548  0.861 
p8b2b2b1[6]  p8b2b2b1[5]  -62.674  -27.137  -16.548  0.922 
p8b2b2b1[7]  p8b2b2b1[6]  -68.891  -25.369  -18.235  1.211 
p8b2b2b1[8]  p8b2b2b1[7]  -74.431  -28.038  -19.596  1.284 
p8b2b2b1[9]  p8b2b2b1[8]  -80.692  -31.07  -20.907  1.142 
p8b2b2b1[10]  p8b2b2b1[9]  -87.731  -26.314  -22.643  0.933 
p8b2b2b1[11]  p8b2b2b1[10]  -95.257  -27.16  -22.643  1.068 
p8b2b2b1[12]  p8b2b2b1[11]  -100.804  -22.085  -24.846  1.032 
p8b2b2b1[13]  p8b2b2b1[12]  -105.248  -17.631  -27.876  0.897 
p8b2b2b1[14]  p8b2b2b1[13]  -110.345  -11.973  -28.048  0.685 
p8b2b2b1[15]  p8b2b2b1[14]  -108.468  -5.738  -29.175  0.62 
p8b2b2b2[0]  p8b2b2[1]  -13.91  -25.259  -13.238  0.879 
p8b2b2b2[1]  p8b2b2b2[0]  -16.372  -30.322  -16.669  1.244 
p8b2b2b2[2]  p8b2b2b2[1]  -11.343  -35.621  -22.908  0.853 
p8b2b2b2[3]  p8b2b2b2[2]  -18.836  -38.596  -25.884  0.954 
p8b2b2b2[4]  p8b2b2b2[3]  -26.564  -42.499  -25.254  0.944 
p8b2b2b2[5]  p8b2b2b2[4]  -30.08  -50.198  -26.615  0.832 
p8b2b2b2[6]  p8b2b2b2[5]  -33.216  -52.303  -32.321  0.774 
p8b2b2b2[7]  p8b2b2b2[6]  -38.414  -56.426  -36.792  0.662 
p8b2b2b2[8]  p8b2b2b2[7]  -42.667  -55.274  -38.329  1.134 
p8b2b2b2[9]  p8b2b2b2[8]  -47.91  -52.48  -41.414  0.791 
p8b2b2b2[10]  p8b2b2b2[9]  -49.897  -57.533  -47.404  0.655 
p8b2b2b2[11]  p8b2b2b2[10]  -54.465  -63.442  -50.082  0.667 
p8b2b2b2[12]  p8b2b2b2[11]  -59.073  -61.253  -54.134  0.813 
p8b2b2b2[13]  p8b2b2b2[12]  -63.711  -62.731  -59.576  0.725 
p8b2b2b2[14]  p8b2b2b2[13]  -64.494  -70.044  -61.891  0.687 
p8b2b2b2[15]  p8b2b2b2[14]  -67.141  -71.305  -67.572  0.828 
p8b2b2b2[16]  p8b2b2b2[15]  -72.902  -70.638  -70.989  0.786 
p8b2b2b2[17]  p8b2b2b2[16]  -72.862  -78.358  -71.133  0.686 
p8b2b2b2[18]  p8b2b2b2[17]  -72.992  -83.923  -75.541  0.745 
p8b2b2b2[19]  p8b2b2b2[18]  -71.027  -86.316  -81.263  0.814 
p8b2b2b2[20]  p8b2b2b2[19]  -66.602  -89.651  -83.918  0.862 
p8b2b2b2[21]  p8b2b2b2[20]  -62.821  -95.643  -88.374  0.632 
p8b2b2b2[22]  p8b2b2b2[21]  -59.335  -98.108  -91.164  1.038 
p8b2b2b2[23]  p8b2b2b2[22]  -57.703  -102.846  -94.944  0.743 
p8b2b2b2[24]  p8b2b2b2[23]  -59.742  -105.202  -97.991  0.41 
