//genesis
/* 
This is the main script for running the simulation designed for 
examining the effect of long (order of several seconds) depolarising 
conditioning prepulses on the action potential generated by a model 
cell containing a Hodgkin-Huxley type delayed rectifier potassium 
channel (rat channel data from Ref.*) and the RIIA sodium channel
alpha subunit. The RIIA sodium channel shows prepulse potential and
prepulse duration dependence, i.e., a kind of molecular memory. The 
RIIA sodium channel parameters has been quantified in a CHO surrogate 
system. All the basic parameters viz. m_inf, tau_m, h1_inf (fast 
inactivation gate), tau_h1 and tau_h2 (recovery from slow inactivation)
increases/decreases in a periodic fashion. The fluctuation of the 
channel parameters could be fitted with a sum of 2/3 sin functions. 
The tabchannel object Rat_na_sm has been written to incorporate
the effect of prepulse duration and prepulses potentials on the HH 
type voltage gated sodium channel.

The author wellcomes improvement of this model by making it more real 
like system incorporating other types of ionic conductances viz. 
inward rectifier potassium channel, calcium activated potassium 
channels and calcium channels.

Author: Sriparna Majumdar MBU, IISc '2002
*/

echo ===========================================================
echo
echo A SIMPLE MODEL NEURON CONTAINING HH TYPE RAT BRAIN TRANSIENT
echo SODIUM CHANNEL AND DELAYED RECTIFIER POTASSIUM CHANNEL
echo
echo ============================================================

//****************
// simulation time 
//****************
float tmax =0.22 // simulation time in sec
float dt = 0.00005 // simulation time step in sec
setclock 0 {dt}

// *********************
//    STARTUP SCRIPTS
// *********************

include constants.g
include channel.g
include Rat_Na_sm.g
include traub91chan.g
include compartment.g
include tools.g

float Eleak = -0.0694 // leak membrane potential
//------------------------------------------------------
// Making A Neuron with a Single Compartment called soma
//------------------------------------------------------

create neutral /cell
makecompartment /cell/soma {soma_l} {soma_d} {Eleak}

setfield /cell/soma initVm {EREST} // initialize Vm to rest potential

//provide current injection to soma
//setfield /cell/soma inject 0.8e-9 //0.3 nA injection current

//----------------------------------
// Adding channel to the compartment
//----------------------------------
pushe /cell/soma
//make_hhK    
make_Na_rat_sm 
//make_Na_hip_traub91
make_Kdr_hip_traub91
pope

addmsg /cell/soma/Kdr_hip_traub91 /cell/soma CHANNEL Gk Ek
addmsg /cell/soma /cell/soma/Kdr_hip_traub91 VOLTAGE Vm
addmsg /cell/soma/Na_rat_sm /cell/soma CHANNEL Gk Ek
addmsg /cell/soma /cell/soma/Na_rat_sm VOLTAGE Vm

//------------------------
//   GRAPHICS SECTION
//------------------------

include graphics.g
disk_output
check
reset
