/*********************************************************************
 * A series of operations which handle the construction of the 
 * simulation environment from the given set of input files.
 * Mike True, 8/20/06
 *********************************************************************/

#ifndef PARAMH
    #include "param.h"
    #define PARAMH 1
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* A function that reads the command line parameters for input file info */
void processCommandLineArgs(Param *p, char** argv, int argn)
{
    int i;
    for(i=1; i<argn-1; i++)
    {
        /* This option changes the input file location */
        if(strncmp(argv[i], "-i", 3) == 0)
	    {
	        i++;
            p->inputFileName = argv[i]; 
	    }
        /* This option changes the output file location */
        else if(strncmp(argv[i], "-o", 3) == 0)
    	{
            i++;
            p->outputFileName = argv[i];
	    }
        /* This option changes the logfile location */	    
	    else if(strncmp(argv[i], "-l", 3) == 0)
	    {
            i++;
            p->logFileName = argv[i];     
        }
        /* This option specifies that the HA coefficients are to be read in */
        if(strncmp(argv[i], "-a", 3) == 0)
	    {
	        i++;
            readHACoefficients(p, argv[i]); 
	    }        
        /* This specifies the simulation will be started from a saved state */        
	    else if(strncmp(argv[i], "-sl", 4) == 0)
	    {
            i++;
            p->loadStateFileName = argv[i];     
            p->loadFromState = 1;
        }
        /* This denotes that the simulation will save states at an intervals */        
	    else if(strncmp(argv[i], "-sf", 4) == 0)
	    {
            i++;
            p->useStateFile = 1;
            p->stateFileName = argv[i];  
        }
        #if CELL_REPORTS_ENABLED
        /* This option changes the location of the reports file */
	    else if(strncmp(argv[i], "-r", 3) == 0)
	    {
            i++;
            p->cellReportsOn = 1;
            p->cellReportFileName = argv[i];
	    }
	    #endif
    }
}

/* This function loads in HA coefficients from a file */
void readHACoefficients(Param *param, char *fileName)
{
    FILE *fp = fopen(fileName, "r");        
    if(fp == NULL)
    {
        return;
    }
    fscanf(fp, "%lf %lf %lf", &param->alphaX0, &param->alphaY0, &param->alphaZ0);
    fscanf(fp, "%lf %lf", &param->alphaY1, &param->alphaZ1);
    fscanf(fp, "%lf %lf %lf", &param->alphaX2, &param->alphaY2, &param->alphaZ2);
    fscanf(fp, "%lf %lf %lf", &param->alphaX3, &param->alphaY3, &param->alphaZ3);
    fscanf(fp, "%lf %lf %lf %lf %lf %lf", &param->vO, &param->vT, &param->vS, 
      &param->vR, &param->vW, &param->rp);
    fscanf(fp, "%lf %lf %lf", &(param->initVX), &(param->initVY), &(param->initVZ));
    fscanf(fp, "%lf %lf", &param->guessUpstroke, &param->guessPlateau);                                   
}

/* This function reads in all of the standard parameter information */
void readParam(Param *param, FILE* fp)
{
    int i;
    int useStateFile = 0;
    int loadFromState = 0;
    //Read in all general information
    fscanf
	(
	    fp,
	    "%d %d %f %f %f %f %f %f %d", 
	    &param->size, 
	    &param->stimNum, 
	    &param->dd, 
	    &param->Cm, 
	    &param->D, 
	    &param->simBegin, 
	    &param->simEnd, 
	    &param->dt,
	    &param->iter
	);

    //Read in all information about a particular stimulus
    for(i=0;i<param->stimNum;i++)
	fscanf
	    (
		fp, 
		"%f  %f  %d %d  %d  %d  %f", 
		&param->stimuli[i].begin,
		&param->stimuli[i].end,
		&param->stimuli[i].upper,
		&param->stimuli[i].lower,
		&param->stimuli[i].left,
		&param->stimuli[i].right,
		&param->stimuli[i].amp
	    );
    #if CELL_REPORTS_ENABLED
    param->reportNum = 0;
    #endif
}

#if CELL_REPORTS_ENABLED
/* This function reads in information about what reports should be generated */
void readCellReportInfo(Param *param, FILE* fp)
{
    int i=0, inv = 0;
    if(fp == NULL)
    {
        printf("Error while opening report data...\n");
        exit(1);
    }

    //Read in all general information
    fscanf
        (
            fp,
            "%d",
            &param->reportNum
        );
                
    for(i=0;i<param->reportNum;i++)
    {
        fscanf
            ( 
                fp,
                "%d %d",
                &param->cellReportsX[i-inv],
                &param->cellReportsY[i-inv]                
            );
        param->cellReportFileNames[i] =
          (char *)malloc(sizeof(char) * MAX_FILENAME_SIZE);
        fscanf   
            (
                fp,
                "%s",
                param->cellReportFileNames[i-inv]
            );

        if(param->cellReportsX[i-inv] < 0 || 
          param->cellReportsX[i-inv] >= param->size ||
          param->cellReportsY[i-inv] < 0 || 
          param->cellReportsY[i-inv] >= param->size)
	    {
            inv++;
	    }
        else
        {
            param->cellReportFiles[i-inv] = 
              fopen(param->cellReportFileNames[i-inv],
              "w");
        }
    }
    param->reportNum = param->reportNum - inv;
    fclose(fp);
}

/* This function reads in information about when states file dumps occur */
void readStateInfo(Param *param, FILE* fp)
{
    int i=0, inv = 0;
    if(fp == NULL)
    {
        printf("Error while output state file...\n");
        exit(1);
    }
    //Read in the number of states
    fscanf
        (
            fp,
            "%d",
            &(param->stateNum)
        );
    //Read in information for each state
    for(i=0;i<param->stateNum;i++)
    {
        fscanf
            ( 
                fp,
                "%lf\n",
                &(param->stateTimes[i-inv])
            );
        param->stateFileNames[i-inv] =
          (char *)malloc(sizeof(char) * MAX_FILENAME_SIZE);
        fscanf   
            (
                fp,
                "%s",
                param->stateFileNames[i-inv]
            );

        param->stateFiles[i-inv] = 
          fopen(param->stateFileNames[i-inv], "w");
    }
    param->stateNum = param->stateNum - inv;
    fclose(fp);     
}
#endif
