"""
 * Copyright (C) 2004 Evan Thomas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""


import sys, os, re
from math import exp

from parplex._p3   import *
from parplex.fpsp  import *
from parplex.isrc  import *
from parplex.noise import *
from parplex.wb    import *
from parplex.hh    import *
from parplex.lif   import *
from parplex.pr    import *
from parplex.spsp  import *
from parplex.units import *

try:
    import psyco
    psyco.full()
except ImportError:
    pass
    

# These wrappers will create classes that are really
# Python like
class GD(GD_C):
    def __init__(self):
        GD_C.__init__(self)
        # Some useful defaults
        self.message_handler = message_print
        self.trace_handler = trace_print
        self.debug_handler = debug_print
        self.ap_handler    = ap_print
        self.endWindow_handler = None
        self.startWindow_handler = None
        self.tolerance = 1e-3
        self.duration = 2000
        self.window   = 20

class Cell(Cell_C):
    """
    This class implements a simple cell with only a single 
    compartment.  It hides the complexity of multi-compartment
    modelling and maintains compatibilty with early verions (ha!).
    """
    def __init__(self):
        Cell_C.__init__(self)
        # This line needs to be first, otherwise __setattr__
        # and __gettattr__ get into an infinite recursion
        self.__dict__['soma'] = Compartment(self)
        self.method = rk32    # default numerical method
        self.timeSample = 0.1 # 2KHz sampling seems to be OK

        
    def __getattr__(self, name):
        if name in Compartment_C.__dict__.keys():
            return getattr(self.soma, name)
        else: raise AttributeError, \
              "Cell_C instance has no attribute '"+name+"'"
            #return eval('self.soma.' + name, globals(), locals())

    def __setattr__(self, name, value):
        if name in Compartment_C.__dict__.keys():
            Compartment_C.__setattr__(self.soma, name, value)
        else:    
            Cell_C.__setattr__(self, name, value)

class mCell(Cell_C):
    def __init__(self):
        Cell_C.__init__(self)
        self.method = rk32    # default numerical method
        self.timeSample = 0.1 # 2KHz sampling seems to be OK
    
class Synapse(Synapse_C):
    pass
    
class Compartment(Compartment_C):
    def __getattr__(self, name):
        return getattr(self.owner, name)
    pass
 
_message_options = {}
_message_options['debug'] = 1
_message_options['info']  = 1
_message_options['warn']  = 1

def set_message_option(*options):
    for option in options:
        if option=='nodebug':
            _message_options['debug'] = 0
        elif option=='debug':
            _message_options['debug'] = 1
        elif option=='nowarn':
            _message_options['warn']  = 0
        elif option=='warn':
            _message_options['warn']  = 1
        elif option=='noinfo':
            _message_options['info']  = 0
        elif option=='info':
            _message_options['info']  = 1
    
def message_print(m, stuff):
    if m==debug:
        if not _message_options['debug']: return
        s = 'debug'
    elif m==info:
        if not _message_options['info']: return
        s = 'info'
    elif m==warn:
        if not _message_options['warn']: return
        s = 'warn'
    elif m==fatal:
        s = 'fatal'
    else:
        s = 'unknown'
    
    print '[%03d] %s: %s' % (mpi_rank, s, stuff),

    sys.stdout.flush()
    
    return 0
   
dbx = None
def debug_print(stuff):
    global dbx
    if dbx==None:
        if mpi_size == 1:
            fn = 'db.dat'
        else:
            fn = 'db_%d_%d.dat' % (mpi_size, mpi_rank)
        dbx = open(fn, 'w')
    dbx.write(stuff)
    dbx.flush()


apx = None
apfilename = 'ap'
apfilecompress = 0
def setAPfilename(s, compressed=0):
    global apfilename, apfilecompress
    apfilename = s
    apfilecompress = compressed

def ap_print(cell):
    global apx, apfilename, apfilecompress
    if apx==None:
        if mpi_size == 1:
            fn = apfilename + '.dat'
        else:
            fn = '%s_%d_%d.dat' % \
                 (apfilename, mpi_size, mpi_rank)
        apx = open(fn, 'w')

    if isinstance(cell, Cell):
        for tm in cell.APtimes:
            apx.write('%d %g\n' % (cell.id, tm))
    else:
        for i in range(len(cell.compartments)):
            cmpt = cell.compartments[i]
            for tm in cmpt.APtimes:
                apx.write('%d %d %g\n' % (cell.id, i, tm))
    apx.flush()

def apfile_close():
    global apx
    try:
        apx.close()
        apx = None
    except AttributeError:
        pass
    
tracex = None
trfilename = 'tr'
trfilecmopress = 0
def setTRfilename(s, compressed=0):
    global trfilename, trfilecompress
    trfilename = s
    trfilecompress = compressed

def tracefile_close():
    global tracex
    try:
        tracex.close()
        tracex = None
    except AttributeError:
        pass

def trace_print(cell):
    global tracex, trfilecompress
    try:
        from __main__ import Network
    except ImportError:
        Network = None
   
    if tracex==None:
        if mpi_size == 1:
            fn = trfilename + '.dat'
        else:
            fn = '%s_%d_%d.dat' % \
                 (trfilename, mpi_size, mpi_rank)
        if trfilecompress:
            fn = fn + '.gz'
            import gzip
            tracex = gzip.open(fn, 'w')
        else:
            tracex = open(fn, 'w')
        message_print(info, 'Open of trace file %s successful.\n' % fn)

    if Network:
        cell = getCellByID(Network, id)
        xpos = cell.xpos
        ypos = cell.ypos
    else:
        xpos = 0
        ypos = 0
        
    if isinstance(cell, Cell):
        for i in range(len(cell.traceTimes)):
            time = cell.traceTimes[i]
            data = cell.traceData[i]
            tracex.write('%d %g %g\n' % (cell.id, time, data))
    else:
        for j in range(len(cell.compartments)):
            cmpt = cell.compartments[j]
            for i in range(len(cmpt.traceTimes)):
                time = cmpt.traceTimes[i]
                data = cmpt.traceData[i]
                tracex.write('%d %d %g %g\n' % (cell.id, j, time, data))
                
    tracex.flush()
