"""
 * Copyright (C) 2004 Evan Thomas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""

"""
Test the C implementation of the Tiesinga, et al network
try to generate fig 3
"""

import sys
from random import choice
from time import clock
from os import environ
from re import match
from p3 import *

from tiesinga_C import Pyramidal, epspSynapse
from wb_C import Interneuron, ipspSynapse
from IhProject import *

m = match('(\d+)\..+', os.environ['PBS_JOBID'])
JOBID = m.group(1)

# Possible fig 7 parameter set
runvars = {}
runvars['Ne'] = 100
runvars['Ni'] =  20
runvars['gAMPAei'] = 0.003
runvars['gAMPAee'] = 0.003
runvars['gGABAii'] = 0.001
runvars['gGABAie'] = 0.02
runvars['gIh']     = float(sys.argv[1])
runvars['Pee']   = 0.2
runvars['Pei']   = 0.2
runvars['Pii']   = 1
runvars['Pie']   = 1
runvars['JOBID'] = JOBID
varfile = 'runvars_%s.m' % JOBID
writevars(runvars, varfile, True)
f = open(varfile)
exec f
f.close()
    
# Build neuron
Enet = []
for i in range(Ne):
    cell = Pyramidal()
    cell.Ih.gIh = gIh
    cell.Kahp.q = 0.1*rand_flat()
    cell.soma.Em = cell.soma.Em + rand_norm(0,10)
    cell.dendrite.Em = cell.dendrite.Em + rand_norm(0,10)
    Enet.append(cell)
    
Inet = []
for i in range(Ni):
    cell = Interneuron()
    cell.Em = -65 + rand_norm(0,10)
    Inet.append(cell)

makeconx(Enet, Enet, Pee, gAMPAee, epspSynapse)
makeconx(Enet, Inet, Pei, gAMPAei, epspSynapse)
makeconx(Inet, Enet, Pie, gGABAie, ipspSynapse)
makeconx(Inet, Inet, Pii, gGABAii, ipspSynapse)

network = Enet + Inet

# Randomly trace some neurons
for i in range(10):
    cell = choice(network)
    cell.compartments[0].emtrace = True

###############
# Run options #
###############
setAPfilename('ap_%s' % JOBID)
setTRfilename('trace_%s' % JOBID)
gd = GD()
gd.duration  = 20000
gd.tolerance = 1e-4
gd.network = network
gd.ap_handler = ap_print
gd.trace_handler = trace_print

#######
# Run #
#######
start = clock()

try:
    parplex(gd)
except ParplexRuntimeError:
    (e, v) = sys.exc_info()[:2]
    cell = e.currentCell
    message_print(fatal, 'Caught ParplexRuntimeError: %s\n' % v)
    dumpcell(cell, fatal)
    message_print(fatal, 'Didn\'t make it\n')
    sys.exit(0)

set_message_option('info')
message_print(info, 'made it - elapsed time %ds' % int(clock()-start))

try:
    m.write('figure(1);raster(\'ap.dat\')\n')
    m.write('figure(2);traceplot(\'trace.dat\')\n')
    print m.read()
except:
    pass
